/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class TbPooledConnection
implements PooledConnection,
TbConnectionEventHandler {
    protected HashMap eventMap = null;
    private TbLogicalConnection logicalConn = null;
    private TbConnection physicalConn = null;

    public TbPooledConnection(TbConnection conn) {
        Debug.logMethod("TbPooledConnection", new Object[]{this, conn});
        this.eventMap = new HashMap();
        this.physicalConn = conn;
    }

    @Override
    public final void addConnectionEventListener(ConnectionEventListener eventListener) {
        Debug.logMethod("TbPooledConnection.addConnectionEventListener", new Object[]{this, eventListener});
        if (eventListener != null && this.physicalConn != null && this.eventMap != null) {
            this.eventMap.put(eventListener, eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        Debug.logMethod("TbPooledConnection.close", new Object[]{this});
        try {
            this.physicalConn.close();
        }
        finally {
            this.reset();
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        Debug.logMethod("TbPooledConnection.getConnection", new Object[]{this});
        if (this.physicalConn == null) {
            SQLException sqe = TbError.newSQLException(-590709);
            this.notifyExceptionEvent(sqe);
            return null;
        }
        try {
            if (this.logicalConn != null && !this.logicalConn.isClosed()) {
                this.logicalConn.close();
            }
            this.logicalConn = this.getNewLogicalConnection();
        }
        catch (SQLException e) {
            this.notifyExceptionEvent(e);
            throw e;
        }
        return this.logicalConn;
    }

    protected TbLogicalConnection getNewLogicalConnection() throws SQLException {
        return new TbLogicalConnection(this, this.getPhysicalConnection(), false);
    }

    final TbConnection getPhysicalConnection() {
        return this.physicalConn;
    }

    @Override
    public final void notifyClosedEvent() {
        Debug.logMethod("TbPooledConnection.notifyClosedEvent", new Object[]{this});
        if (this.physicalConn != null && this.eventMap != null) {
            Iterator itr = this.eventMap.keySet().iterator();
            while (itr.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)this.eventMap.get(itr.next());
                listener.connectionClosed(new ConnectionEvent(this));
            }
        }
    }

    @Override
    public final void notifyExceptionEvent(SQLException e) {
        Debug.logMethod("TbPooledConnection.notifyExceptionEvent", new Object[]{this, e});
        if (this.physicalConn != null && this.eventMap != null) {
            Iterator itr = this.eventMap.keySet().iterator();
            while (itr.hasNext()) {
                ConnectionEventListener listener = (ConnectionEventListener)this.eventMap.get(itr.next());
                listener.connectionErrorOccurred(new ConnectionEvent(this, e));
            }
        }
    }

    @Override
    public final void removeConnectionEventListener(ConnectionEventListener eventListener) {
        Debug.logMethod("TbPooledConnection.removeConnectionEventListener", new Object[]{this, eventListener});
        if (eventListener != null && this.physicalConn != null && this.eventMap != null) {
            this.eventMap.remove(eventListener);
        }
    }

    public final void reset() {
        this.eventMap = null;
        if (this.logicalConn != null) {
            try {
                this.logicalConn.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener eventListener) {
        Debug.logMethod("TbPooledConnection.addStatementEventListener", new Object[]{this, eventListener});
        if (eventListener != null && this.logicalConn != null) {
            this.logicalConn.addStatementEventListener(eventListener);
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener eventListener) {
        Debug.logMethod("TbPooledConnection.removeStatementEventListener", new Object[]{this, eventListener});
        if (eventListener != null && this.logicalConn != null) {
            this.logicalConn.removeaStatementEventListener(eventListener);
        }
    }
}

