/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatement;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbLogicalCallableStatement;
import com.tmax.tibero.jdbc.ext.TbLogicalPreparedStatement;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TbLogicalConnection
extends TbConnection {
    private TbConnectionEventHandler eventHandler = null;
    private com.tmax.tibero.jdbc.driver.TbConnection physicalConn = null;
    private boolean closed = true;
    private boolean useXA = false;
    private boolean reseted = true;
    private HashMap<StatementEventListener, StatementEventListener> listenerMap = new HashMap();

    public TbLogicalConnection(TbConnectionEventHandler handler, com.tmax.tibero.jdbc.driver.TbConnection conn, boolean flag) throws SQLException {
        Debug.logMethod("TbLogicalConnection", new Object[]{this, handler, conn, new Boolean(flag)});
        this.eventHandler = handler;
        this.physicalConn = conn;
        this.useXA = flag;
        if (conn.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90643);
        }
        this.closed = false;
        if (!this.physicalConn.isSessionClosed()) {
            this.physicalConn.resetSession();
            this.physicalConn.reuse();
            this.eventHandler.notifyClosedEvent();
        }
        this.addStatementEventListener(new StatementEventListener(){

            @Override
            public void statementClosed(StatementEvent event) {
                Debug.logMethod("TbLogicalConnection.StatementEventListener.statementClosed", new Object[]{this, event});
                try {
                    event.getStatement().close();
                }
                catch (SQLException ignore) {
                    Debug.log(ignore.toString());
                }
            }

            @Override
            public void statementErrorOccurred(StatementEvent event) {
                Debug.logMethod("TbLogicalConnection.StatementEventListener.statementErrorOccurred", new Object[]{this, event});
            }
        });
    }

    @Override
    public void clearWarnings() throws SQLException {
        Debug.logMethod("TbLogicalConnection.clearWarnings", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.clearWarnings();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        Debug.logMethod("TbLogicalConnection.close", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalConn.resetSession();
        this.physicalConn.reuse();
        this.eventHandler.notifyClosedEvent();
    }

    @Override
    public void commit() throws SQLException {
        Debug.logMethod("TbLogicalConnection.commit", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.commit();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public void commit(Xid xid, boolean flag) throws XAException {
        Debug.logMethod("TbLogicalConnection.commit", new Object[]{this, this.physicalConn, xid, new Boolean(flag)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).commit(xid, flag);
            }
        }
        catch (SQLException e) {
            throw new TbXAException(e.getMessage());
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Blob createBlob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createBlob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createBlob();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createClob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createClob();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createNClob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createNClob();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createSQLXML", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createSQLXML();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createStatement", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int rsetType, int rsetConcurrency) throws SQLException {
        Debug.logMethod("TbLogicalConnection.createStatement", new Object[]{this, this.physicalConn, Integer.toString(rsetType), Integer.toString(rsetConcurrency)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement(rsetType, rsetConcurrency);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void end(Xid xid, int flag) throws XAException {
        Debug.logMethod("TbLogicalConnection.end", new Object[]{this, this.physicalConn, xid, Integer.toString(flag)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).end(xid, flag);
            }
        }
        catch (SQLException e) {
            throw new TbXAException(e.getMessage());
        }
    }

    public void forget(Xid xid) throws TbXAException {
        Debug.logMethod("TbLogicalConnection.forget", new Object[]{this, this.physicalConn, xid});
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getAutoCommit", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getAutoCommit();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getCatalog", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getCatalog();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getClientInfo", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getClientInfo();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        Debug.logMethod("TbLogicalConnection.getClientInfo", new Object[]{this, this.physicalConn, name});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getClientInfo(name);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public TbConnectionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getLastExecutedSqlinfo", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getLastExecutedSqlinfo2", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo2();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getMetaData", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getMetaData();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    com.tmax.tibero.jdbc.driver.TbConnection getPhysicalConnection() {
        return this.physicalConn;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getTransactionIsolation", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public int getTxnMode() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getTxnMode", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.getTxnMode();
    }

    public Map getTypeMap() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getTypeMap", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTypeMap();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getWarnings", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getWarnings();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPhysConnClosed() throws SQLException {
        return this.physicalConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        Debug.logMethod("TbLogicalConnection.isReadOnly", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.isReadOnly();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public boolean isUseXA() {
        return this.useXA;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        Debug.logMethod("TbLogicalConnection.isValid", new Object[]{Integer.toString(timeout)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.isValid(timeout);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbLogicalConnection.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        Debug.logMethod("TbLogicalConnection.nativeSQL", new Object[]{this, this.physicalConn, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public int prepare(Xid xid) throws XAException {
        Debug.logMethod("TbLogicalConnection.prepare", new Object[]{this, this.physicalConn, xid});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).prepare(xid);
            }
        }
        catch (SQLException e) {
            throw new TbXAException("prepare failed " + e.getMessage());
        }
        throw new TbXAException("prepare failed");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareCall", new Object[]{this, this.physicalConn, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalCallableStatement logicalCstmt;
            TbLogicalCallableStatement returnCstmt = null;
            TbCallableStatement cstmt = (TbCallableStatement)this.physicalConn.prepareCall(sql);
            returnCstmt = logicalCstmt = new TbLogicalCallableStatement(this, cstmt);
            return returnCstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int rsetType, int rsetConcurrency) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareCall", new Object[]{this, this.physicalConn, sql, new Integer(rsetType), new Integer(rsetConcurrency)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalCallableStatement logicalCstmt;
            TbLogicalCallableStatement returnCstmt = null;
            TbCallableStatement cstmt = (TbCallableStatement)this.physicalConn.prepareCall(sql, rsetType, rsetConcurrency);
            returnCstmt = logicalCstmt = new TbLogicalCallableStatement(this, cstmt);
            return returnCstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement logicalPstmt;
            TbLogicalPreparedStatement returnPstmt = null;
            TbPreparedStatement pstmt = (TbPreparedStatement)this.physicalConn.prepareStatement(sql);
            returnPstmt = logicalPstmt = new TbLogicalPreparedStatement(this, pstmt);
            return returnPstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, boolean forcePrepare) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, sql, new Boolean(forcePrepare)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement logicalPstmt;
            TbLogicalPreparedStatement returnPstmt = null;
            TbPreparedStatement pstmt = (TbPreparedStatement)this.physicalConn.prepareStatement(sql, forcePrepare);
            returnPstmt = logicalPstmt = new TbLogicalPreparedStatement(this, pstmt);
            return returnPstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement logicalPstmt;
            TbLogicalPreparedStatement returnPstmt = null;
            TbPreparedStatement pstmt = (TbPreparedStatement)this.physicalConn.prepareStatement(sql, autoGeneratedKeys);
            returnPstmt = logicalPstmt = new TbLogicalPreparedStatement(this, pstmt);
            return returnPstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int rsetType, int rsetConcurrency) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, sql, new Integer(rsetType), new Integer(rsetConcurrency)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement logicalPstmt;
            TbLogicalPreparedStatement returnPstmt = null;
            TbPreparedStatement pstmt = (TbPreparedStatement)this.physicalConn.prepareStatement(sql, rsetType, rsetConcurrency);
            returnPstmt = logicalPstmt = new TbLogicalPreparedStatement(this, pstmt);
            return returnPstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement logicalPstmt;
            TbLogicalPreparedStatement returnPstmt = null;
            TbPreparedStatement pstmt = (TbPreparedStatement)this.physicalConn.prepareStatement(sql, columnIndexes);
            returnPstmt = logicalPstmt = new TbLogicalPreparedStatement(this, pstmt);
            return returnPstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, sql});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbLogicalPreparedStatement logicalPstmt;
            TbLogicalPreparedStatement returnPstmt = null;
            TbPreparedStatement pstmt = (TbPreparedStatement)this.physicalConn.prepareStatement(sql, columnNames);
            returnPstmt = logicalPstmt = new TbLogicalPreparedStatement(this, pstmt);
            return returnPstmt;
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        Debug.logMethod("TbLogicalConnection.recover", new Object[]{this, this.physicalConn, Integer.toString(flag)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).recover(flag);
            }
        }
        catch (SQLException e) {
            throw new TbXAException("recover failed " + e.getMessage());
        }
        throw new TbXAException("recover failed");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void reset() {
        this.eventHandler = null;
        this.physicalConn = null;
    }

    @Override
    public void rollback() throws SQLException {
        Debug.logMethod("TbLogicalConnection.rollback", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback();
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Debug.logMethod("TbLogicalConnection.rollback", new Object[]{this, this.physicalConn, savepoint});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback(savepoint);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public void rollback(Xid xid) throws XAException {
        Debug.logMethod("TbLogicalConnection.rollback", new Object[]{this, this.physicalConn, xid});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).rollback(xid);
            }
        }
        catch (SQLException e) {
            throw new TbXAException(e.getMessage());
        }
    }

    @Override
    public void setAutoCommit(boolean flag) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setAutoCommit", new Object[]{this, this.physicalConn, new Boolean(flag)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            if (flag) {
                throw TbError.newSQLException(-90602);
            }
        } else {
            try {
                this.physicalConn.setAutoCommit(flag);
            }
            catch (SQLException e) {
                this.eventHandler.notifyExceptionEvent(e);
                throw e;
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setCatalog", new Object[]{this, this.physicalConn, catalog});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Debug.logMethod("TbLogicalConnection.setClientInfo", new Object[]{this, this.physicalConn, properties});
        if (this.isClosed()) {
            throw new SQLClientInfoException(TbError.getMsg(-90603), null, -90603, null);
        }
        try {
            this.physicalConn.setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Debug.logMethod("TbLogicalConnection.setClientInfo", new Object[]{this, this.physicalConn, name, value});
        if (this.isClosed()) {
            throw new SQLClientInfoException(TbError.getMsg(-90603), null, -90603, null);
        }
        try {
            this.physicalConn.setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void setReadOnly(boolean flag) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setReadOnly", new Object[]{this, this.physicalConn, new Boolean(flag)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setReadOnly(flag);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Debug.logMethod("TbLogicalConnection.setSavepoint", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setSavepoint", new Object[]{this, this.physicalConn, name});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setTransactionIsolation", new Object[]{this, this.physicalConn, Integer.toString(isolation)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTransactionIsolation(isolation);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public void setTxnMode(int txnMode) {
        Debug.logMethod("TbLogicalConnection.setTxnMode", new Object[]{this, this.physicalConn, Integer.toString(txnMode)});
        this.physicalConn.setTxnMode(txnMode);
    }

    public void setTypeMap(Map typeMap) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setTypeMap", new Object[]{this, this.physicalConn, typeMap});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTypeMap(typeMap);
        }
        catch (SQLException e) {
            this.eventHandler.notifyExceptionEvent(e);
            throw e;
        }
    }

    public void start(Xid xid, int flag) throws XAException {
        Debug.logMethod("TbLogicalConnection.start", new Object[]{this, this.physicalConn, xid, Integer.toString(flag)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).start(xid, flag);
            }
        }
        catch (SQLException e) {
            throw new TbXAException(e.getMessage());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbLogicalConnection.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }

    public void addStatementEventListener(StatementEventListener eventListener) {
        Debug.logMethod("TbConnection.addStatementEvent", new Object[]{eventListener});
        if (this.physicalConn.isPooledConnection()) {
            this.listenerMap.put(eventListener, eventListener);
        }
    }

    public void removeaStatementEventListener(StatementEventListener eventListener) {
        Debug.logMethod("TbConnection.addStatementEvent", new Object[]{eventListener});
        if (this.physicalConn.isPooledConnection()) {
            this.listenerMap.remove(eventListener);
        }
    }

    public HashMap<StatementEventListener, StatementEventListener> getStatementEventListeners() {
        Debug.logMethod("TbConnection.addStatementEvent", new Object[]{this});
        return this.listenerMap;
    }

    @Override
    public void addWarning(SQLWarning warning) {
        Debug.logMethod("TbLogicalConnection.addWarning", new Object[]{this, this.physicalConn, warning});
        this.physicalConn.addWarning(warning);
    }

    @Override
    public void closeCursor(TbResultSet rs, int cursorId) throws SQLException {
        Debug.logMethod("TbLogicalConnection.closeCursor", new Object[]{this, this.physicalConn, rs, Integer.toString(cursorId)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.closeCursor(rs, cursorId);
    }

    @Override
    public TbBlob createTbBlob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createTbBlob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbBlob();
    }

    @Override
    public TbClob createTbClob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createTbClob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbClob();
    }

    @Override
    public TbDirPathStream createDirPathStream(TbDirPathMetaData dirPathMetaData) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public TbNClob createTbNClob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createTbNClob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbNClob();
    }

    @Override
    public String getNlsDate() {
        Debug.logMethod("TbLogicalConnection.getNlsDate", new Object[]{this, this.physicalConn});
        return this.physicalConn.getNlsDate();
    }

    @Override
    public String getNlsTimestamp() {
        Debug.logMethod("TbLogicalConnection.getNlsTimestamp", new Object[]{this, this.physicalConn});
        return this.physicalConn.getNlsTimestamp();
    }

    @Override
    public int getSerialNo() {
        Debug.logMethod("TbLogicalConnection.getSerialNo", new Object[]{this, this.physicalConn});
        return this.physicalConn.getSerialNo();
    }

    @Override
    public int getServerCharSet() {
        Debug.logMethod("TbLogicalConnection.getServerCharSet", new Object[]{this, this.physicalConn});
        return this.physicalConn.getServerCharSet();
    }

    @Override
    public ServerInfo getServerInfo() {
        Debug.logMethod("TbLogicalConnection.getServerInfo", new Object[]{this, this.physicalConn});
        return this.physicalConn.getServerInfo();
    }

    @Override
    public int getServerNCharSet() {
        Debug.logMethod("TbLogicalConnection.getServerNCharSet", new Object[]{this, this.physicalConn});
        return this.physicalConn.getServerNCharSet();
    }

    @Override
    public int getSessionId() {
        Debug.logMethod("TbLogicalConnection.getSessionId", new Object[]{this, this.physicalConn});
        return this.physicalConn.getSessionId();
    }

    @Override
    public boolean isPooledConnection() {
        Debug.logMethod("TbLogicalConnection.isPooledConnection", new Object[]{this, this.physicalConn});
        return false;
    }

    @Override
    public boolean isSessionClosed() {
        Debug.logMethod("TbLogicalConnection.isSessionClosed", new Object[]{this, this.physicalConn});
        return this.physicalConn.isSessionClosed();
    }

    @Override
    public void resetSession() throws SQLException {
        Debug.logMethod("TbLogicalConnection.resetSession", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.resetSession();
    }
}

