/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.driver.TbRSFwOnly;
import com.tmax.tibero.jdbc.driver.TbRSScrollable;
import com.tmax.tibero.jdbc.driver.TbRSSensitive;
import com.tmax.tibero.jdbc.driver.TbRSUpdatable;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class TbResultSetFactory {
    public static TbResultSet buildResultSet(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt, byte[] rowChunk) throws SQLException {
        if (stmt == null) {
            throw TbError.newSQLException(-90608);
        }
        RsetType rsetType = stmt.getRealRsetType();
        Debug.logReturn("TbResultSetFactory.buildResultSet", rsetType);
        switch (rsetType.getRank()) {
            case 2: {
                TbRSFwOnly rs1 = new TbRSFwOnly(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
                return new TbRSUpdatable(rs1, RsetType.FWUP);
            }
            case 3: {
                return new TbRSScrollable(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
            }
            case 4: {
                TbRSScrollable rs2 = new TbRSScrollable(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
                return new TbRSUpdatable(rs2, RsetType.SIUP);
            }
            case 5: {
                return new TbRSSensitive(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
            }
            case 6: {
                TbRSSensitive rs3 = new TbRSSensitive(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
                return new TbRSUpdatable(rs3, RsetType.SSUP);
            }
        }
        return new TbRSFwOnly(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
    }

    public static TbResultSet buildEmptyResultSet(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt) throws SQLException {
        Debug.logMethod("TbResultSetFactory.buildEmptyResultSet", new Object[]{stmt, Integer.toString(cursorId), Integer.toString(colCnt), Integer.toString(hiddenColCnt)});
        return new TbRSFwOnly(stmt, cursorId, colCnt, hiddenColCnt, null);
    }

    private TbResultSetFactory() {
    }
}

