/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.driver.TbPreparedStatementImpl;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;

public class TbRSScrollable
extends TbResultSetBase {
    protected AbstractList<Row> rows = new LinkedList<Row>();
    private int chunkRowDirOffset;

    protected TbRSScrollable(TbStatement stmt, int cursorId, int colCnt, int hiddenColCnt, byte[] rowChunk) throws SQLException {
        super(stmt, cursorId, colCnt, hiddenColCnt, rowChunk);
        this.currentRowIndex = -1;
        stmt.conn.addFOActiveResultSet(this);
        Debug.logMethod("TbRSScrollable", new Object[]{this});
    }

    @Override
    public synchronized boolean absolute(int rowIndex) throws SQLException {
        Debug.logMethod("TbRSScrollable.absolute", new Object[]{this, Integer.toString(rowIndex)});
        if (rowIndex == 0) {
            throw TbError.newSQLException(-590736);
        }
        if (this.isRSEmpty()) {
            return false;
        }
        if (rowIndex > 0) {
            this.currentRowIndex = rowIndex - 1;
        } else {
            if (!this.fetchComplete) {
                this.fetchRowsAll();
            }
            this.currentRowIndex = this.rowsFetchedCnt + rowIndex;
        }
        return this.isValidRowIndex(this.currentRowIndex);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        Debug.logMethod("TbRSScrollable.afterLast", new Object[]{this});
        if (!this.isRSEmpty()) {
            if (!this.fetchComplete) {
                this.fetchRowsAll();
            }
            this.currentRowIndex = this.stmt.getMaxRows() != 0 && this.currentRowIndex >= this.stmt.getMaxRows() ? this.stmt.getMaxRows() : this.rowsFetchedCnt;
        }
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        Debug.logMethod("TbRSScrollable.beforeFirst", new Object[]{this});
        if (!this.isRSEmpty()) {
            this.currentRowIndex = -1;
        }
    }

    @Override
    public byte[] getRowChunk(int size) {
        this.rowChunk = new byte[size];
        return this.rowChunk;
    }

    @Override
    public void buildRowTable(int rowCount, byte[] chunk) throws SQLException {
        Row[] row = new Row[rowCount];
        int chunkOffset = 1;
        if (this.rowsFetchedCnt + rowCount < 0) {
            throw TbError.newSQLException(-90613);
        }
        this.currentFetchCount = rowCount;
        this.rowsFetchedCnt += rowCount;
        for (int i = 0; i < rowCount; ++i) {
            row[i] = new Row(this.columnCount);
            chunkOffset += row[i].buildRowData(chunk, chunkOffset, this.cols);
            this.rows.add(row[i]);
        }
        this.chunkRowDirOffset = chunkOffset;
    }

    protected void checkRowIndex(int rowIndex) throws SQLException {
        if (rowIndex < 0) {
            throw TbError.newSQLException(-90635);
        }
        if (this.stmt.getMaxRows() != 0 && rowIndex >= this.stmt.getMaxRows() || rowIndex >= this.rowsFetchedCnt) {
            throw TbError.newSQLException(-90624);
        }
    }

    protected void fetchRowsAll() throws SQLException {
        Debug.logMethod("TbRSScrollable.fetchRowsAll", new Object[]{this});
        while (this.stmt.getMaxRows() == 0 && this.currentRowIndex < this.stmt.getMaxRows() && !this.fetchComplete) {
            this.fetchRowsChunk();
        }
    }

    @Override
    public synchronized boolean first() throws SQLException {
        Debug.logMethod("TbRSScrollable.first", new Object[]{this});
        if (this.isRSEmpty()) {
            return false;
        }
        this.currentRowIndex = 0;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    @Override
    protected Row getCurrentRow() throws SQLException {
        if (this.currentRowIndex < 0) {
            throw TbError.newSQLException(-90635);
        }
        if (this.currentRowIndex >= this.rowsFetchedCnt) {
            throw TbError.newSQLException(-90624);
        }
        return this.rows.get(this.currentRowIndex);
    }

    protected Row getRowAt(int rowIndex) throws SQLException {
        return this.rows.get(rowIndex);
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        Debug.logMethod("TbResultSetBase.isLast", new Object[]{this});
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex + 1 == this.stmt.getMaxRows()) {
            return true;
        }
        if (this.currentRowIndex + 1 == this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return true;
            }
            this.fetchRowsChunk();
            return this.fetchComplete && this.currentRowIndex + 1 == this.rowsFetchedCnt;
        }
        return false;
    }

    protected boolean isRSEmpty() throws SQLException {
        if (this.rowsFetchedCnt != 0) {
            return false;
        }
        if (this.rowsFetchedCnt == 0 && this.fetchComplete) {
            return true;
        }
        return !this.isValidRowIndex(0);
    }

    protected boolean isValidRowIndex(int rowIndex) throws SQLException {
        Debug.logMethod("TbRSScrollable.isValidRowIndex", new Object[]{this, Integer.toString(rowIndex)});
        if (this.stmt.getMaxRows() != 0 && rowIndex >= this.stmt.getMaxRows()) {
            return false;
        }
        if (rowIndex >= 0 && rowIndex < this.rowsFetchedCnt) {
            return true;
        }
        if (rowIndex < 0) {
            return false;
        }
        if (rowIndex >= this.rowsFetchedCnt) {
            if (this.fetchComplete) {
                return false;
            }
            while (rowIndex >= this.rowsFetchedCnt) {
                if (!this.fetchComplete) {
                    this.rowChunk = null;
                    this.fetchRowsChunk();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean last() throws SQLException {
        Debug.logMethod("TbRSScrollable.last", new Object[]{this});
        if (this.isRSEmpty()) {
            return false;
        }
        if (!this.fetchComplete) {
            this.fetchRowsAll();
        }
        this.currentRowIndex = this.rowsFetchedCnt - 1;
        if (this.stmt.getMaxRows() != 0 && this.currentRowIndex >= this.stmt.getMaxRows()) {
            this.currentRowIndex = this.stmt.getMaxRows() - 1;
        }
        return this.isValidRowIndex(this.currentRowIndex);
    }

    @Override
    public synchronized boolean next() throws SQLException {
        Debug.logMethod("TbRSScrollable.next", new Object[]{Integer.toString(this.currentRowIndex)});
        this.currentRowIndex = this.currentRowIndex < 0 ? 0 : ++this.currentRowIndex;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        Debug.logMethod("TbRSScrollable.previous", new Object[]{this});
        if (this.isRSEmpty()) {
            return false;
        }
        this.currentRowIndex = this.currentRowIndex > 0 && !this.isValidRowIndex(this.currentRowIndex) ? this.rowsFetchedCnt - 1 : --this.currentRowIndex;
        return this.isValidRowIndex(this.currentRowIndex);
    }

    @Override
    protected void recover() throws SQLException {
        Debug.logMethod("TbRSScrollable.recover", new Object[]{this});
        this.setFOECode(0);
        if (this.stmt == null) {
            throw TbError.newSQLException(-90702, "stmt=null");
        }
        if (!TbSQLTypeScanner.isQueryStmt(this.stmt.getSqlType())) {
            throw TbError.newSQLException(-90702, "sqlType=" + this.stmt.getSqlType());
        }
        if (this.stmt.getRealRsetType().isSensitive() || this.stmt.getRealRsetType().isUpdatable()) {
            throw TbError.newSQLException(-90702, "realRsetType=" + this.stmt.getRealRsetType());
        }
        if (this.stmt.isReturnAutoGeneratedKeys()) {
            throw TbError.newSQLException(-90702, "autoGenKeys=true");
        }
        if (this.stmt instanceof TbPreparedStatementImpl) {
            TbPreparedStatementImpl pstmt = (TbPreparedStatementImpl)this.stmt;
            if (pstmt.getBatchRowCount() > 0) {
                throw TbError.newSQLException(-90702, "BatchRowCnt=" + pstmt.getBatchRowCount());
            }
            BindData bd = pstmt.getBindData();
            if (bd.getDFRParameterCnt() > 0) {
                throw TbError.newSQLException(-90702, "DFRParamCnt=" + bd.getDFRParameterCnt());
            }
            pstmt.setPPID(null);
            try {
                pstmt.conn.getTbComm().prepareExecute(pstmt, pstmt.getOriginalSql(), 0);
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90701, e);
            }
        }
        try {
            this.stmt.conn.getTbComm().executeDirect(this.stmt, this.stmt.getOriginalSql());
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90701, e);
        }
        if (this.stmt.currentRs == null) {
            throw TbError.newSQLException(-90702, "failoverRset=null");
        }
        if (!(this.stmt.currentRs instanceof TbRSScrollable)) {
            throw TbError.newSQLException(-90702, "failoverRsetClass=" + this.stmt.currentRs.getClass().getName());
        }
        TbRSScrollable newRs = (TbRSScrollable)this.stmt.currentRs;
        byte[] newRsChunk = null;
        Iterator<Row> iterRows = this.rows.iterator();
        while (iterRows.hasNext() && newRs.next()) {
            byte[] thisChunk;
            Row thisRow = iterRows.next();
            if (newRsChunk == newRs.rowChunk) continue;
            newRsChunk = newRs.rowChunk;
            int chunkRowDirOff = newRs.chunkRowDirOffset;
            long crcCheck = -1L;
            Object o = thisRow.getRowChunk(1);
            if (o instanceof byte[] && (thisChunk = (byte[])o).length > chunkRowDirOff) {
                crcCheck = this.getCurrentChunkCRC(thisChunk, chunkRowDirOff, 0L);
                crcCheck = this.getCurrentChunkCRC(newRsChunk, chunkRowDirOff, crcCheck);
            }
            if (crcCheck == 0L) continue;
            throw TbError.newSQLException(-90702, "failoverRset invalid.");
        }
        this.csrID = newRs.csrID;
        this.fetchComplete = newRs.fetchComplete;
        this.stmt.setResultSet(this);
        this.typeConverter = this.stmt.conn.getTypeConverter();
        newRs.reset();
        Debug.log("TbRSScrollable.recover finished successfully. " + this);
    }

    @Override
    public synchronized boolean relative(int rowIndex) throws SQLException {
        Debug.logMethod("TbRSScrollable.relative", new Object[]{this, Integer.toString(rowIndex)});
        if (this.isRSEmpty()) {
            return false;
        }
        if (this.isValidRowIndex(this.currentRowIndex)) {
            this.currentRowIndex += rowIndex;
            return this.isValidRowIndex(this.currentRowIndex);
        }
        throw TbError.newSQLException(-90624);
    }

    @Override
    protected void removeCurrentRow() throws SQLException {
        Debug.logMethod("TbRSScrollable.removeCurrentRow", new Object[]{this, new Integer(this.currentRowIndex)});
        this.checkRowIndex(this.currentRowIndex);
        this.rows.remove(this.currentRowIndex);
        --this.currentRowIndex;
        --this.rowsFetchedCnt;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.rows != null) {
            this.rows.clear();
            this.rows = null;
        }
    }

    protected void setRowAt(int rowIndex, Row row) throws SQLException {
        Debug.logMethod("TbRSScrollable.setRowAt", new Object[]{this, Integer.toString(rowIndex), row});
        this.rows.set(rowIndex, row);
    }
}

