/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbRowId;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.BatchInfo;
import com.tmax.tibero.jdbc.data.BatchUpdateInfo;
import com.tmax.tibero.jdbc.data.BigLiteral;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.BytesStreamWrapper;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.ReaderWrapper;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbParameterMetaData;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.driver.TbResultSetMetaData;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;

public class TbPreparedStatementImpl
extends TbStatement
implements PreparedStatement,
ParamContainer {
    protected byte[] ppid;
    private static byte[] PPID_NULL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected int bindParamCnt = 0;
    private int hiddenColCnt = 0;
    private int outColCnt = 0;
    private TbColumnDesc[] colMeta;
    private ResultSetMetaData resultSetMetaData;
    private String processedBigLiteralSql;
    private ArrayList<BigLiteral> bigLiterals;
    protected BindData bindData;
    private BatchUpdateInfo batchUpdateInfo;
    private int batchFlag = 256;
    protected int allocatedBatchRowCount = 1;
    protected int currentRowIndex = 0;
    private int[][] paramInt;
    private long[][] paramLong;
    private float[][] paramFloat;
    private double[][] paramDouble;
    private BigDecimal[][] paramBigDecimal;
    private String[][] paramString;
    private Timestamp[][] paramTimestamp;
    private TbTimestampTZ[][] paramTbTimestampTZ;
    private TbTimestamp[][] paramTbTimestamp;
    private TbDate[][] paramTbDate;
    private Calendar[][] paramCalendar;
    private byte[][][] paramBytes;
    private InputStream[][] paramStream;
    private Reader[][] paramReader;
    private byte[][] paramTypes;
    private Struct[][] paramStruct;
    private Array[][] paramArray;
    protected Binder[][] binder;
    protected Binder staticNullBinder;
    protected Binder staticStringBinder;
    protected Binder staticReaderBinder;
    protected Binder staticIntBinder;
    protected Binder staticLongBinder;
    protected Binder staticFloatBinder;
    protected Binder staticDoubleBinder;
    protected Binder staticBinaryFloatBinder;
    protected Binder staticBinaryDoubleBinder;
    protected Binder staticBigDecimalBinder;
    protected Binder staticDateBinder;
    protected Binder staticTimeBinder;
    protected Binder staticTimestampBinder;
    protected Binder staticTimestampTZBinder;
    protected Binder staticTbDateBinder;
    protected Binder staticTbTimestampBinder;
    protected Binder staticBytesBinder;
    protected Binder staticStreamBinder;
    protected Binder staticNStringBinder;
    protected Binder staticNReaderBinder;
    protected Binder staticStructInBinder;
    protected Binder staticStructOutBinder;
    protected Binder staticArrayInBinder;
    protected Binder staticArrayOutBinder;
    private int varcharMax;
    private int deferrableStrLen;
    private int deferrableNStrLen;
    protected Object autoGenKeyArr;
    private boolean supportBinaryDoubleFloatType;

    private void initializeBinder(ServerInfo info) {
        this.supportBinaryDoubleFloatType = TbPreparedStatementImpl.isSupportBinaryDoubleFloatType(info);
        this.staticNullBinder = StaticBinder.getNullBinder();
        this.staticStringBinder = StaticBinder.getStringBinder();
        this.staticReaderBinder = StaticBinder.getReaderBinder();
        this.staticIntBinder = StaticBinder.getIntBinder();
        this.staticLongBinder = StaticBinder.getLongBinder();
        this.staticFloatBinder = StaticBinder.getFloatBinder();
        this.staticDoubleBinder = StaticBinder.getDoubleBinder();
        this.staticBinaryFloatBinder = StaticBinder.getBinaryFloatBinder(this.supportBinaryDoubleFloatType);
        this.staticBinaryDoubleBinder = StaticBinder.getBinaryDoubleBinder(this.supportBinaryDoubleFloatType);
        this.staticBigDecimalBinder = StaticBinder.getBigDecimalBinder();
        this.staticDateBinder = StaticBinder.getDateBinder();
        this.staticTimeBinder = StaticBinder.getTimeBinder();
        this.staticTimestampBinder = StaticBinder.getTimestampBinder();
        this.staticTimestampTZBinder = StaticBinder.getTbTimestampTZBinder();
        this.staticTbDateBinder = StaticBinder.getTbDateBinder();
        this.staticTbTimestampBinder = StaticBinder.getTbTimestampBinder();
        this.staticBytesBinder = StaticBinder.getBytesBinder();
        this.staticStreamBinder = StaticBinder.getStreamBinder();
        this.staticNStringBinder = StaticBinder.getNStringBinder();
        this.staticNReaderBinder = StaticBinder.getNReaderBinder();
        this.staticStructInBinder = StaticBinder.getStructInBinder();
        this.staticStructOutBinder = StaticBinder.getStructOutBinder();
        this.staticArrayInBinder = StaticBinder.getArrayInBinder();
        this.staticArrayOutBinder = StaticBinder.getArrayOutBinder();
    }

    public TbPreparedStatementImpl(TbConnection conn, String sql) throws SQLException {
        this(conn, sql, 1003, 1007, 64000, false);
        this.initializeBinder(conn.getServerInfo());
        this.varcharMax = conn.getExtFeatureInfo().supports(0) ? 65532 : 4000;
        this.deferrableStrLen = this.varcharMax / Math.max(2, this.typeConverter.getMaxBytesPerChar()) + 1;
        this.deferrableNStrLen = this.varcharMax / Math.max(2, this.typeConverter.getMaxBytesPerNChar()) + 1;
    }

    public TbPreparedStatementImpl(TbConnection conn, String sql, int rsetType, int rsetConcurrency, int preFetchSize, boolean forcePrepare) throws SQLException {
        super(conn, rsetType, rsetConcurrency, preFetchSize);
        Debug.logMethod("TbPreparedStatement", null, null);
        this.poolable = conn.info.isStmtCache();
        this.sqlTypeScanner = new TbSQLTypeScanner();
        this.initSql(sql);
        if (forcePrepare) {
            this.forcePrepare();
        } else {
            this.initParameter();
        }
        this.initializeBinder(conn.getServerInfo());
        this.varcharMax = conn.getExtFeatureInfo().supports(0) ? 65532 : 4000;
        this.deferrableStrLen = this.varcharMax / Math.max(2, this.typeConverter.getMaxBytesPerChar()) + 1;
        this.deferrableNStrLen = this.varcharMax / Math.max(2, this.typeConverter.getMaxBytesPerNChar()) + 1;
    }

    @Override
    public void addBatch() throws SQLException {
        Debug.logMethod("TbPreparedStatement.addBatch", new Object[]{this});
        int deferredParamCount = this.bindData.getDFRParameterCnt();
        for (int i = 0; i < this.bindParamCnt; ++i) {
            BindItem item;
            if (this.binder[this.currentRowIndex][i] == null) {
                this.setCachedBindParameter(i);
            }
            if ((item = this.bindData.getBindItem(i)).isOUTParameter()) {
                throw TbError.newSQLException(-90631);
            }
            if (deferredParamCount > 0 || this.paramTypes[0][i] == this.paramTypes[this.currentRowIndex][i]) continue;
            this.batchFlag = 0;
        }
        if (this.batchUpdateInfo == null) {
            this.batchUpdateInfo = new BatchUpdateInfo();
        }
        BindData binds = new BindData();
        this.bindData.clone(binds);
        this.bindData.clearDFRParameter();
        this.batchUpdateInfo.add(new BatchInfo(binds, this.currentRowIndex));
        if (this.currentRowIndex == this.allocatedBatchRowCount - 1) {
            this.growBatchArray(this.allocatedBatchRowCount, 0);
        }
        ++this.currentRowIndex;
    }

    private void setCachedBindParameter(int i) throws SQLException {
        if (this.currentRowIndex > 0) {
            BindItem item = this.bindData.getBindItem(i);
            int sqlType = item.getSQLType();
            block0 : switch (sqlType) {
                case 4: {
                    this.paramInt[this.currentRowIndex][i] = this.paramInt[this.currentRowIndex - 1][i];
                    break;
                }
                case -5: {
                    this.paramBigDecimal[this.currentRowIndex][i] = this.paramBigDecimal[this.currentRowIndex - 1][i];
                    break;
                }
                case 6: {
                    this.paramFloat[this.currentRowIndex][i] = this.paramFloat[this.currentRowIndex - 1][i];
                    break;
                }
                case 8: {
                    this.paramDouble[this.currentRowIndex][i] = this.paramDouble[this.currentRowIndex - 1][i];
                    break;
                }
                case 2: {
                    this.paramLong[this.currentRowIndex][i] = this.paramLong[this.currentRowIndex - 1][i];
                    break;
                }
                case 12: {
                    this.paramString[this.currentRowIndex][i] = this.paramString[this.currentRowIndex - 1][i];
                    break;
                }
                case -1: {
                    this.paramReader[this.currentRowIndex][i] = this.paramReader[this.currentRowIndex - 1][i];
                    break;
                }
                case 91: 
                case 92: {
                    byte previousDataType = this.paramTypes[this.currentRowIndex - 1][i];
                    switch (previousDataType) {
                        case 5: {
                            if (this.paramCalendar != null && this.paramCalendar[this.currentRowIndex - 1][i] != null) {
                                this.paramCalendar[this.currentRowIndex][i] = this.paramCalendar[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            if (this.paramTbDate != null && this.paramTbDate[this.currentRowIndex - 1][i] != null) {
                                this.paramTbDate[this.currentRowIndex][i] = this.paramTbDate[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                        }
                        case 7: {
                            if (this.paramTimestamp != null && this.paramTimestamp[this.currentRowIndex - 1][i] != null) {
                                this.paramTimestamp[this.currentRowIndex][i] = this.paramTimestamp[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            if (this.paramTbTimestamp != null && this.paramTbTimestamp[this.currentRowIndex - 1][i] != null) {
                                this.paramTbTimestamp[this.currentRowIndex][i] = this.paramTbTimestamp[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                        }
                    }
                    throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                }
                case 93: {
                    byte previousDataType = this.paramTypes[this.currentRowIndex - 1][i];
                    switch (previousDataType) {
                        case 5: {
                            if (this.paramCalendar != null && this.paramCalendar[this.currentRowIndex - 1][i] != null) {
                                this.paramCalendar[this.currentRowIndex][i] = this.paramCalendar[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            if (this.paramTbDate != null && this.paramTbDate[this.currentRowIndex - 1][i] != null) {
                                this.paramTbDate[this.currentRowIndex][i] = this.paramTbDate[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            if (this.paramBytes != null && this.paramBytes[this.currentRowIndex - 1][i] != null) {
                                this.paramBytes[this.currentRowIndex][i] = this.paramBytes[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                        }
                        case 7: {
                            if (this.paramTimestamp != null && this.paramTimestamp[this.currentRowIndex - 1][i] != null) {
                                this.paramTimestamp[this.currentRowIndex][i] = this.paramTimestamp[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            if (this.paramTbTimestamp != null && this.paramTbTimestamp[this.currentRowIndex - 1][i] != null) {
                                this.paramTbTimestamp[this.currentRowIndex][i] = this.paramTbTimestamp[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                        }
                        case 21: {
                            if (this.paramTbTimestampTZ != null && this.paramTbTimestampTZ[this.currentRowIndex - 1][i] != null) {
                                this.paramTbTimestampTZ[this.currentRowIndex][i] = this.paramTbTimestampTZ[this.currentRowIndex - 1][i];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                        }
                    }
                    throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                }
                case -2: {
                    this.paramBytes[this.currentRowIndex][i] = this.paramBytes[this.currentRowIndex - 1][i];
                    break;
                }
                case -4: {
                    this.paramStream[this.currentRowIndex][i] = this.paramStream[this.currentRowIndex - 1][i];
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                }
            }
        } else {
            throw TbError.newSQLException(-90627);
        }
        this.binder[this.currentRowIndex][i] = this.binder[this.currentRowIndex - 1][i];
        this.paramTypes[this.currentRowIndex][i] = this.paramTypes[this.currentRowIndex - 1][i];
    }

    private void addBigLiteral(ArrayList<BigLiteral> literal) throws SQLException {
        int count = literal.size();
        if (this.bindParamCnt == 0) {
            this.binder = new Binder[this.allocatedBatchRowCount][count];
            this.paramTypes = new byte[this.allocatedBatchRowCount][count];
            this.bindData = new BindData(count);
            for (int i = 0; i < count; ++i) {
                BigLiteral bl = literal.get(i);
                String x = bl.getLiteralValue();
                int paramIndex = bl.getLiteralIndex();
                if (this.paramReader == null) {
                    this.paramReader = new Reader[this.allocatedBatchRowCount][count];
                }
                this.bindData.setDFRParam(paramIndex, -1, x.length());
                this.paramReader[this.currentRowIndex][paramIndex] = new StringReader(x);
                this.paramTypes[this.currentRowIndex][paramIndex] = 13;
                this.binder[this.currentRowIndex][paramIndex] = this.staticReaderBinder;
            }
            return;
        }
        this.growBatchArray(0, count);
        this.bindData.resize(this.bindParamCnt + count);
        for (int i = 0; i < count; ++i) {
            BigLiteral bl = literal.get(i);
            int paramIndex = bl.getLiteralIndex();
            String x = bl.getLiteralValue();
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt + count];
            }
            if (paramIndex < this.bindParamCnt) {
                this.pushParamData(count, paramIndex);
            }
            this.bindData.insertDFRLiteral(paramIndex, -1, x.length());
            this.paramReader[this.currentRowIndex][paramIndex] = new StringReader(x);
            this.paramTypes[this.currentRowIndex][paramIndex] = 13;
            this.binder[this.currentRowIndex][paramIndex] = this.staticReaderBinder;
        }
    }

    public void buildColMetaArray(int colCnt, int hiddenCnt, TbColumnDesc[] meta) {
        this.outColCnt = colCnt;
        this.hiddenColCnt = hiddenCnt;
        this.colMeta = meta;
    }

    protected void checkParameterIndex(int pos) throws SQLException {
        if (pos < 0 || pos > this.bindParamCnt) {
            throw TbError.newSQLException(-90609);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        Debug.logMethod("TbPreparedStatement.clearBatch", new Object[]{this});
        if (this.batchUpdateInfo != null) {
            this.batchUpdateInfo.clear();
        }
        for (int i = this.currentRowIndex; i >= 0; --i) {
            for (int j = 0; j < this.bindParamCnt; ++j) {
                this.binder[i][j] = null;
            }
        }
        this.currentRowIndex = 0;
    }

    private void clearBigLiteral(ArrayList<BigLiteral> literal) throws SQLException {
        int count = literal.size();
        int[] index = new int[count];
        block15: for (int i = count - 1; i >= 0; --i) {
            int j;
            BigLiteral bl = literal.get(i);
            index[i] = bl.getLiteralIndex();
            BindItem item = this.bindData.getBindItem(i);
            int sqlType = item.getSQLType();
            for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                this.binder[this.currentRowIndex][j] = this.binder[this.currentRowIndex][j + 1];
                this.binder[this.currentRowIndex][j + 1] = null;
            }
            for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                this.paramTypes[this.currentRowIndex][j] = this.paramTypes[this.currentRowIndex][j + 1];
            }
            switch (sqlType) {
                case 4: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramInt[this.currentRowIndex][j] = this.paramInt[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case -5: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramBigDecimal[this.currentRowIndex][j] = this.paramBigDecimal[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case 6: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramFloat[this.currentRowIndex][j] = this.paramFloat[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case 8: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramDouble[this.currentRowIndex][j] = this.paramDouble[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case 2: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramLong[this.currentRowIndex][j] = this.paramLong[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case 12: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramString[this.currentRowIndex][j] = this.paramString[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case -1: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramReader[this.currentRowIndex][j] = this.paramReader[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case 91: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        if (this.paramTbDate == null) continue;
                        this.paramTbDate[this.currentRowIndex][j] = this.paramTbDate[this.currentRowIndex][j + 1];
                    }
                }
                case 92: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        if (this.paramCalendar == null) continue;
                        this.paramCalendar[this.currentRowIndex][j] = this.paramCalendar[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case 93: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        if (this.paramTimestamp != null) {
                            this.paramTimestamp[this.currentRowIndex][j] = this.paramTimestamp[this.currentRowIndex][j + 1];
                        }
                        if (this.paramTbTimestamp != null) {
                            this.paramTbTimestamp[this.currentRowIndex][j] = this.paramTbTimestamp[this.currentRowIndex][j + 1];
                        }
                        if (this.paramTbTimestampTZ == null) continue;
                        this.paramTbTimestampTZ[this.currentRowIndex][j] = this.paramTbTimestampTZ[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case -2: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramBytes[this.currentRowIndex][j] = this.paramBytes[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case -4: {
                    for (j = index[i]; j < this.bindParamCnt + count - 1; ++j) {
                        this.paramStream[this.currentRowIndex][j] = this.paramStream[this.currentRowIndex][j + 1];
                    }
                    continue block15;
                }
                case 0: {
                    continue block15;
                }
                default: {
                    throw TbError.newSQLException(-590704, Integer.toString(sqlType));
                }
            }
        }
        this.bindData.removeDFRLiteral(index);
    }

    @Override
    public void clearParameters() throws SQLException {
        Debug.logMethod("TbPreparedStatement.clearParameters", new Object[]{this});
        if (this.bindData != null) {
            this.bindData.reuse();
        }
        for (int i = 0; i < this.bindParamCnt; ++i) {
            this.binder[this.currentRowIndex][i] = null;
        }
    }

    protected void copyBindParamInfo(ParamContainer pc) throws SQLException {
        Reader[] tempReader;
        InputStream[] tempStream;
        byte[][] tempBytes;
        TbTimestampTZ[] tempTbTimestampTZ;
        TbTimestamp[] tempTbTimestamp;
        TbDate[] tempTbDate;
        Timestamp[] tempTimestamp;
        Calendar[] tempCalendar;
        String[] tempString;
        BigDecimal[] tempBigDecimal;
        double[] tempDouble;
        float[] tempFloat;
        long[] tempLong;
        int[] tempInt;
        int newParamCount = pc.getParameterCnt();
        this.getBindData().set(pc.getBindData());
        Binder[][] tempBinder = pc.getBinder();
        this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
        if (tempBinder != null) {
            for (int i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(tempBinder[0], 0, this.binder[i], 0, newParamCount);
            }
        }
        byte[] tempTypes = pc.getParamTypesOfRow(this.currentRowIndex);
        this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
        if (tempTypes != null) {
            System.arraycopy(tempTypes, 0, this.paramTypes[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempInt = pc.getParamIntOfRow(this.currentRowIndex)) != null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempInt, 0, this.paramInt[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempLong = pc.getParamLongOfRow(this.currentRowIndex)) != null) {
            this.paramLong = new long[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempLong, 0, this.paramLong[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempFloat = pc.getParamFloatOfRow(this.currentRowIndex)) != null) {
            this.paramFloat = new float[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempFloat, 0, this.paramFloat[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempDouble = pc.getParamDoubleOfRow(this.currentRowIndex)) != null) {
            this.paramDouble = new double[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempLong, 0, this.paramDouble[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempBigDecimal = pc.getParamBigDecimalOfRow(this.currentRowIndex)) != null) {
            this.paramBigDecimal = new BigDecimal[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempBigDecimal, 0, this.paramBigDecimal[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempString = pc.getParamStringOfRow(this.currentRowIndex)) != null) {
            this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempString, 0, this.paramString[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempCalendar = pc.getParamCalendarOfRow(this.currentRowIndex)) != null) {
            this.paramCalendar = new Calendar[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempCalendar, 0, this.paramCalendar[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempTimestamp = pc.getParamTimestampOfRow(this.currentRowIndex)) != null) {
            this.paramTimestamp = new Timestamp[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempTimestamp, 0, this.paramTimestamp[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempTbDate = pc.getParamTbDateOfRow(this.currentRowIndex)) != null) {
            this.paramTbDate = new TbDate[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempTbDate, 0, this.paramTbDate[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempTbTimestamp = pc.getParamTbTimestampOfRow(this.currentRowIndex)) != null) {
            this.paramTbTimestamp = new TbTimestamp[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempTbTimestamp, 0, this.paramTbTimestamp[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempTbTimestampTZ = pc.getParamTbTimestampTZOfRow(this.currentRowIndex)) != null) {
            this.paramTbTimestampTZ = new TbTimestampTZ[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempTbTimestampTZ, 0, this.paramTbTimestampTZ[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempBytes = pc.getParamBytesOfRow(this.currentRowIndex)) != null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            System.arraycopy(tempBytes, 0, this.paramBytes[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempStream = pc.getParamStreamOfRow(this.currentRowIndex)) != null) {
            this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempStream, 0, this.paramStream[this.currentRowIndex], 0, newParamCount);
        }
        if ((tempReader = pc.getParamReaderOfRow(this.currentRowIndex)) != null) {
            this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tempReader, 0, this.paramReader[this.currentRowIndex], 0, newParamCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        Debug.logMethod("TbPreparedStatement.execute", null, null);
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        Debug.logMethod("TbPreparedStatement.execute", new String[]{"sql"}, new Object[]{sql});
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        if (autoGeneratedKeys != 1) {
            TbError.newSQLException(-590733);
        }
        Debug.logMethod("TbPreparedStatement.execute", new String[]{"sql"}, new Object[]{sql});
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(null);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        Debug.logMethod("TbPreparedStatement.execute", new String[]{"sql"}, new Object[]{sql});
        if (columnIndexes == null || columnIndexes.length == 0) {
            TbError.newSQLException(-590732);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(columnIndexes);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        Debug.logMethod("TbPreparedStatement.execute", new String[]{"sql"}, new Object[]{sql});
        if (columnNames == null || columnNames.length == 0) {
            TbError.newSQLException(-590734);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(columnNames);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        Debug.logMethod("TbPreparedStatement.executeBatch", new Object[]{this});
        int maxByteCount = this.conn.typeConverter.getMaxBytesPerChar();
        this.checkConnectionOpen();
        this.initBeforeExecute();
        if (this.currentRowIndex == 0) {
            this.batchCounts = new int[0];
            return this.batchCounts;
        }
        if (this.originalSql.length() > 65535 / maxByteCount) {
            ArrayList<BigLiteral> literal = new ArrayList<BigLiteral>();
            TbSQLParser.getBigLiteral(this.originalSql, maxByteCount, literal);
            if (literal.size() > 0) {
                throw TbError.newSQLException(-90652);
            }
        }
        try {
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            Object object = this.conn;
            synchronized (object) {
                this.batchCounts = this.conn.getTbComm().batchUpdateLoop(this, this.batchUpdateInfo);
            }
            object = this.batchCounts;
            return object;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
            this.clearBatch();
        }
    }

    private int executeBigLiteral(String sql, ArrayList<BigLiteral> literal) throws SQLException {
        Debug.logMethod("TbPreparedStatement.executeBigLiteral", new Object[]{this});
        this.addBigLiteral(literal);
        try {
            int n = this.executeCompleteSQL(sql);
            return n;
        }
        catch (SQLException e) {
            Debug.log("TbPreparedStatement.executeBigLiteral (PPID CLEARED)");
            this.ppid = null;
            throw e;
        }
        finally {
            this.clearBigLiteral(literal);
        }
    }

    private void prepareBigLiteralInternal(String sql, ArrayList<BigLiteral> literal) throws SQLException {
        Debug.logMethod("TbPreparedStatement.prepareBigLiteral", new Object[]{this});
        this.addBigLiteral(literal);
        try {
            this.prepareSQLInternal(sql);
        }
        catch (SQLException e) {
            Debug.log("TbPreparedStatement.prepareBigLiteral (PPID CLEARED)");
            this.ppid = null;
            throw e;
        }
        finally {
            this.clearBigLiteral(literal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCompleteSQL(String sql) throws SQLException {
        if (!this.isInsertStmt(sql)) {
            this.returnAutoGeneratedKeys = false;
        }
        if (TbSQLTypeScanner.isQueryStmt(this.sqlType)) {
            if (this.userRsetType.getType() == 1005 || this.userRsetType.getConcurrency() == 1008) {
                if (this.rsetTypeDowngraded) {
                    this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        int ret = this.conn.getTbComm().prepareExecute(this, sql, this.currentRowIndex);
                        this.rsetTypeDowngraded = true;
                        return ret;
                    }
                }
                this.sqlWithRowId = this.getQueryWithRowId(sql);
                try {
                    this.realRsetType = this.userRsetType;
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        return this.conn.getTbComm().prepareExecute(this, this.sqlWithRowId, this.currentRowIndex);
                    }
                }
                catch (SQLException se) {
                    this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                    TbConnection ret = this.conn;
                    synchronized (ret) {
                        int ret2 = this.conn.getTbComm().prepareExecute(this, sql, this.currentRowIndex);
                        this.rsetTypeDowngraded = true;
                        return ret2;
                    }
                }
            }
            try {
                this.realRsetType = this.userRsetType;
                TbConnection se = this.conn;
                synchronized (se) {
                    return this.conn.getTbComm().prepareExecute(this, sql, this.currentRowIndex);
                }
            }
            catch (SQLException e) {
                this.ppid = null;
                if (this.conn.isClosed() || !this.conn.info.isFailoverCursorEnabled() || e.getErrorCode() != -90700) {
                    throw e;
                }
                Debug.log("Failover cursor: re-execute query " + this);
                int ucnt = this.conn.getTbComm().prepareExecute(this, sql, this.currentRowIndex);
                this.addWarning(TbError.newSQLWarning(-90700, e));
                return ucnt;
            }
        }
        if (TbSQLTypeScanner.isDMLStmt(this.sqlType) || !TbSQLTypeScanner.isQueryStmt(this.sqlType) && !TbSQLTypeScanner.isPSMStmt(this.sqlType)) {
            this.realRsetType = this.userRsetType;
            String autoGeneratedValuesSql = sql;
            if (this.returnAutoGeneratedKeys) {
                if (this.realRsetType.isSensitive() || this.realRsetType.isUpdatable()) {
                    this.realRsetType = RsetType.SIRD;
                }
                if (this.autoGenKeyArr == null) {
                    autoGeneratedValuesSql = this.getAutoGenSql(this.originalSql);
                } else if (this.autoGenKeyArr instanceof int[]) {
                    autoGeneratedValuesSql = this.getAutoGenSql(this.originalSql, (int[])this.autoGenKeyArr);
                } else if (this.autoGenKeyArr instanceof String[]) {
                    autoGeneratedValuesSql = this.getAutoGenSql(this.originalSql, (String[])this.autoGenKeyArr);
                }
            }
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                this.rowsUpdated = this.conn.getTbComm().prepareExecute(this, autoGeneratedValuesSql, this.currentRowIndex);
            }
            return this.rowsUpdated;
        }
        this.realRsetType = TbSQLTypeScanner.isPSMStmt(this.sqlType) && this.userRsetType.isScrollable() || this.userRsetType.isUpdatable() ? RsetType.getDownGradedRsetType(this.userRsetType.getRank()) : this.userRsetType;
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            return this.conn.getTbComm().prepareExecute(this, sql, this.currentRowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSQLInternal(String sql) throws SQLException {
        if (!this.isInsertStmt(sql)) {
            this.returnAutoGeneratedKeys = false;
        }
        if (TbSQLTypeScanner.isQueryStmt(this.sqlType)) {
            this.realRsetType = this.userRsetType;
            Vector<Integer> serverTypes = new Vector<Integer>();
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                this.conn.getTbComm().prepare(this, sql, serverTypes);
            }
            this.allocatedBatchRowCount = 1;
            this.currentRowIndex = 0;
            this.bindData = new BindData(this.bindParamCnt);
            this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
            this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
            for (int i = 0; i < this.bindParamCnt; ++i) {
                int dataType = serverTypes.get(i);
                DataType.checkValidDataType(dataType);
                this.paramTypes[this.currentRowIndex][i] = (byte)dataType;
            }
            serverTypes.clear();
            Object var2_2 = null;
        }
    }

    protected synchronized int executeInternal(String sql) throws SQLException {
        int maxByteCount = this.conn.typeConverter.getMaxBytesPerChar();
        if (sql.length() > 65535 / maxByteCount) {
            if (this.processedBigLiteralSql == null) {
                if (this.bigLiterals == null) {
                    this.bigLiterals = new ArrayList();
                }
                this.processedBigLiteralSql = TbSQLParser.getBigLiteral(sql, maxByteCount, this.bigLiterals);
            }
            if (this.bigLiterals.size() > 0) {
                return this.executeBigLiteral(this.processedBigLiteralSql, this.bigLiterals);
            }
        }
        try {
            return this.executeCompleteSQL(sql);
        }
        catch (SQLException e) {
            Debug.log("TbPreparedStatement.executeInternal (PPID CLEARED)");
            this.ppid = null;
            throw e;
        }
    }

    protected synchronized void prepareInternal(String sql) throws SQLException {
        int maxByteCount = this.conn.typeConverter.getMaxBytesPerChar();
        if (sql.length() > 65535 / maxByteCount) {
            if (this.processedBigLiteralSql == null) {
                if (this.bigLiterals == null) {
                    this.bigLiterals = new ArrayList();
                }
                this.processedBigLiteralSql = TbSQLParser.getBigLiteral(sql, maxByteCount, this.bigLiterals);
            }
            if (this.bigLiterals.size() > 0) {
                this.prepareBigLiteralInternal(this.processedBigLiteralSql, this.bigLiterals);
            }
        }
        try {
            this.prepareSQLInternal(sql);
        }
        catch (SQLException e) {
            Debug.log("TbPreparedStatement.prepareSQLInternal (PPID CLEARED)");
            this.ppid = null;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        Debug.logMethod("TbPreparedStatement.executeQuery", null, null);
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.currentRs == null) {
            this.currentRs = TbResultSetFactory.buildResultSet(this, -1, 0, 0, null);
        }
        return this.currentRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        Debug.logMethod("TbPreparedStatement.executeQuery", new String[]{"sql"}, new Object[]{sql});
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.currentRs == null) {
            this.currentRs = TbResultSetFactory.buildResultSet(this, -1, 0, 0, null);
        }
        return this.currentRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        Debug.logMethod("TbPreparedStatement.executeUpdate", null, null);
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        Debug.logMethod("TbPreparedStatement.executeUpdate", new String[]{"sql"}, new Object[]{sql});
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        if (autoGeneratedKeys != 1) {
            TbError.newSQLException(-590733);
        }
        Debug.logMethod("TbPreparedStatement.executeUpdate", new String[]{"sql"}, new Object[]{sql});
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(null);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null || columnIndexes.length == 0) {
            TbError.newSQLException(-590732);
        }
        Debug.logMethod("TbPreparedStatement.executeUpdate", new String[]{"sql"}, new Object[]{sql});
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(columnIndexes);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null || columnNames.length == 0) {
            TbError.newSQLException(-590732);
        }
        Debug.logMethod("TbPreparedStatement.executeUpdate", new String[]{"sql"}, new Object[]{sql});
        this.checkConnectionOpen();
        this.initSQLInfo(sql);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(columnNames);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcePrepare() throws SQLException {
        Debug.logMethod("TbPreparedStatement.forcePrepare", new Object[]{this});
        Vector<Integer> serverTypes = new Vector<Integer>();
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().prepare(this, this.originalSql, serverTypes);
        }
        this.allocatedBatchRowCount = 1;
        this.currentRowIndex = 0;
        this.bindData = new BindData(this.bindParamCnt);
        this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
        this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
        for (int i = 0; i < this.bindParamCnt; ++i) {
            int dataType = serverTypes.get(i);
            DataType.checkValidDataType(dataType);
            this.paramTypes[this.currentRowIndex][i] = (byte)dataType;
        }
        serverTypes.clear();
        serverTypes = null;
    }

    public int getBatchFlag() {
        return this.batchFlag;
    }

    public int getBatchRowCount() {
        return this.currentRowIndex;
    }

    @Override
    public BindData getBindData() {
        return this.bindData;
    }

    @Override
    public Binder[][] getBinder() {
        return this.binder;
    }

    @Override
    public Binder getBinder(int rowIndex, int colIndex) {
        return this.binder[rowIndex][colIndex];
    }

    public TbColumnDesc[] getColMetaArray() {
        return this.colMeta;
    }

    public int getHiddenColCnt() {
        return this.hiddenColCnt;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbPreparedStatement.getMetaData", new Object[]{this});
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        if (rs == null) {
            this.prepareInternal();
            int colCnt = this.getColumnCount();
            Column[] cols = new Column[colCnt];
            for (int i = 0; i < colCnt; ++i) {
                cols[i] = new Column(this.conn.getMapDateToTimestamp());
            }
            this.typeConverter.buildColumnMetaData(this.colMeta, this.hiddenColCnt, colCnt, cols);
            this.resultSetMetaData = new TbResultSetMetaData(cols, 0);
        }
        return this.resultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareInternal() throws SQLException {
        Debug.logMethod("TbPreparedStatement.executePrepare", null, null);
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.prepareInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    int getColumnCount() {
        int hiddenColumnCount = this.getHiddenColCnt();
        int beginColumnIndex = 0;
        if (this.getRealRsetType() != null) {
            beginColumnIndex = hiddenColumnCount + (this.getRealRsetType().useRowId() ? 1 : 0);
        }
        return this.getOutColCnt() - beginColumnIndex;
    }

    public int getOutColCnt() {
        return this.outColCnt;
    }

    @Override
    public BigDecimal getParamBigDecimal(int rowIndex, int columnIndex) {
        return this.paramBigDecimal[rowIndex][columnIndex];
    }

    @Override
    public BigDecimal[] getParamBigDecimalOfRow(int rowIndex) {
        return this.paramBigDecimal == null ? null : this.paramBigDecimal[rowIndex];
    }

    @Override
    public byte[] getParamBytes(int rowIndex, int columnIndex) {
        return this.paramBytes[rowIndex][columnIndex];
    }

    @Override
    public byte[][] getParamBytesOfRow(int rowIndex) {
        return this.paramBytes == null ? (byte[][])null : this.paramBytes[rowIndex];
    }

    @Override
    public Calendar getParamCalendar(int rowIndex, int columnIndex) {
        return this.paramCalendar[rowIndex][columnIndex];
    }

    @Override
    public Calendar[] getParamCalendarOfRow(int rowIndex) {
        return this.paramCalendar == null ? null : this.paramCalendar[rowIndex];
    }

    @Override
    public double getParamDouble(int rowIndex, int columnIndex) {
        return this.paramDouble[rowIndex][columnIndex];
    }

    @Override
    public double[] getParamDoubleOfRow(int rowIndex) {
        return this.paramDouble == null ? null : this.paramDouble[rowIndex];
    }

    @Override
    public int getParameterCnt() {
        return this.bindParamCnt;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new TbParameterMetaData(this.bindParamCnt);
    }

    @Override
    public float getParamFloat(int rowIndex, int columnIndex) {
        return this.paramFloat[rowIndex][columnIndex];
    }

    @Override
    public float[] getParamFloatOfRow(int rowIndex) {
        return this.paramFloat == null ? null : this.paramFloat[rowIndex];
    }

    @Override
    public int getParamInt(int rowIndex, int columnIndex) {
        return this.paramInt[rowIndex][columnIndex];
    }

    @Override
    public int[] getParamIntOfRow(int rowIndex) {
        return this.paramInt == null ? null : this.paramInt[rowIndex];
    }

    @Override
    public long getParamLong(int rowIndex, int columnIndex) {
        return this.paramLong[rowIndex][columnIndex];
    }

    @Override
    public long[] getParamLongOfRow(int rowIndex) {
        return this.paramLong == null ? null : this.paramLong[rowIndex];
    }

    @Override
    public Reader getParamReader(int rowIndex, int columnIndex) {
        return this.paramReader[rowIndex][columnIndex];
    }

    @Override
    public Reader[] getParamReaderOfRow(int rowIndex) {
        return this.paramReader == null ? null : this.paramReader[rowIndex];
    }

    @Override
    public InputStream getParamStream(int rowIndex, int columnIndex) {
        return this.paramStream[rowIndex][columnIndex];
    }

    @Override
    public InputStream[] getParamStreamOfRow(int rowIndex) {
        return this.paramStream == null ? null : this.paramStream[rowIndex];
    }

    @Override
    public String getParamString(int rowIndex, int columnIndex) {
        return this.paramString[rowIndex][columnIndex];
    }

    @Override
    public String[] getParamStringOfRow(int rowIndex) {
        return this.paramString == null ? null : this.paramString[rowIndex];
    }

    @Override
    public Timestamp getParamTimestamp(int rowIndex, int columnIndex) {
        return this.paramTimestamp[rowIndex][columnIndex];
    }

    @Override
    public TbDate getParamTbDate(int rowIndex, int columnIndex) {
        return this.paramTbDate[rowIndex][columnIndex];
    }

    @Override
    public TbDate[] getParamTbDateOfRow(int rowIndex) {
        return this.paramTbDate == null ? null : this.paramTbDate[rowIndex];
    }

    @Override
    public TbTimestamp getParamTbTimestamp(int rowIndex, int columnIndex) {
        return this.paramTbTimestamp[rowIndex][columnIndex];
    }

    @Override
    public TbTimestamp[] getParamTbTimestampOfRow(int rowIndex) {
        return this.paramTbTimestamp == null ? null : this.paramTbTimestamp[rowIndex];
    }

    @Override
    public TbTimestampTZ getParamTbTimestampTZ(int rowIndex, int columnIndex) {
        return this.paramTbTimestampTZ[rowIndex][columnIndex];
    }

    @Override
    public TbTimestampTZ[] getParamTbTimestampTZOfRow(int rowIndex) {
        return this.paramTbTimestampTZ == null ? null : this.paramTbTimestampTZ[rowIndex];
    }

    @Override
    public Timestamp[] getParamTimestampOfRow(int rowIndex) {
        return this.paramTimestamp == null ? null : this.paramTimestamp[rowIndex];
    }

    @Override
    public Array getParamArray(int rowIndex, int columnIndex) {
        return this.paramArray[rowIndex][columnIndex];
    }

    @Override
    public Array[] getParamArrayOfRow(int rowIndex) {
        return this.paramArray == null ? null : this.paramArray[rowIndex];
    }

    @Override
    public Struct getParamStruct(int rowIndex, int columnIndex) {
        return this.paramStruct[rowIndex][columnIndex];
    }

    @Override
    public Struct[] getParamStructOfRow(int rowIndex) {
        return this.paramStruct == null ? null : this.paramStruct[rowIndex];
    }

    @Override
    public byte getParamType(int rowIndex, int colIndex) {
        return this.paramTypes[rowIndex][colIndex];
    }

    @Override
    public byte[][] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public byte[] getParamTypesOfRow(int rowIndex) {
        return this.paramTypes == null ? null : this.paramTypes[rowIndex];
    }

    public byte[] getPPID() {
        return this.ppid;
    }

    private void growBatchArray(int addBatchCount, int addParamCount) {
        int i;
        int newParamCount = this.bindParamCnt + addParamCount;
        int newBatchCount = this.allocatedBatchRowCount + addBatchCount;
        Binder[][] tempBinder = this.binder;
        this.binder = new Binder[newBatchCount][newParamCount];
        if (tempBinder != null) {
            for (int i2 = 0; i2 < this.allocatedBatchRowCount; ++i2) {
                System.arraycopy(tempBinder[i2], 0, this.binder[i2], 0, this.bindParamCnt);
            }
        }
        byte[][] tempTypes = this.paramTypes;
        this.paramTypes = new byte[newBatchCount][newParamCount];
        if (tempTypes != null) {
            for (int i3 = 0; i3 < this.allocatedBatchRowCount; ++i3) {
                System.arraycopy(tempTypes[i3], 0, this.paramTypes[i3], 0, this.bindParamCnt);
            }
        }
        if (this.paramInt != null) {
            int[][] temp = this.paramInt;
            this.paramInt = new int[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramInt[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramLong != null) {
            long[][] temp = this.paramLong;
            this.paramLong = new long[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramLong[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramFloat != null) {
            float[][] temp = this.paramFloat;
            this.paramFloat = new float[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramFloat[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramDouble != null) {
            double[][] temp = this.paramDouble;
            this.paramDouble = new double[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramDouble[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramBigDecimal != null) {
            BigDecimal[][] temp = this.paramBigDecimal;
            this.paramBigDecimal = new BigDecimal[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramBigDecimal[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramString != null) {
            String[][] temp = this.paramString;
            this.paramString = new String[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramString[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramCalendar != null) {
            Calendar[][] temp = this.paramCalendar;
            this.paramCalendar = new Calendar[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramCalendar[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramTimestamp != null) {
            Timestamp[][] temp = this.paramTimestamp;
            this.paramTimestamp = new Timestamp[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramTimestamp[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramTbDate != null) {
            TbDate[][] temp = this.paramTbDate;
            this.paramTbDate = new TbDate[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramTbDate[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramTbTimestamp != null) {
            TbTimestamp[][] temp = this.paramTbTimestamp;
            this.paramTbTimestamp = new TbTimestamp[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramTbTimestamp[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramTbTimestampTZ != null) {
            TbTimestampTZ[][] temp = this.paramTbTimestampTZ;
            this.paramTbTimestampTZ = new TbTimestampTZ[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramTbTimestampTZ[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramBytes != null) {
            byte[][][] temp = this.paramBytes;
            this.paramBytes = new byte[newBatchCount][newParamCount][];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramBytes[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramStream != null) {
            InputStream[][] temp = this.paramStream;
            this.paramStream = new InputStream[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramStream[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramReader != null) {
            Reader[][] temp = this.paramReader;
            this.paramReader = new Reader[newBatchCount][newParamCount];
            for (i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(temp[i], 0, this.paramReader[i], 0, this.bindParamCnt);
            }
        }
        this.allocatedBatchRowCount = newBatchCount;
    }

    public void initParameter() throws SQLException {
        this.bindParamCnt = TbSQLParser.getParamCount(this.originalSql, this.sqlType);
        this.allocatedBatchRowCount = 1;
        this.currentRowIndex = 0;
        if (this.bindData == null) {
            this.bindData = new BindData(this.bindParamCnt);
        } else {
            this.bindData.reuse();
            this.bindData.resize(this.bindParamCnt);
        }
        this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
        this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
    }

    private void initSQLInfo(String sql) throws SQLException {
        Debug.logMethod("TbPreparedStatement.initSQLInfo", new String[]{"SQL"}, new Object[]{sql});
        if (this.originalSql.equals(sql)) {
            return;
        }
        if (this.ppid != null) {
            this.ppid = null;
        }
        this.initSql(sql);
        this.initParameter();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        Debug.logMethod("TbStatement.isPoolable", new Object[]{this});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.poolable;
    }

    private void pushParamData(int count, int paramIndex) throws SQLException {
        int j;
        BindItem item = this.bindData.getBindItem(paramIndex);
        int sqlType = item.getSQLType();
        for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
            this.binder[this.currentRowIndex][j] = this.binder[this.currentRowIndex][j - 1];
        }
        for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
            this.paramTypes[this.currentRowIndex][j] = this.paramTypes[this.currentRowIndex][j - 1];
        }
        switch (sqlType) {
            case 4: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramInt[this.currentRowIndex][j] = this.paramInt[this.currentRowIndex][j - 1];
                }
                break;
            }
            case -5: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramBigDecimal[this.currentRowIndex][j] = this.paramBigDecimal[this.currentRowIndex][j - 1];
                }
                break;
            }
            case 6: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramFloat[this.currentRowIndex][j] = this.paramFloat[this.currentRowIndex][j - 1];
                }
                break;
            }
            case 8: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramDouble[this.currentRowIndex][j] = this.paramDouble[this.currentRowIndex][j - 1];
                }
                break;
            }
            case 2: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramLong[this.currentRowIndex][j] = this.paramLong[this.currentRowIndex][j - 1];
                }
                break;
            }
            case 12: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramString[this.currentRowIndex][j] = this.paramString[this.currentRowIndex][j - 1];
                }
                break;
            }
            case -1: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramReader[this.currentRowIndex][j] = this.paramReader[this.currentRowIndex][j - 1];
                }
                break;
            }
            case 91: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    if (this.paramTbDate == null) continue;
                    this.paramTbDate[this.currentRowIndex][j] = this.paramTbDate[this.currentRowIndex][j - 1];
                }
            }
            case 92: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    if (this.paramCalendar == null) continue;
                    this.paramCalendar[this.currentRowIndex][j] = this.paramCalendar[this.currentRowIndex][j - 1];
                }
                break;
            }
            case 93: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    if (this.paramTimestamp != null) {
                        this.paramTimestamp[this.currentRowIndex][j] = this.paramTimestamp[this.currentRowIndex][j - 1];
                    }
                    if (this.paramTbTimestamp != null) {
                        this.paramTbTimestamp[this.currentRowIndex][j] = this.paramTbTimestamp[this.currentRowIndex][j - 1];
                    }
                    if (this.paramTbTimestampTZ == null) continue;
                    this.paramTbTimestampTZ[this.currentRowIndex][j] = this.paramTbTimestampTZ[this.currentRowIndex][j - 1];
                }
                break;
            }
            case -2: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramBytes[this.currentRowIndex][j] = this.paramBytes[this.currentRowIndex][j - 1];
                }
                break;
            }
            case -4: {
                for (j = this.bindParamCnt + count - 1; j > paramIndex; --j) {
                    this.paramStream[this.currentRowIndex][j] = this.paramStream[this.currentRowIndex][j - 1];
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw TbError.newSQLException(-590704, Integer.toString(sqlType));
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.ppid = null;
        this.colMeta = null;
        this.paramInt = null;
        this.paramLong = null;
        this.paramFloat = null;
        this.paramDouble = null;
        this.paramBigDecimal = null;
        this.paramString = null;
        this.paramCalendar = null;
        this.paramTimestamp = null;
        this.paramTbDate = null;
        this.paramTbTimestamp = null;
        this.paramTbTimestampTZ = null;
        this.paramBytes = null;
        this.paramStream = null;
        this.paramReader = null;
        this.paramTypes = null;
        this.binder = null;
        this.processedBigLiteralSql = null;
        this.resultSetMetaData = null;
        if (this.bigLiterals != null) {
            this.bigLiterals.clear();
            this.bigLiterals = null;
        }
        if (this.bindData != null) {
            this.bindData.reset();
            this.bindData = null;
        }
        if (this.batchUpdateInfo != null) {
            this.batchUpdateInfo.clear();
            this.batchUpdateInfo = null;
        }
        this.autoGenKeyArr = null;
    }

    @Override
    public synchronized void resetForCache() {
        super.resetForCache();
        this.paramInt = null;
        this.paramLong = null;
        this.paramFloat = null;
        this.paramDouble = null;
        this.paramBigDecimal = null;
        this.paramString = null;
        this.paramCalendar = null;
        this.paramTimestamp = null;
        this.paramTbDate = null;
        this.paramTbTimestamp = null;
        this.paramTbTimestampTZ = null;
        this.paramBytes = null;
        this.paramStream = null;
        this.paramReader = null;
        this.paramTypes = null;
        this.binder = null;
        this.allocatedBatchRowCount = 1;
        this.currentRowIndex = 0;
        this.processedBigLiteralSql = null;
        this.resultSetMetaData = null;
        if (this.bigLiterals != null) {
            this.bigLiterals.clear();
            this.bigLiterals = null;
        }
        if (this.bindData != null) {
            this.bindData.reset();
            this.bindData = null;
        }
        if (this.batchUpdateInfo != null) {
            this.batchUpdateInfo.clear();
            this.batchUpdateInfo = null;
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setArray", new Object[]{this, x});
        this.setArrayInternal(i, x);
    }

    @Override
    public void setAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setAsciiStream", new Object[]{this, x});
        this.setAsciiStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setAsciiStream", new Object[]{this, x, Integer.toString(len)});
        this.setAsciiStreamInternal(i, x, len);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setAsciiStream", new Object[]{this, x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.setAsciiStreamInternal(i, x, (int)len);
    }

    void setAsciiStreamInternal(int i, InputStream x, int len) throws SQLException {
        if (x == null || len <= 0) {
            this.setNullInternal(i, 3);
            return;
        }
        int bufLen = 65532 < len ? 65533 : len;
        byte[] byteBuf = new byte[bufLen];
        int readLen = 0;
        try {
            readLen = x.read(byteBuf, 0, bufLen);
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
        if (readLen < 0) {
            this.setNullInternal(i, 3);
        } else if (readLen > 65532) {
            if (this.paramStream == null) {
                this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(i - 1, -1, len);
            this.paramStream[this.currentRowIndex][i - 1] = new BytesStreamWrapper(x, byteBuf, readLen);
            this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 13;
        } else {
            if (this.paramBytes == null) {
                this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            }
            this.bindData.setINParam(i - 1, 12, readLen);
            this.paramBytes[this.currentRowIndex][i - 1] = byteBuf;
            this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 3;
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBigDecimal", new Object[]{this, Integer.toString(i), x});
        this.setBigDecimalInternal(i, x);
    }

    void setBigDecimalInternal(int i, BigDecimal x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 1);
            return;
        }
        if (this.paramBigDecimal == null) {
            this.paramBigDecimal = new BigDecimal[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, -5, -1);
        this.paramBigDecimal[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 1;
        this.binder[this.currentRowIndex][i - 1] = this.staticBigDecimalBinder;
    }

    @Override
    public void setBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x});
        this.setBinaryStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.setBinaryStreamInternal(i, x, len);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.setBinaryStreamInternal(i, x, (int)len);
    }

    void setBinaryStreamInternal(int i, InputStream x, int len) throws SQLException {
        if (x == null || len <= 0) {
            this.setNullInternal(i, 4);
            return;
        }
        int bufLen = 65532 < len ? 65533 : len;
        byte[] byteBuf = new byte[bufLen];
        int readLen = 0;
        try {
            readLen = x.read(byteBuf, 0, bufLen);
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
        if (readLen < 0) {
            this.setNullInternal(i, 4);
        } else if (readLen > 65532) {
            if (this.paramStream == null) {
                this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(i - 1, -4, len);
            this.paramStream[this.currentRowIndex][i - 1] = new BytesStreamWrapper(x, byteBuf, readLen);
            this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 12;
        } else {
            if (this.paramBytes == null) {
                this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            }
            this.bindData.setINParam(i - 1, -2, readLen);
            this.paramBytes[this.currentRowIndex][i - 1] = byteBuf;
            this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 4;
        }
    }

    public void setBindData(BindData data) {
        this.bindData = data;
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBlob", new Object[]{this, Integer.toString(i), x});
        this.setBlobInternal(i, x);
    }

    @Override
    public void setBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBlob", new Object[]{this, Integer.toString(i), x});
        this.setBlobInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBlob(int i, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBlob", new Object[]{this, Integer.toString(i), x, Long.toString(length)});
        this.setBlobInternal(i, x, length);
    }

    void setBlobInternal(int i, Blob x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 12);
            return;
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        this.bindData.setINParam(i - 1, -2, ((TbLob)((Object)x)).getLocatorLength());
        this.paramBytes[this.currentRowIndex][i - 1] = ((TbLob)((Object)x)).getLocator();
        this.paramTypes[this.currentRowIndex][i - 1] = 12;
        this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
    }

    void setBlobInternal(int i, InputStream x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(length));
        }
        this.setBinaryStreamInternal(i, x, (int)length);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        this.setBooleanInternal(i, x);
    }

    void setBooleanInternal(int i, boolean x) throws SQLException {
        if (this.paramString == null) {
            this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 1, 1);
        this.paramString[this.currentRowIndex][i - 1] = x ? "1" : "0";
        this.paramTypes[this.currentRowIndex][i - 1] = 2;
        this.binder[this.currentRowIndex][i - 1] = this.staticStringBinder;
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setByte", new Object[]{this, Integer.toString(i), new Byte(x)});
        this.setByteInternal(i, x);
    }

    void setByteInternal(int i, byte x) throws SQLException {
        if (this.paramInt == null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 4, -1);
        this.paramInt[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 1;
        this.binder[this.currentRowIndex][i - 1] = this.staticIntBinder;
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBytes", new Object[]{this, Integer.toString(i), x});
        this.setBytesInternal(i, 4, x);
    }

    public void setBytes(int i, int dataType, byte[] x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBytes", new Object[]{this, Integer.toString(i), Integer.toString(dataType), x});
        DataType.checkValidDataType(dataType);
        this.setBytesInternal(i, dataType, x);
    }

    void setBytesInternal(int i, int dataType, byte[] x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, dataType);
            return;
        }
        if (x.length >= 65532) {
            if (this.paramStream == null) {
                this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(i - 1, -4, x.length);
            this.paramStream[this.currentRowIndex][i - 1] = new ByteArrayInputStream(x);
            this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 12;
        } else {
            if (this.paramBytes == null) {
                this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            }
            if (!(this.supportBinaryDoubleFloatType || dataType != 24 && dataType != 23)) {
                dataType = 1;
            }
            this.bindData.setINParam(i - 1, -2, x.length);
            this.paramBytes[this.currentRowIndex][i - 1] = x;
            this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = (byte)dataType;
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.setCharacterStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(int i, Reader x, int len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setCharacterStream", new Object[]{this, Integer.toString(i), x, Integer.toString(len)});
        this.setCharacterStreamInternal(i, x, len);
    }

    @Override
    public void setCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.setCharacterStreamInternal(i, x, (int)len);
    }

    void setCharacterStreamInternal(int i, Reader x, int length) throws SQLException {
        if (x == null || length <= 0) {
            this.setNullInternal(i, 3);
            return;
        }
        int cBufLen = length < this.varcharMax + 1 ? length : this.varcharMax + 1;
        char[] cb = new char[cBufLen];
        int readCh = 0;
        try {
            readCh = x.read(cb, 0, cBufLen);
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
        if (readCh < 0) {
            this.setNullInternal(i, 3);
        } else if (readCh < this.deferrableStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(i - 1, 12, length);
            this.paramString[this.currentRowIndex][i - 1] = new String(cb, 0, readCh);
            this.binder[this.currentRowIndex][i - 1] = this.staticStringBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 3;
        } else if (readCh > this.varcharMax) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(i - 1, -1, length);
            this.paramReader[this.currentRowIndex][i - 1] = ReaderWrapper.getInstance(x, cb, readCh);
            this.binder[this.currentRowIndex][i - 1] = this.staticReaderBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 13;
        } else {
            byte[] buf = new byte[readCh * this.typeConverter.getMaxBytesPerChar()];
            int byteLen = this.typeConverter.charsToBytes(cb, 0, readCh, buf, 0, buf.length);
            if (byteLen < this.varcharMax) {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(i - 1, 12, byteLen);
                this.paramBytes[this.currentRowIndex][i - 1] = buf;
                this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 3;
            } else {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(i - 1, -1, byteLen);
                this.paramStream[this.currentRowIndex][i - 1] = new ByteArrayInputStream(buf, 0, byteLen);
                this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 13;
            }
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setClob", new Object[]{this, Integer.toString(i), x});
        this.setClobInternal(i, 13, x);
    }

    @Override
    public void setClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setClob", new Object[]{this, Integer.toString(i), x});
        this.setClobInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setClob(int i, Reader x, long length) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setClob", new Object[]{this, Integer.toString(i), x, Long.toString(length)});
        this.setClobInternal(i, x, length);
    }

    public void setClobInternal(int i, int dataType, Clob x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, dataType);
            return;
        }
        if (!(x instanceof TbClob) && !(x instanceof TbNClob)) {
            throw TbError.newSQLException(-590770, x.toString());
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        this.bindData.setINParam(i - 1, -2, ((TbLob)((Object)x)).getLocator().length);
        this.paramBytes[this.currentRowIndex][i - 1] = ((TbLob)((Object)x)).getLocator();
        this.paramTypes[this.currentRowIndex][i - 1] = (byte)dataType;
        this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
    }

    void setClobInternal(int i, Reader x, long len) throws SQLException {
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.setCharacterStreamInternal(i, x, (int)len);
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setDate", new Object[]{this, Integer.toString(i), x});
        this.setDateInternal(i, x);
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setDate", new Object[]{this, Integer.toString(i), x, cal});
        if (x == null) {
            this.setNullInternal(i, 5);
            return;
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.setTime(x);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        byte[] buf = new byte[8];
        this.typeConverter.fromDate(buf, 0, cal);
        this.bindData.setINParam(i - 1, 91, buf.length);
        this.paramBytes[this.currentRowIndex][i - 1] = buf;
        this.paramTypes[this.currentRowIndex][i - 1] = 5;
        this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
    }

    void setDateInternal(int i, Date x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 5);
            return;
        }
        if (this.paramCalendar == null) {
            this.paramCalendar = new Calendar[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(x);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.bindData.setINParam(i - 1, 91, -1);
        this.paramCalendar[this.currentRowIndex][i - 1] = cal;
        this.paramTypes[this.currentRowIndex][i - 1] = 5;
        this.binder[this.currentRowIndex][i - 1] = this.staticDateBinder;
    }

    public void setTbDate(int i, TbDate x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setTbDate", new Object[]{this, Integer.toString(i), x});
        this.setTbDateInternal(i, x);
    }

    void setTbDateInternal(int i, TbDate x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 5);
            return;
        }
        if (this.paramTbDate == null) {
            this.paramTbDate = new TbDate[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 91, -1);
        this.paramTbDate[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 5;
        this.binder[this.currentRowIndex][i - 1] = this.staticTbDateBinder;
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        this.setDoubleInternal(i, x);
    }

    void setDoubleInternal(int i, double x) throws SQLException {
        if (this.paramDouble == null) {
            this.paramDouble = new double[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType && (Double.compare(x, Double.NaN) == 0 || Double.compare(x, Double.NEGATIVE_INFINITY) == 0 || Double.compare(x, Double.POSITIVE_INFINITY) == 0)) {
            this.setBinaryDoubleInternal(i, x);
        } else {
            this.bindData.setINParam(i - 1, 8, -1);
            this.paramDouble[this.currentRowIndex][i - 1] = x;
            this.paramTypes[this.currentRowIndex][i - 1] = 1;
            this.binder[this.currentRowIndex][i - 1] = this.staticDoubleBinder;
        }
    }

    public void setBinaryDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBinaryDouble", new Object[]{this, Integer.toString(i), Long.toHexString(Double.doubleToLongBits(x))});
        this.setBinaryDoubleInternal(i, x);
    }

    void setBinaryDoubleInternal(int i, double x) throws SQLException {
        if (this.paramDouble == null) {
            this.paramDouble = new double[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType) {
            this.bindData.setINParam(i - 1, 101, -1);
            this.paramDouble[this.currentRowIndex][i - 1] = x;
            this.paramTypes[this.currentRowIndex][i - 1] = 24;
            this.binder[this.currentRowIndex][i - 1] = this.staticBinaryDoubleBinder;
        } else {
            this.setDoubleInternal(i, x);
        }
    }

    public void setFixedCHAR(int i, String x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setFixedCHAR", new Object[]{this, Integer.toString(i), x});
        this.setFixedCHARInternal(i, x);
    }

    void setFixedCHARInternal(int i, String x) throws SQLException {
        if (x == null || x.length() == 0) {
            this.setNullInternal(i, 3);
            return;
        }
        if (this.paramString == null) {
            this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 1, x.length());
        this.paramString[this.currentRowIndex][i - 1] = x;
        this.binder[this.currentRowIndex][i - 1] = this.staticStringBinder;
        this.paramTypes[this.currentRowIndex][i - 1] = 2;
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        this.setFloatInternal(i, x);
    }

    void setFloatInternal(int i, float x) throws SQLException {
        if (this.paramFloat == null) {
            this.paramFloat = new float[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType && (Float.compare(x, Float.NaN) == 0 || Float.compare(x, Float.NEGATIVE_INFINITY) == 0 || Float.compare(x, Float.POSITIVE_INFINITY) == 0)) {
            this.setBinaryFloatInternal(i, x);
        } else {
            this.bindData.setINParam(i - 1, 6, -1);
            this.paramFloat[this.currentRowIndex][i - 1] = x;
            this.paramTypes[this.currentRowIndex][i - 1] = 1;
            this.binder[this.currentRowIndex][i - 1] = this.staticFloatBinder;
        }
    }

    public void setBinaryFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBinaryFloat", new Object[]{this, Integer.toString(i), Long.toHexString(Float.floatToIntBits(x))});
        this.setBinaryFloatInternal(i, x);
    }

    void setBinaryFloatInternal(int i, float x) throws SQLException {
        if (this.paramFloat == null) {
            this.paramFloat = new float[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType) {
            this.bindData.setINParam(i - 1, 100, -1);
            this.paramFloat[this.currentRowIndex][i - 1] = x;
            this.paramTypes[this.currentRowIndex][i - 1] = 23;
            this.binder[this.currentRowIndex][i - 1] = this.staticBinaryFloatBinder;
        } else {
            this.setFloatInternal(i, x);
        }
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        this.setIntInternal(i, x);
    }

    void setIntInternal(int i, int x) throws SQLException {
        if (this.paramInt == null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 4, -1);
        this.paramInt[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 1;
        this.binder[this.currentRowIndex][i - 1] = this.staticIntBinder;
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        this.setLongInternal(i, x);
    }

    void setLongInternal(int i, long x) throws SQLException {
        if (this.paramLong == null) {
            this.paramLong = new long[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 2, -1);
        this.paramLong[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 1;
        this.binder[this.currentRowIndex][i - 1] = this.staticLongBinder;
    }

    @Override
    public void setNCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.setNCharacterStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setNCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.setNCharacterStreamInternal(i, x, (int)len);
    }

    void setNCharacterStreamInternal(int i, Reader x, int length) throws SQLException {
        if (x == null || length <= 0) {
            this.setNullInternal(i, 19);
            return;
        }
        int cBufLen = length < this.varcharMax + 1 ? length : this.varcharMax + 1;
        char[] cb = new char[cBufLen];
        int readCh = 0;
        try {
            readCh = x.read(cb, 0, cBufLen);
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
        if (readCh < 0) {
            this.setNullInternal(i, 19);
        } else if (readCh < this.deferrableNStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(i - 1, -9, length);
            this.paramString[this.currentRowIndex][i - 1] = new String(cb, 0, readCh);
            this.binder[this.currentRowIndex][i - 1] = this.staticNStringBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 19;
        } else if (readCh > this.varcharMax) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(i - 1, -16, length);
            this.paramReader[this.currentRowIndex][i - 1] = ReaderWrapper.getInstance(x, cb, readCh);
            this.binder[this.currentRowIndex][i - 1] = this.staticNReaderBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 20;
        } else {
            byte[] buf = new byte[readCh * this.typeConverter.getMaxBytesPerNChar()];
            int byteLen = this.typeConverter.nCharsToBytes(cb, 0, readCh, buf, 0, buf.length);
            if (byteLen < this.varcharMax) {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(i - 1, -9, byteLen);
                this.paramBytes[this.currentRowIndex][i - 1] = buf;
                this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 19;
            } else {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(i - 1, -16, byteLen);
                this.paramStream[this.currentRowIndex][i - 1] = new ByteArrayInputStream(buf, 0, byteLen);
                this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 20;
            }
        }
    }

    public void setNClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNClob", new Object[]{this, Integer.toString(i), x});
        this.setClobInternal(i, 20, x);
    }

    @Override
    public void setNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNClob", new Object[]{this, Integer.toString(i), x});
        this.setClobInternal(i, 20, x);
    }

    @Override
    public void setNClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNClob", new Object[]{this, Integer.toString(i), x});
        this.setNClobInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setNClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.setNClobInternal(i, x, (int)len);
    }

    void setNClobInternal(int i, Reader x, int len) throws SQLException {
        if (x == null || len <= 0) {
            this.setNullInternal(i, 19);
            return;
        }
        if (len >= this.conn.getMaxDFRNCharCount()) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(i - 1, -16, len);
            this.paramReader[this.currentRowIndex][i - 1] = x;
            this.binder[this.currentRowIndex][i - 1] = this.staticNReaderBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 20;
        } else {
            int readLen = 0;
            char[] cbuf = new char[len];
            try {
                readLen = x.read(cbuf, 0, len);
            }
            catch (IOException e) {
                throw TbError.newSQLException(-90202, e.getMessage());
            }
            if (readLen != len) {
                char[] temp = cbuf;
                cbuf = new char[readLen];
                System.arraycopy(temp, 0, cbuf, 0, readLen);
            }
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(i - 1, -9, len);
            this.paramString[this.currentRowIndex][i - 1] = new String(cbuf);
            this.binder[this.currentRowIndex][i - 1] = this.staticStringBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 19;
        }
    }

    @Override
    public void setNString(int i, String x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNString", new Object[]{this, Integer.toString(i), x});
        this.setNStringInternal(i, x);
    }

    void setNStringInternal(int i, String x) throws SQLException {
        if (x == null || x.length() == 0) {
            this.setNullInternal(i, 19);
            return;
        }
        if (x.length() < this.deferrableNStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(i - 1, -9, x.length());
            this.paramString[this.currentRowIndex][i - 1] = x;
            this.binder[this.currentRowIndex][i - 1] = this.staticNStringBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 19;
        } else {
            byte[] buf = new byte[x.length() * this.typeConverter.getMaxBytesPerNChar()];
            int byteLen = this.typeConverter.fromNString(buf, 0, x);
            if (byteLen > this.varcharMax) {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(i - 1, -16, byteLen);
                this.paramStream[this.currentRowIndex][i - 1] = new ByteArrayInputStream(buf, 0, byteLen);
                this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 20;
            } else {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(i - 1, -9, byteLen);
                this.paramBytes[this.currentRowIndex][i - 1] = buf;
                this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 19;
            }
        }
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType)});
        this.setNullInternal(i, DataType.getDataType(sqlType));
    }

    @Override
    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType), typeName});
        this.setNullInternal(i, DataType.getDataType(sqlType));
    }

    void setNullInternal(int i, int dataType) throws SQLException {
        this.bindData.setINParam(i - 1, 0, 0);
        this.paramTypes[this.currentRowIndex][i - 1] = (byte)dataType;
        this.binder[this.currentRowIndex][i - 1] = this.staticNullBinder;
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        this.setObject(i, x, DataType.getSqlType(x), 0);
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        this.setObject(i, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int i, Object x, int sqlType, int scale) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setObject", new Object[]{this, Integer.toString(i), x, Integer.toString(sqlType), Integer.toString(scale)});
        this.setObjectInternal(i, x, sqlType, scale);
    }

    void setObjectInternal(int i, Object x, int sqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 2);
            return;
        }
        switch (sqlType) {
            case -7: {
                this.setBooleanInternal(i, new Boolean(x.toString()));
                break;
            }
            case -15: 
            case -9: {
                this.setNStringInternal(i, x.toString());
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (x instanceof Boolean) {
                    this.setStringInternal(i, (Boolean)x != false ? "1" : "0");
                    break;
                }
                this.setStringInternal(i, x.toString());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytesInternal(i, 4, (byte[])x);
                break;
            }
            case -6: 
            case 5: {
                if (x instanceof Number) {
                    this.setShortInternal(i, ((Number)x).shortValue());
                    break;
                }
                if (x instanceof String) {
                    this.setShortInternal(i, Short.parseShort((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setShortInternal(i, (short)((Boolean)x != false ? 1 : 0));
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 4: {
                if (x instanceof Number) {
                    this.setIntInternal(i, ((Number)x).intValue());
                    break;
                }
                if (x instanceof String) {
                    this.setIntInternal(i, Integer.parseInt((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setIntInternal(i, (Boolean)x != false ? 1 : 0);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case -5: {
                if (x instanceof Number) {
                    this.setLongInternal(i, ((Number)x).longValue());
                    break;
                }
                if (x instanceof String) {
                    this.setLongInternal(i, Long.parseLong((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setLongInternal(i, (Boolean)x != false ? 1L : 0L);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 3: {
                if (x instanceof BigDecimal) {
                    this.setBigDecimalInternal(i, (BigDecimal)x);
                    break;
                }
                if (x instanceof Number) {
                    this.setBigDecimalInternal(i, new BigDecimal(((Number)x).doubleValue()));
                    break;
                }
                if (x instanceof String) {
                    this.setBigDecimalInternal(i, new BigDecimal((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBigDecimalInternal(i, new BigDecimal((Boolean)x != false ? 1.0 : 0.0));
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 7: {
                if (x instanceof Number) {
                    this.setFloatInternal(i, ((Number)x).floatValue());
                    break;
                }
                if (x instanceof String) {
                    this.setFloatInternal(i, Float.valueOf((String)x).floatValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setFloatInternal(i, (Boolean)x != false ? 1.0f : 0.0f);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 6: 
            case 8: {
                if (x instanceof Number) {
                    this.setDoubleInternal(i, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof String) {
                    this.setDoubleInternal(i, Double.valueOf((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setDoubleInternal(i, (Boolean)x != false ? 1.0 : 0.0);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 2: {
                if (x instanceof Short) {
                    this.setShortInternal(i, (Short)x);
                    break;
                }
                if (x instanceof Integer) {
                    this.setIntInternal(i, (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setLongInternal(i, (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setFloatInternal(i, ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setDoubleInternal(i, (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setBigDecimalInternal(i, (BigDecimal)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBooleanInternal(i, (Boolean)x);
                    break;
                }
                if (x instanceof String) {
                    this.setBigDecimalInternal(i, new BigDecimal((String)x));
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 100: {
                if (x instanceof Number) {
                    this.setBinaryFloatInternal(i, ((Number)x).floatValue());
                    break;
                }
                if (x instanceof String) {
                    this.setBinaryFloatInternal(i, Float.valueOf((String)x).floatValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBinaryFloatInternal(i, (Boolean)x != false ? 1.0f : 0.0f);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 101: {
                if (x instanceof Number) {
                    this.setBinaryDoubleInternal(i, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof String) {
                    this.setBinaryDoubleInternal(i, Double.valueOf((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBinaryDoubleInternal(i, (Boolean)x != false ? 1.0 : 0.0);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 91: {
                if (x instanceof Date) {
                    this.setDateInternal(i, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setDateInternal(i, (Date)x);
                    break;
                }
                if (x instanceof String) {
                    this.setDateInternal(i, Date.valueOf((String)x));
                    break;
                }
                if (x instanceof TbDate) {
                    this.setTbDate(i, (TbDate)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 92: {
                if (x instanceof Time) {
                    this.setTimeInternal(i, (Time)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimeInternal(i, new Time(((Timestamp)x).getTime()));
                    break;
                }
                if (x instanceof Date) {
                    this.setTimeInternal(i, new Time(((Date)x).getTime()));
                    break;
                }
                if (x instanceof String) {
                    this.setTimeInternal(i, Time.valueOf((String)x));
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 93: {
                if (x instanceof Timestamp) {
                    this.setTimestampInternal(i, (Timestamp)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setDateInternal(i, (Date)x);
                    break;
                }
                if (x instanceof String) {
                    this.setTimestampInternal(i, Timestamp.valueOf((String)x));
                    break;
                }
                if (x instanceof TbTimestamp) {
                    this.setTbTimestamp(i, (TbTimestamp)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 2004: {
                if (x instanceof Blob) {
                    this.setBlobInternal(i, (Blob)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 2011: {
                if (x instanceof NClob) {
                    this.setClobInternal(i, 20, (NClob)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 2005: {
                if (x instanceof Clob) {
                    this.setClobInternal(i, 13, (Clob)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case -8: {
                if (x instanceof RowId) {
                    this.setRowIdInternal(i, (RowId)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 2009: {
                if (x instanceof SQLXML) {
                    this.setSQLXMLInternal(i, (SQLXML)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 2002: {
                if (x instanceof Struct) {
                    this.setStructInternal(i, (Struct)x);
                    break;
                }
                if (x instanceof SQLData) {
                    this.setStructInternal(i, (Struct)TbStruct.toStruct(x, this.conn));
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case -2003: 
            case 2003: {
                if (x instanceof Array) {
                    this.setArrayInternal(i, (Array)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            default: {
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
        }
    }

    private void setStructInternal(int i, Struct x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 28);
            return;
        }
        if (this.paramStruct == null) {
            this.paramStruct = new TbStruct[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        TbStruct struct = (TbStruct)x;
        int structKind = struct.getDescriptor().getDataType();
        this.bindData.setINParam(i - 1, structKind, 0);
        this.paramStruct[this.currentRowIndex][i - 1] = struct;
        this.paramTypes[this.currentRowIndex][i - 1] = (byte)structKind;
        this.binder[this.currentRowIndex][i - 1] = this.staticStructInBinder;
        TbStructDescriptor desc = struct.getDescriptor();
        this.bindData.getBindItem(i - 1).setTypeDescriptor(desc);
    }

    private void setArrayInternal(int i, Array x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 29);
            return;
        }
        if (this.paramArray == null) {
            this.paramArray = new TbArray[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        TbArray array = (TbArray)x;
        int arrayKind = array.getDescriptor().getDataType();
        this.bindData.setINParam(i - 1, arrayKind, 0);
        this.paramArray[this.currentRowIndex][i - 1] = array;
        this.paramTypes[this.currentRowIndex][i - 1] = (byte)arrayKind;
        this.binder[this.currentRowIndex][i - 1] = this.staticArrayInBinder;
        TbArrayDescriptor desc = array.getDescriptor();
        this.bindData.getBindItem(i - 1).setTypeDescriptor(desc);
    }

    private void setTableInternal(int i, Array x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setParameterCnt(int count) {
        this.bindParamCnt = count;
    }

    protected void setParamTypes(int colIndex, byte dataType) {
        this.paramTypes[this.currentRowIndex][colIndex] = dataType;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setPoolable", new Object[]{this, new Boolean(poolable)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        this.poolable = poolable;
    }

    public void setPPID(byte[] ppid) {
        this.ppid = (byte[])(ppid == null || Arrays.equals(ppid, PPID_NULL) ? null : ppid);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void setRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setRowId", new Object[]{this, Integer.toString(i), x});
        if (!(x instanceof TbRowId)) {
            throw TbError.newSQLException(-590771, String.valueOf(x));
        }
        this.setRowIdInternal(i, x);
    }

    void setRowIdInternal(int i, RowId x) throws SQLException {
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        this.bindData.setINParam(i - 1, -8, x.getBytes().length);
        this.paramBytes[this.currentRowIndex][i - 1] = x.getBytes();
        this.paramTypes[this.currentRowIndex][i - 1] = 15;
        this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setShort", new Object[]{this, Integer.toString(i), new Short(x)});
        this.setShortInternal(i, x);
    }

    void setShortInternal(int i, short x) throws SQLException {
        if (this.paramInt == null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 4, -1);
        this.paramInt[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 1;
        this.binder[this.currentRowIndex][i - 1] = this.staticIntBinder;
    }

    @Override
    public void setSQLXML(int i, SQLXML x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setSQLXML", new Object[]{this, Integer.toString(i), x});
        this.setSQLXMLInternal(i, x);
    }

    void setSQLXMLInternal(int i, SQLXML x) throws SQLException {
        InputStream stream = ((TbSQLXML)x).getValue();
        if (this.paramStream == null) {
            this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setDFRParam(i - 1, 2009, Integer.MAX_VALUE);
        this.paramStream[this.currentRowIndex][i - 1] = stream;
        this.paramTypes[this.currentRowIndex][i - 1] = 13;
        this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setString", new Object[]{this, Integer.toString(i), x});
        this.setStringInternal(i, x);
    }

    void setStringInternal(int i, String x) throws SQLException {
        if (this.conn.info.getDefaultNChar()) {
            this.setNStringInternal(i, x);
            return;
        }
        if (x == null || x.length() == 0) {
            this.setNullInternal(i, 3);
            return;
        }
        if (x.length() < this.deferrableStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(i - 1, 12, x.length());
            this.paramString[this.currentRowIndex][i - 1] = x;
            this.binder[this.currentRowIndex][i - 1] = this.staticStringBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 3;
        } else if (x.length() > this.varcharMax) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(i - 1, -1, x.length());
            this.paramReader[this.currentRowIndex][i - 1] = new StringReader(x);
            this.binder[this.currentRowIndex][i - 1] = this.staticReaderBinder;
            this.paramTypes[this.currentRowIndex][i - 1] = 13;
        } else {
            byte[] buf = new byte[x.length() * this.typeConverter.getMaxBytesPerChar()];
            int byteLen = this.typeConverter.fromString(buf, 0, x);
            if (byteLen > this.varcharMax) {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(i - 1, -1, byteLen);
                this.paramStream[this.currentRowIndex][i - 1] = new ByteArrayInputStream(buf, 0, byteLen);
                this.binder[this.currentRowIndex][i - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 13;
            } else {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(i - 1, 12, byteLen);
                this.paramBytes[this.currentRowIndex][i - 1] = buf;
                this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][i - 1] = 3;
            }
        }
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setTime", new Object[]{this, Integer.toString(i), x});
        this.setTimeInternal(i, x);
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setTime", new Object[]{this, Integer.toString(i), x, cal});
        if (x == null) {
            this.setNullInternal(i, 5);
            return;
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.setTime(x);
        byte[] buf = new byte[8];
        this.typeConverter.fromTime(buf, 0, cal, 0);
        this.bindData.setINParam(i - 1, 92, buf.length);
        this.paramBytes[this.currentRowIndex][i - 1] = buf;
        this.paramTypes[this.currentRowIndex][i - 1] = 5;
        this.binder[this.currentRowIndex][i - 1] = this.staticBytesBinder;
    }

    void setTimeInternal(int i, Time x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 5);
            return;
        }
        if (this.paramCalendar == null) {
            this.paramCalendar = new Calendar[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(x);
        this.bindData.setINParam(i - 1, 92, 0);
        this.paramCalendar[this.currentRowIndex][i - 1] = cal;
        this.paramTypes[this.currentRowIndex][i - 1] = 5;
        this.binder[this.currentRowIndex][i - 1] = this.staticTimeBinder;
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setTimestamp", new Object[]{this, Integer.toString(i), x});
        this.setTimestampInternal(i, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setTimestamp", new Object[]{this, Integer.toString(i), x, cal});
        if (x == null) {
            this.setNullInternal(i, 7);
            return;
        }
        TbDatabaseMetaData dbMeta = new TbDatabaseMetaData(this.conn);
        if (dbMeta.getDatabaseMajorVersion() < 5) {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.setTimeInMillis(x.getTime());
            TbTimestamp tts = new TbTimestamp(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), x.getNanos());
            if (this.paramTbTimestamp == null) {
                this.paramTbTimestamp = new TbTimestamp[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(i - 1, 93, -1);
            this.paramTbTimestamp[this.currentRowIndex][i - 1] = tts;
            this.paramTypes[this.currentRowIndex][i - 1] = 7;
            this.binder[this.currentRowIndex][i - 1] = this.staticTbTimestampBinder;
        } else {
            if (this.paramTbTimestampTZ == null) {
                this.paramTbTimestampTZ = new TbTimestampTZ[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            TbTimestampTZ tbTimestampTZ = new TbTimestampTZ(x, cal.getTimeZone());
            this.bindData.setINParam(i - 1, 93, -1);
            this.paramTbTimestampTZ[this.currentRowIndex][i - 1] = tbTimestampTZ;
            this.paramTypes[this.currentRowIndex][i - 1] = 21;
            this.binder[this.currentRowIndex][i - 1] = this.staticTimestampTZBinder;
        }
    }

    void setTimestampInternal(int i, Timestamp x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 7);
            return;
        }
        if (this.paramTimestamp == null) {
            this.paramTimestamp = new Timestamp[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 93, -1);
        this.paramTimestamp[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 7;
        this.binder[this.currentRowIndex][i - 1] = this.staticTimestampBinder;
    }

    public void setTbTimestamp(int i, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setTbTimestamp", new Object[]{this, Integer.toString(i), x});
        this.setTbTimestampInternal(i, x);
    }

    void setTbTimestampInternal(int i, TbTimestamp x) throws SQLException {
        if (x == null) {
            this.setNullInternal(i, 7);
            return;
        }
        if (this.paramTbTimestamp == null) {
            this.paramTbTimestamp = new TbTimestamp[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(i - 1, 93, -1);
        this.paramTbTimestamp[this.currentRowIndex][i - 1] = x;
        this.paramTypes[this.currentRowIndex][i - 1] = 7;
        this.binder[this.currentRowIndex][i - 1] = this.staticTbTimestampBinder;
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setUnicodeStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        this.setUnicodeStreamInternal(i, x, length);
    }

    void setUnicodeStreamInternal(int i, InputStream x, int length) throws SQLException {
        if (x == null || length <= 0) {
            this.setNullInternal(i, 3);
            return;
        }
        InputStreamReader reader = new InputStreamReader(x);
        this.setCharacterStreamInternal(i, reader, length);
    }

    @Override
    public void setURL(int i, URL x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        Debug.logMethod("TbPreparedStatement.addBatch", new String[]{"sql"}, new Object[]{sql});
        this.initSQLInfo(sql);
        int deferredParamCount = this.bindData.getDFRParameterCnt();
        for (int i = 0; i < this.bindParamCnt; ++i) {
            BindItem item;
            if (this.binder[this.currentRowIndex][i] == null) {
                this.setCachedBindParameter(i);
            }
            if ((item = this.bindData.getBindItem(i)).isOUTParameter()) {
                throw TbError.newSQLException(-90631);
            }
            if (deferredParamCount > 0 || this.paramTypes[0][i] == this.paramTypes[this.currentRowIndex][i]) continue;
            this.batchFlag = 0;
        }
        if (this.batchUpdateInfo == null) {
            this.batchUpdateInfo = new BatchUpdateInfo();
        }
        BindData binds = new BindData();
        this.bindData.clone(binds);
        this.bindData.clearDFRParameter();
        this.batchUpdateInfo.add(new BatchInfo(binds, this.currentRowIndex));
        if (this.currentRowIndex == this.allocatedBatchRowCount - 1) {
            this.growBatchArray(this.allocatedBatchRowCount, 0);
        }
        ++this.currentRowIndex;
    }

    public void setAutoGenKeyArr(Object autoGenKeyArr) {
        this.autoGenKeyArr = autoGenKeyArr;
    }

    private static boolean isSupportBinaryDoubleFloatType(ServerInfo info) {
        return info.getProtocolMajorVersion() * 100 + info.getProtocolMinorVersion() >= 206;
    }
}

