/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbKeepAlive;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TbKeepAlivePollingThread
extends Thread {
    private HashMap<String, HashSet<TbKeepAlive>> keepAliveSetMap;
    private long sleepMillis;

    public TbKeepAlivePollingThread() {
        super("TbKeepAlivePollingThread");
        Debug.logMethod("TbKeepAlivePollingThread", new String[]{"TbKeepAlivePollingThread"}, new Object[]{this});
        this.setDaemon(true);
        this.sleepMillis = 1000L;
        this.keepAliveSetMap = new HashMap();
        this.start();
    }

    @Override
    public void run() {
        Debug.logMethod("TbKeepAlivePollingThread.run", new String[]{"TbKeepAlivePollingThread"}, new Object[]{this});
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.poll();
                continue;
            }
            catch (Exception e) {
                Debug.logThrowable(e);
                continue;
            }
            break;
        }
    }

    private void poll() {
        Debug.logMethod("TbKeepAlivePollingThread.poll", new String[]{"TbKeepAlivePollingThread"}, new Object[]{this});
        block6: for (Map.Entry<String, HashSet<TbKeepAlive>> entry : this.keepAliveSetMap.entrySet()) {
            HashSet<TbKeepAlive> kaSet = entry.getValue();
            if (kaSet == null || kaSet.isEmpty()) continue;
            for (TbKeepAlive ka : entry.getValue()) {
                long currentTime = System.currentTimeMillis();
                try {
                    SocketChannel channel = ka.getChannel();
                    if (channel != null) {
                        int kaState;
                        if (channel.finishConnect()) {
                            kaState = ka.checkReply();
                            switch (kaState) {
                                case 1: {
                                    ka.closeCheckChannel(kaState);
                                    ka.resetBaseTime();
                                    break;
                                }
                                case 4: {
                                    for (TbKeepAlive wka : this.keepAliveSetMap.get(entry.getKey())) {
                                        wka.closeCheckChannel(kaState);
                                        wka.closeOrgConnSocket(kaState);
                                    }
                                    continue block6;
                                }
                            }
                            continue;
                        }
                        if (currentTime - ka.getBaseTime() <= ka.getIntervalMillis()) continue;
                        kaState = 3;
                        if (ka.getTryCount() >= ka.getMaxRetryCount()) {
                            for (TbKeepAlive wka : this.keepAliveSetMap.get(entry.getKey())) {
                                wka.closeCheckChannel(kaState);
                                wka.closeOrgConnSocket(kaState);
                            }
                            continue block6;
                        }
                        ka.closeCheckChannel(kaState);
                        ka.tryConnect();
                        continue;
                    }
                    if (currentTime - ka.getBaseTime() <= ka.getIdleMillis()) continue;
                    ka.tryConnect();
                }
                catch (Throwable e1) {
                    Debug.log("Exception occurred during keep alive check processing. Addr=" + ka.toString() + ", Exception=" + e1.toString());
                    ka.closeCheckChannel(5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TbKeepAlive keepAlive) {
        Debug.logMethod("TbKeepAlivePollingThread.remove", new String[]{"keepAlive"}, new Object[]{keepAlive});
        HashMap<String, HashSet<TbKeepAlive>> hashMap = this.keepAliveSetMap;
        synchronized (hashMap) {
            String address = keepAlive.getTargetAddressWithSvrInstId();
            HashSet<TbKeepAlive> kaSet = this.keepAliveSetMap.get(address);
            if (kaSet == null) {
                kaSet = new HashSet();
                this.keepAliveSetMap.put(address, kaSet);
            }
            kaSet.add(keepAlive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TbKeepAlive keepAlive) {
        Debug.logMethod("TbKeepAlivePollingThread.remove", new String[]{"keepAlive"}, new Object[]{keepAlive});
        HashMap<String, HashSet<TbKeepAlive>> hashMap = this.keepAliveSetMap;
        synchronized (hashMap) {
            String address = keepAlive.getTargetAddressWithSvrInstId();
            if (address == null) {
                return;
            }
            HashSet<TbKeepAlive> kaSet = this.keepAliveSetMap.get(address);
            if (kaSet != null) {
                kaSet.remove(keepAlive);
            }
        }
    }
}

