/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbResultSet;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbPreparedStatementImpl;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class TbCallableStatementImpl
extends TbPreparedStatementImpl
implements CallableStatement {
    private static final int DFLT_NAMED_PARAM_CNT = 10;
    private static final int OID_BYTE_LENGTH = 32;
    private static final int TOBJID_BYTE_LENGTH = 4;
    private static final int VERSION_NO_BYTE_LENGTH = 4;
    private String[] namedParamArr = new String[10];
    private int namedParamCnt;
    private boolean haveNamedParameter;
    private boolean haveOrdinalParameter;
    private boolean lastColumnWasNull;
    private byte[][] outParamBytes = new byte[this.bindParamCnt][];
    private byte[] outParamTypes = new byte[this.bindParamCnt];
    private TbResultSet[] outPrefetchedRs = new TbResultSet[this.bindParamCnt];
    private BindItem[] outItems = new BindItem[this.bindParamCnt];
    protected TbPivotInfo[][] pivotInfoArr;
    protected ArrayList<Vector<byte[]>> pivotDataArr;

    public TbCallableStatementImpl(TbConnection conn, String sql) throws SQLException {
        this(conn, sql, 1003, 1007, 64000);
    }

    public TbCallableStatementImpl(TbConnection conn, String sql, int rsetType, int rsetConcur, int preFetchSize) throws SQLException {
        super(conn, sql, rsetType, rsetConcur, preFetchSize, false);
        for (int i = 0; i < this.bindParamCnt; ++i) {
            this.outItems[i] = new BindItem();
        }
        Debug.logMethod("TbCallableStatement", new Object[]{this});
    }

    private int addNamedParam(String paramName) {
        for (int i = 0; i < this.namedParamCnt; ++i) {
            if (!this.namedParamArr[i].equals(paramName)) continue;
            return i + 1;
        }
        if (this.namedParamCnt >= this.namedParamArr.length) {
            String[] newArr = new String[this.namedParamArr.length * 2];
            System.arraycopy(this.namedParamArr, 0, newArr, 0, this.namedParamArr.length);
            this.namedParamArr = newArr;
        }
        this.namedParamArr[this.namedParamCnt++] = paramName;
        this.haveNamedParameter = true;
        return this.namedParamCnt;
    }

    public void addPivotData(int paramIdx, byte[] data) {
        Vector<Object> vPivotData;
        if (this.pivotDataArr == null) {
            this.pivotDataArr = new ArrayList(this.bindParamCnt);
            for (int i = 0; i < this.bindParamCnt; ++i) {
                this.pivotDataArr.add(null);
            }
        }
        if ((vPivotData = this.pivotDataArr.get(paramIdx)) == null) {
            vPivotData = new Vector();
            this.pivotDataArr.set(paramIdx, vPivotData);
        }
        vPivotData.add(data);
    }

    private void checkOutParamExists(int i) throws SQLException {
        if (this.outParamBytes[i] == null) {
            throw TbError.newSQLException(-90609);
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        if (this.haveNamedParameter && this.haveOrdinalParameter) {
            throw TbError.newSQLException(-90655);
        }
        if (this.namedParamCnt > 0) {
            this.rewriteQuestionToNamedParam();
        }
        return super.execute();
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        if (this.haveNamedParameter && this.haveOrdinalParameter) {
            throw TbError.newSQLException(-90655);
        }
        if (this.namedParamCnt > 0) {
            this.rewriteQuestionToNamedParam();
        }
        return super.executeUpdate();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getArray", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getArrayInternal(i);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getArray", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getArrayInternal(paramIndex);
    }

    private Array getArrayInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        byte[] data = this.outParamBytes[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        String oid = this.typeConverter.toString(data, 0, 32, 3, false);
        int tobjID = TbCommon.bytes2Int(data, 32, 4);
        int versionNo = TbCommon.bytes2Int(data, 36, 4);
        TbArrayDescriptor desc = TbArrayDescriptor.createDescriptor(29, oid, tobjID, versionNo, this.conn);
        item.setTypeDescriptor(desc);
        return this.typeConverter.toArray(data, 40, item.getLength(), DataType.getDataType(item.getSQLType()), !this.getRealRsetType().isScrollable(), desc, this.conn.getTypeMap());
    }

    public Struct getStruct(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getStruct", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getStructInternal(i);
    }

    private Struct getStructInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return (Struct)this.typeConverter.toStruct(this.outParamBytes[i - 1], 0, item.getLength(), item.getSQLType(), !this.getRealRsetType().isScrollable(), null, null, this.conn.getTypeMap());
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBigDecimal", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBigDecimalInternal(i);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int i, int scale) throws SQLException {
        return this.getBigDecimal(i);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBigDecimal", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBigDecimalInternal(paramIndex);
    }

    private BigDecimal getBigDecimalInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toBigDecimal(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBlob", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBlobInternal(i);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBlob", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBlobInternal(paramIndex);
    }

    private Blob getBlobInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toBlob(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1], false);
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBoolean", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBooleanInternal(i);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBoolean", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBooleanInternal(paramIndex);
    }

    private boolean getBooleanInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return false;
        }
        return this.typeConverter.toBoolean(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public byte getByte(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getByte", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getByteInternal(i);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getByte", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getByteInternal(paramIndex);
    }

    private byte getByteInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return 0;
        }
        return this.typeConverter.toByte(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBytes", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getBytesInternal(i);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getBytes", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getBytesInternal(paramIndex);
    }

    private byte[] getBytesInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toBytes((Object)this.outParamBytes[i - 1], 0, item.getLength(), (int)this.outParamTypes[i - 1], false);
    }

    @Override
    public Reader getCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getCharacterStream", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getCharacterStreamInternal(i);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getCharacterStream", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getCharacterStreamInternal(paramIndex);
    }

    private Reader getCharacterStreamInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toCharacterStream(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getClob", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getClobInternal(i);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getClob", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getClobInternal(paramIndex);
    }

    private Clob getClobInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toClob(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1], false);
    }

    @Override
    public Date getDate(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getDate", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getDateInternal(i);
    }

    @Override
    public Date getDate(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.getDate", new Object[]{this, Integer.toString(i), cal});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        Date date = this.getDateInternal(i);
        if (cal != null) {
            cal.setTime(date);
            date = (Date)cal.getTime();
        }
        return date;
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getDate", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getDateInternal(paramIndex);
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.getDate", new Object[]{this, parameterName, cal});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getDate(paramIndex, cal);
    }

    private Date getDateInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toDate(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    public TbDate getTbDate(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTbDate", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTbDateInternal(i);
    }

    public TbDate getTbDate(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTbDate", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTbDateInternal(paramIndex);
    }

    private TbDate getTbDateInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toTbDate(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public double getDouble(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getDouble", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getDoubleInternal(i);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getDouble", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getDoubleInternal(paramIndex);
    }

    private double getDoubleInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return 0.0;
        }
        return this.typeConverter.toDouble(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public float getFloat(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getFloat", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getFloatInternal(i);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getFloat", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getFloatInternal(paramIndex);
    }

    private float getFloatInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return 0.0f;
        }
        return this.typeConverter.toFloat(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public int getInt(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getInt", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getIntInternal(i);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getInt", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getIntInternal(paramIndex);
    }

    private int getIntInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return 0;
        }
        return this.typeConverter.toInt(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public long getLong(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getLong", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getLongInternal(i);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getLong", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getLongInternal(paramIndex);
    }

    private long getLongInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return 0L;
        }
        return this.typeConverter.toLong(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getNCharacterStream", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getCharacterStreamInternal(i);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getNCharacterStream", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getCharacterStreamInternal(paramIndex);
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getNClob", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getNClobInternal(i);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getNClob", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getNClobInternal(paramIndex);
    }

    private NClob getNClobInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toNClob(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public String getNString(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getNString", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getStringInternal(i);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getNString", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getStringInternal(paramIndex);
    }

    @Override
    public Object getObject(int i) throws SQLException {
        Debug.logMethod("TbResult.getObject", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getObjectInternal(i);
    }

    public Object getObject(int i, Map map) throws SQLException {
        Debug.logMethod("TbResult.getObject", new Object[]{this, Integer.toString(i), map});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        TbStruct struct = (TbStruct)this.getObjectInternal(i);
        if (map == null) {
            return struct;
        }
        String typeName = struct.getSQLTypeName();
        Class c = (Class)map.get(typeName);
        return struct.toClass(c, map);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getObject", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getObjectInternal(paramIndex);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        Debug.logMethod("TbCallableStatement.getObject", new Object[]{this, parameterName, map});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getObject(paramIndex, map);
    }

    private Object getObjectInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        byte[] data = this.outParamBytes[i - 1];
        if (item.getParamMode() == 1) {
            throw TbError.newSQLException(-590772);
        }
        if (this.outParamTypes[i - 1] == 16) {
            if (this.outPrefetchedRs[i - 1] == null) {
                return this.typeConverter.toResultSet(this, this.outParamBytes[i - 1], item);
            }
            return this.outPrefetchedRs[i - 1];
        }
        if (this.outParamTypes[i - 1] == 32 || this.outParamTypes[i - 1] == 28) {
            if (this.setLastColumnWasNull(item)) {
                return null;
            }
            String oid = this.typeConverter.toString(data, 0, 32, 3, false);
            int tobjID = TbCommon.bytes2Int(data, 32, 4);
            int versionNo = TbCommon.bytes2Int(data, 36, 4);
            TbStructDescriptor desc = TbStructDescriptor.createDescriptor(32, oid, tobjID, versionNo, this.conn);
            item.setTypeDescriptor(desc);
            return this.typeConverter.toStruct(data, 40, item.getLength(), DataType.getDataType(item.getSQLType()), !this.getRealRsetType().isScrollable(), desc, null, null);
        }
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toObject(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1], item.getSQLType(), true);
    }

    public BindItem getOutItems(int i) {
        return this.outItems[i];
    }

    public Vector<byte[]> getPivotData(int paramIndex) throws SQLException {
        if (this.outParamTypes[paramIndex - 1] == 16) {
            if (this.pivotDataArr == null || this.pivotDataArr.get(paramIndex - 1) == null) {
                int csrId = TbCommon.bytes2Int(this.outParamBytes[paramIndex - 1], 0, this.outItems[paramIndex - 1].getLength());
                this.conn.getTbComm().executePivot(this, paramIndex - 1, csrId);
            }
            if (this.pivotDataArr != null) {
                return this.pivotDataArr.get(paramIndex - 1);
            }
        }
        return null;
    }

    public TbPivotInfo[] getPivotInfo(int paramIndex) throws SQLException {
        if (this.outParamTypes[paramIndex - 1] == 16) {
            if (this.pivotInfoArr == null || this.pivotInfoArr[paramIndex - 1] == null) {
                int csrId = TbCommon.bytes2Int(this.outParamBytes[paramIndex - 1], 0, this.outItems[paramIndex - 1].getLength());
                this.conn.getTbComm().executePivot(this, paramIndex - 1, csrId);
            }
            if (this.pivotInfoArr != null) {
                return this.pivotInfoArr[paramIndex - 1];
            }
        }
        return null;
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public RowId getRowId(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getRowId", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getRowIdInternal(i);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getRowId", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getRowIdInternal(paramIndex);
    }

    private RowId getRowIdInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toRowId(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public short getShort(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getShort", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getShortInternal(i);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getShort", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getShortInternal(paramIndex);
    }

    private short getShortInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return 0;
        }
        return this.typeConverter.toShort(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getSQLXML", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getSQLXMLInternal(i);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getSQLXML", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getSQLXMLInternal(paramIndex);
    }

    private SQLXML getSQLXMLInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toSQLXML(this.outParamBytes[i - 1], 0, item.getLength(), 13, false);
    }

    @Override
    public String getString(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getString", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getStringInternal(i);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getString", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getStringInternal(paramIndex);
    }

    private String getStringInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toString(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1], true);
    }

    @Override
    public Time getTime(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTime", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTimeInternal(i);
    }

    @Override
    public Time getTime(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTime", new Object[]{this, Integer.toString(i), cal});
        Time tm = this.getTimeInternal(i);
        if (cal != null) {
            cal.setTime(tm);
            tm = (Time)cal.getTime();
        }
        return tm;
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTime", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTimeInternal(paramIndex);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTime", new Object[]{this, parameterName, cal});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTime(paramIndex, cal);
    }

    private Time getTimeInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toTime(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTimestamp", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTimestampInternal(i);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTimestamp", new Object[]{this, Integer.toString(i), cal});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        Timestamp ts = this.getTimestampInternal(i);
        if (cal != null) {
            cal.setTime(ts);
            ts = (Timestamp)cal.getTime();
        }
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTimestamp", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTimestampInternal(paramIndex);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTimestamp", new Object[]{this, parameterName, cal});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTimestamp(paramIndex, cal);
    }

    private Timestamp getTimestampInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toTimestamp(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    public TbTimestamp getTbTimestamp(int i) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTbTimestamp", new Object[]{this, Integer.toString(i)});
        if (this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        return this.getTbTimestampInternal(i);
    }

    public TbTimestamp getTbTimestamp(String parameterName) throws SQLException {
        Debug.logMethod("TbCallableStatement.getTbTimestamp", new Object[]{this, parameterName});
        if (!this.haveNamedParameter) {
            throw TbError.newSQLException(-90655);
        }
        int paramIndex = this.addNamedParam(parameterName);
        return this.getTbTimestampInternal(paramIndex);
    }

    private TbTimestamp getTbTimestampInternal(int i) throws SQLException {
        this.checkConnectionOpen();
        this.checkOutParamExists(i - 1);
        BindItem item = this.outItems[i - 1];
        if (this.setLastColumnWasNull(item)) {
            return null;
        }
        return this.typeConverter.toTbTimestamp(this.outParamBytes[i - 1], 0, item.getLength(), this.outParamTypes[i - 1]);
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized void registerOutParameter(int i, int sqlType) throws SQLException {
        this.registerOutParameter(i, sqlType, 0);
    }

    @Override
    public synchronized void registerOutParameter(int i, int sqlType, int scale) throws SQLException {
        Debug.logMethod("TbCallableStatement.registerOutParameter", new Object[]{this, Integer.toString(i), Integer.toString(sqlType), Integer.toString(scale)});
        this.registerOutParameterInternal(i, sqlType, scale, null);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameterInternal(paramIndex, sqlType, 0, typeName);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(parameterName, sqlType, 0);
    }

    @Override
    public synchronized void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        Debug.logMethod("TbCallableStatement.registerOutParameter", new Object[]{this, parameterName, Integer.toString(sqlType), Integer.toString(scale)});
        int paramIndex = this.addNamedParam(parameterName);
        this.registerOutParameterInternal(paramIndex, sqlType, scale, null);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbCallableStatement.registerOutParameter", new Object[]{this, parameterName, Integer.toString(sqlType), typeName});
        int paramIndex = this.addNamedParam(parameterName);
        this.registerOutParameterInternal(paramIndex, sqlType, 0, typeName);
    }

    private void registerOutParameterInternal(int i, int sqlType, int scale, String typeName) throws SQLException {
        switch (sqlType) {
            case -2003: 
            case 2003: {
                this.bindData.setOUTParam(i - 1, sqlType, typeName, this.conn);
                if (this.binder[this.currentRowIndex][i - 1] == null) {
                    this.binder[this.currentRowIndex][i - 1] = this.staticArrayOutBinder;
                }
                int dataType = this.bindData.getBindItem(i - 1).getTypeDescriptor().getDataType();
                this.setParamTypes(i - 1, (byte)dataType);
                break;
            }
            case 2002: {
                this.bindData.setOUTParam(i - 1, sqlType, typeName, this.conn);
                if (this.binder[this.currentRowIndex][i - 1] == null) {
                    this.binder[this.currentRowIndex][i - 1] = this.staticStructOutBinder;
                }
                int dataType = this.bindData.getBindItem(i - 1).getTypeDescriptor().getDataType();
                this.setParamTypes(i - 1, (byte)dataType);
                break;
            }
            default: {
                this.bindData.setOUTParam(i - 1, sqlType, typeName);
                if (this.binder[this.currentRowIndex][i - 1] == null) {
                    this.binder[this.currentRowIndex][i - 1] = this.staticNullBinder;
                }
                int dataType = DataType.getDataType(sqlType);
                this.setParamTypes(i - 1, (byte)dataType);
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.namedParamArr = null;
        this.outParamBytes = null;
        this.outParamTypes = null;
        this.outPrefetchedRs = null;
        this.outItems = null;
    }

    @Override
    public synchronized void resetForCache() {
        super.resetForCache();
        this.namedParamArr = null;
        this.outParamBytes = null;
        this.outParamTypes = null;
        this.outPrefetchedRs = null;
        this.outItems = null;
    }

    private void rewriteQuestionToNamedParam() throws SQLException {
        int j = 0;
        char[] sqlArr = this.originalSql.toCharArray();
        StringBuffer sqlBuf = new StringBuffer();
        if (super.getParameterCnt() != this.namedParamCnt) {
            throw TbError.newSQLException(-90627);
        }
        for (int i = 0; i < sqlArr.length; ++i) {
            if (sqlArr[i] == '?') {
                sqlBuf.append(this.namedParamArr[j++]);
                sqlBuf.append("=>?");
                continue;
            }
            sqlBuf.append(sqlArr[i]);
        }
        if (j != this.namedParamCnt) {
            throw TbError.newSQLException(-90627);
        }
        Debug.logMethod("TbCallableStatement.rewriteQuestionToNamedParam", new Object[]{this, this.originalSql, sqlBuf.toString()});
        this.originalSql = new String(sqlBuf);
    }

    @Override
    public void setAsciiStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setAsciiStream", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(i, x, length);
    }

    @Override
    public void setAsciiStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setAsciiStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(i, x, (int)len);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setAsciiStream", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBinaryStreamInternal(paramIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setAsciiStream", new Object[]{this, parameterName, x, Integer.toString(length)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBinaryStreamInternal(paramIndex, x, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setAsciiStream", new Object[]{this, parameterName, x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        int paramIndex = this.addNamedParam(parameterName);
        super.setBinaryStreamInternal(paramIndex, x, (int)len);
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBigDecimal", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setBigDecimalInternal(i, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBigDecimal", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBigDecimalInternal(paramIndex, x);
    }

    @Override
    public void setBinaryStream(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(i, x, length);
    }

    @Override
    public void setBinaryStream(int i, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.haveOrdinalParameter = true;
        super.setBinaryStreamInternal(i, x, (int)len);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBinaryStream", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBinaryStreamInternal(paramIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBinaryStream", new Object[]{this, parameterName, x, Integer.toString(length)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBinaryStreamInternal(paramIndex, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBinaryStream", new Object[]{this, parameterName, x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        int paramIndex = this.addNamedParam(parameterName);
        super.setBinaryStreamInternal(paramIndex, x, (int)len);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBlob", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setBlobInternal(i, x);
    }

    @Override
    public void setBlob(int i, InputStream x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBlob", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setBlobInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBlob(int i, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBlob", new Object[]{this, Integer.toString(i), x, Long.toString(length)});
        this.haveOrdinalParameter = true;
        super.setBlobInternal(i, x, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBlob", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBlobInternal(paramIndex, x);
    }

    @Override
    public void setBlob(String parameterName, InputStream x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBlob", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBlobInternal(paramIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBlob", new Object[]{this, parameterName, x, Long.toString(length)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBlobInternal(paramIndex, x, length);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        this.haveOrdinalParameter = true;
        super.setBooleanInternal(i, x);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBoolean", new Object[]{this, parameterName, new Boolean(x)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBooleanInternal(paramIndex, x);
    }

    @Override
    public void setByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setByte", new Object[]{this, Integer.toString(i), Byte.toString(x)});
        this.haveOrdinalParameter = true;
        super.setByteInternal(i, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setByte", new Object[]{this, parameterName, Byte.toString(x)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setByteInternal(paramIndex, x);
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBytes", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setBytesInternal(i, 4, x);
    }

    @Override
    public void setBytes(int i, int dataType, byte[] x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBytes", new Object[]{this, Integer.toString(i), Integer.toString(dataType), x});
        this.haveOrdinalParameter = true;
        super.setBytesInternal(i, dataType, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setBytes", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setBytesInternal(paramIndex, 4, x);
    }

    @Override
    public void setCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setCharacterStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setCharacterStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        this.haveOrdinalParameter = true;
        super.setCharacterStreamInternal(i, x, length);
    }

    @Override
    public void setCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.haveOrdinalParameter = true;
        super.setCharacterStreamInternal(i, x, (int)len);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setCharacterStream", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setCharacterStreamInternal(paramIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setCharacterStream", new Object[]{this, parameterName, x, Integer.toString(length)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setCharacterStreamInternal(paramIndex, x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setCharacterStream", new Object[]{this, parameterName, x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        int paramIndex = this.addNamedParam(parameterName);
        super.setCharacterStreamInternal(paramIndex, x, (int)len);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setClob", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setClobInternal(i, 13, x);
    }

    @Override
    public void setClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setClob", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setClobInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setClob(int i, Reader x, long length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setClob", new Object[]{this, Integer.toString(i), x, Long.toString(length)});
        this.haveOrdinalParameter = true;
        super.setClobInternal(i, x, length);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setClob", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setClobInternal(paramIndex, 13, x);
    }

    @Override
    public void setClob(String parameterName, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setClob", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setClobInternal(paramIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setClob(String parameterName, Reader x, long length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setClob", new Object[]{this, parameterName, x, Long.toString(length)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setClobInternal(paramIndex, x, length);
    }

    @Override
    public void setDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setDate", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setDateInternal(i, x);
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.setDate", new Object[]{this, Integer.toString(i), x, cal});
        this.haveOrdinalParameter = true;
        super.setDateInternal(i, x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setDate", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setDateInternal(paramIndex, x);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.setDate", new Object[]{this, parameterName, x, cal});
        int paramIndex = this.addNamedParam(parameterName);
        super.setDateInternal(paramIndex, x);
    }

    @Override
    public void setTbDate(int i, TbDate x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTbDate", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setTbDateInternal(i, x);
    }

    public void setTbDate(String parameterName, TbDate x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTbDate", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setTbDateInternal(paramIndex, x);
    }

    @Override
    public void setDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        this.haveOrdinalParameter = true;
        super.setDoubleInternal(i, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setDouble", new Object[]{this, parameterName, Double.toString(x)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setDoubleInternal(paramIndex, x);
    }

    @Override
    public void setFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        this.haveOrdinalParameter = true;
        super.setFloatInternal(i, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setFloat", new Object[]{this, parameterName, Float.toString(x)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setFloatInternal(paramIndex, x);
    }

    @Override
    public void setInt(int i, int x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        this.haveOrdinalParameter = true;
        super.setIntInternal(i, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setInt", new Object[]{this, parameterName, Integer.toString(x)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setIntInternal(paramIndex, x);
    }

    private synchronized boolean setLastColumnWasNull(BindItem item) {
        this.lastColumnWasNull = item.getLength() == 0;
        return this.lastColumnWasNull;
    }

    @Override
    public void setLong(int i, long x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        this.haveOrdinalParameter = true;
        super.setLongInternal(i, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setLong", new Object[]{this, parameterName, Long.toString(x)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setLongInternal(paramIndex, x);
    }

    @Override
    public void setNCharacterStream(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNCharacterStream", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setNCharacterStreamInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setNCharacterStream(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNCharacterStream", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.haveOrdinalParameter = true;
        super.setNCharacterStreamInternal(i, x, (int)len);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNCharacterStream", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setNCharacterStreamInternal(paramIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNCharacterStream", new Object[]{this, parameterName, x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        int paramIndex = this.addNamedParam(parameterName);
        super.setNCharacterStreamInternal(paramIndex, x, (int)len);
    }

    @Override
    public void setNClob(int i, Clob x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNClob", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setClobInternal(i, 20, x);
    }

    @Override
    public void setNClob(int i, NClob x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNClob", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setClobInternal(i, 20, x);
    }

    @Override
    public void setNClob(int i, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNClob", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setNClobInternal(i, x, Integer.MAX_VALUE);
    }

    @Override
    public void setNClob(int i, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNClob", new Object[]{this, Integer.toString(i), x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        this.haveOrdinalParameter = true;
        super.setNClobInternal(i, x, (int)len);
    }

    @Override
    public void setNClob(String parameterName, NClob x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNClob", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setClobInternal(paramIndex, 20, x);
    }

    @Override
    public void setNClob(String parameterName, Reader x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNClob", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setNClobInternal(paramIndex, x, Integer.MAX_VALUE);
    }

    @Override
    public void setNClob(String parameterName, Reader x, long len) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNClob", new Object[]{this, parameterName, x, Long.toString(len)});
        if (len > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(len));
        }
        int paramIndex = this.addNamedParam(parameterName);
        super.setNClobInternal(paramIndex, x, (int)len);
    }

    @Override
    public void setNString(int i, String x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNString", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setNStringInternal(i, x);
    }

    @Override
    public void setNString(String parameterName, String x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNString", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setNStringInternal(paramIndex, x);
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType)});
        this.haveOrdinalParameter = true;
        super.setNullInternal(i, DataType.getDataType(sqlType));
    }

    @Override
    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNull", new Object[]{this, Integer.toString(i), Integer.toString(sqlType), typeName});
        this.haveOrdinalParameter = true;
        super.setNullInternal(i, DataType.getDataType(sqlType));
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNull", new Object[]{this, parameterName, Integer.toString(sqlType)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setNullInternal(paramIndex, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        Debug.logMethod("TbCallableStatement.setNull", new Object[]{this, parameterName, Integer.toString(sqlType), typeName});
        int paramIndex = this.addNamedParam(parameterName);
        super.setNullInternal(paramIndex, sqlType);
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        this.setObject(i, x, DataType.getSqlType(x), 0);
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        this.setObject(i, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int i, Object x, int sqlType, int scale) throws SQLException {
        Debug.logMethod("TbCallableStatement.setObject", new Object[]{this, Integer.toString(i), x, Integer.toString(sqlType), Integer.toString(scale)});
        this.haveOrdinalParameter = true;
        super.setObjectInternal(i, x, sqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(parameterName, x, DataType.getSqlType(x), 0);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterName, x, targetSqlType, 0);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        Debug.logMethod("TbCallableStatement.setObject", new Object[]{this, parameterName, x, Integer.toString(this.sqlType), Integer.toString(scale)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setObjectInternal(paramIndex, x, targetSqlType, scale);
    }

    public void setOutParam(int i, int dataType, byte[] x, TbResultSet prefetchedRs) throws SQLException {
        DataType.checkValidDataType(dataType);
        this.outParamTypes[i] = (byte)dataType;
        this.outParamBytes[i] = x;
        this.outPrefetchedRs[i] = prefetchedRs;
    }

    public void setPivotInfo(int paramIdx, TbPivotInfo[] info) {
        if (this.pivotInfoArr == null) {
            this.pivotInfoArr = new TbPivotInfo[this.bindParamCnt][];
        }
        this.pivotInfoArr[paramIdx] = info;
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void setRowId(int i, RowId x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setRowId", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setRowIdInternal(i, x);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setRowId", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setRowIdInternal(paramIndex, x);
    }

    @Override
    public void setShort(int i, short x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        this.haveOrdinalParameter = true;
        super.setShortInternal(i, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setShort", new Object[]{this, parameterName, Short.toString(x)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setShortInternal(paramIndex, x);
    }

    @Override
    public void setSQLXML(int i, SQLXML x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setSQLXML", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setSQLXMLInternal(i, x);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setSQLXML", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setSQLXMLInternal(paramIndex, x);
    }

    @Override
    public void setString(int i, String x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setString", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setStringInternal(i, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setString", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setStringInternal(paramIndex, x);
    }

    @Override
    public void setTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTime", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setTimeInternal(i, x);
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTime", new Object[]{this, Integer.toString(i), x, cal});
        this.haveOrdinalParameter = true;
        super.setTimeInternal(i, x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTime", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setTimeInternal(paramIndex, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTime", new Object[]{this, parameterName, x, cal});
        int paramIndex = this.addNamedParam(parameterName);
        super.setTimeInternal(paramIndex, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTimestamp", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setTimestampInternal(i, x);
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTimestamp", new Object[]{this, Integer.toString(i), x, cal});
        this.haveOrdinalParameter = true;
        super.setTimestampInternal(i, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTimestamp", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setTimestampInternal(paramIndex, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTimestamp", new Object[]{this, parameterName, x, cal});
        int paramIndex = this.addNamedParam(parameterName);
        super.setTimestampInternal(paramIndex, x);
    }

    @Override
    public void setTbTimestamp(int i, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTbTimestamp", new Object[]{this, Integer.toString(i), x});
        this.haveOrdinalParameter = true;
        super.setTbTimestampInternal(i, x);
    }

    public void setTbTimestamp(String parameterName, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbCallableStatement.setTbTimestamp", new Object[]{this, parameterName, x});
        int paramIndex = this.addNamedParam(parameterName);
        super.setTbTimestampInternal(paramIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setUnicodeStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        this.haveOrdinalParameter = true;
        super.setUnicodeStreamInternal(i, x, length);
    }

    @Deprecated
    public void setUnicodeStream(String parameterName, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbCallableStatement.setUnicodeStream", new Object[]{this, parameterName, x, Integer.toString(length)});
        int paramIndex = this.addNamedParam(parameterName);
        super.setUnicodeStreamInternal(paramIndex, x, length);
    }

    @Override
    public void setURL(int i, URL x) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Debug.logMethod("TbCallableStatement.isWrapperFor", new Object[]{iface});
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        Debug.logMethod("TbCallableStatement.unwrap", new Object[]{iface});
        try {
            return iface.cast(this);
        }
        catch (ClassCastException e) {
            throw TbError.newSQLException(-90657);
        }
    }
}

