/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl.binder;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.dpl.binder.DPLBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class DPLReaderBinder
extends DPLBinder {
    private final int EXTRA_DATA_LENGTH = 12;

    @Override
    public void bind(TbConnection conn, TbDirPathStream stream, TbStreamDataWriter writer, int paramIndex, int length) throws SQLException {
        DataTypeConverter dataTypeConverter = conn.getTypeConverter();
        Reader reader = stream.getParamReader(paramIndex);
        StreamBuffer buf = writer.getStreamBuf();
        int svrType = stream.getDPLMetaData().getDataType(paramIndex + 1);
        char[] charBuf = new char[4096];
        byte[] byteBuf = new byte[16384];
        int readChars = 0;
        int readBufferLength = 0;
        int convertedBytes = 0;
        int writeByteCnt = 0;
        try {
            if (buf.getRemained() <= 12) {
                stream.dirPathLoadStream(writer, 0);
            }
            writer.writeInt(0, 4);
            while (length >= 0) {
                readChars = length > 4096 ? 4096 : length;
                readBufferLength = reader.read(charBuf, 0, readChars);
                if (readBufferLength <= 0) {
                    if (writeByteCnt > 0) {
                        writer.reWriteInt(buf.getCurDataSize() - writeByteCnt - 4, writeByteCnt, 4);
                        writer.writePaddingDPL(writeByteCnt);
                    }
                    return;
                }
                convertedBytes = svrType == 13 || svrType == 20 ? dataTypeConverter.charsToFixedBytes(charBuf, 0, readBufferLength, byteBuf, 0, byteBuf.length) : dataTypeConverter.charsToBytes(charBuf, 0, readBufferLength, byteBuf, 0, byteBuf.length);
                int offset = 0;
                int availableBytes = 0;
                int unReadBytes = 0;
                while ((unReadBytes = convertedBytes - offset) > (availableBytes = buf.getRemained()) - 12 && availableBytes > 12) {
                    writer.writeBytes(byteBuf, offset, availableBytes -= 12);
                    offset += availableBytes;
                    writer.reWriteInt(buf.getCurDataSize() - (writeByteCnt += availableBytes) - 4, writeByteCnt, 4);
                    writer.writePaddingDPL(writeByteCnt);
                    stream.dirPathLoadStream(writer, 1);
                    writeByteCnt = 0;
                    writer.writeInt(0, 4);
                }
                writer.writeBytes(byteBuf, offset, unReadBytes);
                writeByteCnt += unReadBytes;
                offset += unReadBytes;
                length -= readBufferLength;
            }
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
    }
}

