/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.dpl;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbIntervalDts;
import com.tmax.tibero.jdbc.TbIntervalYtm;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.binder.DPLBinder;
import com.tmax.tibero.jdbc.dpl.binder.StaticDPLBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TbDirPathStream {
    public static final int DPL_BIND_STREAM = -1;
    public static final int DPL_LOAD_STREAM_SUCCESS = 0;
    public static final int DPL_LOAD_STREAM_NEED_DATA = 1;
    public static final int DPL_LOAD_STREAM_NO_DATA = 2;
    public static final int DPL_LOAD_STREAM_FAIL = 3;
    public static final int SQL_DPL_DATASAVE_SAVE_ONLY = 0;
    public static final int SQL_DPL_DATASAVE_FINISH = 1;
    public static final int DPL_PARAM_INFO_OFFSET = 24;
    private int returnCode;
    private int rowCnt;
    private int totalRowCnt;
    private TbConnection conn = null;
    private TbDirPathMetaData metaData = null;
    private int bindParamCnt;
    private int[] paramLength = null;
    private TbStreamDataWriter writer = null;
    private int[] paramInt;
    private long[] paramLong;
    private float[] paramFloat;
    private double[] paramDouble;
    private BigDecimal[] paramBigDecimal;
    private String[] paramString;
    private Date[] paramDate;
    private TbDate[] paramTbDate;
    private Time[] paramTime;
    private Timestamp[] paramTimestamp;
    private TbTimestamp[] paramTbTimestamp;
    private TbTimestampTZ[] paramTbTimestampTZ;
    private byte[][] paramBytes;
    private Reader[] paramReader;
    private InputStream[] paramStream;
    private Object[] paramObject;
    private TbIntervalYtm[] paramTbIntervalYtm;
    private TbIntervalDts[] paramTbIntervalDts;
    private DPLBinder[] binder;
    private DPLBinder staticNullDPLBinder = StaticDPLBinder.nullDPLBinder;
    private DPLBinder staticStringDPLBinder = StaticDPLBinder.stringDPLBinder;
    private DPLBinder staticReaderDPLBinder = StaticDPLBinder.readerDPLBinder;
    private DPLBinder staticIntDPLBinder = StaticDPLBinder.intDPLBinder;
    private DPLBinder staticLongDPLBinder = StaticDPLBinder.longDPLBinder;
    private DPLBinder staticFloatDPLBinder = StaticDPLBinder.floatDPLBinder;
    private DPLBinder staticDoubleDPLBinder = StaticDPLBinder.doubleDPLBinder;
    private DPLBinder staticBigDecimalDPLBinder = StaticDPLBinder.bigDecimalDPLBinder;
    private DPLBinder staticDateDPLBinder = StaticDPLBinder.dateDPLBinder;
    private DPLBinder staticTbDateDPLBinder = StaticDPLBinder.tbDateDPLBinder;
    private DPLBinder staticTimeDPLBinder = StaticDPLBinder.timeDPLBinder;
    private DPLBinder staticTimestampDPLBinder = StaticDPLBinder.timestampDPLBinder;
    private DPLBinder staticTbTimestampDPLBinder = StaticDPLBinder.tbTimestampDPLBinder;
    private DPLBinder staticTbTimestampTZDPLBinder = StaticDPLBinder.tbTimestampTZDPLBinder;
    private DPLBinder staticTimestampLTZDPLBinder = StaticDPLBinder.timestampLTZDPLBinder;
    private DPLBinder staticRawDPLBinder = StaticDPLBinder.rawDPLBinder;
    private DPLBinder staticBytesDPLBinder = StaticDPLBinder.bytesDPLBinder;
    private DPLBinder staticRowIdDPLBinder = StaticDPLBinder.rowIdDPLBinder;
    private DPLBinder staticLongStreamDPLBinder = StaticDPLBinder.longStreamDPLBinder;
    private DPLBinder staticStreamDPLBinder = StaticDPLBinder.streamDPLBinder;
    private DPLBinder staticEmptyLOBDPLBinder = StaticDPLBinder.emptyLOBDPLBinder;
    private DPLBinder staticTbIntervalYtmBinder = StaticDPLBinder.tbIntervalYtmDPLBinder;
    private DPLBinder staticTbIntervalDtsBinder = StaticDPLBinder.tbIntervalDtsDPLBinder;

    public TbDirPathStream(TbConnection connection, TbDirPathMetaData meta) throws SQLException {
        Debug.logMethod("TbDirPathStream", new Object[]{this, connection, meta});
        this.conn = connection;
        this.metaData = meta;
        this.bindParamCnt = meta.getColumnCnt();
        this.binder = new DPLBinder[this.bindParamCnt];
        TbStream tbStream = this.conn.getTbComm().getStream();
        this.writer = tbStream.createDirPathWriter(meta.getBufferSize());
        this.writer.clearDPLBuffer();
        this.totalRowCnt = 0;
        this.initReturnInfo();
        if (this.metaData.getParallelFlag() || this.metaData.getPartition() != null && this.metaData.getPartition().length() > 0) {
            ServerInfo serverInfo = connection.getServerInfo();
            if (serverInfo.getProtocolMajorVersion() * 100 + serverInfo.getProtocolMinorVersion() < 205) {
                throw TbError.newSQLException(-90662);
            }
            this.prepareParallel();
        } else {
            this.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathAbort();
        }
    }

    public void addTotalRowCnt(int count) {
        this.totalRowCnt += count;
    }

    public int getTotalRowCnt() {
        return this.totalRowCnt;
    }

    protected void checkParameterIndex(int i) throws SQLException {
        if (i < 1 || i > this.metaData.getColumnCnt()) {
            throw TbError.newSQLException(-90609);
        }
    }

    public void clearBindData() {
        this.clearArray(this.paramBigDecimal);
        this.clearArray(this.paramString);
        this.clearArray(this.paramDate);
        this.clearArray(this.paramTime);
        this.clearArray(this.paramTimestamp);
        this.clearArray(this.paramTbTimestamp);
        this.clearArray(this.paramTbTimestampTZ);
        this.clearArray((Object[])this.paramBytes);
        this.clearArray(this.paramReader);
        this.clearArray(this.paramStream);
        this.clearArray(this.paramObject);
        this.clearArray(this.binder);
    }

    private void clearArray(Object[] array) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = null;
        }
    }

    public void close() {
        this.reset();
    }

    private void copyStream() throws SQLException {
        try {
            for (int i = 0; i < this.bindParamCnt; ++i) {
                if (this.binder[i] == null) {
                    throw TbError.newSQLException(-90627);
                }
                this.binder[i].bind(this.conn, this, this.writer, i, this.paramLength[i]);
            }
        }
        catch (SQLException se) {
            this.writer.clearDPLBuffer();
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSave(int action) throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathDataSave(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dirPathLoadStream(TbStreamDataWriter dplStreamWriter, int partialFlag) throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathLoadStream(this, dplStreamWriter, partialFlag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRow() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathFlushRow();
        }
    }

    public int getBindDataSize() {
        return this.writer.getBufferedDataSize();
    }

    public DPLBinder[] getBinder() {
        return this.binder;
    }

    public TbDirPathMetaData getDPLMetaData() {
        return this.metaData;
    }

    public TbStreamDataWriter getDPLStreamDataWriter() {
        return this.writer;
    }

    public BigDecimal getParamBigDecimal(int columnIndex) {
        return this.paramBigDecimal[columnIndex];
    }

    public byte[] getParamBytes(int columnIndex) {
        return this.paramBytes[columnIndex];
    }

    public Date getParamDate(int columnIndex) {
        return this.paramDate[columnIndex];
    }

    public TbDate getParamTbDate(int columnIndex) {
        return this.paramTbDate[columnIndex];
    }

    public double getParamDouble(int columnIndex) {
        return this.paramDouble[columnIndex];
    }

    public float getParamFloat(int columnIndex) {
        return this.paramFloat[columnIndex];
    }

    public int getParamInt(int columnIndex) {
        return this.paramInt[columnIndex];
    }

    public int getParamLength(int columnIndex) {
        return this.paramLength[columnIndex];
    }

    public long getParamLong(int columnIndex) {
        return this.paramLong[columnIndex];
    }

    public Object getParamObject(int columnIndex) {
        return this.paramObject[columnIndex];
    }

    public Reader getParamReader(int columnIndex) {
        return this.paramReader[columnIndex];
    }

    public InputStream getParamStream(int columnIndex) {
        return this.paramStream[columnIndex];
    }

    public String getParamString(int columnIndex) {
        return this.paramString[columnIndex];
    }

    public Time getParamTime(int columnIndex) {
        return this.paramTime[columnIndex];
    }

    public Timestamp getParamTimestamp(int columnIndex) {
        return this.paramTimestamp[columnIndex];
    }

    public TbTimestamp getParamTbTimestamp(int columnIndex) {
        return this.paramTbTimestamp[columnIndex];
    }

    public TbTimestampTZ getParamTbTimestampTZ(int columnIndex) {
        return this.paramTbTimestampTZ[columnIndex];
    }

    public TbIntervalYtm getParamTbIntervalYtm(int columnIndex) {
        return this.paramTbIntervalYtm[columnIndex];
    }

    public TbIntervalDts getParamTbIntervalDts(int columnIndex) {
        return this.paramTbIntervalDts[columnIndex];
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public int getRowCnt() {
        return this.rowCnt;
    }

    public boolean hasBindData() {
        return this.writer.getBufferedDataSize() > 24;
    }

    private void initReturnInfo() {
        this.returnCode = -1;
        this.rowCnt = 0;
    }

    public int loadStream() throws SQLException {
        this.initReturnInfo();
        this.copyStream();
        this.dirPathLoadStream(this.writer, 0);
        return this.returnCode;
    }

    public int loadStreamBatch(int flag) throws SQLException {
        this.initReturnInfo();
        if ((flag & 0x100) != 0) {
            this.copyStream();
        }
        if ((flag & 0x10) != 0) {
            Debug.logMethod("TbDirPathStream.loadStreamBatch", new String[]{"isComplete, data, buffer"}, new Object[]{new Boolean(this.writer.getBufferedDataSize() > this.metaData.getBufferSize()), Integer.toString(this.writer.getBufferedDataSize()), Integer.toString(this.metaData.getBufferSize())});
            if (this.writer.getBufferedDataSize() > this.metaData.getBufferSize()) {
                this.dirPathLoadStream(this.writer, 0);
            }
        } else {
            this.dirPathLoadStream(this.writer, 0);
        }
        return this.returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.metaData.checkDirPathMetaData();
        this.paramLength = new int[this.bindParamCnt];
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathPrepare(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareParallel() throws SQLException {
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.metaData.checkDirPathMetaData();
        if (this.conn.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.paramLength = new int[this.bindParamCnt];
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().dirPathPrepareParallel(this);
        }
    }

    private void reset() {
        this.conn = null;
        this.writer = null;
        this.paramLength = null;
        if (this.metaData != null) {
            this.metaData.reset();
            this.metaData = null;
        }
    }

    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbDirPathStream.setAsciiStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        this.setBinaryStream(i, x, length);
    }

    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setBigDecimal", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramBigDecimal == null) {
            this.paramBigDecimal = new BigDecimal[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramBigDecimal[i - 1] = x;
        this.binder[i - 1] = this.staticBigDecimalDPLBinder;
    }

    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        if (x == null || length <= 0) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramStream == null) {
            this.paramStream = new InputStream[this.bindParamCnt];
        }
        this.paramLength[i - 1] = length;
        this.paramStream[i - 1] = x;
        this.binder[i - 1] = this.staticStreamDPLBinder;
    }

    public void setBoolean(int i, boolean x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setBoolean", new Object[]{this, Integer.toString(i), new Boolean(x)});
        this.checkParameterIndex(i);
        if (this.paramString == null) {
            this.paramString = new String[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 20;
        this.paramString[i - 1] = x ? "1" : "0";
        this.binder[i - 1] = this.staticStringDPLBinder;
    }

    public void setByte(int i, byte x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setByte", new Object[]{this, Integer.toString(i), new Byte(x)});
        this.checkParameterIndex(i);
        if (this.paramInt == null) {
            this.paramInt = new int[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 1;
        this.paramInt[i - 1] = x;
        this.binder[i - 1] = this.staticIntDPLBinder;
    }

    public void setBytes(int i, byte[] x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setBytes", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.bindParamCnt][];
        }
        this.paramLength[i - 1] = x.length;
        this.paramBytes[i - 1] = x;
        this.binder[i - 1] = this.staticBytesDPLBinder;
    }

    public void setBytes(int i, int tbType, byte[] x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setBytes", new Object[]{this, Integer.toString(i), Integer.toString(tbType), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.bindParamCnt][];
        }
        this.paramLength[i - 1] = x.length;
        this.paramBytes[i - 1] = x;
        this.binder[i - 1] = this.staticRawDPLBinder;
    }

    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        Debug.logMethod("TbDirPathStream.setCharacterStream", new Object[]{this, Integer.toString(i), x});
        if (x == null || length <= 0) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramReader == null) {
            this.paramReader = new Reader[this.bindParamCnt];
        }
        this.paramLength[i - 1] = length;
        this.paramReader[i - 1] = x;
        this.binder[i - 1] = this.staticReaderDPLBinder;
    }

    public void setDate(int i, Date x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setDate", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramDate == null) {
            this.paramDate = new Date[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramDate[i - 1] = x;
        this.binder[i - 1] = this.staticDateDPLBinder;
    }

    public void setDate(int index, Date data, Calendar cal) throws SQLException {
        this.setDate(index, data);
    }

    public void setTbDate(int i, TbDate x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setTbDate", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTbDate == null) {
            this.paramTbDate = new TbDate[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTbDate[i - 1] = x;
        this.binder[i - 1] = this.staticTbDateDPLBinder;
    }

    public void setDouble(int i, double x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setDouble", new Object[]{this, Integer.toString(i), Double.toString(x)});
        this.checkParameterIndex(i);
        if (this.paramDouble == null) {
            this.paramDouble = new double[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramDouble[i - 1] = x;
        this.binder[i - 1] = this.staticDoubleDPLBinder;
    }

    public void setEmptyLob(int i) throws SQLException {
        Debug.logMethod("TbDirPathStream.setEmptyLob", new Object[]{this, Integer.toString(i)});
        this.checkParameterIndex(i);
        int svrType = this.metaData.getDataType(i);
        if (svrType != 12 && svrType != 13 && svrType != 20) {
            throw TbError.newSQLException(-590703);
        }
        this.paramLength[i - 1] = -1;
        this.binder[i - 1] = this.staticEmptyLOBDPLBinder;
    }

    public void setFloat(int i, float x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setFloat", new Object[]{this, Integer.toString(i), Float.toString(x)});
        this.checkParameterIndex(i);
        if (this.paramFloat == null) {
            this.paramFloat = new float[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramFloat[i - 1] = x;
        this.binder[i - 1] = this.staticFloatDPLBinder;
    }

    public void setInt(int i, int x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setInt", new Object[]{this, Integer.toString(i), Integer.toString(x)});
        this.checkParameterIndex(i);
        if (this.paramInt == null) {
            this.paramInt = new int[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramInt[i - 1] = x;
        this.binder[i - 1] = this.staticIntDPLBinder;
    }

    public void setLong(int i, long x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setLong", new Object[]{this, Integer.toString(i), Long.toString(x)});
        this.checkParameterIndex(i);
        if (this.paramLong == null) {
            this.paramLong = new long[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramLong[i - 1] = x;
        this.binder[i - 1] = this.staticLongDPLBinder;
    }

    public void setLongBinaryStream(int i, InputStream x, int length) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setLongBinaryStream", new Object[]{this, Integer.toString(i), x, Integer.toString(length)});
        if (x == null || length <= 0) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramStream == null) {
            this.paramStream = new InputStream[this.bindParamCnt];
        }
        this.paramLength[i - 1] = length;
        this.paramStream[i - 1] = x;
        String clientCharSet = this.metaData.getClientCharSet();
        String svrCharSet = ((TbDatabaseMetaData)this.conn.getMetaData()).getServerCharSet();
        this.binder[i - 1] = clientCharSet == null || clientCharSet.equals(svrCharSet) ? this.staticStreamDPLBinder : this.staticLongStreamDPLBinder;
    }

    public void setNull(int i) throws SQLException {
        Debug.logMethod("TbDirPathStream.setNull", new Object[]{this, Integer.toString(i)});
        this.checkParameterIndex(i);
        this.paramLength[i - 1] = 0;
        this.binder[i - 1] = this.staticNullDPLBinder;
    }

    public void setObject(int i, Object x) throws SQLException {
        this.setObject(i, x, DataType.getSqlType(x), 0);
    }

    public void setObject(int i, Object x, int targetSqlType) throws SQLException {
        this.setObject(i, x, targetSqlType, 0);
    }

    public void setObject(int i, Object x, int sqlType, int scale) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setObject", new Object[]{this, Integer.toString(i), x, Integer.toString(sqlType), Integer.toString(scale)});
        if (x == null) {
            this.setNull(i);
            return;
        }
        switch (sqlType) {
            case -7: {
                this.setBoolean(i, new Boolean(x.toString()));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(i, x.toString());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(i, (byte[])x);
                break;
            }
            case -6: 
            case 5: {
                this.setShort(i, new Short(x.toString()));
                break;
            }
            case 4: {
                this.setInt(i, new Integer(x.toString()));
                break;
            }
            case -5: {
                this.setLong(i, new Long(x.toString()));
                break;
            }
            case 3: {
                this.setBigDecimal(i, new BigDecimal(x.toString()));
                break;
            }
            case 6: {
                this.setFloat(i, new Float(x.toString()).floatValue());
                break;
            }
            case 7: {
                this.setFloat(i, new Float(x.toString()).floatValue());
                break;
            }
            case 8: {
                this.setDouble(i, new Double(x.toString()));
                break;
            }
            case 2: {
                if (x instanceof Short) {
                    this.setShort(i, (Short)x);
                    break;
                }
                if (x instanceof Integer) {
                    this.setInt(i, (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setLong(i, (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setFloat(i, ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setDouble(i, (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setBigDecimal(i, (BigDecimal)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBoolean(i, (Boolean)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 91: {
                if (x instanceof Date) {
                    this.setDate(i, (Date)x);
                    break;
                }
                if (x instanceof TbDate) {
                    this.setTbDate(i, (TbDate)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            case 92: {
                this.setTime(i, (Time)x);
                break;
            }
            case 93: {
                if (x instanceof Timestamp) {
                    this.setTimestamp(i, (Timestamp)x);
                    break;
                }
                if (x instanceof TbTimestamp) {
                    this.setTbTimestamp(i, (TbTimestamp)x);
                    break;
                }
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
            default: {
                throw TbError.newSQLException(-590704, x.toString() + "," + sqlType);
            }
        }
    }

    public void setReturnCode(int code) {
        this.returnCode = code;
    }

    public void addRowCnt(int count) {
        this.rowCnt += count;
    }

    public void setRowid(int i, String x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setRowid", new Object[]{this, Integer.toString(i), x});
        if (x == null || x.length() == 0) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramString == null) {
            this.paramString = new String[this.bindParamCnt];
        }
        this.paramLength[i - 1] = x.length();
        this.paramString[i - 1] = x;
        this.binder[i - 1] = this.staticRowIdDPLBinder;
    }

    public void setShort(int i, short x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setShort", new Object[]{this, Integer.toString(i), Short.toString(x)});
        this.checkParameterIndex(i);
        if (this.paramInt == null) {
            this.paramInt = new int[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramInt[i - 1] = x;
        this.binder[i - 1] = this.staticIntDPLBinder;
    }

    public void setString(int i, String x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setString", new Object[]{this, Integer.toString(i), x});
        if (x == null || x.length() == 0) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramString == null) {
            this.paramString = new String[this.bindParamCnt];
        }
        this.paramLength[i - 1] = x.length();
        this.paramString[i - 1] = x;
        this.binder[i - 1] = this.staticStringDPLBinder;
    }

    public void setTime(int i, Time x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setTime", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTime == null) {
            this.paramTime = new Time[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTime[i - 1] = x;
        this.binder[i - 1] = this.staticTimeDPLBinder;
    }

    public void setTime(int index, Time data, Calendar cal) throws SQLException {
        this.setTime(index, data);
    }

    public void setTimestamp(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setTimestamp", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTimestamp == null) {
            this.paramTimestamp = new Timestamp[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTimestamp[i - 1] = x;
        this.binder[i - 1] = this.staticTimestampDPLBinder;
    }

    public void setTbTimestamp(int i, TbTimestamp x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setTbTimestamp", new Object[]{this, Integer.toString(i), x});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTbTimestamp == null) {
            this.paramTbTimestamp = new TbTimestamp[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTbTimestamp[i - 1] = x;
        this.binder[i - 1] = this.staticTbTimestampDPLBinder;
    }

    public void setTimestamp(int index, Timestamp data, Calendar cal) throws SQLException {
        this.setTimestampTZ(index, data, cal.getTimeZone());
    }

    public void setTimestampTZ(int i, Timestamp x, TimeZone timezone) throws SQLException {
        Debug.logMethod("TbDirPathStream.setTimestampTZ", new Object[]{this, Integer.toString(i), x, timezone});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTbTimestampTZ == null) {
            this.paramTbTimestampTZ = new TbTimestampTZ[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTbTimestampTZ[i - 1] = new TbTimestampTZ(x, timezone);
        this.binder[i - 1] = this.staticTbTimestampTZDPLBinder;
    }

    public void setTimestampLTZ(int i, Timestamp x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setTimestampLTZ", new Object[]{this, Integer.toString(i)});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTimestamp == null) {
            this.paramTimestamp = new Timestamp[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTimestamp[i - 1] = x;
        this.binder[i - 1] = this.staticTimestampLTZDPLBinder;
    }

    public void setTbIntervalYtm(int i, TbIntervalYtm x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setIntervalYtm", new Object[]{this, Integer.toString(i)});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTbIntervalYtm == null) {
            this.paramTbIntervalYtm = new TbIntervalYtm[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTbIntervalYtm[i - 1] = x;
        this.binder[i - 1] = this.staticTbIntervalYtmBinder;
    }

    public void setTbIntervalDts(int i, TbIntervalDts x) throws SQLException {
        Debug.logMethod("TbDirPathStream.setIntervalDts", new Object[]{this, Integer.toString(i)});
        if (x == null) {
            this.setNull(i);
            return;
        }
        this.checkParameterIndex(i);
        if (this.paramTbIntervalDts == null) {
            this.paramTbIntervalDts = new TbIntervalDts[this.bindParamCnt];
        }
        this.paramLength[i - 1] = 0;
        this.paramTbIntervalDts[i - 1] = x;
        this.binder[i - 1] = this.staticTbIntervalDtsBinder;
    }
}

