/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.UTF8CharToByteConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class UTF8Encoder
implements CharsetEncoder {
    private UTF8CharToByteConverter conv = new UTF8CharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    @Override
    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.conv.convCharArr(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    @Override
    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        throw TbError.newSQLException(-590714);
    }

    @Override
    public int getEndingBytePos(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return offset;
        }
        int clbOffset = this.getLeadingBytePos(byteArr, offset);
        if (byteArr[clbOffset] >= -32) {
            return clbOffset + 2;
        }
        return clbOffset + 1;
    }

    @Override
    public int getLeadingBytePos(byte[] byteArr, int offset) {
        int i = offset;
        while ((byteArr[i] & 0x80) != 0 && (byteArr[i] & 0x40) == 0) {
            --i;
        }
        return i;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public boolean isEndingByte(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return true;
        }
        int clbOffset = this.getLeadingBytePos(byteArr, offset);
        if (byteArr[clbOffset] >= -32) {
            return offset == clbOffset + 2;
        }
        return offset == clbOffset + 1;
    }

    @Override
    public boolean isLeadingByte(byte[] byteArr, int offset) {
        byte c = byteArr[offset];
        return (c & 0x80) == 0 || (c & 0x40) != 0;
    }

    @Override
    public byte[] stringToBytes(String src) throws SQLException {
        byte[] temp = new byte[src.length() * this.getMaxBytesPerChar()];
        int byteLen = this.conv.convString(src, 0, src.length(), temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    @Override
    public int stringToBytes(byte[] buf, int offset, String src) throws SQLException {
        return this.conv.convString(src, 0, src.length(), buf, offset, buf.length);
    }
}

