/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetDecoder;
import com.tmax.tibero.jdbc.data.charset.UTF16ByteToCharConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class UTF16Decoder
implements CharsetDecoder {
    private UTF16ByteToCharConverter conv = new UTF16ByteToCharConverter();

    @Override
    public int bytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        return this.conv.convert(srcBytes, srcStart, srcStart + srcLen, destChars, destStart, destStart + destLen);
    }

    @Override
    public String bytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        try {
            return new String(srcBytes, srcStart, srcLen, "UTF-16BE");
        }
        catch (Exception e) {
            throw TbError.newSQLException(-590714);
        }
    }

    @Override
    public String bytesToString(byte[] srcBytes) throws SQLException {
        return this.bytesToString(srcBytes, 0, srcBytes.length);
    }

    @Override
    public int fixedBytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        throw TbError.newSQLException(-590714);
    }

    @Override
    public String fixedBytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        return null;
    }

    @Override
    public String fixedBytesToString(byte[] srcBytes) throws SQLException {
        return null;
    }
}

