/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

public class MS950ExtCharToByteConverter {
    private static final char[] CP950EXT_TO_CHARSET = new char[]{'\uf9f9', '\uf9f8', '\uf9e6', '\uf9ef', '\uf9dd', '\uf9e8', '\uf9f1', '\uf9df', '\uf9ec', '\uf9f5', '\uf9e3', '\uf9ee', '\uf9f7', '\uf9e5', '\uf9e9', '\uf9f2', '\uf9e0', '\uf9eb', '\uf9f4', '\uf9e2', '\uf9e7', '\uf9f0', '\uf9de', '\uf9ed', '\uf9f6', '\uf9e4', '\uf9ea', '\uf9f3', '\uf9e1', '\uf9fa', '\uf9fb', '\uf9fd', '\uf9fc', '\uf9fe', '\uf9d9', '\uf9dc', '\uf9da', '\uf9d6', '\uf9db', '\uf9d8', '\uf9d7'};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE25 = new char[][]{{'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\uffff'}, {'\u0010', '\uffff'}, {' ', '\u0001'}, {'!', '\u0000'}, {'!', '\b'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE58 = new char[][]{{'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0000'}, {'\"', '\u0800'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE5A = new char[][]{{'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0400'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE60 = new char[][]{{'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0000'}, {'$', '\u0004'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE78 = new char[][]{{'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0002'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE7C = new char[][]{{'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0000'}, {'&', '\u0080'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE88 = new char[][]{{'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u8000'}};
    private static final char[][] CP950EXT_TO_UNICODE_PAGE92 = new char[][]{{'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0200'}};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int convert(int wc, byte[] dest, int destOffset) {
        int i;
        int used;
        char[] ch = null;
        if (wc >= 9472 && wc < 9632) {
            ch = CP950EXT_TO_UNICODE_PAGE25[(wc >> 4) - 592];
        } else if (wc >= 22528 && wc < 22720) {
            ch = CP950EXT_TO_UNICODE_PAGE58[(wc >> 4) - 1408];
        } else if (wc >= 23040 && wc < 23296) {
            ch = CP950EXT_TO_UNICODE_PAGE5A[(wc >> 4) - 1440];
        } else if (wc >= 24576 && wc < 24672) {
            ch = CP950EXT_TO_UNICODE_PAGE60[(wc >> 4) - 1536];
        } else if (wc >= 30720 && wc < 30864) {
            ch = CP950EXT_TO_UNICODE_PAGE78[(wc >> 4) - 1920];
        } else if (wc >= 31744 && wc < 31920) {
            ch = CP950EXT_TO_UNICODE_PAGE7C[(wc >> 4) - 1984];
        } else if (wc >= 34816 && wc < 35024) {
            ch = CP950EXT_TO_UNICODE_PAGE88[(wc >> 4) - 2176];
        } else if (wc >= 37376 && wc < 37568) {
            ch = CP950EXT_TO_UNICODE_PAGE92[(wc >> 4) - 2336];
        }
        if (ch != null && ((used = ch[1]) & 1 << (i = wc & 0xF)) != 0) {
            used &= (1 << i) - 1;
            used = (used & 0x5555) + ((used & 0xAAAA) >> 1);
            used = (used & 0x3333) + ((used & 0xCCCC) >> 2);
            used = (used & 0xF0F) + ((used & 0xF0F0) >> 4);
            used = (used & 0xFF) + (used >> 8);
            char c = CP950EXT_TO_CHARSET[ch[0] + used];
            dest[destOffset] = (byte)(c >> 8);
            dest[destOffset + 1] = (byte)(c & 0xFF);
            return 0;
        }
        return -1;
    }
}

