/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.Big5CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.Big5ExtCharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.HKSCS2001CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.MS950ExtCharToByteConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class MS950CharToByteConverter {
    private HKSCS2001CharToByteConverter hkscs2001Converter;
    private Big5CharToByteConverter big5Converter;
    private Big5ExtCharToByteConverter big5ExtConverter;
    private MS950ExtCharToByteConverter ms950ExtConverter;
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public MS950CharToByteConverter() {
        this.hkscs2001Converter = new HKSCS2001CharToByteConverter();
        this.big5Converter = new Big5CharToByteConverter();
        this.big5ExtConverter = new Big5ExtCharToByteConverter();
        this.ms950ExtConverter = new MS950ExtCharToByteConverter();
    }

    public int convCharArr(char[] src, int srcStartOffset, int srcEndOffset, byte[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int j = destStartOffset;
        byte[] ret = new byte[2];
        for (int i = srcStartOffset; i < srcEndOffset && j < destEndOffset; ++i) {
            char wc = src[i];
            if (wc < '\u0080') {
                dest[j++] = (byte)wc;
                continue;
            }
            int rc = this.hkscs2001Converter.convert(wc, ret, 0);
            if (rc == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.ms950ExtConverter.convert(wc, ret, 0) == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.big5ExtConverter.convert(wc, ret, 0) == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.big5Converter.convert(wc, ret, 0) == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.subMode) {
                dest[j++] = this.subBytes[0];
                continue;
            }
            throw TbError.newSQLException(-590742, (int)wc);
        }
        return j - destStartOffset;
    }

    public int convCharArr(int[] src, int srcStartOffset, int srcEndOffset, byte[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int j = destStartOffset;
        byte[] ret = new byte[2];
        for (int i = srcStartOffset; i < srcEndOffset && j < destEndOffset; ++i) {
            int wc = src[i];
            if (wc < 128) {
                dest[j++] = (byte)wc;
                continue;
            }
            int rc = this.hkscs2001Converter.convert(wc, ret, 0);
            if (rc == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.ms950ExtConverter.convert(wc, ret, 0) == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.big5ExtConverter.convert(wc, ret, 0) == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.big5Converter.convert(wc, ret, 0) == 0) {
                dest[j++] = ret[0];
                dest[j++] = ret[1];
                continue;
            }
            if (this.subMode) {
                dest[j++] = this.subBytes[0];
                continue;
            }
            throw TbError.newSQLException(-590742, wc);
        }
        return j - destStartOffset;
    }

    public int convString(String srcStr, int srcCharOffset, int srcCharEndOffset, byte[] destByteBuf, int destByteOffset, int destBufSize) throws SQLException {
        return this.convCharArr(srcStr.toCharArray(), srcCharOffset, srcCharEndOffset, destByteBuf, destByteOffset, destBufSize);
    }

    public int getMaxBytesPerChar() {
        return 2;
    }
}

