/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.MS932CharToByteConverter;
import java.sql.SQLException;

public class MS932Encoder
implements CharsetEncoder {
    private MS932CharToByteConverter conv = new MS932CharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    @Override
    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.conv.convCharArr(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    @Override
    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return 0;
    }

    @Override
    public int getEndingBytePos(byte[] byteArr, int offset) {
        if (this.isEndingByte(byteArr, offset)) {
            return offset;
        }
        return offset + 1;
    }

    @Override
    public int getLeadingBytePos(byte[] byteArr, int offset) {
        if (this.isLeadingByte(byteArr, offset)) {
            return offset;
        }
        return offset - 1;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public boolean isEndingByte(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return true;
        }
        return !this.isLeadingByte(byteArr, offset);
    }

    @Override
    public boolean isLeadingByte(byte[] byteArr, int offset) {
        int i = offset;
        while (!(i - 1 < 0 || this.isSingleByte(byteArr[i]) && this.isSingleByte(byteArr[i - 1]))) {
            --i;
        }
        while (i <= offset) {
            if (!this.isSingleByte(byteArr[i])) {
                if (i + 1 == offset) {
                    return false;
                }
                ++i;
            } else if (i == offset) {
                return true;
            }
            ++i;
        }
        return true;
    }

    private boolean isSingleByte(byte value) {
        if (value < 128) {
            return true;
        }
        return value >= 161 && value < 224;
    }

    @Override
    public byte[] stringToBytes(String src) throws SQLException {
        byte[] temp = new byte[src.length() * this.getMaxBytesPerChar()];
        int byteLen = this.conv.convString(src, 0, src.length(), temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    @Override
    public int stringToBytes(byte[] buf, int offset, String src) throws SQLException {
        return this.conv.convString(src, 0, src.length(), buf, offset, buf.length);
    }
}

