/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import java.sql.SQLException;

public class MS1252CharToByteConverter {
    private static final short[] UNICODE_TO_MS1252_IDX_PAGE1 = new short[]{0, 0, 140, 156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 0, 0, 0, 0, 142, 158, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 0, 0, 0, 0, 0};
    private static final char[] UNICODE_TO_MS1252_IDX_PAGE2 = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0088', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0098', '\u0000', '\u0000', '\u0000'};
    private static final char[] UNICODE_TO_MS1252_IDX_PAGE20 = new char[]{'\u0000', '\u0000', '\u0000', '\u0096', '\u0097', '\u0000', '\u0000', '\u0000', '\u0091', '\u0092', '\u0082', '\u0000', '\u0093', '\u0094', '\u0084', '\u0000', '\u0086', '\u0087', '\u0095', '\u0000', '\u0000', '\u0000', '\u0085', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0089', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u008b', '\u009b', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public boolean canConvert(char c) {
        return c < '\u0080' || c >= '\u00c0' && c < '\u00ff' || c >= '\u0100' && c < '\u01bf' || c >= '\u1ea0' && c < '\u1eff';
    }

    protected int convSingleByte(char c, byte[] out) {
        if (c < '\u0080') {
            out[0] = (byte)(c & 0x7F);
            return 1;
        }
        return 0;
    }

    public int convCharArr(char[] src, int srcStartOffset, int srcEndOffset, byte[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int j = destStartOffset;
        for (int i = srcStartOffset; i < srcEndOffset && j < destEndOffset; ++i) {
            char wc = src[i];
            if (wc < '\u0080') {
                dest[j++] = (byte)wc;
                continue;
            }
            int c1 = wc >= '\u00a0' && wc < '\u0100' ? (int)wc : ((short)wc >= 336 && wc < '\u0198' ? (int)((char)UNICODE_TO_MS1252_IDX_PAGE1[wc - 336]) : (wc >= '\u02c0' && wc < '\u02e0' ? UNICODE_TO_MS1252_IDX_PAGE2[wc - 704] : (wc >= '\u2010' && wc < '\u2040' ? UNICODE_TO_MS1252_IDX_PAGE20[wc - 8208] : (wc == '\u20ac' ? 128 : (wc == '\u2122' ? 153 : 63)))));
            if (c1 == 0) {
                c1 = 63;
            }
            dest[j++] = (byte)c1;
        }
        return j - destStartOffset;
    }

    public int convString(String srcStr, int srcCharOffset, int srcCharEndOffset, byte[] destByteBuf, int destByteOffset, int destBufSize) throws SQLException {
        return this.convCharArr(srcStr.toCharArray(), srcCharOffset, srcCharEndOffset, destByteBuf, destByteOffset, destBufSize);
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

