/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class MS1252ByteToCharConverter {
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'?'};
    private static final char[] MS1252_TO_UNICODE_PAGE = new char[]{'\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\u017d', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\u017e', '\u0178'};

    private int decodeFromUcs(byte high, byte low) {
        return (high << 8) + (low & 0xFF);
    }

    private void encodeUCharToUCS2(char[] buf, int offset, int wc) {
        boolean high = false;
        byte low = (byte)wc;
        buf[offset] = (char)(high ? 1 : 0);
        buf[offset++] = (char)low;
    }

    public int convert(byte[] src, int srcStartOffset, int srcEndOffset, char[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int i = srcStartOffset;
        int j = destStartOffset;
        while (i < srcEndOffset) {
            int wc = this.decodeFromUcs((byte)0, src[i]);
            if (wc < 128 || wc >= 160) {
                dest[j++] = (char)wc;
                ++i;
                continue;
            }
            int k = wc - 128;
            if ((wc = MS1252_TO_UNICODE_PAGE[k]) != 65533) {
                dest[j++] = (char)wc;
                ++i;
                continue;
            }
            if (this.subMode) {
                this.encodeUCharToUCS2(dest, j, this.subChars[0]);
                ++j;
                continue;
            }
            throw TbError.newSQLException(-590742, wc);
        }
        return j - destStartOffset;
    }
}

