/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import java.sql.SQLException;

public class MS1251CharToByteConverter {
    private static final short[] UNICODE_TO_MS1251_IDX_PAGE00 = new short[]{160, 0, 0, 0, 164, 0, 166, 167, 0, 169, 0, 171, 172, 173, 174, 0, 176, 177, 0, 0, 0, 181, 182, 183, 0, 0, 0, 187, 0, 0, 0, 0};
    private static final char[] UNICODE_TO_MS1251_IDX_PAGE04 = new char[]{'\u0000', '\u00a8', '\u0080', '\u0081', '\u00aa', '\u00bd', '\u00b2', '\u00af', '\u00a3', '\u008a', '\u008c', '\u008e', '\u008d', '\u0000', '\u00a1', '\u008f', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff', '\u0000', '\u00b8', '\u0090', '\u0083', '\u00ba', '\u00be', '\u00b3', '\u00bf', '\u00bc', '\u009a', '\u009c', '\u009e', '\u009d', '\u0000', '\u00a2', '\u009f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00a5', '\u00b4', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final char[] UNICODE_TO_MS1251_IDX_PAGE20 = new char[]{'\u0000', '\u0000', '\u0000', '\u0096', '\u0097', '\u0000', '\u0000', '\u0000', '\u0091', '\u0092', '\u0082', '\u0000', '\u0093', '\u0094', '\u0084', '\u0000', '\u0086', '\u0087', '\u0095', '\u0000', '\u0000', '\u0000', '\u0085', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0089', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u008b', '\u009b', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public int convCharArr(char[] src, int srcStartOffset, int srcEndOffset, byte[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int j = destStartOffset;
        for (int i = srcStartOffset; i < srcEndOffset && j < destEndOffset; ++i) {
            char wc = src[i];
            if (wc < '\u0080') {
                dest[j++] = (byte)wc;
                continue;
            }
            int c1 = wc >= '\u00a0' && wc < '\u00c0' ? (int)UNICODE_TO_MS1251_IDX_PAGE00[wc - 160] : ((short)wc >= 1024 && wc < '\u0498' ? UNICODE_TO_MS1251_IDX_PAGE04[wc - 1024] : (wc >= '\u2010' && wc < '\u2040' ? UNICODE_TO_MS1251_IDX_PAGE20[wc - 8208] : (wc == '\u20ac' ? 136 : (wc == '\u2116' ? 185 : (wc == '\u2122' ? 153 : (wc == '\u0098' ? 152 : 63))))));
            if (c1 == 0) {
                c1 = 63;
            }
            dest[j++] = (byte)c1;
        }
        return j - destStartOffset;
    }

    public int convString(String srcStr, int srcCharOffset, int srcCharEndOffset, byte[] destByteBuf, int destByteOffset, int destBufSize) throws SQLException {
        return this.convCharArr(srcStr.toCharArray(), srcCharOffset, srcCharEndOffset, destByteBuf, destByteOffset, destBufSize);
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

