/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetDecoder;
import com.tmax.tibero.jdbc.data.charset.KOI8RByteToCharConverter;
import java.sql.SQLException;

public class KOI8RDecoder
implements CharsetDecoder {
    private KOI8RByteToCharConverter conv = new KOI8RByteToCharConverter();

    @Override
    public int bytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        return this.conv.convert(srcBytes, srcStart, srcStart + srcLen, destChars, destStart, destStart + destLen);
    }

    @Override
    public String bytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        int destLen = srcLen;
        char[] destChars = new char[destLen];
        int length = this.bytesToChars(srcBytes, srcStart, srcLen, destChars, 0, destLen);
        return new String(destChars, 0, length);
    }

    @Override
    public String bytesToString(byte[] srcBytes) throws SQLException {
        return this.bytesToString(srcBytes, 0, srcBytes.length);
    }

    @Override
    public int fixedBytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        int chIndex = destStart;
        for (int btIndex = srcStart; btIndex < srcStart + srcLen; btIndex += 2) {
            if (srcBytes[btIndex] == 0) {
                if (srcBytes[btIndex + 1] < 0) {
                    destChars[chIndex++] = (char)(srcBytes[btIndex + 1] + 256);
                    continue;
                }
                destChars[chIndex++] = (char)srcBytes[btIndex + 1];
                continue;
            }
            chIndex += this.conv.convert(srcBytes, btIndex, btIndex + 2, destChars, chIndex, chIndex + 2);
        }
        return chIndex - destStart;
    }

    @Override
    public String fixedBytesToString(byte[] srcBytes, int srcStart, int srcLen) throws SQLException {
        return null;
    }

    @Override
    public String fixedBytesToString(byte[] srcBytes) throws SQLException {
        return null;
    }
}

