/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import java.sql.SQLException;

public class ISO8859P5CharToByteConverter {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    private static final char[] UNICODE_TO_KOI8R_IDX_PAGE00 = new char[]{'\u00a0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00fd', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00ad', '\u0000', '\u0000'};
    private static final char[] UNICODE_TO_KOI8R_IDX_PAGE04 = new char[]{'\u0000', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u0000', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u0000', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u0000', '\u00fe', '\u00ff'};

    public int convCharArr(char[] src, int srcStartOffset, int srcEndOffset, byte[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int j = destStartOffset;
        for (int i = srcStartOffset; i < srcEndOffset && j < destEndOffset; ++i) {
            char wc = src[i];
            if (wc < '\u00a0') {
                dest[j++] = (byte)wc;
                continue;
            }
            int c1 = wc >= '\u00a0' && wc < '\u00b0' ? UNICODE_TO_KOI8R_IDX_PAGE00[wc - 160] : (wc >= '\u0400' && wc < '\u0460' ? UNICODE_TO_KOI8R_IDX_PAGE04[wc - 1024] : (wc == '\u2116' ? 240 : 63));
            if (c1 == 0) {
                c1 = 63;
            }
            dest[j++] = (byte)c1;
        }
        return j - destStartOffset;
    }

    public int convString(String srcStr, int srcCharOffset, int srcCharEndOffset, byte[] destByteBuf, int destByteOffset, int destBufSize) throws SQLException {
        return this.convCharArr(srcStr.toCharArray(), srcCharOffset, srcCharEndOffset, destByteBuf, destByteOffset, destBufSize);
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

