/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class ISO8859P1CharToByteConverter {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public int convCharArr(char[] src, int srcStartOffset, int srcEndOffset, byte[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int i = srcStartOffset;
        int j = destStartOffset;
        while (i < srcEndOffset && j < destEndOffset) {
            char wc = src[i];
            if (wc < '\u0100') {
                dest[j++] = (byte)wc;
                ++i;
                continue;
            }
            if (this.subMode) {
                dest[j++] = this.subBytes[0];
                ++i;
                continue;
            }
            throw TbError.newSQLException(-590742, (int)wc);
        }
        return j - destStartOffset;
    }

    public int convString(String srcStr, int srcCharOffset, int srcCharEndOffset, byte[] destByteBuf, int destByteOffset, int destBufSize) throws SQLException {
        return this.convCharArr(srcStr.toCharArray(), srcCharOffset, srcCharEndOffset, destByteBuf, destByteOffset, destBufSize);
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

