/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import java.sql.SQLException;

public class ISO8859P15ByteToCharConverter {
    protected boolean subMode = true;
    protected char[] subChars = new char[]{'?'};
    private static final char[] ISO8859P15_TO_UNICODE_PAGE = new char[]{'\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u20ac', '\u00a5', '\u0160', '\u00a7', '\u0161', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u017d', '\u00b5', '\u00b6', '\u00b7', '\u017e', '\u00b9', '\u00ba', '\u00bb', '\u0152', '\u0153', '\u0178', '\u00bf'};

    private int decodeFromUcs(byte high, byte low) {
        return (high << 8) + (low & 0xFF);
    }

    public int convert(byte[] src, int srcStartOffset, int srcEndOffset, char[] dest, int destStartOffset, int destEndOffset) throws SQLException {
        int i = srcStartOffset;
        int j = destStartOffset;
        while (i < srcEndOffset) {
            int wc = this.decodeFromUcs((byte)0, src[i]);
            if (wc >= 160 && wc < 192) {
                wc = ISO8859P15_TO_UNICODE_PAGE[wc - 160];
                dest[j++] = (char)wc;
                ++i;
                continue;
            }
            dest[j++] = (char)wc;
            ++i;
        }
        return j - destStartOffset;
    }
}

