/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.EUCKRCharToByteConverter;
import java.sql.SQLException;

public class EUCKREncoder
implements CharsetEncoder {
    private EUCKRCharToByteConverter conv = new EUCKRCharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    @Override
    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.conv.convCharArr(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    @Override
    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        int byteIndex = destStart;
        for (int chIndex = srcStart; chIndex < srcStart + srcLen; ++chIndex) {
            if (srcChars[chIndex] < '\u0080') {
                destBytes[byteIndex++] = 0;
                destBytes[byteIndex++] = (byte)srcChars[chIndex];
                continue;
            }
            int num = this.conv.convCharArr(srcChars, chIndex, chIndex + 1, destBytes, byteIndex, byteIndex + this.maxBytesPerChar);
            if (num == 0) {
                destBytes[byteIndex] = 0;
                destBytes[byteIndex + 1] = 0;
            } else if (num == 1) {
                destBytes[byteIndex + 1] = destBytes[byteIndex];
                destBytes[byteIndex] = 0;
            }
            byteIndex += this.maxBytesPerChar;
        }
        return byteIndex - destStart;
    }

    @Override
    public int getEndingBytePos(byte[] byteArr, int offset) {
        if (this.isEndingByte(byteArr, offset)) {
            return offset;
        }
        return offset + 1;
    }

    @Override
    public int getLeadingBytePos(byte[] byteArr, int offset) {
        if (this.isLeadingByte(byteArr, offset)) {
            return offset;
        }
        return offset - 1;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public boolean isEndingByte(byte[] byteArr, int offset) {
        if (byteArr[offset] >= 0) {
            return true;
        }
        return !this.isLeadingByte(byteArr, offset);
    }

    @Override
    public boolean isLeadingByte(byte[] byteArr, int offset) {
        int i;
        for (i = offset; i >= 0 && byteArr[i] < 0; --i) {
        }
        return i == offset || (offset - i) % 2 == 1;
    }

    @Override
    public byte[] stringToBytes(String src) throws SQLException {
        byte[] temp = new byte[src.length() * this.getMaxBytesPerChar()];
        int byteLen = this.conv.convString(src, 0, src.length(), temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    @Override
    public int stringToBytes(byte[] buf, int offset, String src) throws SQLException {
        return this.conv.convString(src, 0, src.length(), buf, offset, buf.length);
    }
}

