/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class Charset {
    public static final int ASCII = 0;
    public static final int EUC_KR = 1;
    public static final int MSWIN949 = 2;
    public static final int UTF_8 = 3;
    public static final int UTF_16 = 4;
    public static final int SJIS = 5;
    public static final int JA16SJIS = 6;
    public static final int JA16SJIS_TILDE = 7;
    public static final int EUC_JP = 8;
    public static final int EUC_JP_TILDE = 9;
    public static final int VN8VN3 = 10;
    public static final int GBK = 11;
    public static final int MSWIN1252 = 12;
    public static final int MSWIN950 = 13;
    public static final int MSWIN1251 = 14;
    public static final int ISO8859P1 = 15;
    public static final int ISO8859P2 = 16;
    public static final int ISO8859P9 = 17;
    public static final int ISO8859P15 = 18;
    public static final int KOI8R = 19;
    public static final int ISO8859P5 = 20;
    public static final int CP866 = 21;
    public static final int TIS620 = 22;
    public static final int MSWIN1253 = 23;
    public static final int ISO8859P7 = 24;
    public static final int MSWIN1256 = 25;
    public static final int ISO8859P6 = 26;
    public static final int SJISTILDE = 27;
    public static final int ZHT16BIG5 = 28;
    public static final int ZHT16MSWIN950 = 29;
    public static final int MAX_CHAR_SET = 29;
    public static final String[] name = new String[]{"ASCII", "EUC-KR", "MSWIN949", "UTF-8", "UTF-16", "SHIFT-JIS", "JA16SJIS", "JA16SJISTILDE", "JA16EUC", "JA16EUCTILDE", "VN8VN3", "GBK", "WE8MSWIN1252", "ZHT16HKSCS", "CL8MSWIN1251", "WE8ISO8859P1", "EE8ISO8859P2", "WE8ISO8859P9", "WE8ISO8859P15", "CL8KOI8R", "CL8ISO8859P5", "CP866", "TH8TISASCII", "EL8MSWIN1253", "EL8ISO8859P7", "AR8MSWIN1256", "AR8ISO8859P6"};
    private static final String[][] aliases = new String[][]{{"US7ASCII"}, {"EUCKR", "KO16KSC5601"}, {"CP949", "KO16MSWIN949"}, {"UTF8"}, {"UTF-16BE", "AL16UTF16"}, {"SJIS", "JA16SJIS"}, {"CP932"}, {"CP932"}, {"EUC-JP"}, {"EUC-JP"}, {"TCVN"}, {"CP936", "ZHS16GBK"}, {"CP1252", "MSWIN1252"}, {"CP950", "MSWIN950"}, {"CP1251", "MSWIN1251"}, {"ISO8859P1", "ISO-8859-1"}, {"ISO8859P2", "ISO-8859-2"}, {"ISO8859P9", "ISO-8859-9"}, {"ISO8859P15", "ISO-8859-15"}, {"KOI8-R"}, {"ISO8859P5", "ISO-8859-5"}, {"RUCP866"}, {"TIS620"}, {"CP1253", "MSWIN1253"}, {"ISO8859P7", "ISO-8859-7"}, {"CP1256", "MSWIN1256"}, {"ISO8859P6", "ISO-8859-6"}};

    public static int getCharset(String charsetName) {
        int i;
        if (charsetName == null) {
            return -1;
        }
        for (i = 0; i < name.length; ++i) {
            if (!name[i].equalsIgnoreCase(charsetName)) continue;
            return i;
        }
        for (i = 0; i < aliases.length; ++i) {
            for (int j = 0; j < aliases[i].length; ++j) {
                if (!aliases[i][j].equalsIgnoreCase(charsetName)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String getName(int charset) throws SQLException {
        if (charset < 0 || charset >= 29) {
            throw TbError.newSQLException(-590718);
        }
        return name[charset];
    }

    public static void verify(int charset) throws SQLException {
        if (charset < 0 || charset >= 29) {
            throw TbError.newSQLException(-590718);
        }
    }

    private Charset() {
    }
}

