/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.ASCIICharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import java.sql.SQLException;

public class ASCIIEncoder
implements CharsetEncoder {
    private ASCIICharToByteConverter conv = new ASCIICharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    @Override
    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.conv.convCharArr(srcChars, srcStart, srcStart + srcLen, destBytes, destStart, destStart + destLen);
    }

    @Override
    public int charsToFixedBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return 0;
    }

    @Override
    public int getEndingBytePos(byte[] byteArr, int offset) {
        return offset;
    }

    @Override
    public int getLeadingBytePos(byte[] byteArr, int offset) {
        return offset;
    }

    @Override
    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    @Override
    public boolean isEndingByte(byte[] byteArr, int offset) {
        return true;
    }

    @Override
    public boolean isLeadingByte(byte[] byteArr, int offset) {
        return true;
    }

    @Override
    public byte[] stringToBytes(String src) throws SQLException {
        byte[] temp = new byte[src.length() * this.getMaxBytesPerChar()];
        int byteLen = this.conv.convString(src, 0, src.length(), temp, 0, temp.length);
        byte[] dest = new byte[byteLen];
        System.arraycopy(temp, 0, dest, 0, byteLen);
        return dest;
    }

    @Override
    public int stringToBytes(byte[] buf, int offset, String val) throws SQLException {
        return this.conv.convString(val, 0, val.length(), buf, offset, buf.length);
    }
}

