/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;

public class TbTimestampTZBinder
extends Binder {
    private static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        DataTypeConverter conv = conn.getTypeConverter();
        TbTimestampTZ bindParam = bpc.getParamTbTimestampTZ(rowIndex, paramIndex);
        int offset = writer.getBufferedDataSize();
        writer.makeBufferAvailable(13);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        Calendar utcCalendar = Calendar.getInstance(TZ_UTC);
        utcCalendar.setTimeInMillis(bindParam.getTime());
        int convertedLen = conv.fromTimestampTZ(byteBuf, offset + 1, utcCalendar, bindParam.getNanos(), bindParam.getTimeZone());
        byteBuf[offset] = (byte)convertedLen;
        writer.moveOffset(convertedLen + 1);
        writer.writePadding(convertedLen + 1);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        DataTypeConverter conv = conn.getTypeConverter();
        TbTimestampTZ bindParam = bpc.getParamTbTimestampTZ(rowIndex, paramIndex);
        int offset = writer.getBufferedDataSize();
        writer.makeBufferAvailable(13);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        Calendar utcCalendar = Calendar.getInstance(TZ_UTC);
        utcCalendar.setTimeInMillis(bindParam.getTime());
        int convertedLen = conv.fromTimestampTZ(byteBuf, offset + 1, utcCalendar, bindParam.getNanos(), bindParam.getTimeZone());
        byteBuf[offset] = (byte)convertedLen;
        writer.moveOffset(convertedLen + 1);
        if (pad) {
            writer.writePadding(convertedLen + 1);
        }
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
    }
}

