/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class StructOutBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        DataTypeConverter conv = conn.getTypeConverter();
        int STRUCT_META_LENGTH = 40;
        BindItem item = bpc.getBindData().getBindItem(paramIndex);
        Object bindParam = null;
        TbStructDescriptor desc = (TbStructDescriptor)item.getTypeDescriptor();
        String oid = desc.getOID();
        int tbojID = desc.getTobjID();
        int versionNo = desc.getVersionNo();
        int offset = writer.getBufferedDataSize();
        writer.makeBufferAvailable(43);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        byteBuf[offset] = 40;
        int rpcolLen = 1;
        int convertedLen = conv.fromString(byteBuf, offset + rpcolLen, oid);
        writer.moveOffset(convertedLen + rpcolLen);
        writer.writeInt(tbojID, 4);
        writer.writeInt(versionNo, 4);
        writer.writePadding(40 + rpcolLen);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        throw TbError.newSQLException(-590705);
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
        throw TbError.newSQLException(-590705);
    }
}

