/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.ObjSeriCtx;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.LinkedList;

public class StructInBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        byte[] buf;
        int STRUCT_META_LENGTH = 40;
        DataTypeConverter conv = conn.getTypeConverter();
        BindItem item = bpc.getBindData().getBindItem(paramIndex);
        TbStruct bindParam = null;
        TbStructDescriptor desc = (TbStructDescriptor)item.getTypeDescriptor();
        String oid = desc.getOID();
        int tbojID = desc.getTobjID();
        int versionNo = desc.getVersionNo();
        int offset1 = writer.getBufferedDataSize();
        writer.makeBufferAvailable(43);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        int rpLen1 = 40;
        byteBuf[offset1] = (byte)rpLen1;
        int rpcolLen = 1;
        int convertedLen = conv.fromString(byteBuf, offset1 + rpcolLen, oid);
        writer.moveOffset(convertedLen + rpcolLen);
        writer.writeInt(tbojID, 4);
        writer.writeInt(versionNo, 4);
        bindParam = (TbStruct)bpc.getParamStruct(rowIndex, paramIndex);
        int rpLen2 = 0;
        int offset2 = writer.getBufferedDataSize();
        byteBuf[offset2] = (byte)rpLen2;
        int rpcolLen2 = 1;
        writer.moveOffset(rpcolLen2);
        writer.writeByte((byte)-124);
        writer.writeByte((byte)1);
        if (!desc.isFinal()) {
            writer.writeBytes(DataTypeConverter.RPCOL_UDT_NOT_FINAL);
        }
        int offset3 = writer.getBufferedDataSize();
        int rpLen3 = 0;
        writer.writeByte((byte)rpLen3);
        int curObjGrpDepth = 0;
        LinkedList<ObjSeriCtx> llCtx = new LinkedList<ObjSeriCtx>();
        ObjSeriCtx root = new ObjSeriCtx(bindParam);
        llCtx.addFirst(root);
        ObjSeriCtx cur = root;
        block4: while (!llCtx.isEmpty()) {
            int attrIdx;
            Object[] attrs = cur.struct.getAttributes();
            if (attrs == null) {
                if (curObjGrpDepth == 0) {
                    writer.writeByte((byte)-3);
                } else {
                    writer.writeByte((byte)-4);
                    writer.writeByte((byte)curObjGrpDepth);
                }
                curObjGrpDepth = 0;
                llCtx.remove(0);
                if (llCtx.isEmpty()) continue;
                cur = (ObjSeriCtx)llCtx.getFirst();
                continue;
            }
            if ((attrIdx = cur.attrProcessed++) >= attrs.length) {
                llCtx.remove(0);
                continue;
            }
            Object nextAttr = attrs[attrIdx];
            int nextAttrType = cur.struct.getDescriptor().getAttributeTypes()[attrIdx];
            switch (nextAttrType) {
                case 28: 
                case 32: {
                    if (nextAttr instanceof TbStruct || nextAttr instanceof SQLData) {
                        ObjSeriCtx newCtx;
                        if (nextAttr instanceof SQLData) {
                            TbStruct tmp = (TbStruct)TbStruct.toStruct(nextAttr, conn);
                            newCtx = new ObjSeriCtx(tmp);
                        } else {
                            newCtx = new ObjSeriCtx((TbStruct)nextAttr);
                        }
                        if (!newCtx.struct.getDescriptor().isFinal()) {
                            int[] offset = this.writeNotFinalObject(writer, byteBuf, newCtx.desc);
                            llCtx.addFirst(newCtx);
                            cur = newCtx;
                            cur.setOffset(offset);
                            continue block4;
                        }
                        llCtx.addFirst(newCtx);
                        cur = newCtx;
                        ++curObjGrpDepth;
                        continue block4;
                    }
                    if (curObjGrpDepth == 0) {
                        writer.writeByte((byte)-3);
                        break;
                    }
                    writer.writeByte((byte)-4);
                    writer.writeByte((byte)curObjGrpDepth);
                    curObjGrpDepth = 0;
                    break;
                }
                case 29: 
                case 30: {
                    break;
                }
                default: {
                    ParamContainer defaultTypeSubParams = cur.struct.getSubParams();
                    Binder binder = defaultTypeSubParams.getBinder(-1, attrIdx);
                    binder.bind(conn, defaultTypeSubParams, writer, -1, attrIdx, defaultTypeSubParams.getBindData().getBindItem(attrIdx).getLength(), false);
                    curObjGrpDepth = 0;
                }
            }
            if (cur.attrProcessed < cur.struct.getNumOfFields()) continue;
            if (!cur.desc.isFinal()) {
                cur.rewriteRpLen(writer, byteBuf, offset1);
            }
            llCtx.remove(0);
            if (llCtx.isEmpty()) continue;
            cur = (ObjSeriCtx)llCtx.getFirst();
        }
        rpLen3 = writer.getBufferedDataSize() - offset1 - 40 - rpcolLen - rpcolLen2;
        if (rpLen3 <= 250) {
            writer.reWriteInt(offset3, rpLen3, 1);
        } else if (rpLen3 <= 65535) {
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 3, rpLen3);
            writer.moveOffset(2);
            writer.reWriteInt(offset3, 254, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 2);
        } else {
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 5, rpLen3);
            writer.moveOffset(4);
            writer.reWriteInt(offset3, 251, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 4);
        }
        rpLen2 = writer.getBufferedDataSize() - offset1 - rpcolLen - rpcolLen2;
        if (rpLen2 <= 250) {
            rpcolLen2 = 1;
            writer.reWriteInt(offset2, rpLen2, 1);
        } else if (rpLen2 <= 65535) {
            rpcolLen2 = 3;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 3, rpLen2);
            writer.moveOffset(2);
            writer.reWriteInt(offset2, 254, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 2);
        } else {
            rpcolLen2 = 5;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 5, rpLen2);
            writer.moveOffset(4);
            writer.reWriteInt(offset2, 251, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 4);
        }
        rpLen1 = writer.getBufferedDataSize() - offset1 - rpcolLen - rpcolLen2;
        if (rpLen1 <= 250) {
            rpcolLen = 1;
            writer.reWriteInt(offset1, rpLen1, 1);
        } else if (rpLen1 <= 65535) {
            rpcolLen = 3;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset1 + 1, buf, offset1 + 3, rpLen1);
            writer.moveOffset(2);
            writer.reWriteInt(offset1, 254, 1);
            writer.reWriteInt(offset1 + 1, rpLen1, 2);
        } else {
            rpcolLen = 5;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset1 + 1, buf, offset1 + 5, rpLen1);
            writer.moveOffset(4);
            writer.reWriteInt(offset1, 251, 1);
            writer.reWriteInt(offset1 + 1, rpLen1, 4);
        }
        writer.writePadding(rpLen1 + rpcolLen + rpcolLen2);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        int rpLen3;
        int STRUCT_META_LENGTH = 40;
        BindItem item = bpc.getBindData().getBindItem(paramIndex);
        TbStruct bindParam = null;
        TbStructDescriptor desc = (TbStructDescriptor)item.getTypeDescriptor();
        writer.makeBufferAvailable(43);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        bindParam = (TbStruct)bpc.getParamStruct(rowIndex, paramIndex);
        int rpLen2 = 0;
        int offset2 = writer.getBufferedDataSize();
        byteBuf[offset2] = (byte)rpLen2;
        int rpcolLen2 = 1;
        writer.moveOffset(rpcolLen2);
        writer.writeByte((byte)-124);
        writer.writeByte((byte)1);
        if (!desc.isFinal()) {
            writer.writeBytes(DataTypeConverter.RPCOL_UDT_NOT_FINAL);
        }
        int offset3 = writer.getBufferedDataSize();
        writer.writeByte((byte)0);
        int curObjGrpDepth = 0;
        LinkedList<ObjSeriCtx> llCtx = new LinkedList<ObjSeriCtx>();
        ObjSeriCtx root = new ObjSeriCtx(bindParam);
        llCtx.addFirst(root);
        ObjSeriCtx cur = root;
        block3: while (!llCtx.isEmpty()) {
            int attrIdx;
            Object[] attrs = cur.struct.getAttributes();
            if (attrs == null) {
                if (curObjGrpDepth == 0) {
                    writer.writeByte((byte)-3);
                } else {
                    writer.writeByte((byte)-4);
                    writer.writeByte((byte)curObjGrpDepth);
                }
                curObjGrpDepth = 0;
                cur = (ObjSeriCtx)llCtx.removeFirst();
                continue;
            }
            if ((attrIdx = cur.attrProcessed++) >= attrs.length) break;
            Object nextAttr = attrs[attrIdx];
            int nextAttrType = cur.struct.getDescriptor().getAttributeTypes()[attrIdx];
            switch (nextAttrType) {
                case 28: 
                case 32: {
                    if (nextAttr instanceof TbStruct) {
                        ObjSeriCtx newCtx = new ObjSeriCtx((TbStruct)nextAttr);
                        break;
                    }
                    if (nextAttr instanceof SQLData) {
                        TbStruct tmp = (TbStruct)TbStruct.toStruct(nextAttr, conn);
                        ObjSeriCtx newCtx = new ObjSeriCtx(tmp);
                        llCtx.addFirst(newCtx);
                        cur = newCtx;
                        ++curObjGrpDepth;
                        continue block3;
                    }
                    if (curObjGrpDepth == 0) {
                        writer.writeByte((byte)-3);
                        break;
                    }
                    writer.writeByte((byte)-4);
                    writer.writeByte((byte)curObjGrpDepth);
                    curObjGrpDepth = 0;
                    break;
                }
                default: {
                    ParamContainer subParams1 = cur.struct.getSubParams();
                    Binder binder = subParams1.getBinder(-1, attrIdx);
                    binder.bind(conn, subParams1, writer, -1, attrIdx, subParams1.getBindData().getBindItem(attrIdx).getLength(), false);
                    curObjGrpDepth = 0;
                }
            }
            if (cur.attrProcessed < cur.struct.getNumOfFields()) continue;
            llCtx.remove(0);
            if (llCtx.isEmpty()) continue;
            cur = (ObjSeriCtx)llCtx.getFirst();
        }
        if ((rpLen3 = writer.getBufferedDataSize() - offset2 - 40 - rpcolLen2) <= 250) {
            writer.reWriteInt(offset3, rpLen3, 1);
        } else if (rpLen3 <= 65535) {
            byte[] buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 3, rpLen3);
            writer.reWriteInt(offset3, 254, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 2);
        } else {
            byte[] buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 5, rpLen3);
            writer.reWriteInt(offset3, 251, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 4);
        }
        rpLen2 = writer.getBufferedDataSize() - offset2 - rpcolLen2;
        if (rpLen2 <= 250) {
            rpcolLen2 = 1;
            writer.reWriteInt(offset2, rpLen2, 1);
        } else if (rpLen2 <= 65535) {
            rpcolLen2 = 3;
            byte[] buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 3, rpLen2);
            writer.reWriteInt(offset2, 254, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 2);
        } else {
            rpcolLen2 = 5;
            byte[] buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 5, rpLen2);
            writer.reWriteInt(offset2, 251, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 4);
        }
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
        throw TbError.newSQLException(-590705);
    }

    public int[] writeNotFinalObject(TbStreamDataWriter writer, byte[] byteBuf, TbStructDescriptor desc) throws SQLException {
        boolean rpLen2 = false;
        int offset2 = writer.getBufferedDataSize();
        byteBuf[offset2] = (byte)(rpLen2 ? 1 : 0);
        int rpcolLen2 = 1;
        writer.moveOffset(rpcolLen2);
        writer.writeByte((byte)-124);
        writer.writeByte((byte)1);
        if (!desc.isFinal()) {
            writer.writeBytes(DataTypeConverter.RPCOL_UDT_NOT_FINAL);
        }
        int offset3 = writer.getBufferedDataSize();
        writer.writeByte((byte)0);
        return new int[]{offset2, offset3};
    }
}

