/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import java.sql.SQLException;

public class StringBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        int rpcolLen;
        int convertedLen;
        DataTypeConverter conv = conn.getTypeConverter();
        String bindParam = bpc.getParamString(rowIndex, paramIndex);
        int maxLength = bindParam.length() * conv.getMaxBytesPerChar();
        int offset = writer.getBufferedDataSize();
        writer.makeBufferAvailable(maxLength + 3);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        if (maxLength <= 250) {
            convertedLen = conv.fromString(byteBuf, offset + 1, bindParam);
            byteBuf[offset] = (byte)convertedLen;
            rpcolLen = 1;
        } else {
            convertedLen = conv.fromString(byteBuf, offset + 3, bindParam);
            if (convertedLen <= 250) {
                byteBuf[offset] = (byte)convertedLen;
                rpcolLen = 1;
                System.arraycopy(byteBuf, offset + 3, byteBuf, offset + 1, convertedLen);
            } else {
                byteBuf[offset] = -2;
                byteBuf[offset + 1] = (byte)(0xFF & convertedLen >> 8);
                byteBuf[offset + 2] = (byte)(0xFF & convertedLen);
                rpcolLen = 3;
            }
        }
        writer.moveOffset(convertedLen + rpcolLen);
        writer.writePadding(convertedLen + rpcolLen);
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        int rpcolLen;
        int convertedLen;
        DataTypeConverter conv = conn.getTypeConverter();
        String bindParam = bpc.getParamString(rowIndex, paramIndex);
        int maxLength = bindParam.length() * conv.getMaxBytesPerChar();
        int offset = writer.getBufferedDataSize();
        writer.makeBufferAvailable(maxLength + 3);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        if (maxLength <= 250) {
            convertedLen = conv.fromString(byteBuf, offset + 1, bindParam);
            byteBuf[offset] = (byte)convertedLen;
            rpcolLen = 1;
        } else {
            convertedLen = conv.fromString(byteBuf, offset + 3, bindParam);
            if (convertedLen <= 250) {
                byteBuf[offset] = (byte)convertedLen;
                rpcolLen = 1;
                System.arraycopy(byteBuf, offset + 3, byteBuf, offset + 1, convertedLen);
            } else {
                byteBuf[offset] = -2;
                byteBuf[offset + 1] = (byte)(0xFF & convertedLen >> 8);
                byteBuf[offset + 2] = (byte)(0xFF & convertedLen);
                rpcolLen = 3;
            }
        }
        writer.moveOffset(convertedLen + rpcolLen);
        if (pad) {
            writer.writePadding(convertedLen + rpcolLen);
        }
    }
}

