/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class StreamBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        writer.writeRpcolData(null, 0);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        writer.writeRpcolData(null, 0);
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
        boolean isNChar;
        boolean isChar;
        InputStream bindParam = bpc.getParamStream(rowIndex, paramIndex);
        int deferredParamType = bpc.getBindData().getBindItem(paramIndex).getSQLType();
        TbStream stream = conn.getTbComm().getStream();
        int writeByteCnt = 0;
        int headerOffset = writer.getBufferedDataSize();
        DataTypeConverter conv = conn.getTypeConverter();
        int charFragmentsLen = 0;
        byte[] charFragments = null;
        switch (deferredParamType) {
            case -1: 
            case 1: 
            case 12: {
                isChar = true;
                isNChar = false;
                charFragments = new byte[conv.getMaxBytesPerChar()];
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                isChar = false;
                isNChar = true;
                charFragments = new byte[conv.getMaxBytesPerNChar()];
                break;
            }
            default: {
                isNChar = false;
                isChar = false;
            }
        }
        try {
            while (length > 0L) {
                int readByteCnt;
                writer.setCurDataSize(headerOffset);
                writeByteCnt = length < 65532L ? (int)length : 65532;
                writer.makeBufferAvailable(writeByteCnt + 4);
                byte[] byteBuf = writer.getStreamBuf().getRawBytes();
                if (charFragmentsLen > 0) {
                    writeByteCnt -= charFragmentsLen;
                    System.arraycopy(charFragments, 0, byteBuf, headerOffset + 4, charFragmentsLen);
                }
                if ((readByteCnt = bindParam.read(byteBuf, headerOffset + 4 + charFragmentsLen, writeByteCnt)) == -1) {
                    if (charFragmentsLen <= 0) break;
                    readByteCnt = charFragmentsLen;
                    charFragmentsLen = 0;
                } else {
                    int lastByteOff = headerOffset + 4 + (readByteCnt += charFragmentsLen) - 1;
                    int lead = 0;
                    if (isChar && writer.reWriteInt(headerOffset, 0, 4) > 0 && !conv.isEndingByte(byteBuf, lastByteOff)) {
                        lead = conv.getLeadingBytePos(byteBuf, lastByteOff);
                        charFragmentsLen = lastByteOff - lead + 1;
                    } else if (isNChar && writer.reWriteInt(headerOffset, 0, 4) > 0 && !conv.isEndingByteNCharset(byteBuf, lastByteOff)) {
                        lead = conv.getLeadingBytePosNCharset(byteBuf, lastByteOff);
                        charFragmentsLen = lastByteOff - lead + 1;
                    } else {
                        charFragmentsLen = 0;
                    }
                    if (charFragmentsLen > 0) {
                        readByteCnt -= charFragmentsLen;
                        System.arraycopy(byteBuf, lead, charFragments, 0, charFragmentsLen);
                    }
                }
                writer.writeInt(readByteCnt, 4);
                writer.moveOffset(readByteCnt);
                writer.writePadding(readByteCnt);
                writer.reWriteInt(4, writer.getBufferedDataSize() - 16, 4);
                stream.flush();
                length -= (long)readByteCnt;
            }
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202);
        }
    }
}

