/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class NReaderBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        writer.writeRpcolData(null, 0);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        writer.writeRpcolData(null, 0);
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
        DataTypeConverter conv = conn.getTypeConverter();
        Reader bindParam = bpc.getParamReader(rowIndex, paramIndex);
        TbStream stream = conn.getTbComm().getStream();
        char[] charBuf = new char[conn.getMaxDFRNCharCount()];
        int headerOffset = writer.getBufferedDataSize();
        try {
            while (length > 0L) {
                writer.setCurDataSize(headerOffset);
                int readCharLen = length < (long)charBuf.length ? bindParam.read(charBuf, 0, (int)length) : bindParam.read(charBuf, 0, charBuf.length);
                if (readCharLen != -1) {
                    int maxLength = readCharLen * conv.getMaxBytesPerNChar();
                    writer.makeBufferAvailable(maxLength + 4);
                    byte[] byteBuf = writer.getStreamBuf().getRawBytes();
                    int convertedByteCnt = conv.nCharsToBytes(charBuf, 0, readCharLen, byteBuf, headerOffset + 4, maxLength);
                    writer.writeInt(convertedByteCnt, 4);
                    writer.moveOffset(convertedByteCnt);
                    writer.writePadding(convertedByteCnt);
                    writer.reWriteInt(4, writer.getBufferedDataSize() - 16, 4);
                    stream.flush();
                    length -= (long)readCharLen;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw TbError.newSQLException(-90202, e.getMessage());
        }
    }
}

