/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.binder;

import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class ArrayInBinder
extends Binder {
    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length) throws SQLException {
        byte[] buf;
        int RPCOL_UDT_COLL = -120;
        boolean RPCOL_UDT_ROOT = true;
        int COLLECTION_META_LENGTH = 40;
        DataTypeConverter conv = conn.getTypeConverter();
        BindItem item = bpc.getBindData().getBindItem(paramIndex);
        TbArrayDescriptor desc = (TbArrayDescriptor)item.getTypeDescriptor();
        String oid = desc.getOID();
        int tbojID = desc.getTobjID();
        int versionNo = desc.getVersionNo();
        int offset1 = writer.getBufferedDataSize();
        writer.makeBufferAvailable(43);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        byteBuf[offset1] = 40;
        int rpcolLen = 1;
        int convertedLen = conv.fromString(byteBuf, offset1 + rpcolLen, oid);
        writer.moveOffset(convertedLen + rpcolLen);
        writer.writeInt(tbojID, 4);
        writer.writeInt(versionNo, 4);
        int rpLen2 = 0;
        int offset2 = writer.getBufferedDataSize();
        byteBuf[offset2] = (byte)rpLen2;
        int rpcolLen2 = 1;
        writer.moveOffset(rpcolLen2);
        writer.writeByte((byte)-120);
        writer.writeByte((byte)1);
        int offset3 = writer.getBufferedDataSize();
        writer.writeByte((byte)0);
        for (int i = 0; i < 3; ++i) {
            writer.writeByte((byte)0);
        }
        TbArray bindParam = null;
        bindParam = (TbArray)bpc.getParamArray(rowIndex, paramIndex);
        int arrayElemCnt = bindParam.length();
        int elemCntOffset = writer.getBufferedDataSize();
        int elemCntRpLen = 0;
        if (arrayElemCnt <= 250) {
            TbCommon.int2Bytes(arrayElemCnt, byteBuf, elemCntOffset, 1);
            elemCntRpLen = 1;
        } else if (arrayElemCnt <= 254) {
            byteBuf[elemCntOffset] = -2;
            TbCommon.int2Bytes(arrayElemCnt, byteBuf, elemCntOffset + 1, 2);
            elemCntRpLen = 3;
        } else {
            byteBuf[elemCntOffset] = -5;
            TbCommon.int2Bytes(arrayElemCnt, byteBuf, elemCntOffset + 1, 4);
            elemCntRpLen = 5;
        }
        writer.moveOffset(elemCntRpLen);
        TbArray.Params paramContainer = bindParam.getSubParams();
        BindData bindData = paramContainer.getBindData();
        for (int i = 0; i < arrayElemCnt; ++i) {
            Binder binder = paramContainer.getBinder(-1, i);
            binder.bind(conn, paramContainer, writer, -1, i, bindData.getBindItem(i).getLength(), false);
        }
        int rpLen3 = writer.getBufferedDataSize() - offset1 - 40 - rpcolLen - rpcolLen2;
        if (rpLen3 <= 250) {
            writer.reWriteInt(offset3, rpLen3, 1);
        } else if (rpLen3 <= 65535) {
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 3, rpLen3);
            writer.moveOffset(2);
            writer.reWriteInt(offset3, 254, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 2);
        } else {
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 5, rpLen3);
            writer.moveOffset(4);
            writer.reWriteInt(offset3, 251, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 4);
        }
        rpLen2 = writer.getBufferedDataSize() - offset1 - rpcolLen - rpcolLen2;
        if (rpLen2 <= 250) {
            rpcolLen2 = 1;
            writer.reWriteInt(offset2, rpLen2, 1);
        } else if (rpLen2 <= 65535) {
            rpcolLen2 = 3;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 3, rpLen2);
            writer.moveOffset(2);
            writer.reWriteInt(offset2, 254, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 2);
        } else {
            rpcolLen2 = 5;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 5, rpLen2);
            writer.moveOffset(4);
            writer.reWriteInt(offset2, 251, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 4);
        }
        int rpLen1 = writer.getBufferedDataSize() - offset1 - rpcolLen - rpcolLen2;
        if (rpLen1 <= 250) {
            rpcolLen = 1;
            writer.reWriteInt(offset1, rpLen1, 1);
        } else if (rpLen1 <= 65535) {
            rpcolLen = 3;
            byte[] buf2 = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf2, offset1 + 1, buf2, offset1 + 3, rpLen1);
            writer.moveOffset(2);
            writer.reWriteInt(offset1, 254, 1);
            writer.reWriteInt(offset1 + 1, rpLen1, 2);
        } else {
            rpcolLen = 5;
            byte[] buf3 = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf3, offset1 + 1, buf3, offset1 + 5, rpLen1);
            writer.moveOffset(4);
            writer.reWriteInt(offset1, 251, 1);
            writer.reWriteInt(offset1 + 1, rpLen1, 4);
        }
        writer.writePadding(rpLen1 + rpcolLen + rpcolLen2);
    }

    @Override
    public void bind(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, int length, boolean pad) throws SQLException {
        byte[] buf;
        int RPCOL_UDT_COLL = -120;
        boolean RPCOL_UDT_ROOT = true;
        int COLLECTION_META_LENGTH = 40;
        int dataLen = 40;
        writer.makeBufferAvailable(dataLen + 3);
        byte[] byteBuf = writer.getStreamBuf().getRawBytes();
        int rpLen2 = 0;
        int offset2 = writer.getBufferedDataSize();
        byteBuf[offset2] = (byte)rpLen2;
        int rpcolLen2 = 1;
        writer.moveOffset(rpcolLen2);
        writer.writeByte((byte)-120);
        writer.writeByte((byte)1);
        int offset3 = writer.getBufferedDataSize();
        writer.writeByte((byte)0);
        for (int i = 0; i < 3; ++i) {
            writer.writeByte((byte)0);
        }
        TbArray bindParam = null;
        bindParam = (TbArray)bpc.getParamArray(rowIndex, paramIndex);
        int arrayElemCnt = bindParam.length();
        int elemCntOffset = writer.getBufferedDataSize();
        int elemCntRpLen = 0;
        if (arrayElemCnt <= 250) {
            TbCommon.int2Bytes(arrayElemCnt, byteBuf, elemCntOffset, 1);
            elemCntRpLen = 1;
        } else if (arrayElemCnt <= 254) {
            byteBuf[elemCntOffset] = -2;
            TbCommon.int2Bytes(arrayElemCnt, byteBuf, elemCntOffset + 1, 2);
            elemCntRpLen = 3;
        } else {
            byteBuf[elemCntOffset] = -5;
            TbCommon.int2Bytes(arrayElemCnt, byteBuf, elemCntOffset + 1, 4);
            elemCntRpLen = 5;
        }
        writer.moveOffset(elemCntRpLen);
        TbArray.Params paramContainer = bindParam.getSubParams();
        BindData bindData = paramContainer.getBindData();
        for (int i = 0; i < arrayElemCnt; ++i) {
            Binder binder = paramContainer.getBinder(-1, i);
            binder.bind(conn, paramContainer, writer, -1, i, bindData.getBindItem(i).getLength(), false);
        }
        int rpLen3 = writer.getBufferedDataSize() - offset2 - 40 - rpcolLen2;
        if (rpLen3 <= 250) {
            writer.reWriteInt(offset3, rpLen3, 1);
        } else if (rpLen3 <= 65535) {
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 3, rpLen3);
            writer.moveOffset(2);
            writer.reWriteInt(offset3, 254, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 2);
        } else {
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset3 + 1, buf, offset3 + 5, rpLen3);
            writer.moveOffset(4);
            writer.reWriteInt(offset3, 251, 1);
            writer.reWriteInt(offset3 + 1, rpLen3, 4);
        }
        rpLen2 = writer.getBufferedDataSize() - offset2 - rpcolLen2;
        if (rpLen2 <= 250) {
            rpcolLen2 = 1;
            writer.reWriteInt(offset2, rpLen2, 1);
        } else if (rpLen2 <= 65535) {
            rpcolLen2 = 3;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 3, rpLen2);
            writer.moveOffset(2);
            writer.reWriteInt(offset2, 254, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 2);
        } else {
            rpcolLen2 = 5;
            buf = writer.getStreamBuf().getRawBytes();
            System.arraycopy(buf, offset2 + 1, buf, offset2 + 5, rpLen2);
            writer.moveOffset(4);
            writer.reWriteInt(offset2, 251, 1);
            writer.reWriteInt(offset2 + 1, rpLen2, 4);
        }
    }

    @Override
    public void bindDFR(TbConnection conn, ParamContainer bpc, TbStreamDataWriter writer, int rowIndex, int paramIndex, long length) throws SQLException {
        throw TbError.newSQLException(-590705);
    }
}

