/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TbNumber {
    private static final int NUMBER_MAX_PREC = 38;
    private static final int EXP_BIAS_POS = 65;
    private static final int EXP_BIAS_NEG = 62;
    private static final int NUMBER_MAX_EXP = 62;
    private static final int NUMBER_MIN_EXP = -65;
    private static final int NUMBER_TOP = -16;
    private static final int NUMBER_BOT = 16;
    private static final int NUMBER_BASE = 100;
    private static final int NUMBER_MAX_LEN = 21;
    private static final int NUMBER_MASK_SIGN = 128;
    private static final int NUMBER_MASK_EXP = 127;
    private static final byte[] MAX_INTEGER = new byte[]{6, -59, -107, -81, -80, -92, -81};
    private static final byte[] MIN_INTEGER = new byte[]{7, 58, 107, 81, 80, 92, 80, -16};
    private static final byte[] MAX_LONG = new byte[]{11, -54, -119, -106, -95, -56, -125, -60, -74, -51, -70, -121};
    private static final byte[] MIN_LONG = new byte[]{12, 53, 119, 106, 95, 56, 125, 60, 74, 51, 70, 120, -16};
    private static char[][] coefToChar = new char[][]{{'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'0', '0'}, {'9', '9'}, {'9', '8'}, {'9', '7'}, {'9', '6'}, {'9', '5'}, {'9', '4'}, {'9', '3'}, {'9', '2'}, {'9', '1'}, {'9', '0'}, {'8', '9'}, {'8', '8'}, {'8', '7'}, {'8', '6'}, {'8', '5'}, {'8', '4'}, {'8', '3'}, {'8', '2'}, {'8', '1'}, {'8', '0'}, {'7', '9'}, {'7', '8'}, {'7', '7'}, {'7', '6'}, {'7', '5'}, {'7', '4'}, {'7', '3'}, {'7', '2'}, {'7', '1'}, {'7', '0'}, {'6', '9'}, {'6', '8'}, {'6', '7'}, {'6', '6'}, {'6', '5'}, {'6', '4'}, {'6', '3'}, {'6', '2'}, {'6', '1'}, {'6', '0'}, {'5', '9'}, {'5', '8'}, {'5', '7'}, {'5', '6'}, {'5', '5'}, {'5', '4'}, {'5', '3'}, {'5', '2'}, {'5', '1'}, {'5', '0'}, {'4', '9'}, {'4', '8'}, {'4', '7'}, {'4', '6'}, {'4', '5'}, {'4', '4'}, {'4', '3'}, {'4', '2'}, {'4', '1'}, {'4', '0'}, {'3', '9'}, {'3', '8'}, {'3', '7'}, {'3', '6'}, {'3', '5'}, {'3', '4'}, {'3', '3'}, {'3', '2'}, {'3', '1'}, {'3', '0'}, {'2', '9'}, {'2', '8'}, {'2', '7'}, {'2', '6'}, {'2', '5'}, {'2', '4'}, {'2', '3'}, {'2', '2'}, {'2', '1'}, {'2', '0'}, {'1', '9'}, {'1', '8'}, {'1', '7'}, {'1', '6'}, {'1', '5'}, {'1', '4'}, {'1', '3'}, {'1', '2'}, {'1', '1'}, {'1', '0'}, {'0', '9'}, {'0', '8'}, {'0', '7'}, {'0', '6'}, {'0', '5'}, {'0', '4'}, {'0', '3'}, {'0', '2'}, {'0', '1'}, {'0', '0'}, {'0', '1'}, {'0', '2'}, {'0', '3'}, {'0', '4'}, {'0', '5'}, {'0', '6'}, {'0', '7'}, {'0', '8'}, {'0', '9'}, {'1', '0'}, {'1', '1'}, {'1', '2'}, {'1', '3'}, {'1', '4'}, {'1', '5'}, {'1', '6'}, {'1', '7'}, {'1', '8'}, {'1', '9'}, {'2', '0'}, {'2', '1'}, {'2', '2'}, {'2', '3'}, {'2', '4'}, {'2', '5'}, {'2', '6'}, {'2', '7'}, {'2', '8'}, {'2', '9'}, {'3', '0'}, {'3', '1'}, {'3', '2'}, {'3', '3'}, {'3', '4'}, {'3', '5'}, {'3', '6'}, {'3', '7'}, {'3', '8'}, {'3', '9'}, {'4', '0'}, {'4', '1'}, {'4', '2'}, {'4', '3'}, {'4', '4'}, {'4', '5'}, {'4', '6'}, {'4', '7'}, {'4', '8'}, {'4', '9'}, {'5', '0'}, {'5', '1'}, {'5', '2'}, {'5', '3'}, {'5', '4'}, {'5', '5'}, {'5', '6'}, {'5', '7'}, {'5', '8'}, {'5', '9'}, {'6', '0'}, {'6', '1'}, {'6', '2'}, {'6', '3'}, {'6', '4'}, {'6', '5'}, {'6', '6'}, {'6', '7'}, {'6', '8'}, {'6', '9'}, {'7', '0'}, {'7', '1'}, {'7', '2'}, {'7', '3'}, {'7', '4'}, {'7', '5'}, {'7', '6'}, {'7', '7'}, {'7', '8'}, {'7', '9'}, {'8', '0'}, {'8', '1'}, {'8', '2'}, {'8', '3'}, {'8', '4'}, {'8', '5'}, {'8', '6'}, {'8', '7'}, {'8', '8'}, {'8', '9'}, {'9', '0'}, {'9', '1'}, {'9', '2'}, {'9', '3'}, {'9', '4'}, {'9', '5'}, {'9', '6'}, {'9', '7'}, {'9', '8'}, {'9', '9'}};

    private static int convertCoef(byte[] bytes, int byteOff, char[] buf, int bufOff, int posDecpoint) {
        int i;
        int convLen = 0;
        int coef = bytes[byteOff + 2];
        if (coef < 0) {
            coef += 256;
        }
        char[] coefp = coefToChar[coef];
        buf[bufOff + convLen] = coefp[0];
        if (coefp[0] != '0') {
            // empty if block
        }
        int n = ++convLen;
        ++convLen;
        buf[bufOff + n] = coefp[1];
        int siglen = TbNumber.getSiglen(bytes, byteOff);
        for (i = 1; i < siglen; ++i) {
            coef = bytes[byteOff + 2 + i];
            if (coef < 0) {
                coef += 256;
            }
            coefp = coefToChar[coef];
            buf[bufOff + convLen++] = coefp[0];
            buf[bufOff + convLen++] = coefp[1];
        }
        if (buf[bufOff + convLen - 1] == '0') {
            --convLen;
        }
        if (posDecpoint > 0 && posDecpoint < convLen) {
            for (i = bufOff + convLen; i >= posDecpoint + bufOff; --i) {
                buf[i + 1] = buf[i];
            }
            buf[bufOff + posDecpoint] = 46;
            ++convLen;
        }
        return convLen;
    }

    private static int convertExp(int exp10, int offset, char[] buf) {
        int i;
        boolean leadingZero = false;
        int n = exp10 = exp10 < 0 ? -exp10 : exp10;
        if (exp10 >= 0 && exp10 < 10) {
            buf[offset++] = 48;
            leadingZero = true;
        }
        String exp = Integer.toString(exp10);
        for (i = 0; i < exp.length(); ++i) {
            buf[offset + i] = exp.charAt(i);
        }
        return i + (leadingZero ? 1 : 0);
    }

    private static byte digitEncode(boolean isPositive, int x) {
        return isPositive ? (byte)(128 + x) : (byte)(128 - x);
    }

    public static int fromInteger(byte[] buf, int offset, int v) {
        int lastNonZeroPos = 0;
        int[] coef = new int[21];
        boolean isPositive = v >= 0;
        int size = 0;
        while (v != 0) {
            int c = v / 100;
            coef[size] = v - 100 * c;
            v = c;
            ++size;
        }
        if (size == 0) {
            return TbNumber.toZero(buf, offset);
        }
        if (isPositive) {
            for (int i = 0; i < size; ++i) {
                buf[offset + 2 + i] = (byte)(128 + coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            buf[offset + 1] = (byte)(0x80 | (byte)(65 + (size - 1)));
            size = lastNonZeroPos + 1;
        } else {
            for (int i = 0; i < size; ++i) {
                buf[offset + 2 + i] = (byte)(128 - -coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            buf[offset + 1] = (byte)(62 - (size - 1));
            size = lastNonZeroPos + 1;
            buf[offset + 2 + size] = -16;
            ++size;
        }
        buf[offset] = (byte)(size + 1);
        return size + 2;
    }

    public static byte[] fromInteger(int v) throws SQLException {
        int lastNonZeroPos = 0;
        int[] coef = new int[21];
        boolean isPositive = v >= 0;
        int size = 0;
        while (v != 0) {
            int c = v / 100;
            coef[size] = v - 100 * c;
            v = c;
            ++size;
        }
        if (size == 0) {
            return TbNumber.toZero();
        }
        byte[] bytes = new byte[23];
        if (isPositive) {
            for (int i = 0; i < size; ++i) {
                bytes[2 + i] = (byte)(128 + coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            bytes[1] = (byte)(0x80 | (byte)(65 + (size - 1)));
            size = lastNonZeroPos + 1;
        } else {
            for (int i = 0; i < size; ++i) {
                bytes[2 + i] = (byte)(128 - -coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            bytes[1] = (byte)(62 - (size - 1));
            size = lastNonZeroPos + 1;
            bytes[2 + size] = -16;
            ++size;
        }
        bytes[0] = (byte)(size + 1);
        return bytes;
    }

    public static int fromLong(byte[] buf, int offset, long v) throws SQLException {
        int lastNonZeroPos = 0;
        int[] coef = new int[21];
        boolean isPositive = v >= 0L;
        int size = 0;
        while (v != 0L) {
            long c = v / 100L;
            coef[size] = (int)(v - 100L * c);
            v = c;
            ++size;
        }
        if (size == 0) {
            return TbNumber.toZero(buf, offset);
        }
        if (isPositive) {
            for (int i = 0; i < size; ++i) {
                buf[offset + 2 + i] = (byte)(128 + coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            buf[offset + 1] = (byte)(0x80 | 65 + (size - 1));
            size = lastNonZeroPos + 1;
        } else {
            for (int i = 0; i < size; ++i) {
                buf[offset + 2 + i] = (byte)(128 - -coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            buf[offset + 1] = (byte)(62 - (size - 1));
            size = lastNonZeroPos + 1;
            buf[offset + 2 + size] = -16;
            ++size;
        }
        buf[offset] = (byte)(size + 1);
        return size + 2;
    }

    public static byte[] fromLong(long v) throws SQLException {
        int lastNonZeroPos = 0;
        int[] coef = new int[21];
        boolean isPositive = v >= 0L;
        int size = 0;
        while (v != 0L) {
            long c = v / 100L;
            coef[size] = (int)(v - 100L * c);
            v = c;
            ++size;
        }
        if (size == 0) {
            return TbNumber.toZero();
        }
        byte[] bytes = new byte[23];
        if (isPositive) {
            for (int i = 0; i < size; ++i) {
                bytes[2 + i] = (byte)(128 + coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            bytes[1] = (byte)(0x80 | 65 + (size - 1));
            size = lastNonZeroPos + 1;
        } else {
            for (int i = 0; i < size; ++i) {
                bytes[2 + i] = (byte)(128 - -coef[size - i - 1]);
                if (coef[size - i - 1] == 0) continue;
                lastNonZeroPos = i;
            }
            bytes[1] = (byte)(62 - (size - 1));
            size = lastNonZeroPos + 1;
            bytes[2 + size] = -16;
            ++size;
        }
        bytes[0] = (byte)(size + 1);
        return bytes;
    }

    public static int fromString(byte[] buf, int offset, String str) throws SQLException {
        byte[] temp_coef = new byte[39];
        StringReader sr = new StringReader(str);
        try {
            int orderOfCoef;
            int coefIdx = 0;
            int posLastNonzero = -1;
            int numZeroesFollowingPoint = 0;
            char scan = (char)sr.read();
            boolean isPositive = true;
            if (scan == '-') {
                isPositive = false;
                scan = (char)sr.read();
            } else if (scan == '+') {
                scan = (char)sr.read();
            }
            while (scan == '0') {
                scan = (char)sr.read();
            }
            while (Character.isDigit(scan)) {
                if (coefIdx < 38) {
                    temp_coef[coefIdx] = (byte)Character.getNumericValue(scan);
                    if (scan != '0') {
                        posLastNonzero = coefIdx;
                    }
                }
                ++coefIdx;
                scan = (char)sr.read();
            }
            int pos1stNonzeroBeforePoint = coefIdx;
            if (scan == '.') {
                scan = (char)sr.read();
                if (posLastNonzero < 0) {
                    while (scan == '0') {
                        ++numZeroesFollowingPoint;
                        scan = (char)sr.read();
                    }
                }
                while (Character.isDigit(scan)) {
                    if (coefIdx < 38) {
                        temp_coef[coefIdx] = (byte)Character.getNumericValue(scan);
                        if (scan != '0') {
                            posLastNonzero = coefIdx;
                        }
                    }
                    ++coefIdx;
                    scan = (char)sr.read();
                }
            }
            int exp10 = 0;
            boolean expIsNegative = false;
            if (scan == 'e' | scan == 'E') {
                scan = (char)sr.read();
                if (scan == '-') {
                    expIsNegative = true;
                    scan = (char)sr.read();
                } else if (scan == '+') {
                    scan = (char)sr.read();
                }
                exp10 = 0;
                while (Character.isDigit(scan)) {
                    exp10 = exp10 * 10 + Character.getNumericValue(scan);
                    scan = (char)sr.read();
                }
            }
            if (posLastNonzero < 0) {
                return TbNumber.toZero(buf, offset);
            }
            int n = orderOfCoef = pos1stNonzeroBeforePoint > 0 ? pos1stNonzeroBeforePoint - 1 : -(numZeroesFollowingPoint + 1);
            if (expIsNegative) {
                exp10 = -exp10;
            }
            boolean initialZeroInCoef = ((exp10 += orderOfCoef) & 1) == 0;
            int exp = exp10 >> 1;
            if (exp > 62) {
                throw TbError.newSQLException(-90653, str);
            }
            if (exp < -65) {
                throw TbError.newSQLException(-90654, str);
            }
            int totalLen = 1 + (isPositive ? 0 : 1) + (posLastNonzero + 1 + 1 + (initialZeroInCoef ? 1 : 0)) / 2;
            buf[offset] = (byte)totalLen;
            buf[offset + 1] = isPositive ? (byte)(0x80 | 65 + exp) : (byte)(62 - exp);
            boolean isLower = initialZeroInCoef;
            int sum = 0;
            int t = 2;
            for (int i = 0; i <= posLastNonzero; ++i) {
                if (isLower) {
                    buf[offset + t++] = TbNumber.digitEncode(isPositive, sum + temp_coef[i]);
                } else {
                    sum = temp_coef[i] * 10;
                }
                isLower = !isLower;
            }
            if (isLower) {
                buf[offset + t++] = TbNumber.digitEncode(isPositive, sum);
            }
            if (!isPositive) {
                buf[offset + t++] = -16;
            }
            return totalLen + 1;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static byte[] fromString(String str) throws SQLException {
        byte[] temp_coef = new byte[39];
        StringReader sr = new StringReader(str);
        try {
            int orderOfCoef;
            int coefIdx = 0;
            int posLastNonzero = -1;
            int numZeroesFollowingPoint = 0;
            char scan = (char)sr.read();
            boolean isPositive = true;
            if (scan == '-') {
                isPositive = false;
                scan = (char)sr.read();
            } else if (scan == '+') {
                scan = (char)sr.read();
            }
            while (scan == '0') {
                scan = (char)sr.read();
            }
            while (Character.isDigit(scan)) {
                if (coefIdx < 38) {
                    temp_coef[coefIdx] = (byte)Character.getNumericValue(scan);
                    if (scan != '0') {
                        posLastNonzero = coefIdx;
                    }
                }
                ++coefIdx;
                scan = (char)sr.read();
            }
            int pos1stNonzeroBeforePoint = coefIdx;
            if (scan == '.') {
                scan = (char)sr.read();
                if (posLastNonzero < 0) {
                    while (scan == '0') {
                        ++numZeroesFollowingPoint;
                        scan = (char)sr.read();
                    }
                }
                while (Character.isDigit(scan)) {
                    if (coefIdx < 38) {
                        temp_coef[coefIdx] = (byte)Character.getNumericValue(scan);
                        if (scan != '0') {
                            posLastNonzero = coefIdx;
                        }
                    }
                    ++coefIdx;
                    scan = (char)sr.read();
                }
            }
            int exp10 = 0;
            boolean expIsNegative = false;
            if (scan == 'e' | scan == 'E') {
                scan = (char)sr.read();
                if (scan == '-') {
                    expIsNegative = true;
                    scan = (char)sr.read();
                } else if (scan == '+') {
                    scan = (char)sr.read();
                }
                exp10 = 0;
                while (Character.isDigit(scan)) {
                    exp10 = exp10 * 10 + Character.getNumericValue(scan);
                    scan = (char)sr.read();
                }
            }
            if (posLastNonzero < 0) {
                return TbNumber.toZero();
            }
            int n = orderOfCoef = pos1stNonzeroBeforePoint > 0 ? pos1stNonzeroBeforePoint - 1 : -(numZeroesFollowingPoint + 1);
            if (expIsNegative) {
                exp10 = -exp10;
            }
            boolean initialZeroInCoef = ((exp10 += orderOfCoef) & 1) == 0;
            int exp = exp10 >> 1;
            if (exp > 62) {
                throw TbError.newSQLException(-90653, str);
            }
            if (exp < -65) {
                throw TbError.newSQLException(-90654, str);
            }
            int totalLen = 1 + (isPositive ? 0 : 1) + (posLastNonzero + 1 + 1 + (initialZeroInCoef ? 1 : 0)) / 2;
            byte[] bytes = new byte[totalLen + 1];
            bytes[0] = (byte)totalLen;
            bytes[1] = isPositive ? (byte)(0x80 | 65 + exp) : (byte)(62 - exp);
            boolean isLower = initialZeroInCoef;
            int sum = 0;
            int t = 2;
            for (int i = 0; i <= posLastNonzero; ++i) {
                if (isLower) {
                    bytes[t++] = TbNumber.digitEncode(isPositive, sum + temp_coef[i]);
                } else {
                    sum = temp_coef[i] * 10;
                }
                isLower = !isLower;
            }
            if (isLower) {
                bytes[t++] = TbNumber.digitEncode(isPositive, sum);
            }
            if (!isPositive) {
                bytes[t++] = -16;
            }
            return bytes;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static int getDecoNeg(byte coef) {
        int deco = 128 - coef;
        return deco < 0 ? deco + 256 : deco;
    }

    private static int getDecoPos(byte coef) {
        int deco = coef - 128;
        return deco < 0 ? deco + 256 : deco;
    }

    private static int getExpNeg(byte x) {
        int signexp = x < 0 ? x + 256 : x;
        return 62 - (signexp & 0x7F);
    }

    private static int getExpPos(byte x) {
        int signexp = x < 0 ? x + 256 : x;
        return (signexp & 0x7F) - 65;
    }

    public static String getNormalForm(byte[] x, int offset, int length) {
        int i;
        int posDecpoint;
        int siglen10;
        int exp10;
        char[] buf = null;
        if (x[offset] == 1) {
            return "0";
        }
        boolean isPositive = TbNumber.isPositive(x[offset + 1]);
        if (isPositive) {
            exp10 = (TbNumber.getExpPos(x[offset + 1]) << 1) + (TbNumber.getDecoPos(x[offset + 2]) >= 10 ? 1 : 0);
            siglen10 = (TbNumber.getSiglen(x, offset) << 1) - (TbNumber.getDecoPos(x[offset + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledPos(x, offset);
        } else {
            exp10 = (TbNumber.getExpNeg(x[offset + 1]) << 1) + (TbNumber.getDecoNeg(x[offset + 2]) >= 10 ? 1 : 0);
            siglen10 = (TbNumber.getSiglen(x, offset) << 1) - (TbNumber.getDecoNeg(x[offset + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledNeg(x, offset);
        }
        int bufMax = exp10 >= 0 ? (isPositive ? 0 : 1) + (siglen10 <= exp10 + 1 ? exp10 + 1 + 0 + 0 : exp10 + 1 + 1 + (siglen10 - (exp10 + 1))) + 1 : (isPositive ? 0 : 1) + 1 + (-exp10 - 1) + siglen10 + 1;
        buf = new char[bufMax];
        int bufOff = 0;
        if (!isPositive) {
            buf[bufOff++] = 45;
        }
        if ((posDecpoint = exp10 + 1) <= 0) {
            buf[bufOff++] = 46;
            for (i = 0; i < -posDecpoint; ++i) {
                buf[bufOff++] = 48;
            }
        }
        int numWritten = TbNumber.convertCoef(x, offset, buf, bufOff, posDecpoint);
        bufOff += numWritten;
        for (i = 0; i < posDecpoint - numWritten; ++i) {
            buf[bufOff++] = 48;
        }
        return new String(buf, 0, bufOff);
    }

    public static String getRoughSciForm(byte[] x, int offset, int length) {
        int siglen10;
        int exp10;
        if (x[offset] == 1) {
            return "0E+00";
        }
        boolean isPositive = TbNumber.isPositive(x[offset + 1]);
        if (isPositive) {
            exp10 = (TbNumber.getExpPos(x[offset + 1]) << 1) + (TbNumber.getDecoPos(x[offset + 2]) >= 10 ? 1 : 0);
            siglen10 = (TbNumber.getSiglen(x, offset) << 1) - (TbNumber.getDecoPos(x[offset + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledPos(x, offset);
        } else {
            exp10 = (TbNumber.getExpNeg(x[offset + 1]) << 1) + (TbNumber.getDecoNeg(x[offset + 2]) >= 10 ? 1 : 0);
            siglen10 = (TbNumber.getSiglen(x, offset) << 1) - (TbNumber.getDecoNeg(x[offset + 2]) < 10 ? 1 : 0) - TbNumber.lastHalfFilledNeg(x, offset);
        }
        int explen10 = exp10 >= 100 || exp10 <= -100 ? 3 : 2;
        int bufMax = (isPositive ? 0 : 1) + siglen10 + (siglen10 > 1 ? 1 : 0) + 1 + 1 + explen10 + 1;
        char[] buf = new char[bufMax];
        int bufOff = 0;
        if (!isPositive) {
            buf[bufOff++] = 45;
        }
        bufOff += TbNumber.convertCoef(x, offset, buf, bufOff, 1);
        buf[bufOff++] = 69;
        buf[bufOff++] = exp10 >= 0 ? 43 : 45;
        bufOff += TbNumber.convertExp(exp10, bufOff, buf);
        return new String(buf, 0, bufOff);
    }

    public static int getSiglen(byte[] bytes, int offset) {
        int signexp = bytes[offset + 1];
        if (signexp < 0) {
            signexp += 256;
        }
        return bytes[offset] - 1 - ((~signexp & 0x80) >> 7);
    }

    public static boolean isOrdinary(byte[] x, int offset) {
        return x[offset] == 1 || x[offset + 2] != -16 && x[offset + 2] != 16;
    }

    private static boolean isPositive(byte signexp) {
        if (signexp < 0) {
            signexp = (byte)(signexp + 256);
        }
        return (signexp & 0x80) != 0;
    }

    public static boolean isValid(byte[] x, int offset) {
        byte nsize = x[offset];
        int nsignexp = x[offset + 1];
        if (nsize > 23) {
            return false;
        }
        if (nsignexp < 0) {
            nsignexp += 256;
        }
        switch (nsize) {
            case 0: {
                break;
            }
            case 1: {
                if (nsignexp != 128) break;
                return true;
            }
            case 2: {
                if (x[offset + 2] == 240 && (nsignexp == 255 || nsignexp == 127)) {
                    return true;
                }
                if (x[offset + 2] == 16 && (nsignexp == 128 || nsignexp == 0)) {
                    return true;
                }
            }
            default: {
                if (nsignexp >= 128 && nsignexp <= 255) {
                    int esize = nsize - 2;
                    for (int i = 0; i <= esize; ++i) {
                        int coef = x[offset + 2 + i];
                        if (coef < 0) {
                            coef += 256;
                        }
                        if (coef >= 128 && coef <= 227) continue;
                        return false;
                    }
                    return true;
                }
                if (nsignexp < 0 || nsignexp > 127) break;
                int esize = nsize - 2;
                for (int i = 0; i < esize; ++i) {
                    int coef = x[offset + 2 + i];
                    if (coef < 0) {
                        coef += 256;
                    }
                    if (coef >= 29 && coef <= 128) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static int lastHalfFilledNeg(byte[] x, int offset) {
        int coef = 128 - x[offset + 2 + TbNumber.getSiglen(x, offset) - 1];
        if (coef < 0) {
            coef += 256;
        }
        return coef % 10 == 0 ? 1 : 0;
    }

    private static int lastHalfFilledPos(byte[] x, int offset) {
        int coef = x[offset + 2 + TbNumber.getSiglen(x, offset) - 1] - 128;
        if (coef < 0) {
            coef += 256;
        }
        return coef % 10 == 0 ? 1 : 0;
    }

    private static boolean lessThanOrEqualTo(byte[] x, int xOff, byte[] y, int yOff) {
        int minsize = x[xOff] <= y[yOff] ? x[xOff] : y[yOff];
        for (int i = 1; i <= minsize; ++i) {
            if ((byte)(128 + x[xOff + i]) < (byte)(128 + y[yOff + i])) {
                return true;
            }
            if ((byte)(128 + x[xOff + i]) <= (byte)(128 + y[yOff + i])) continue;
            return false;
        }
        return x[xOff] <= y[yOff];
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) throws SQLException {
        if (!TbNumber.isOrdinary(bytes, offset)) {
            throw TbError.newSQLException(-590705);
        }
        String normalForm = TbNumber.getNormalForm(bytes, offset, length);
        return new BigDecimal(normalForm);
    }

    public static double toDouble(byte[] bytes, int offset, int length) throws SQLException {
        String sciForm = TbNumber.getRoughSciForm(bytes, offset, length);
        return Double.valueOf(sciForm);
    }

    public static double toBinaryDouble(byte[] bytes, int offset, int length) throws SQLException {
        double d;
        if (TbCommon.isPositiveInfinityDoubleBytes(bytes, offset, length)) {
            return Double.POSITIVE_INFINITY;
        }
        if (TbCommon.isNegativeInfinityDoubleBytes(bytes, offset, length)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (TbCommon.isMaxValueDoubleBytes(bytes, offset, length)) {
            return Double.MAX_VALUE;
        }
        if (TbCommon.isMinValueDoubleBytes(bytes, offset, length)) {
            return Double.MIN_VALUE;
        }
        if (TbCommon.isNanDoubleBytes(bytes, offset, length)) {
            return Double.NaN;
        }
        if (TbCommon.isNegativeZeroDoubleBytes(bytes, offset, length)) {
            return 0.0;
        }
        long longBits = TbCommon.bytes2Long(bytes, offset, length);
        if (longBits < 0L) {
            d = Double.longBitsToDouble(longBits);
            d *= -1.0;
        } else {
            d = longBits > 0L ? Double.longBitsToDouble(longBits ^= 0xFFFFFFFFFFFFFFFFL) : Double.longBitsToDouble(longBits);
        }
        return d;
    }

    public static float toBinaryFloat(byte[] bytes, int offset, int length) {
        float f;
        if (TbCommon.isPositiveInfinityFloatBytes(bytes, offset, length)) {
            return Float.POSITIVE_INFINITY;
        }
        if (TbCommon.isNegativeInfinityFloatBytes(bytes, offset, length)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (TbCommon.isMaxValueFloatBytes(bytes, offset, length)) {
            return Float.MAX_VALUE;
        }
        if (TbCommon.isMinValueFloatBytes(bytes, offset, length)) {
            return Float.MIN_VALUE;
        }
        if (TbCommon.isNanFloatBytes(bytes, offset, length)) {
            return Float.NaN;
        }
        if (TbCommon.isNegativeZeroFloatBytes(bytes, offset, length)) {
            return 0.0f;
        }
        int intBits = TbCommon.bytes2Int(bytes, offset, length);
        if (intBits < 0) {
            f = Float.intBitsToFloat(intBits);
            f *= -1.0f;
        } else {
            f = intBits > 0 ? Float.intBitsToFloat(intBits ^= 0xFFFFFFFF) : Float.intBitsToFloat(intBits);
        }
        return f;
    }

    public static int toInteger(byte[] x, int offset, int length) throws SQLException {
        int i;
        int len;
        int exp;
        int tv = 0;
        if (x[offset] == 1) {
            return 0;
        }
        if (!TbNumber.isOrdinary(x, offset)) {
            throw TbError.newSQLException(-590705);
        }
        if (!TbNumber.lessThanOrEqualTo(MIN_INTEGER, 0, x, offset)) {
            throw TbError.newSQLException(-90654);
        }
        if (!TbNumber.lessThanOrEqualTo(x, offset, MAX_INTEGER, 0)) {
            throw TbError.newSQLException(-90653);
        }
        boolean isPositive = TbNumber.isPositive(x[offset + 1]);
        if (isPositive) {
            exp = TbNumber.getExpPos(x[offset + 1]);
            len = TbNumber.getSiglen(x, offset);
            len = len > exp + 1 ? exp + 1 : len;
            for (i = 0; i < len; ++i) {
                tv = tv * 100 + TbNumber.getDecoPos(x[offset + 2 + i]);
            }
        } else {
            exp = TbNumber.getExpNeg(x[offset + 1]);
            len = TbNumber.getSiglen(x, offset);
            len = len > exp + 1 ? exp + 1 : len;
            for (i = 0; i < len; ++i) {
                tv = tv * 100 + TbNumber.getDecoNeg(x[offset + 2 + i]);
            }
        }
        for (i = 0; i < exp + 1 - len; ++i) {
            tv *= 100;
        }
        return isPositive ? tv : -tv;
    }

    public static long toLong(byte[] x, int offset, int length) throws SQLException {
        int i;
        int len;
        int exp;
        long tv = 0L;
        if (x[offset] == 1) {
            return 0L;
        }
        if (!TbNumber.isOrdinary(x, offset)) {
            throw TbError.newSQLException(-590705);
        }
        if (!TbNumber.lessThanOrEqualTo(MIN_LONG, 0, x, offset)) {
            throw TbError.newSQLException(-90654);
        }
        if (!TbNumber.lessThanOrEqualTo(x, offset, MAX_LONG, 0)) {
            throw TbError.newSQLException(-90653);
        }
        boolean isPositive = TbNumber.isPositive(x[offset + 1]);
        if (isPositive) {
            exp = TbNumber.getExpPos(x[offset + 1]);
            len = TbNumber.getSiglen(x, offset);
            len = len > exp + 1 ? exp + 1 : len;
            for (i = 0; i < len; ++i) {
                tv = tv * 100L + (long)TbNumber.getDecoPos(x[offset + 2 + i]);
            }
        } else {
            exp = TbNumber.getExpNeg(x[offset + 1]);
            len = TbNumber.getSiglen(x, offset);
            len = len > exp + 1 ? exp + 1 : len;
            for (i = 0; i < len; ++i) {
                tv = tv * 100L + (long)TbNumber.getDecoNeg(x[offset + 2 + i]);
            }
        }
        for (i = 0; i < exp + 1 - len; ++i) {
            tv *= 100L;
        }
        return isPositive ? tv : -tv;
    }

    private static byte[] toZero() {
        return new byte[]{1, -128};
    }

    private static int toZero(byte[] buf, int offset) {
        buf[offset] = 1;
        buf[offset + 1] = -128;
        return 2;
    }

    private TbNumber() {
    }
}

