/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import java.util.Calendar;

public class TbDate {
    static final short OFFSET_CENTURY = 0;
    static final short OFFSET_YEAR = 1;
    static final short OFFSET_MONTH = 2;
    static final short OFFSET_DAY_OF_MONTH = 3;
    static final short OFFSET_HOUR_OF_DAY = 4;
    static final short OFFSET_MINUTE = 5;
    static final short OFFSET_SECOND = 6;
    static final short OFFSET_DATE_END = 7;
    public static final char DELIMITER_DATE = '-';
    public static final char DELIMITER_TIME = ':';
    public static final char DELIMITER_BLANK = ' ';
    private byte[] data;

    public TbDate(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data should not be null");
        }
        if (data.length != 8) {
            throw new IllegalArgumentException("invalid array size");
        }
        this.data = data;
    }

    public TbDate(int year, int month, int dayOfMonth, int hourOfDay, int minutes, int seconds) {
        this.data = new byte[8];
        this.data[0] = (byte)(year / 100 + 100);
        this.data[1] = (byte)(year % 100 + 100);
        this.data[2] = (byte)month;
        this.data[3] = (byte)dayOfMonth;
        this.data[4] = (byte)hourOfDay;
        this.data[5] = (byte)minutes;
        this.data[6] = (byte)seconds;
        this.data[7] = 0;
    }

    public TbDate(long time) {
        this.data = new byte[8];
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int era = cal.get(0);
        int year = cal.get(1);
        if (era == 0) {
            year = year * -1 + 1;
        }
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        int hourOfDay = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        this.data[0] = (byte)(year / 100 + 100);
        this.data[1] = (byte)(year % 100 + 100);
        this.data[2] = (byte)month;
        this.data[3] = (byte)dayOfMonth;
        this.data[4] = (byte)hourOfDay;
        this.data[5] = (byte)minutes;
        this.data[6] = (byte)seconds;
        this.data[7] = 0;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getYear() {
        int db_century = 0xFF & this.data[0];
        int db_year = 0xFF & this.data[1];
        int year = (db_century - 100) * 100 + (db_year - 100);
        return year;
    }

    public int getMonth() {
        int month = 0xFF & this.data[2];
        return month;
    }

    public int getDayOfMonth() {
        int dayOfMonth = 0xFF & this.data[3];
        return dayOfMonth;
    }

    public int getHourOfDay() {
        int hourOfDay = 0xFF & this.data[4];
        return hourOfDay;
    }

    public int getMinutes() {
        int minutes = 0xFF & this.data[5];
        return minutes;
    }

    public int getSeconds() {
        int seconds = 0xFF & this.data[6];
        return seconds;
    }

    public String toString() {
        char[] buffer = new char[20];
        int offset = 0;
        int year = this.getYear();
        if (year < 10000 && year >= 0) {
            offset += TbDate.writeFormattedInt(buffer, offset, 4, this.getYear());
        } else {
            int i;
            String yearStr = Integer.toString(year);
            for (i = 0; i < yearStr.length(); ++i) {
                buffer[offset + i] = yearStr.charAt(i);
            }
            offset += i;
        }
        buffer[offset++] = 45;
        offset += TbDate.writeFormattedInt(buffer, offset, 2, this.getMonth());
        buffer[offset++] = 45;
        offset += TbDate.writeFormattedInt(buffer, offset, 2, this.getDayOfMonth());
        buffer[offset++] = 32;
        offset += TbDate.writeFormattedInt(buffer, offset, 2, this.getHourOfDay());
        buffer[offset++] = 58;
        offset += TbDate.writeFormattedInt(buffer, offset, 2, this.getMinutes());
        buffer[offset++] = 58;
        offset += TbDate.writeFormattedInt(buffer, offset, 2, this.getSeconds());
        return new String(buffer, 0, offset);
    }

    private static int writeFormattedInt(char[] buffer, int offset, int expectedLength, int value) {
        for (int i = offset + expectedLength - 1; i >= offset; --i) {
            int mod = value % 10;
            buffer[i] = (char)(48 + mod);
            value /= 10;
        }
        return expectedLength;
    }
}

