/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import java.io.IOException;
import java.io.Reader;

public class ReaderWrapper
extends Reader {
    protected Reader srcReader;
    private char[] charData;
    private int charLen;
    private int charDataOff;

    protected ReaderWrapper(Reader srcReader, char[] preprocessedData, int preprocessedCharLen) {
        this.srcReader = srcReader;
        this.charData = preprocessedData;
        this.charLen = preprocessedCharLen;
        this.charDataOff = 0;
    }

    public static ReaderWrapper getInstance(Reader srcReader, char[] preprocessedData, int preprocessedCharLen) {
        return new ReaderWrapper(srcReader, preprocessedData, preprocessedCharLen);
    }

    @Override
    public void close() throws IOException {
        this.srcReader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int copy = 0;
        int remain = this.charLen - this.charDataOff;
        if (remain > 0) {
            copy = len < remain ? len : remain;
            System.arraycopy(this.charData, this.charDataOff, cbuf, off, copy);
            this.charDataOff += copy;
        }
        if (copy >= len) {
            return copy;
        }
        int read = this.srcReader.read(cbuf, off + copy, len - copy);
        if (copy > 0 && read < 0) {
            return copy;
        }
        return copy + read;
    }

    public int getPreReadCharLen() {
        return this.charLen;
    }
}

