/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.driver.TbConnection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class ExtFeatureInfo {
    public static final short UNKNOWN = 0;
    public static final short SUPPORT = 1;
    public static final short UNSUPPORT = 2;
    public static final int ID_64K_VARCHAR = 0;
    public static final int ID_STATIC_VIEW_FOR_UDT = 1;
    public static final int ID_UDT_OWNER_OF_COLUMN = 2;
    public static final int ID_MAX = 3;
    private static final String DB_T;
    private static final String DB_I;
    private static final String DB_U;
    private static final String UDT_OWNER_OF_COL_VIEWNAME;
    private static final String UDT_OWNER_OF_COL_COLNAME = "DATA_TYPE_OWNER";
    private TbConnection conn;
    private short[] info = new short[3];

    public ExtFeatureInfo(TbConnection conn) {
        this.conn = conn;
    }

    public boolean supports(int id) {
        return this.supports(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean supports(int id, boolean initialize) {
        if (id < 0 && id >= 3) {
            return false;
        }
        if (initialize && this.info[id] == 0) {
            PreparedStatement pstmt = null;
            switch (id) {
                case 0: {
                    String name = this.conn.serverInfo.getTbProductName();
                    int major = this.conn.serverInfo.getTbMajor();
                    boolean ret = major >= 6 && DB_T.equalsIgnoreCase(name) || major >= 11 && DB_I.equalsIgnoreCase(name) || major >= 6 && DB_U.equalsIgnoreCase(name);
                    this.info[0] = ret ? 1 : 2;
                    return ret;
                }
                case 1: {
                    boolean exist = false;
                    pstmt = this.conn.prepareStatement(" SELECT OBJECT_NAME FROM ALL_OBJECTS  WHERE OWNER = 'SYSCAT' AND OBJECT_TYPE IN ('TABLE', 'VIEW') AND OBJECT_NAME = ?");
                    pstmt.setString(1, "ALL_TYPES");
                    ResultSet rs = pstmt.executeQuery();
                    exist = rs.next();
                    this.info[1] = exist ? 1 : 2;
                    boolean bl = exist;
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return bl;
                    catch (Exception e) {
                        try {
                            if (pstmt == null) break;
                            pstmt.close();
                        }
                        catch (Exception e2) {}
                        break;
                        catch (Throwable throwable) {
                            try {
                                if (pstmt != null) {
                                    pstmt.close();
                                }
                            }
                            catch (Exception e3) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
                case 2: {
                    boolean hasCol = false;
                    pstmt = this.conn.prepareStatement(" SELECT COLUMN_NAME FROM ALL_TAB_COLUMNS  WHERE OWNER = 'SYSCAT' AND TABLE_NAME = ? AND COLUMN_NAME = ?");
                    pstmt.setString(1, UDT_OWNER_OF_COL_VIEWNAME);
                    pstmt.setString(2, UDT_OWNER_OF_COL_COLNAME);
                    ResultSet rs = pstmt.executeQuery();
                    hasCol = rs.next();
                    this.info[2] = hasCol ? 1 : 2;
                    boolean bl = hasCol;
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return bl;
                    catch (Exception e) {
                        try {
                            if (pstmt == null) break;
                            pstmt.close();
                        }
                        catch (Exception e4) {}
                        break;
                        catch (Throwable throwable) {
                            try {
                                if (pstmt != null) {
                                    pstmt.close();
                                }
                            }
                            catch (Exception e5) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
        return this.info[id] == 1;
    }

    static {
        char[][] dbs = new char[][]{{'T', 'i', 'b', 'e', 'r', 'o'}, {'U', 'p', 'R', 'i', 'g', 'h', 't'}, {'I', 'n', 's', 'p', 'u', 'r'}};
        DB_T = new String(dbs[0]);
        DB_I = new String(dbs[1]);
        DB_U = new String(dbs[2]);
        UDT_OWNER_OF_COL_VIEWNAME = new String(new char[]{'A', 'L', 'L', '_', 'T', 'B', 'L', '_', 'C', 'O', 'L', 'U', 'M', 'N', 'S'});
    }
}

