/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbIntervalDts;
import com.tmax.tibero.jdbc.TbIntervalYtm;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbRowId;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.TbXMLInputStream;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbNrowId;
import com.tmax.tibero.jdbc.data.TbNumber;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.ZoneInfo;
import com.tmax.tibero.jdbc.data.charset.CharsetMapper;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.jdbc.util.TbDTFormatter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;

public class DataTypeConverter
implements Cloneable {
    public static final byte RPCOL_UDT_OBJ = -124;
    public static final byte RPCOL_UDT_COLL = -120;
    public static final byte RPCOL_UDT_ROOT = 1;
    public static final byte RPCOL_UDT_SUBTYPE = 2;
    public static final byte[] RPCOL_UDT_NOT_FINAL = new byte[]{-2, 0, 0, 0};
    public static final int RPCOL_UDT_MIN_SIZE = 3;
    public static final byte RPCOL_NULLOBJ_W_DEPTH = -4;
    public static final byte RPCOL_NULLOBJ = -3;
    public static final int COLLECTION_META_LENGTH = 40;
    public static final int STRUCT_META_LENGTH = 40;
    public static final String _DESC_OID_PREFIX = "/O";
    public static final String _DESC_TOBJ_ID_PREFIX = "/T";
    public static final String _DESC_VERSION_NO_PREFIX = "/V";
    private TbConnection conn = null;
    private CharsetMapper charsetMapper = new CharsetMapper(2);
    private CharsetMapper nCharsetMapper = null;
    private static final int[] pr2six = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64, 64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64, 64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    private static final byte[] d = new byte[]{66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 64, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 62, 66, 66, 66, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 66, 66, 66, 65, 66, 66, 66, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 66, 66, 66, 66, 66, 66, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66};

    public DataTypeConverter(TbConnection conn1) throws SQLException {
        this.conn = conn1;
    }

    public void buildColumnMetadata(TbColumnDesc[] colDesc, TbResultSet rs, int colCnt) throws SQLException {
        Debug.logMethod("DataTypeConverter.buildColumnMetadata", new Object[]{colDesc, rs, Integer.toString(colCnt)});
        this.buildColumnMetaData(colDesc, 0, colCnt, rs.getCols());
        for (int i = 0; i < colCnt; ++i) {
            if (!DataType.isLocatorCategory(colDesc[i].dataType)) continue;
            rs.setHaveLocator(true);
        }
    }

    public void buildColumnMetaData(TbColumnDesc[] colDesc, int off, int colCnt, Column[] cols) throws SQLException {
        Debug.logMethod("DataTypeConverter.buildColumnMetadata", new Object[]{colDesc, cols, Integer.toString(colCnt)});
        Debug.log(DataTypeConverter.colDesc2Str(colDesc));
        if (colDesc.length > colCnt) {
            int i;
            HashMap newDescMap = new HashMap();
            try {
                block7: for (i = colCnt; i < colDesc.length; ++i) {
                    if (colDesc[i].name == null || !colDesc[i].name.matches("[0-9a-zA-Z]{32}")) continue;
                    switch (colDesc[i].dataType) {
                        case 28: 
                        case 32: {
                            TbStructDescriptor newStDesc = TbStructDescriptor.createDescriptor(colDesc[i].dataType, colDesc[i].name, this.conn);
                            this.descPut(newDescMap, i, newStDesc);
                            continue block7;
                        }
                        case 29: 
                        case 30: 
                        case 31: {
                            TbArrayDescriptor newArrDesc = TbArrayDescriptor.createDescriptor(colDesc[i].dataType, colDesc[i].name, this.conn);
                            this.descPut(newDescMap, i, newArrDesc);
                        }
                    }
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() <= -90400 && e.getErrorCode() > -90500) {
                    throw e;
                }
                this.conn.addWarning(TbError.newSQLWarning(-90664, e));
            }
            catch (Exception e) {
                this.conn.addWarning(TbError.newSQLWarning(-90664, e));
            }
            for (i = 0; i < colCnt; ++i) {
                if (DataType.isUDTCategory(colDesc[i].dataType)) {
                    cols[i].set(i, colDesc[i], (TbTypeDescriptor)this.descGet(newDescMap, colDesc[i].scale));
                    continue;
                }
                cols[i].set(i, colDesc[i]);
            }
        } else {
            for (int i = 0; i < colCnt; ++i) {
                cols[i].set(i, colDesc[i]);
            }
        }
    }

    private static String colDesc2Str(TbColumnDesc[] descs) {
        if (descs == null) {
            return "[(null)]";
        }
        StringBuffer sb = new StringBuffer(descs.length * 40);
        sb.append("[#\n");
        for (int i = 0; i < descs.length; ++i) {
            sb.append("  coldesc idx=").append(i).append("/type=").append(descs[i].dataType).append("/size=").append(descs[i].maxSize).append("/prec=").append(descs[i].precision).append("/scale=").append(descs[i].scale).append("/etc=").append(descs[i].etcMeta).append("/name=").append(descs[i].name).append("\n");
        }
        sb.append("#]");
        return sb.toString();
    }

    private <K, V> V descGet(Map<K, V> map, K key) {
        return map.get(key);
    }

    private <K, V> V descPut(Map<K, V> map, K key, V value) {
        return map.put(key, value);
    }

    public int bytesToChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        return this.charsetMapper.bytesToChars(srcBytes, srcStart, srcLen, destChars, destStart, destLen, false);
    }

    public int bytesToNChars(byte[] srcBytes, int srcStart, int srcLen, char[] destChars, int destStart, int destLen) throws SQLException {
        return this.nCharsetMapper.bytesToChars(srcBytes, srcStart, srcLen, destChars, destStart, destLen, false);
    }

    public byte[] castFromBigDecimal(BigDecimal data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(data.toString());
            }
            case 1: {
                return this.fromBigDecimal(data);
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromBigDecimal(byte[] buf, int offset, BigDecimal data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 1: {
                return this.fromBigDecimal(buf, offset, data);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromBoolean(boolean data, int svrType) throws SQLException {
        switch (svrType) {
            case 1: {
                return this.fromInt(data ? 1 : 0);
            }
            case 2: 
            case 3: {
                return this.fromString(data ? "1" : "0");
            }
            case 18: 
            case 19: {
                return this.fromNString(data ? "1" : "0");
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromBoolean(byte[] buf, int offset, boolean data, int svrType) throws SQLException {
        switch (svrType) {
            case 1: {
                return this.fromInt(buf, offset, data ? 1 : 0);
            }
            case 2: 
            case 3: {
                return this.fromString(buf, offset, data ? "1" : "0");
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data ? "1" : "0");
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromByte(byte data, int svrType) throws SQLException {
        switch (svrType) {
            case 1: {
                return this.fromInt(data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromByte(byte[] buf, int offset, byte data, int svrType) throws SQLException {
        switch (svrType) {
            case 1: {
                return this.fromInt(buf, offset, data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromBytes(byte[] data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(new String(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(new String(data));
            }
            case 4: {
                return data;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromBytes(byte[] buf, int offset, byte[] data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, new String(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, new String(data));
            }
            case 4: {
                System.arraycopy(data, 0, buf, offset, data.length);
                return data.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromDate(byte[] buf, int offset, Date data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 5: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromDate(buf, offset, cal);
            }
            case 7: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTimestamp(buf, offset, cal, 0);
            }
            case 6: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTime(buf, offset, cal, 0);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTbDate(byte[] buf, int offset, TbDate data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 5: 
            case 6: {
                return this.fromTbDate(buf, offset, data);
            }
            case 7: {
                TbTimestamp t = new TbTimestamp(data.getYear(), data.getMonth(), data.getDayOfMonth(), data.getHourOfDay(), data.getMinutes(), data.getSeconds(), 0);
                return this.fromTbTimestamp(buf, offset, t);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromDate(Date data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(data.toString());
            }
            case 5: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromDate(cal);
            }
            case 7: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTimestamp(cal, 0);
            }
            case 6: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTime(cal, 0);
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromDouble(byte[] buf, int offset, double data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, Double.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, Double.toString(data));
            }
            case 1: {
                return this.fromDouble(buf, offset, data);
            }
            case 4: {
                byte[] bytes = Double.toString(data).getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
            case 24: {
                return this.fromBinaryDouble(buf, offset, data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromDouble(double data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Double.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(Double.toString(data));
            }
            case 1: {
                return this.fromDouble(data);
            }
            case 4: {
                return Double.toString(data).getBytes();
            }
            case 24: {
                return this.fromBinaryDouble(data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromFloat(byte[] buf, int offset, float data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, Float.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, Float.toString(data));
            }
            case 1: {
                return this.fromFloat(buf, offset, data);
            }
            case 4: {
                byte[] bytes = Float.toString(data).getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
            case 23: {
                return this.fromBinaryFloat(buf, offset, data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromFloat(float data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Float.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(Float.toString(data));
            }
            case 1: {
                return this.fromFloat(data);
            }
            case 4: {
                return Float.toString(data).getBytes();
            }
            case 23: {
                return this.fromBinaryFloat(data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromInt(byte[] buf, int offset, int data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, Integer.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, Integer.toString(data));
            }
            case 1: {
                return this.fromInt(buf, offset, data);
            }
            case 4: {
                byte[] bytes = Integer.toString(data).getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromInt(int data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Integer.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(Integer.toString(data));
            }
            case 1: {
                return this.fromInt(data);
            }
            case 4: {
                return Integer.toString(data).getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromLong(byte[] buf, int offset, long data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, Long.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, Long.toString(data));
            }
            case 1: {
                return this.fromLong(buf, offset, data);
            }
            case 4: {
                byte[] bytes = Long.toString(data).getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromLong(long data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Long.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(Long.toString(data));
            }
            case 1: {
                return this.fromLong(data);
            }
            case 4: {
                return Long.toString(data).getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromObject(Object data, int svrType) throws SQLException {
        if (data instanceof String) {
            return this.castFromString((String)data, svrType);
        }
        if (data instanceof Boolean) {
            return this.castFromBoolean((Boolean)data, svrType);
        }
        if (data instanceof Byte) {
            return this.castFromByte((Byte)data, svrType);
        }
        if (data instanceof byte[]) {
            return this.castFromBytes((byte[])data, svrType);
        }
        if (data instanceof BigDecimal) {
            return this.castFromBigDecimal((BigDecimal)data, svrType);
        }
        if (data instanceof Integer) {
            return this.castFromInt((Integer)data, svrType);
        }
        if (data instanceof Float) {
            return this.castFromFloat(((Float)data).floatValue(), svrType);
        }
        if (data instanceof Double) {
            return this.castFromDouble((Double)data, svrType);
        }
        if (data instanceof Long) {
            return this.castFromLong((Long)data, svrType);
        }
        if (data instanceof Short) {
            return this.castFromShort((Short)data, svrType);
        }
        if (data instanceof Date) {
            return this.castFromDate((Date)data, svrType);
        }
        if (data instanceof Time) {
            return this.castFromTime((Time)data, svrType);
        }
        if (data instanceof Timestamp) {
            return this.castFromTimestamp((Timestamp)data, svrType);
        }
        throw TbError.newSQLException(-90610, data.toString());
    }

    public int castFromRowId(byte[] buf, int offset, String data, int svrType) throws SQLException {
        ServerInfo svrInfo = this.conn.getServerInfo();
        int endian = svrInfo.getServerEndian();
        switch (svrType) {
            case 15: {
                if (svrInfo.getServerIsNanobase() == 1) {
                    return new TbNrowId(this.conn).getServerBytes(buf, offset, endian, data);
                }
                return new TbRowId().fromString(buf, offset, endian, data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromShort(byte[] buf, int offset, short data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, Short.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, Short.toString(data));
            }
            case 1: {
                return this.fromShort(buf, offset, data);
            }
            case 4: {
                byte[] bytes = Short.toString(data).getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromShort(short data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(Short.toString(data));
            }
            case 18: 
            case 19: {
                return this.fromNString(Short.toString(data));
            }
            case 1: {
                return this.fromShort(data);
            }
            case 4: {
                return Short.toString(data).getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromString(byte[] buf, int offset, String data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data);
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data);
            }
            case 1: {
                BigDecimal bd = new BigDecimal(data);
                return this.fromBigDecimal(buf, offset, bd);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
            case 5: {
                Date date = Date.valueOf(data);
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return this.fromDate(buf, offset, cal);
            }
            case 6: {
                Time time = Time.valueOf(data);
                Calendar cal = Calendar.getInstance();
                cal.setTime(time);
                return this.fromTime(buf, offset, cal, 0);
            }
            case 7: {
                Timestamp ts = Timestamp.valueOf(data);
                Calendar cal = Calendar.getInstance();
                cal.setTime(ts);
                return this.fromTimestamp(buf, offset, cal, ts.getNanos());
            }
            case 13: {
                return this.stringToFixedBytes(data, 0, data.length(), buf, offset, buf.length - offset);
            }
            case 20: {
                return this.getDBEncodedNBytes(buf, offset, data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromString(String data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(data);
            }
            case 18: 
            case 19: {
                return this.fromNString(data);
            }
            case 1: {
                BigDecimal bd = new BigDecimal(data);
                return this.fromBigDecimal(bd);
            }
            case 4: {
                return data.toString().getBytes();
            }
            case 5: {
                Date date = Date.valueOf(data);
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return this.fromDate(cal);
            }
            case 6: {
                Time time = Time.valueOf(data);
                Calendar cal = Calendar.getInstance();
                cal.setTime(time);
                return this.fromTime(cal, 0);
            }
            case 7: {
                Timestamp ts = Timestamp.valueOf(data);
                Calendar cal = Calendar.getInstance();
                cal.setTime(ts);
                return this.fromTimestamp(cal, ts.getNanos());
            }
            case 13: {
                byte[] buf = new byte[data.length() * 2];
                this.stringToFixedBytes(data, 0, data.length(), buf, 0, buf.length);
                return buf;
            }
            case 20: {
                return this.getDBEncodedNBytes(data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTime(byte[] buf, int offset, Time data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 6: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTime(buf, offset, cal, 0);
            }
            case 5: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromDate(buf, offset, cal);
            }
            case 7: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTimestamp(buf, offset, cal, 0);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromTime(Time data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(data.toString());
            }
            case 6: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTime(cal, 0);
            }
            case 5: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromDate(cal);
            }
            case 7: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTimestamp(cal, 0);
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTimestamp(byte[] buf, int offset, Timestamp data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 5: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromDate(buf, offset, cal);
            }
            case 6: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTime(buf, offset, cal, data.getNanos());
            }
            case 7: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTimestamp(buf, offset, cal, data.getNanos());
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public byte[] castFromTimestamp(Timestamp data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(data.toString());
            }
            case 5: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromDate(cal);
            }
            case 6: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTime(cal, data.getNanos());
            }
            case 7: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(data);
                return this.fromTimestamp(cal, data.getNanos());
            }
            case 4: {
                return data.toString().getBytes();
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTbTimestamp(byte[] buf, int offset, TbTimestamp data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 5: 
            case 6: {
                TbDate d = new TbDate(data.getYear(), data.getMonth(), data.getDayOfMonth(), data.getHourOfDay(), data.getMinutes(), data.getSeconds());
                return this.fromTbDate(buf, offset, d);
            }
            case 7: {
                return this.fromTbTimestamp(buf, offset, data);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTbTimestampTZ(byte[] buf, int offset, TbTimestampTZ data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 5: 
            case 6: {
                Calendar c = Calendar.getInstance(data.getTimeZone());
                c.setTimeInMillis(data.getTime());
                TbDate d = new TbDate(c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13));
                return this.fromTbDate(buf, offset, d);
            }
            case 7: {
                Calendar cal = Calendar.getInstance(data.getTimeZone());
                cal.setTimeInMillis(data.getTime());
                TbTimestamp t = new TbTimestamp(cal.getTimeInMillis());
                return this.fromTbTimestamp(buf, offset, t);
            }
            case 21: {
                return this.fromTbTimestampTZ(buf, offset, data);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTimestampLTZ(byte[] buf, int offset, Timestamp data, int svrType) throws SQLException {
        switch (svrType) {
            case 2: 
            case 3: 
            case 10: {
                return this.fromString(buf, offset, data.toString());
            }
            case 18: 
            case 19: {
                return this.fromNString(buf, offset, data.toString());
            }
            case 5: 
            case 6: {
                TimeZone timezone = TimeZone.getTimeZone("UTC");
                Calendar c = Calendar.getInstance(timezone);
                c.setTimeInMillis(data.getTime());
                TbDate d = new TbDate(c.get(1), c.get(2), c.get(5), c.get(11), c.get(12), c.get(13));
                return this.fromTbDate(buf, offset, d);
            }
            case 22: {
                TimeZone timezone = TimeZone.getTimeZone("UTC");
                Calendar calLTZ = Calendar.getInstance(timezone);
                calLTZ.setTimeInMillis(data.getTime());
                TbTimestamp tsLTZ = new TbTimestamp(calLTZ.getTimeInMillis(), timezone);
                return this.fromTbTimestamp(buf, offset, tsLTZ);
            }
            case 4: {
                byte[] bytes = data.toString().getBytes();
                System.arraycopy(bytes, 0, buf, offset, bytes.length);
                return bytes.length;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTbIntervalYtm(byte[] buf, int offset, TbIntervalYtm data, int svrType) throws SQLException {
        switch (svrType) {
            case 8: {
                return this.fromTbIntervalYtm(buf, offset, data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int castFromTbIntervalDts(byte[] buf, int offset, TbIntervalDts data, int svrType) throws SQLException {
        switch (svrType) {
            case 9: {
                return this.fromTbIntervalDts(buf, offset, data);
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(svrType));
    }

    public int charsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.charsetMapper.charsToBytes(srcChars, srcStart, srcLen, destBytes, destStart, destLen, false);
    }

    public int charsToFixedBytes(char[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destLen) throws SQLException {
        byte highByte = 0;
        byte lowByte = 0;
        int index = destOff;
        for (int i = srcOff; i < srcOff + srcLen; ++i) {
            highByte = (byte)(src[i] >> 8 & 0xFF);
            lowByte = (byte)(src[i] & 0xFF);
            if (index + 1 >= destOff + destLen) {
                throw TbError.newSQLException(-590744, index + 1 + " >= " + destLen);
            }
            dest[index++] = highByte;
            dest[index++] = lowByte;
        }
        return index - destOff;
    }

    public int fixedBytesToChars(byte[] src, int srcOff, int srcLen, char[] dest, int destOff, int destLen) throws SQLException {
        int j = destOff;
        if (srcLen % 2 != 0) {
            throw TbError.newSQLException(-590748, srcLen);
        }
        for (int i = srcOff; i < srcOff + srcLen; i += 2) {
            if (j >= destOff + destLen) {
                throw TbError.newSQLException(-590744, j + " >= " + destOff + " + " + destLen);
            }
            dest[j++] = (char)((short)(src[i] << 8 & 0xFFFF) + (short)(src[i + 1] & 0xFF));
        }
        return j - destOff;
    }

    private byte[] fromBigDecimal(BigDecimal x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromBigDecimal", new Object[]{x});
        return TbNumber.fromString(x.toString());
    }

    public int fromBigDecimal(byte[] buf, int offset, BigDecimal x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromBigDecimal", new Object[]{x});
        return TbNumber.fromString(buf, offset, x.toString());
    }

    public int fromDate(byte[] buf, int offset, Calendar x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromDate", new Object[]{x});
        int year = x.get(1);
        buf[offset] = (byte)(year / 100 + 100);
        buf[offset + 1] = (byte)(year % 100 + 100);
        buf[offset + 2] = (byte)(x.get(2) + 1);
        buf[offset + 3] = (byte)x.get(5);
        buf[offset + 4] = x.get(9) == 0 ? (byte)x.get(10) : (byte)(x.get(10) + 12);
        buf[offset + 5] = (byte)x.get(12);
        buf[offset + 6] = (byte)x.get(13);
        buf[offset + 7] = 0;
        return 8;
    }

    private byte[] fromDate(Calendar x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromDate", new Object[]{x});
        byte[] date = new byte[8];
        int year = x.get(1);
        date[0] = (byte)(year / 100 + 100);
        date[1] = (byte)(year % 100 + 100);
        date[2] = (byte)(x.get(2) + 1);
        date[3] = (byte)x.get(5);
        date[4] = x.get(9) == 0 ? (byte)x.get(10) : (byte)(x.get(10) + 12);
        date[5] = (byte)x.get(12);
        date[6] = (byte)x.get(13);
        return date;
    }

    public int fromTbDate(byte[] buf, int offset, TbDate date) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTbDate", new Object[]{date});
        System.arraycopy(date.getBytes(), 0, buf, offset, 8);
        return 8;
    }

    public int fromDouble(byte[] buf, int offset, double x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromDouble", new Object[]{Double.toString(x)});
        return TbNumber.fromString(buf, offset, Double.toString(x));
    }

    private byte[] fromDouble(double x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromDouble", new Object[]{Double.toString(x)});
        return TbNumber.fromString(Double.toString(x));
    }

    public int fromFloat(byte[] buf, int offset, float x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromFloat", new Object[]{Float.toString(x)});
        return TbNumber.fromString(buf, offset, Float.toString(x));
    }

    private byte[] fromFloat(float x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromFloat", new Object[]{Float.toString(x)});
        return TbNumber.fromString(Float.toString(x));
    }

    public int fromBinaryDouble(byte[] buf, int offset, double x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromBinaryDouble", new Object[]{Long.toHexString(Double.doubleToLongBits(x))});
        return this.convertDouble2Bytes(buf, offset, x);
    }

    public byte[] fromBinaryDouble(double x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromBinaryDouble", new String[]{"binary_double"}, new Object[]{Long.toHexString(Double.doubleToLongBits(x))});
        byte[] ret = new byte[8];
        this.convertDouble2Bytes(ret, 0, x);
        return ret;
    }

    private int convertDouble2Bytes(byte[] buf, int offset, double x) {
        int doubleSize = 8;
        if (Double.compare(x, Double.NaN) == 0) {
            buf[offset] = -1;
            buf[offset + 1] = -8;
            buf[offset + 2] = 0;
            buf[offset + 3] = 0;
            buf[offset + 4] = 0;
            buf[offset + 5] = 0;
            buf[offset + 6] = 0;
            buf[offset + 7] = 0;
        } else if (Double.compare(x, -0.0) == 0 || Double.compare(x, 0.0) == 0) {
            buf[offset] = -128;
            buf[offset + 1] = 0;
            buf[offset + 2] = 0;
            buf[offset + 3] = 0;
            buf[offset + 4] = 0;
            buf[offset + 5] = 0;
            buf[offset + 6] = 0;
            buf[offset + 7] = 0;
        } else if (x > 0.0) {
            long longBits = Double.doubleToRawLongBits(x *= -1.0);
            TbCommon.long2Bytes(longBits, buf, offset, doubleSize);
        } else if (x < 0.0) {
            long longBits = Double.doubleToRawLongBits(x);
            TbCommon.long2Bytes(longBits ^= 0xFFFFFFFFFFFFFFFFL, buf, offset, doubleSize);
        } else {
            long longBits = Double.doubleToRawLongBits(x);
            TbCommon.long2Bytes(longBits, buf, offset, doubleSize);
        }
        return doubleSize;
    }

    public int fromBinaryFloat(byte[] buf, int offset, float x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromBinaryFloat", new Object[]{Long.toHexString(Float.floatToIntBits(x))});
        return this.convertFloat2Bytes(buf, offset, x);
    }

    public byte[] fromBinaryFloat(float x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromBinaryFloat", new String[]{"binary_float"}, new Object[]{Long.toHexString(Float.floatToIntBits(x))});
        byte[] ret = new byte[4];
        this.convertFloat2Bytes(ret, 0, x);
        return ret;
    }

    private int convertFloat2Bytes(byte[] buf, int offset, float x) {
        int floatSize = 4;
        if (Float.compare(x, Float.NaN) == 0) {
            buf[offset] = -1;
            buf[offset + 1] = -64;
            buf[offset + 2] = 0;
            buf[offset + 3] = 0;
        } else if (Float.compare(x, -0.0f) == 0 || Float.compare(x, 0.0f) == 0) {
            buf[offset] = -128;
            buf[offset + 1] = 0;
            buf[offset + 2] = 0;
            buf[offset + 3] = 0;
        } else if (x > 0.0f) {
            int intBits = Float.floatToRawIntBits(x *= -1.0f);
            TbCommon.int2Bytes(intBits, buf, offset, floatSize);
        } else if (x < 0.0f) {
            int intBits = Float.floatToRawIntBits(x);
            TbCommon.int2Bytes(intBits ^= 0xFFFFFFFF, buf, offset, floatSize);
        } else {
            int intBits = Float.floatToRawIntBits(x);
            TbCommon.int2Bytes(intBits, buf, offset, floatSize);
        }
        return floatSize;
    }

    public int fromInt(byte[] buf, int offset, int x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromInt", new Object[]{Integer.toString(x)});
        return TbNumber.fromInteger(buf, offset, x);
    }

    private byte[] fromInt(int x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromInt", new Object[]{Integer.toString(x)});
        return TbNumber.fromInteger(x);
    }

    public int fromLong(byte[] buf, int offset, long x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromLong", new Object[]{Long.toString(x)});
        return TbNumber.fromLong(buf, offset, x);
    }

    private byte[] fromLong(long x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromLong", new Object[]{Long.toString(x)});
        return TbNumber.fromLong(x);
    }

    public int fromNString(byte[] buf, int offset, String x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromNString", new Object[]{x});
        return this.getDBEncodedNBytes(buf, offset, x);
    }

    private byte[] fromNString(String x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromNString", new Object[]{x});
        return this.getDBEncodedNBytes(x);
    }

    public int fromShort(byte[] buf, int offset, short x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromShort", new Object[]{Short.toString(x)});
        return this.fromInt(buf, offset, x);
    }

    private byte[] fromShort(short x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromShort", new Object[]{Short.toString(x)});
        return this.fromInt(x);
    }

    public int fromString(byte[] buffer, int offset, String x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromString", new Object[]{x});
        return this.getDBEncodedBytes(buffer, offset, x);
    }

    public byte[] fromString(String x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromString", new Object[]{x});
        return this.getDBEncodedBytes(x);
    }

    public int fromTime(byte[] buf, int offset, Calendar cal, int nanoSec) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTime", new Object[]{cal});
        int hour = cal.get(10);
        if (cal.get(9) == 1) {
            hour += 12;
        }
        buf[offset] = (byte)hour;
        buf[offset + 1] = (byte)cal.get(12);
        buf[offset + 2] = (byte)cal.get(13);
        buf[offset + 3] = 0;
        TbCommon.int2Bytes(nanoSec, buf, offset + 4, 4);
        return 8;
    }

    private byte[] fromTime(Calendar cal, int nanoSec) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTime", new Object[]{cal});
        byte[] time = new byte[8];
        int hour = cal.get(10);
        if (cal.get(9) == 1) {
            hour += 12;
        }
        time[0] = (byte)hour;
        time[1] = (byte)cal.get(12);
        time[2] = (byte)cal.get(13);
        time[3] = 0;
        TbCommon.int2Bytes(nanoSec, time, 4, 4);
        return time;
    }

    public int fromTimestamp(byte[] buf, int offset, Calendar cal, int nanoSec) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTimestamp", new Object[]{cal});
        int year = cal.get(1);
        int hour = cal.get(10);
        if (cal.get(9) == 1) {
            hour += 12;
        }
        buf[offset] = (byte)(year / 100 + 100);
        buf[offset + 1] = (byte)(year % 100 + 100);
        buf[offset + 2] = (byte)(cal.get(2) + 1);
        buf[offset + 3] = (byte)cal.get(5);
        buf[offset + 4] = (byte)hour;
        buf[offset + 5] = (byte)cal.get(12);
        buf[offset + 6] = (byte)cal.get(13);
        buf[offset + 7] = 0;
        TbCommon.int2Bytes(nanoSec, buf, offset + 8, 4);
        return 12;
    }

    public int fromTimestampTZ(byte[] buf, int offset, Calendar cal, int nanoSec, TimeZone timezone) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTimestamp", new Object[]{cal});
        int year = cal.get(1);
        int hour = cal.get(10);
        if (cal.get(9) == 1) {
            hour += 12;
        }
        buf[offset] = (byte)(year / 100 + 100);
        buf[offset + 1] = (byte)(year % 100 + 100);
        buf[offset + 2] = (byte)(cal.get(2) + 1);
        buf[offset + 3] = (byte)cal.get(5);
        buf[offset + 4] = (byte)hour;
        buf[offset + 5] = (byte)cal.get(12);
        buf[offset + 6] = (byte)cal.get(13);
        buf[offset + 7] = 0;
        TbCommon.int2Bytes(nanoSec, buf, offset + 8, 4);
        String timezoneName = timezone.getID();
        int zoneID = ZoneInfo.getTimeZoneIdByName(timezoneName);
        int zoneOffset = timezone.getOffset(cal.getTimeInMillis());
        int utcSecond = (zoneOffset /= 1000) % 60;
        int utcMinute = zoneOffset / 60 % 60;
        int utcHour = zoneOffset / 3600;
        buf[offset + 12] = (byte)((0xFF & utcHour) + 100);
        buf[offset + 13] = (byte)(0xFF & utcMinute);
        buf[offset + 14] = (byte)(0xFF & utcSecond);
        TbCommon.int2Bytes(zoneID, buf, offset + 15, 2);
        return 17;
    }

    private byte[] fromTimestamp(Calendar cal, int nanoSec) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTimestamp", new Object[]{cal});
        byte[] ts = new byte[12];
        int year = cal.get(1);
        int hour = cal.get(10);
        if (cal.get(9) == 1) {
            hour += 12;
        }
        ts[0] = (byte)(year / 100 + 100);
        ts[1] = (byte)(year % 100 + 100);
        ts[2] = (byte)(cal.get(2) + 1);
        ts[3] = (byte)cal.get(5);
        ts[4] = (byte)hour;
        ts[5] = (byte)cal.get(12);
        ts[6] = (byte)cal.get(13);
        TbCommon.int2Bytes(nanoSec, ts, 8, 4);
        return ts;
    }

    public int fromTbTimestamp(byte[] buf, int offset, TbTimestamp timestamp) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTbTimestamp", new Object[]{timestamp});
        System.arraycopy(timestamp.getBytes(), 0, buf, offset, 12);
        return 12;
    }

    public int fromTbTimestampTZ(byte[] buf, int offset, TbTimestampTZ tstz) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTbTimestampTZ", new Object[]{tstz});
        Calendar cal = Calendar.getInstance(ZoneInfo.TZ_UTC);
        cal.setTimeInMillis(tstz.getTime());
        return this.fromTimestampTZ(buf, offset, cal, tstz.getNanos(), tstz.getTimeZone());
    }

    public int fromTbIntervalYtm(byte[] buf, int offset, TbIntervalYtm x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTbIntervalYtm", new Object[]{x});
        System.arraycopy(x.getBytes(), 0, buf, offset, 5);
        return 5;
    }

    public int fromTbIntervalDts(byte[] buf, int offset, TbIntervalDts x) throws SQLException {
        Debug.logMethod("DataTypeConverter.fromTbIntervalDts", new Object[]{x});
        System.arraycopy(x.getBytes(), 0, buf, offset, 12);
        return 12;
    }

    private String getDBDecodedNString(byte[] bytes, int offset, int length) throws SQLException {
        return this.nCharsetMapper.bytesToString(bytes, offset, length, false);
    }

    public String getDBDecodedString(byte[] bytes, int offset, int length) throws SQLException {
        return this.charsetMapper.bytesToString(bytes, offset, length, false);
    }

    private int getDBEncodedBytes(byte[] buffer, int offset, String msg) throws SQLException {
        return this.charsetMapper.stringToBytes(buffer, offset, msg);
    }

    public byte[] getDBEncodedBytes(String msg) throws SQLException {
        return this.charsetMapper.stringToBytes(msg);
    }

    private int getDBEncodedNBytes(byte[] buf, int offset, String msg) throws SQLException {
        return this.nCharsetMapper.stringToBytes(buf, offset, msg);
    }

    private byte[] getDBEncodedNBytes(String msg) throws SQLException {
        return this.nCharsetMapper.stringToBytes(msg);
    }

    public int getEndingBytePos(byte[] srcBytes, int offset) {
        return this.charsetMapper.getEndingBytePos(srcBytes, offset);
    }

    public int getEndingBytePosNCharset(byte[] srcBytes, int offset) {
        return this.nCharsetMapper.getEndingBytePos(srcBytes, offset);
    }

    public int getLeadingBytePos(byte[] srcBytes, int offset) {
        return this.charsetMapper.getLeadingBytePos(srcBytes, offset);
    }

    public int getLeadingBytePosNCharset(byte[] srcBytes, int offset) {
        return this.nCharsetMapper.getLeadingBytePos(srcBytes, offset);
    }

    public int getMaxBytesPerChar() {
        return this.charsetMapper.getMaxBytesPerChar();
    }

    public int getMaxBytesPerNChar() {
        return this.nCharsetMapper.getMaxBytesPerChar();
    }

    public int getUCS2MaxBytesPerChar() {
        return 2;
    }

    public boolean isEndingByte(byte[] srcBytes, int offset) {
        return this.charsetMapper.isEndingByte(srcBytes, offset);
    }

    public boolean isEndingByteNCharset(byte[] srcBytes, int offset) {
        return this.nCharsetMapper.isEndingByte(srcBytes, offset);
    }

    public boolean isLeadingByte(byte[] srcBytes, int offset) {
        return this.charsetMapper.isLeadingByte(srcBytes, offset);
    }

    public boolean isLeadingByteNCharset(byte[] srcBytes, int offset) {
        return this.nCharsetMapper.isLeadingByte(srcBytes, offset);
    }

    public int nCharsToBytes(char[] srcChars, int srcStart, int srcLen, byte[] destBytes, int destStart, int destLen) throws SQLException {
        return this.nCharsetMapper.charsToBytes(srcChars, srcStart, srcLen, destBytes, destStart, destLen, false);
    }

    public void reset() {
        this.charsetMapper = null;
        this.nCharsetMapper = null;
        this.conn = null;
    }

    public void setCharset(int charset, int nCharset) throws SQLException {
        if (charset == 27) {
            charset = 7;
        }
        if (nCharset == 27) {
            nCharset = 7;
        }
        if (charset == 28 || charset == 29) {
            charset = 13;
        }
        if (nCharset == 28 || nCharset == 29) {
            nCharset = 13;
        }
        this.charsetMapper = new CharsetMapper(charset);
        this.nCharsetMapper = new CharsetMapper(nCharset);
    }

    private int stringToFixedBytes(String src, int srcOff, int srcLen, byte[] dest, int destOff, int destLen) throws SQLException {
        byte highByte = 0;
        byte lowByte = 0;
        int index = destOff;
        for (int i = srcOff; i < srcLen; ++i) {
            highByte = (byte)(src.charAt(i) >> 8 & 0xFF);
            lowByte = (byte)(src.charAt(i) & 0xFF);
            if (index + 1 >= destLen) {
                throw TbError.newSQLException(-590744, index + 1 + " >= " + destLen);
            }
            dest[index++] = highByte;
            dest[index++] = lowByte;
        }
        return index - destOff;
    }

    public Object toStruct(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF, TbStructDescriptor desc, Class<?> clazz, Map<String, Class<?>> typeMap) throws SQLException {
        int rplen;
        boolean isRoot;
        int off;
        Debug.logMethod("DataTypeConverter.toStruct", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (dataType != 32 && dataType != 28) {
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        if (desc == null) {
            throw TbError.newSQLException(-90612, "obj_desc null");
        }
        if (!(x instanceof byte[])) {
            throw TbError.newSQLException(-90612, "inst=" + x.toString());
        }
        byte[] b = (byte[])x;
        if (b.length > offset + 3 && b[offset] == -124) {
            off = offset;
        } else if (b.length > offset + 5 && length > 5) {
            int readLen;
            byte[] locator = new byte[length];
            System.arraycopy(b, offset, locator, 0, length);
            TbBlob blob = new TbBlob(this.conn, locator, true);
            long lobLen = blob.length();
            if (lobLen > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90612, "rp(lob) len=" + lobLen);
            }
            b = blob.getBytes(1L, (int)lobLen);
            int n = readLen = b == null ? 0 : b.length;
            if (readLen < 3) {
                throw TbError.newSQLException(-90612, "udt_lob_len=" + readLen);
            }
            if (b[0] != -124) {
                throw TbError.newSQLException(-90612, "udt_rpflag=0x" + Integer.toHexString(0xFF & b[0]));
            }
            off = 0;
        } else {
            throw TbError.newSQLException(-90612, x.toString());
        }
        if (b[off + 1] == 1) {
            isRoot = true;
        } else if (b[off + 1] == 2) {
            isRoot = false;
        } else {
            throw TbError.newSQLException(-90612, "udt_inherit=0x" + Integer.toHexString(0xFF & b[off + 1]));
        }
        TbStructDescriptor realDesc = desc;
        if (b[off += 2] == RPCOL_UDT_NOT_FINAL[0] && b.length >= off + 4 && b[off + 1] == RPCOL_UDT_NOT_FINAL[1] && b[off + 2] == RPCOL_UDT_NOT_FINAL[2] && b[off + 3] == RPCOL_UDT_NOT_FINAL[3]) {
            off += RPCOL_UDT_NOT_FINAL.length;
        }
        if ((rplen = b[off] & 0xFF) <= 250) {
            ++off;
        } else if (rplen == 254) {
            rplen = TbCommon.bytes2Int(b, off + 1, 2);
            off += 3;
        } else if (rplen == 251) {
            rplen = TbCommon.bytes2Int(b, off + 1, 4);
            off += 5;
        } else {
            throw TbError.newSQLException(-90612, "udt_rplen=0x" + Integer.toHexString(rplen));
        }
        if (!isRoot) {
            int oidRpLen = 0xFF & b[off];
            byte[] rawOID = this.toBytes((Object)b, off + 1, oidRpLen, 4, freeTmpLobOnEOF);
            off += 1 + oidRpLen;
            char[] hexCode = "0123456789ABCDEF".toCharArray();
            StringBuilder sb = new StringBuilder(oidRpLen * 2);
            for (int i = 0; i < oidRpLen; ++i) {
                sb.append(hexCode[rawOID[i] >> 4 & 0xF]);
                sb.append(hexCode[rawOID[i] & 0xF]);
            }
            String hexEncodedOID = sb.toString();
            try {
                realDesc = TbStructDescriptor.createDescriptor(dataType, hexEncodedOID, this.conn);
            }
            catch (SQLException e) {
                throw TbError.newSQLException(-90612, e);
            }
        }
        LinkedList<ObjInstBldCtx> llCtx = new LinkedList<ObjInstBldCtx>();
        ObjInstBldCtx cur = new ObjInstBldCtx(realDesc);
        block12: while (true) {
            int objGrpDepth = 0;
            int nullObjGrpDepth = 0;
            int subRpLen = 0;
            switch (b[off]) {
                case -4: {
                    nullObjGrpDepth = 0xFF & b[off + 1];
                    off += 2;
                    break;
                }
                case -3: {
                    ++off;
                    break;
                }
                case 0: {
                    nullObjGrpDepth = Integer.MAX_VALUE;
                    ++off;
                    break;
                }
                default: {
                    subRpLen = b[off] & 0xFF;
                    if (subRpLen <= 250) {
                        ++off;
                    } else if (subRpLen == 254) {
                        subRpLen = TbCommon.bytes2Int(b, off + 1, 2);
                        off += 3;
                    } else if (subRpLen == 251) {
                        subRpLen = TbCommon.bytes2Int(b, off + 1, 4);
                        off += 5;
                    } else {
                        throw TbError.newSQLException(-90612, "subRpLen=" + subRpLen);
                    }
                    if (cur.desc.getAttributeTypes()[cur.attrProcessed] != 1) break;
                    --off;
                    ++subRpLen;
                }
            }
            while (cur.desc.getAttributeTypes()[cur.attrProcessed] == 32 && (subRpLen != 0 || objGrpDepth < nullObjGrpDepth)) {
                String attrTypeName = cur.desc.getAttributeTypeNames()[cur.attrProcessed];
                String attrOID = cur.desc.getAttributeOIDs()[cur.attrProcessed];
                for (ObjInstBldCtx ctx : llCtx) {
                    if (ctx.attrProcessed > 0) break;
                    if ((attrTypeName == null || !attrTypeName.equalsIgnoreCase(ctx.desc.getSQLTypeName())) && (attrOID == null || !attrOID.equalsIgnoreCase(ctx.desc.getOID()))) continue;
                    throw TbError.newSQLException(-90612, b.toString());
                }
                Object attrDescObj = null;
                if (attrOID != null && (attrDescObj = this.conn.getDescriptor(_DESC_OID_PREFIX + attrOID)) == null) {
                    attrDescObj = TbStructDescriptor.createDescriptor(32, attrOID, this.conn);
                }
                if (attrDescObj == null && attrTypeName != null && (attrDescObj = this.conn.getDescriptor(attrTypeName)) == null) {
                    attrDescObj = TbStructDescriptor.createDescriptor(attrTypeName, this.conn);
                }
                if (attrDescObj == null) {
                    throw TbError.newSQLException(-90665, "parent=" + cur.desc.getSQLTypeName() + ", attrIdx=" + cur.attrProcessed + ", attr=" + attrTypeName + ", attrOID=" + attrOID);
                }
                if (!(attrDescObj instanceof TbStructDescriptor) || !((TbStructDescriptor)attrDescObj).isFinal()) break;
                TbStructDescriptor attrDesc = (TbStructDescriptor)attrDescObj;
                ObjInstBldCtx newCtx = new ObjInstBldCtx(attrDesc);
                llCtx.addFirst(cur);
                cur = newCtx;
                ++objGrpDepth;
            }
            int attrDataType = cur.desc.getAttributeTypes()[cur.attrProcessed];
            int attrSqlType = DataType.getSqlType(attrDataType);
            String attrTypeName = cur.desc.getAttributeTypeNames()[cur.attrProcessed];
            String attrOID = cur.desc.getAttributeOIDs()[cur.attrProcessed];
            Object descObj = null;
            switch (attrDataType) {
                case 29: 
                case 30: 
                case 31: {
                    if (attrOID != null && (descObj = this.conn.getDescriptor(attrOID)) == null) {
                        descObj = TbArrayDescriptor.createDescriptor(attrDataType, attrOID, this.conn);
                    }
                    if (descObj == null && attrTypeName != null && (descObj = this.conn.getDescriptor(attrTypeName)) == null) {
                        descObj = TbArrayDescriptor.createDescriptor(attrTypeName, this.conn);
                    }
                    if (descObj != null) break;
                    throw TbError.newSQLException(-90665, "parent=" + cur.desc.getSQLTypeName() + ", attrIdx=" + cur.attrProcessed + ", attr=" + attrTypeName + ", attrOID=" + attrOID);
                }
                case 28: 
                case 32: {
                    if (attrOID != null && (descObj = this.conn.getDescriptor(attrOID)) == null) {
                        descObj = TbStructDescriptor.createDescriptor(attrDataType, attrOID, this.conn);
                    }
                    if (descObj == null && attrTypeName != null && (descObj = this.conn.getDescriptor(attrTypeName)) == null) {
                        descObj = TbStructDescriptor.createDescriptor(attrTypeName, this.conn);
                    }
                    if (descObj != null) break;
                    throw TbError.newSQLException(-90665, "parent=" + cur.desc.getSQLTypeName() + ", attrIdx=" + cur.attrProcessed + ", attr=" + attrTypeName + ", attrOID=" + attrOID);
                }
            }
            if (descObj instanceof TbArrayDescriptor) {
                TbArrayDescriptor attrArrDesc = (TbArrayDescriptor)descObj;
                cur.values[cur.attrProcessed] = this.toArray(b, off, subRpLen, attrDataType, freeTmpLobOnEOF, attrArrDesc, typeMap);
            } else if (descObj instanceof TbStructDescriptor) {
                TbStructDescriptor attrStDesc = (TbStructDescriptor)descObj;
                cur.values[cur.attrProcessed] = this.toStruct(b, off, subRpLen, attrDataType, freeTmpLobOnEOF, attrStDesc, null, typeMap);
            } else {
                cur.values[cur.attrProcessed] = this.toObject(b, off, subRpLen, attrDataType, attrSqlType, freeTmpLobOnEOF);
            }
            ++cur.attrProcessed;
            off += subRpLen;
            objGrpDepth = 0;
            while (true) {
                if (cur.values.length > cur.attrProcessed) continue block12;
                TbStruct newStruct = new TbStruct(cur.desc, this.conn, cur.values);
                Object newClsInstOrStruct = null;
                boolean isRootNode = llCtx.isEmpty();
                if (newStruct != null) {
                    newClsInstOrStruct = isRootNode && clazz != null ? newStruct.toClass(clazz, typeMap) : newStruct.toClass(typeMap);
                }
                if (isRootNode) {
                    return newClsInstOrStruct;
                }
                ObjInstBldCtx parent = (ObjInstBldCtx)llCtx.removeFirst();
                parent.values[parent.attrProcessed++] = newClsInstOrStruct;
                cur = parent;
            }
            break;
        }
    }

    public Array toArray(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF, TbArrayDescriptor desc, Map<String, Class<?>> typeMap) throws SQLException {
        int off;
        Debug.logMethod("DataTypeConverter.toArray", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (!(x instanceof byte[])) {
            throw TbError.newSQLException(-90612, "inst=" + x.toString());
        }
        if (dataType != 29 && dataType != 30 && dataType != 31) {
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        if (desc == null) {
            throw TbError.newSQLException(-90612, "arr_desc=null");
        }
        byte[] b = (byte[])x;
        if (b.length > offset + 3 && b[offset] == -120 && b[offset + 1] == 1) {
            off = offset + 2;
        } else if (b.length > offset + 5) {
            int readLen;
            byte[] locator = new byte[length];
            System.arraycopy(b, offset, locator, 0, length);
            TbBlob blob = new TbBlob(this.conn, locator, true);
            long lobLen = blob.length();
            if (lobLen > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90612, "rp(lob) len=" + lobLen);
            }
            b = blob.getBytes(1L, (int)lobLen);
            int n = readLen = b == null ? 0 : b.length;
            if (readLen < 3) {
                throw TbError.newSQLException(-90612, "udt_lob_len=" + readLen);
            }
            if (b[0] != -120 || b[1] != 1) {
                throw TbError.newSQLException(-90612, "udt_rpflag=0x" + Integer.toHexString(0xFF & b[0]) + ",0x" + Integer.toHexString(0xFF & b[1]));
            }
            off = 2;
        } else {
            throw TbError.newSQLException(-90612, x.toString());
        }
        int elemType = desc.getElementType();
        int elemSqlType = desc.getBaseType();
        int rplen = b[off] & 0xFF;
        if (rplen <= 250) {
            ++off;
        } else if (rplen == 254) {
            rplen = TbCommon.bytes2Int(b, off + 1, 2);
            off += 3;
        } else if (rplen == 251) {
            rplen = TbCommon.bytes2Int(b, off + 1, 4);
            off += 5;
        } else {
            throw TbError.newSQLException(-90612, "rplen=" + rplen);
        }
        if (b[off] != 0 || b[off + 1] != 0 || b[off + 2] != 0) {
            throw TbError.newSQLException(-90612, "illegal_input");
        }
        int arrayElemCnt = b[off += 3] & 0xFF;
        if (arrayElemCnt <= 250) {
            ++off;
        } else if (arrayElemCnt == 254) {
            arrayElemCnt = TbCommon.bytes2Int(b, off + 1, 2);
            off += 3;
        } else if (arrayElemCnt == 251) {
            arrayElemCnt = TbCommon.bytes2Int(b, off + 1, 4);
            off += 5;
        } else {
            throw TbError.newSQLException(-90612, "arrayElemCnt=" + arrayElemCnt);
        }
        Object[] elem = new Object[arrayElemCnt];
        for (int i = 0; i < arrayElemCnt; ++i) {
            int subRpLen = b[off] & 0xFF;
            if (subRpLen <= 250) {
                ++off;
            } else if (subRpLen == 254) {
                subRpLen = TbCommon.bytes2Int(b, off + 1, 2);
                off += 3;
            } else if (subRpLen == 251) {
                subRpLen = TbCommon.bytes2Int(b, off + 1, 4);
                off += 5;
            } else {
                throw TbError.newSQLException(-90612, "subRpLen=" + subRpLen);
            }
            switch (elemType) {
                case 29: 
                case 30: 
                case 31: {
                    Object aDscObj = this.conn.getDescriptor(desc.getElementTypeName());
                    if (aDscObj == null) {
                        aDscObj = TbArrayDescriptor.createDescriptor(elemType, desc.getElementTypeName(), this.conn);
                    }
                    if (aDscObj instanceof TbArrayDescriptor) {
                        TbArrayDescriptor arrDesc = (TbArrayDescriptor)aDscObj;
                        elem[i] = this.toArray(b, off, subRpLen, elemType, freeTmpLobOnEOF, arrDesc, typeMap);
                        break;
                    }
                    TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
                    break;
                }
                case 28: 
                case 32: {
                    Object sDscObj = this.conn.getDescriptor(desc.getElementTypeName());
                    if (sDscObj == null) {
                        sDscObj = TbStructDescriptor.createDescriptor(elemType, desc.getElementTypeName(), this.conn);
                    }
                    if (sDscObj instanceof TbStructDescriptor) {
                        TbStructDescriptor structDesc = (TbStructDescriptor)sDscObj;
                        elem[i] = this.toStruct(b, off, subRpLen, elemType, freeTmpLobOnEOF, structDesc, null, typeMap);
                        break;
                    }
                    TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
                    break;
                }
                case 1: {
                    if (subRpLen == 0) {
                        elem[i] = null;
                        break;
                    }
                    elem[i] = this.toObject(b, off - 1, subRpLen + 1, elemType, elemSqlType, freeTmpLobOnEOF);
                    break;
                }
                default: {
                    elem[i] = this.toObject(b, off, subRpLen, elemType, elemSqlType, freeTmpLobOnEOF);
                }
            }
            off += subRpLen;
        }
        return new TbArray(desc, this.conn, elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toAsciiStream(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toAsciiStream", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length == 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    return new ByteArrayInputStream(data, offset, length);
                }
                case 10: {
                    byte[] longData;
                    byte[] locator = new byte[length];
                    System.arraycopy(data, offset, locator, 0, length);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        longData = this.conn.getTbComm().readLongRaw(locator);
                    }
                    return new ByteArrayInputStream(longData, 0, longData.length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public BigDecimal toBigDecimal(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toBigDecimal", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length == 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    try {
                        String value = this.getDBDecodedString(data, offset, length);
                        return new BigDecimal(value.trim());
                    }
                    catch (NumberFormatException e) {
                        Debug.log("DataTypeConverter.toBigDecimal (FAILED): " + e.getMessage());
                        return null;
                    }
                }
                case 1: {
                    return TbNumber.toBigDecimal(data, offset, length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toBinaryStream(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toBinaryStream", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length == 0 || x == null) {
            return null;
        }
        if (x instanceof InputStream) {
            try {
                ((InputStream)x).reset();
                return (InputStream)x;
            }
            catch (IOException e) {
                throw TbError.newSQLException(-90616, e);
            }
        }
        if (x instanceof Blob) {
            return ((TbBlob)x).getBinaryStream();
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    return new ByteArrayInputStream(data, offset, length);
                }
                case 11: {
                    byte[] longRawData;
                    byte[] longLoc = new byte[length];
                    System.arraycopy(data, offset, longLoc, 0, length);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        longRawData = this.conn.getTbComm().readLongRaw(longLoc);
                    }
                    return new ByteArrayInputStream(longRawData, 0, longRawData.length);
                }
                case 12: {
                    byte[] lobLoc = new byte[length];
                    System.arraycopy(data, offset, lobLoc, 0, length);
                    return new TbBlob(this.conn, lobLoc, false).getBinaryStream();
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public Blob toBlob(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF) throws SQLException {
        Debug.logMethod("DataTypeConverter.toBlob", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length == 0 || x == null) {
            return null;
        }
        if (x instanceof Blob) {
            return (Blob)x;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 12: {
                    byte[] locator = new byte[length];
                    System.arraycopy(data, offset, locator, 0, length);
                    return new TbBlob(this.conn, locator, freeTmpLobOnEOF);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public boolean toBoolean(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toBoolean", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length == 0 || x == null) {
            return false;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    String val1 = this.getDBDecodedString(data, offset, length).trim();
                    return val1 != null && (val1.equals("t") || val1.equals("1") || val1.equalsIgnoreCase("true"));
                }
                case 18: 
                case 19: {
                    String val2 = this.getDBDecodedNString(data, offset, length).trim();
                    return val2 != null && (val2.equals("t") || val2.equals("1") || val2.equalsIgnoreCase("true"));
                }
                case 1: {
                    return TbNumber.toInteger(data, offset, length) != 0;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public byte toByte(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toByte", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        int value = this.toIntInternal(x, offset, length, dataType);
        if (value > 127 || value < -128) {
            throw TbError.newSQLException(-590749, value);
        }
        return (byte)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF) throws SQLException {
        Debug.logMethod("DataTypeConverter.toBytes", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length == 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 10: 
                case 11: {
                    byte[] longLoc = new byte[length];
                    System.arraycopy(data, offset, longLoc, 0, length);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        return this.conn.getTbComm().readLongRaw(longLoc);
                    }
                }
                case 12: {
                    byte[] lobLoc = new byte[length];
                    System.arraycopy(data, offset, lobLoc, 0, length);
                    TbBlob blob = new TbBlob(this.conn, lobLoc, freeTmpLobOnEOF);
                    byte[] tmpBlobBytes = blob.getBytes(1L, (int)blob.length());
                    if (blob.getIsTempLob() && freeTmpLobOnEOF) {
                        blob.free();
                    }
                    return tmpBlobBytes;
                }
                case 13: 
                case 20: {
                    throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
                }
            }
            byte[] result = new byte[length];
            System.arraycopy(data, offset, result, 0, length);
            return result;
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public int toBytes(Object x, int offset, int length, int dataType, byte[] result) throws SQLException {
        Debug.logMethod("DataTypeConverter.toBytes", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return 0;
        }
        if (x instanceof byte[]) {
            switch (dataType) {
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 20: {
                    throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
                }
            }
            if (length > result.length) {
                throw TbError.newSQLException(-90650);
            }
            System.arraycopy(x, offset, result, 0, length);
            return length;
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader toCharacterStream(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toCharacterStream", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof Reader) {
            try {
                ((Reader)x).reset();
                return (Reader)x;
            }
            catch (IOException e) {
                throw TbError.newSQLException(-90616, e);
            }
        }
        if (x instanceof Clob) {
            return ((TbClob)x).getCharacterStream();
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    return new StringReader(this.getDBDecodedString(data, 0, length));
                }
                case 18: 
                case 19: {
                    return new StringReader(this.getDBDecodedNString(data, 0, length));
                }
                case 10: {
                    String str;
                    byte[] longLoc = new byte[length];
                    System.arraycopy(data, offset, longLoc, 0, length);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        str = this.conn.getTbComm().readLong(longLoc);
                    }
                    return new StringReader(str);
                }
                case 13: {
                    byte[] clobLoc = new byte[length];
                    System.arraycopy(data, offset, clobLoc, 0, length);
                    return new TbClob(this.conn, clobLoc, false).getCharacterStream();
                }
                case 20: {
                    byte[] nclobLoc = new byte[length];
                    System.arraycopy(data, offset, nclobLoc, 0, length);
                    return new TbNClob(this.conn, nclobLoc, false).getCharacterStream();
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public Clob toClob(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF) throws SQLException {
        Debug.logMethod("DataTypeConverter.toClob", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof Clob) {
            return (Clob)x;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 13: {
                    byte[] clobLoc = new byte[length];
                    System.arraycopy(data, offset, clobLoc, 0, length);
                    return new TbClob(this.conn, clobLoc, freeTmpLobOnEOF);
                }
                case 20: {
                    byte[] nclobLoc = new byte[length];
                    System.arraycopy(data, offset, nclobLoc, 0, length);
                    return new TbNClob(this.conn, nclobLoc, freeTmpLobOnEOF);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public Date toDate(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toDate", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    String dateStr = this.getDBDecodedString(data, offset, length);
                    return Date.valueOf(dateStr.trim());
                }
                case 5: {
                    if (length != 8) {
                        throw TbError.newSQLException(-590750, length);
                    }
                    return this.toDateFromBytes(data, offset);
                }
                case 7: {
                    if (length != 12) {
                        throw TbError.newSQLException(-590751, length);
                    }
                    return this.toDateFromBytes(data, offset);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    private Date toDateFromBytes(byte[] bytes, int offset) {
        int db_century = 0xFF & bytes[offset];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hour, minute, second);
        calendar.clear(14);
        return new Date(calendar.getTimeInMillis());
    }

    public TbDate toTbDate(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toTbDate", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 5: {
                    if (length != 8) {
                        throw TbError.newSQLException(-590750, length);
                    }
                    byte[] dateData = new byte[8];
                    System.arraycopy(data, offset, dateData, 0, 8);
                    TbDate date = new TbDate(dateData);
                    return date;
                }
                case 7: {
                    if (length != 12) {
                        throw TbError.newSQLException(-590751, length);
                    }
                    byte[] tsData = new byte[8];
                    System.arraycopy(data, offset, tsData, 0, 8);
                    TbDate tsdt = new TbDate(tsData);
                    return tsdt;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public double toDouble(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toDouble", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return 0.0;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    try {
                        String value = this.getDBDecodedString(data, offset, length);
                        return Double.parseDouble(value.trim());
                    }
                    catch (NumberFormatException e) {
                        Debug.log("DataTypeConverter.toDouble (FAILED) : " + e.getMessage());
                        return 0.0;
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String value = this.getDBDecodedNString(data, offset, length);
                        return Double.parseDouble(value.trim());
                    }
                    catch (NumberFormatException e) {
                        Debug.log("DataTypeConverter.toDouble (FAILED) : " + e.getMessage());
                        return 0.0;
                    }
                }
                case 1: {
                    return TbNumber.toDouble(data, offset, length);
                }
                case 24: {
                    return TbNumber.toBinaryDouble(data, offset, length);
                }
                case 23: {
                    return TbNumber.toBinaryFloat(data, offset, length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public float toFloat(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toFloat", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return 0.0f;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    try {
                        String value = this.getDBDecodedString(data, offset, length);
                        return Float.parseFloat(value.trim());
                    }
                    catch (NumberFormatException e) {
                        Debug.log("DataTypeConverter.toFloat (FAILED) : " + e.getMessage());
                        return 0.0f;
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String value = this.getDBDecodedNString(data, offset, length);
                        return Float.parseFloat(value.trim());
                    }
                    catch (NumberFormatException e) {
                        Debug.log("DataTypeConverter.toFloat (FAILED) : " + e.getMessage());
                        return 0.0f;
                    }
                }
                case 1: {
                    return (float)TbNumber.toDouble(data, offset, length);
                }
                case 24: {
                    return (float)TbNumber.toBinaryDouble(data, offset, length);
                }
                case 23: {
                    return TbNumber.toBinaryFloat(data, offset, length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public int toInt(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toInt", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        return this.toIntInternal(x, offset, length, dataType);
    }

    public TbIntervalDts toIntervalDts(Object x, int offset, int length, int dataType, int precision, int scale) throws SQLException {
        Debug.logMethod("DataTypeConverter.toIntervalDts", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType), Integer.toString(precision), Integer.toString(scale)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            switch (dataType) {
                case 9: {
                    byte[] data = new byte[length];
                    System.arraycopy(x, offset, data, 0, length);
                    return new TbIntervalDts(data, precision, scale);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public TbIntervalYtm toIntervalYtm(Object x, int offset, int length, int dataType, int precision) throws SQLException {
        Debug.logMethod("DataTypeConverter.toIntervalYtm", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType), Integer.toString(precision)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            switch (dataType) {
                case 8: {
                    byte[] data = new byte[length];
                    System.arraycopy(x, offset, data, 0, length);
                    return new TbIntervalYtm(data, precision);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public int toIntInternal(Object x, int offset, int length, int dataType) throws SQLException {
        if (length <= 0 || x == null) {
            return 0;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    try {
                        String value = this.getDBDecodedString(data, offset, length);
                        return Integer.parseInt(value.trim());
                    }
                    catch (NumberFormatException e) {
                        return TbCommon.bytes2Int(data, offset, length);
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String value = this.getDBDecodedString(data, offset, length);
                        return Integer.parseInt(value.trim());
                    }
                    catch (NumberFormatException e) {
                        return TbCommon.bytes2Int(data, offset, length);
                    }
                }
                case 1: {
                    return TbNumber.toInteger(data, offset, length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public long toLong(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toLong", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return 0L;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    try {
                        String value = this.getDBDecodedString(data, offset, length);
                        return Long.parseLong(value.trim());
                    }
                    catch (NumberFormatException e) {
                        return TbCommon.bytes2Long(data, offset, length);
                    }
                }
                case 18: 
                case 19: {
                    try {
                        String value = this.getDBDecodedNString(data, offset, length);
                        return Long.parseLong(value.trim());
                    }
                    catch (NumberFormatException e) {
                        return TbCommon.bytes2Long(data, offset, length);
                    }
                }
                case 1: {
                    return TbNumber.toLong(data, offset, length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toLongRawBytes(Object x, int offset, int length) throws SQLException {
        Debug.logMethod("DataTypeConverter.toLongRawBytes", new Object[]{x, Integer.toString(offset), Integer.toString(length)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] locator = new byte[length];
            System.arraycopy(x, offset, locator, 0, length);
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                return this.conn.getTbComm().readLongRaw(locator);
            }
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toLongRawStream(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toLongRawStream", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 10: 
                case 11: {
                    byte[] longData;
                    byte[] longLoc = new byte[length];
                    System.arraycopy(data, offset, longLoc, 0, length);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        longData = this.conn.getTbComm().readLongRaw(longLoc);
                    }
                    return new ByteArrayInputStream(longData, 0, longData.length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toLongString(Object x, int offset, int length) throws SQLException {
        Debug.logMethod("DataTypeConverter.toLongString", new Object[]{x, Integer.toString(offset), Integer.toString(length)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] locator = new byte[length];
            System.arraycopy(x, offset, locator, 0, length);
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                return this.conn.getTbComm().readLong(locator);
            }
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public NClob toNClob(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toNClob", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        return this.toTbNClob(x, offset, length, dataType);
    }

    public TbNClob toTbNClob(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toTbNClob", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof TbNClob || x instanceof NClob) {
            return (TbNClob)x;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 20: {
                    byte[] nlobLoc = new byte[length];
                    System.arraycopy(data, offset, nlobLoc, 0, length);
                    return new TbNClob(this.conn, nlobLoc, false);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public TbNrowId toNrowId(Object x, int offset, int length) throws SQLException {
        Debug.logMethod("DataTypeConverter.toNrowId", new Object[]{x, Integer.toString(offset), Integer.toString(length)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            TbNrowId nrowId = new TbNrowId(this.conn);
            System.arraycopy(x, offset, nrowId.nrowid, 0, 8);
            return nrowId;
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public Object toObject(Object x, int offset, int length, int dataType, int sqlType, boolean freeTmpLobOnEOF) throws SQLException {
        return this.toObject(x, offset, length, dataType, sqlType, -1, -1, freeTmpLobOnEOF, null, null, null);
    }

    public Object toObject(Object x, int offset, int length, int dataType, int sqlType, int precision, int scale, boolean freeTmpLobOnEOF, TbTypeDescriptor desc, Class<?> clazz, Map<String, Class<?>> typeMap) throws SQLException {
        Debug.logMethod("DataTypeConverter.toObject", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType), Integer.toString(sqlType), Integer.toString(precision), Integer.toString(scale)});
        switch (dataType) {
            case 2: 
            case 3: 
            case 18: 
            case 19: {
                return this.toString(x, offset, length, dataType, freeTmpLobOnEOF);
            }
            case 10: {
                return this.toLongString(x, offset, length);
            }
            case 11: {
                return this.toLongRawBytes(x, offset, length);
            }
            case 1: {
                BigDecimal bd = this.toBigDecimal(x, offset, length, dataType);
                switch (sqlType) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Integer(bd.intValue());
                    }
                    case -5: {
                        return new Long(bd.longValue());
                    }
                    case 7: {
                        return new Float(bd.floatValue());
                    }
                    case 6: 
                    case 8: {
                        return new Double(bd.doubleValue());
                    }
                }
                return bd;
            }
            case 24: {
                return new Double(this.toDouble(x, offset, length, dataType));
            }
            case 23: {
                return new Float(this.toFloat(x, offset, length, dataType));
            }
            case 5: {
                switch (sqlType) {
                    case 91: {
                        return this.toDate(x, offset, length, dataType);
                    }
                    case 93: {
                        return this.toTimestamp(x, offset, length, dataType);
                    }
                    case 92: {
                        return this.toTime(x, offset, length, dataType);
                    }
                }
                throw TbError.newSQLException(-590703, Integer.toString(sqlType));
            }
            case 6: {
                return this.toTime(x, offset, length, dataType);
            }
            case 7: 
            case 21: 
            case 22: {
                return this.toTimestamp(x, offset, length, dataType);
            }
            case 4: {
                return this.toBytes(x, offset, length, dataType, freeTmpLobOnEOF);
            }
            case 15: {
                if (this.conn.getServerInfo().getServerIsNanobase() == 1) {
                    return this.toNrowId(x, offset, length);
                }
                return this.toRowId(x, offset, length, dataType);
            }
            case 12: {
                return this.toBlob(x, offset, length, dataType, freeTmpLobOnEOF);
            }
            case 13: 
            case 20: {
                if (sqlType == 2009) {
                    return this.toSQLXML(x, offset, length, dataType, freeTmpLobOnEOF);
                }
                return this.toClob(x, offset, length, dataType, freeTmpLobOnEOF);
            }
            case 9: {
                return this.toIntervalDts(x, offset, length, dataType, precision, scale);
            }
            case 8: {
                return this.toIntervalYtm(x, offset, length, dataType, precision);
            }
            case 29: 
            case 30: 
            case 31: {
                if (desc instanceof TbArrayDescriptor) {
                    return this.toArray(x, offset, length, dataType, freeTmpLobOnEOF, (TbArrayDescriptor)desc, typeMap);
                }
                if (length != 0) break;
                return null;
            }
            case 28: 
            case 32: {
                if (desc instanceof TbStructDescriptor) {
                    if (desc.getOID().compareTo("00000000000000000000000000000001") == 0 && clazz == null && (typeMap == null || typeMap.get(desc.getSQLTypeName()) == null)) {
                        return this.toStruct(x, offset, length, dataType, freeTmpLobOnEOF, (TbStructDescriptor)desc, TbSQLXML.class, typeMap);
                    }
                    return this.toStruct(x, offset, length, dataType, freeTmpLobOnEOF, (TbStructDescriptor)desc, clazz, typeMap);
                }
                if (length != 0) break;
                return null;
            }
        }
        throw TbError.newSQLException(-590703, DataType.getDBTypeName(dataType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TbResultSet toResultSet(Object x, int offset, int length, TbStatement stmt) throws SQLException {
        TbResultSet rs;
        Debug.logMethod("DataTypeConverter.toResultSet", new Object[]{x, new Integer(offset), new Integer(length), stmt});
        int csrId = TbCommon.bytes2Int((byte[])x, offset, length);
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            rs = this.conn.getTbComm().describeCSRReply(stmt, csrId);
        }
        return rs;
    }

    public TbResultSet toResultSet(int colCnt, int hiddenColCnt, int csrId, TbColumnDesc[] colMeta, TbStatement stmt, byte[] rowChunk) throws SQLException {
        Debug.logMethod("DataTypeConverter.toResultSet", new Object[]{new Integer(colCnt), new Integer(hiddenColCnt), new Integer(csrId), colMeta, stmt});
        int realColCnt = colCnt - hiddenColCnt;
        TbResultSet rs = TbResultSetFactory.buildResultSet(stmt, csrId, realColCnt, hiddenColCnt, rowChunk);
        this.buildColumnMetadata(colMeta, rs, colCnt);
        rs.setFetchCompleted(0);
        return rs;
    }

    public TbResultSet toResultSet(TbStatement stmt, byte[] data, BindItem item) throws SQLException {
        Debug.logMethod("DataTypeConverter.toResultSet", new Object[]{stmt, item});
        int length = item.getLength();
        int csrId = TbCommon.bytes2Int(data, 0, length);
        TbColumnDesc[] colMeta = item.getColMeta();
        if (colMeta == null) {
            throw TbError.newSQLException(-90644);
        }
        TbResultSet rs = TbResultSetFactory.buildResultSet(stmt, csrId, colMeta.length, 0, null);
        this.buildColumnMetadata(colMeta, rs, colMeta.length);
        rs.setFetchCompleted(0);
        return rs;
    }

    public TbRowId toRowId(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toRowId", new Object[]{x, Integer.toString(offset), Integer.toString(length), Integer.toString(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            switch (dataType) {
                case 15: {
                    TbRowId rowid = new TbRowId();
                    rowid.fromBytes(this.conn.getServerInfo().getServerEndian(), (byte[])x, offset);
                    return rowid;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public short toShort(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toShort", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        int value = this.toIntInternal(x, offset, length, dataType);
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw TbError.newSQLException(-590749, value);
        }
        return (short)value;
    }

    public SQLXML toSQLXML(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF) throws SQLException {
        Debug.logMethod("DataTypeConverter.toSQLXML", new Object[]{x, Integer.toString(offset), Integer.toString(length)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            switch (dataType) {
                case 13: {
                    byte[] locator = new byte[length];
                    System.arraycopy(x, offset, locator, 0, length);
                    TbClob clob = new TbClob(this.conn, locator, freeTmpLobOnEOF);
                    TbXMLInputStream stream = new TbXMLInputStream(clob);
                    return new TbSQLXML(this.conn, stream);
                }
                case 28: 
                case 32: {
                    Object xmldescObj = this.conn.getDescriptor("/O00000000000000000000000000000001");
                    Object ret = null;
                    if (xmldescObj instanceof TbStructDescriptor) {
                        ret = this.toStruct(x, offset, length, dataType, freeTmpLobOnEOF, (TbStructDescriptor)xmldescObj, null, null);
                    }
                    Object docObj = null;
                    if (ret instanceof TbStruct && ((TbStruct)ret).getNumOfFields() > 1) {
                        docObj = ((TbStruct)ret).getAttributes()[0];
                    }
                    if (!(docObj instanceof TbClob)) break;
                    TbXMLInputStream xis = new TbXMLInputStream((TbClob)docObj);
                    return new TbSQLXML(this.conn, xis);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public String toString(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF) throws SQLException {
        return this.toString(x, offset, length, dataType, -1, -1, freeTmpLobOnEOF);
    }

    public String toString(Object x, int offset, int length, int dataType, int precision, int scale, boolean freeTmpLobOnEOF) throws SQLException {
        Debug.logMethod("DataTypeConverter.toString", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType), Integer.toString(precision), Integer.toString(scale)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    return this.getDBDecodedString(data, offset, length);
                }
                case 18: 
                case 19: {
                    return this.getDBDecodedNString(data, offset, length);
                }
                case 4: {
                    return TbCommon.bytes2String(data, offset, length);
                }
                case 13: {
                    Clob clob = this.toClob(x, offset, length, dataType, freeTmpLobOnEOF);
                    String tmpClobStr = clob.getSubString(1L, (int)clob.length());
                    if (((TbLob)((Object)clob)).getIsTempLob() && freeTmpLobOnEOF) {
                        ((TbLob)((Object)clob)).free();
                    }
                    return tmpClobStr;
                }
                case 20: {
                    TbNClob nclob = (TbNClob)this.toClob(x, offset, length, dataType, freeTmpLobOnEOF);
                    String tmpNClobStr = nclob.getSubString(1L, (int)nclob.length());
                    if (nclob.getIsTempLob() && freeTmpLobOnEOF) {
                        nclob.free();
                    }
                    return tmpNClobStr;
                }
                case 12: {
                    Blob blob = this.toBlob(x, offset, length, dataType, freeTmpLobOnEOF);
                    byte[] blobBytes = blob.getBytes(1L, (int)blob.length());
                    if (((TbLob)((Object)blob)).getIsTempLob() && freeTmpLobOnEOF) {
                        ((TbLob)((Object)blob)).free();
                    }
                    return TbCommon.bytes2String(blobBytes, 0, blobBytes.length);
                }
                case 10: {
                    return this.toLongString(x, offset, length);
                }
                case 11: {
                    byte[] longBytes = this.toLongRawBytes(x, offset, length);
                    return TbCommon.bytes2String(longBytes, 0, longBytes.length);
                }
                case 1: {
                    return TbNumber.getNormalForm(data, offset, length);
                }
                case 24: {
                    return Double.toString(this.toDouble(x, offset, length, dataType));
                }
                case 23: {
                    return Float.toString(this.toFloat(x, offset, length, dataType));
                }
                case 5: {
                    TbDate tbdt = this.toTbDate(x, offset, length, dataType);
                    if (tbdt == null) {
                        return null;
                    }
                    if (this.conn.info.getNlsDatetimeFormatEnabled()) {
                        return TbDTFormatter.format(this.conn.getParsedNlsDateFormat(), tbdt);
                    }
                    return tbdt.toString();
                }
                case 7: {
                    TbTimestamp timestamp = this.toTbTimestamp(x, offset, length, dataType);
                    if (timestamp == null) {
                        return null;
                    }
                    if (this.conn.info.getNlsDatetimeFormatEnabled()) {
                        return TbDTFormatter.format(this.conn.getParsedNlsTimestampFormat(), timestamp);
                    }
                    return timestamp.toString();
                }
                case 21: {
                    TimeZone timezone = this.toTimeZoneFromBytes(data, offset, length);
                    TbTimestamp tsTZ = this.getTbTimestampTZFromBytes(data, offset, length, timezone);
                    if (tsTZ == null) {
                        return null;
                    }
                    String tzID = timezone.getID();
                    if (this.getTimeZoneIdFromBytes(data, offset, length) == ZoneInfo.TZ_ID_OFFSET.getId().intValue() && tzID.startsWith("GMT")) {
                        tzID = tzID.substring("GMT".length());
                    }
                    return tsTZ.toString() + " " + tzID;
                }
                case 22: {
                    TimeZone timezone = TimeZone.getDefault();
                    TbTimestamp tsLTZ = this.getTbTimestampLTZFromBytes(data, offset, length, timezone);
                    if (tsLTZ == null) {
                        return null;
                    }
                    return tsLTZ.toString();
                }
            }
            Object obj = this.toObject(x, offset, length, dataType, DataType.getSqlType(dataType, 0, this.conn.getMapDateToTimestamp()), precision, scale, freeTmpLobOnEOF, null, null, null);
            return obj == null ? null : obj.toString();
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public Time toTime(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toTime", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    String val1 = this.getDBDecodedString(data, offset, length);
                    return Time.valueOf(val1.trim());
                }
                case 18: 
                case 19: {
                    String val2 = this.getDBDecodedNString(data, offset, length);
                    return Time.valueOf(val2.trim());
                }
                case 5: {
                    if (length != 8) {
                        throw TbError.newSQLException(-590750, length);
                    }
                    return this.toTimeFromDate(data, offset);
                }
                case 6: {
                    if (length != 8) {
                        throw TbError.newSQLException(-590752, length);
                    }
                    return this.toTimeFromBytes(data, offset);
                }
                case 7: {
                    if (length != 12) {
                        throw TbError.newSQLException(-590751, length);
                    }
                    return this.toTimeFromTimestamp(data, offset);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    private Time toTimeFromBytes(byte[] bytes, int offset) {
        int hour = 0xFF & bytes[offset];
        int minute = 0xFF & bytes[offset + 1];
        int second = 0xFF & bytes[offset + 2];
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        cal.clear(14);
        return new Time(cal.getTimeInMillis());
    }

    private Time toTimeFromDate(byte[] bytes, int offset) {
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        cal.clear(14);
        return new Time(cal.getTimeInMillis());
    }

    private Time toTimeFromTimestamp(byte[] bytes, int offset) {
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        cal.clear(14);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        return new Time(timestamp.getTime());
    }

    public Timestamp toTimestamp(Object x, int offset, int length, int dataType) throws SQLException {
        return this.toTimestamp(x, offset, length, dataType, null);
    }

    public Timestamp toTimestamp(Object x, int offset, int length, int dataType, Calendar cal) throws SQLException {
        Debug.logMethod("DataTypeConverter.toTimestamp", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType), cal});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 2: 
                case 3: {
                    String val1 = this.getDBDecodedString(data, offset, length);
                    return Timestamp.valueOf(val1.trim());
                }
                case 18: 
                case 19: {
                    String val2 = this.getDBDecodedNString(data, offset, length);
                    return Timestamp.valueOf(val2.trim());
                }
                case 5: {
                    return this.toTimestampFromDate(data, offset, length);
                }
                case 6: {
                    return this.toTimestampFromTime(data, offset, length);
                }
                case 7: {
                    if (cal == null) {
                        return this.toTimestampFromBytes(data, offset, length);
                    }
                    return this.toTimestampFromBytes(data, offset, length, cal);
                }
                case 21: {
                    return this.toTimestampTZFromBytes(data, offset, length);
                }
                case 22: {
                    return this.toTimestampLTZFromBytes(data, offset, length);
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public TbTimestamp toTbTimestamp(Object x, int offset, int length, int dataType) throws SQLException {
        Debug.logMethod("DataTypeConverter.toTbTimestamp", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (x instanceof byte[]) {
            byte[] data = (byte[])x;
            switch (dataType) {
                case 5: {
                    if (length != 8) {
                        throw TbError.newSQLException(-590750, length);
                    }
                    byte[] dateData = new byte[12];
                    System.arraycopy(data, offset, dateData, 0, 8);
                    for (int i = 8; i < dateData.length; ++i) {
                        dateData[i] = 0;
                    }
                    TbTimestamp tsDate = new TbTimestamp(dateData);
                    return tsDate;
                }
                case 7: {
                    if (length != 12) {
                        throw TbError.newSQLException(-590751, length);
                    }
                    byte[] tsData = new byte[12];
                    System.arraycopy(data, offset, tsData, 0, 12);
                    TbTimestamp ts = new TbTimestamp(tsData);
                    return ts;
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    private Timestamp toTimestampFromBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 12) {
            throw TbError.newSQLException(-590751, length);
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.bytes2Int(bytes, offset + 8, 4);
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hour, minute, second);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    private Timestamp toTimestampFromBytes(byte[] bytes, int offset, int length, Calendar cal) throws SQLException {
        if (length != 12) {
            throw TbError.newSQLException(-590751, length);
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.bytes2Int(bytes, offset + 8, 4);
        cal.set(year, month, day, hour, minute, second);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    private Timestamp toTimestampFromTime(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 8) {
            throw TbError.newSQLException(-590752, length);
        }
        int hour = 0xFF & bytes[offset];
        int minute = 0xFF & bytes[offset + 1];
        int second = 0xFF & bytes[offset + 2];
        int nanoSec = TbCommon.bytes2Int(bytes, offset + 4, 4);
        Calendar cal = Calendar.getInstance();
        cal.set(1970, 0, 1, hour, minute, second);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    private Timestamp toTimestampFromDate(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 8) {
            throw TbError.newSQLException(-590750, length);
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = 0;
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hour, minute, second);
        Timestamp timestamp = new Timestamp(cal.getTime().getTime());
        timestamp.setNanos(nanoSec);
        return timestamp;
    }

    private int getTimeZoneIdFromBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 17) {
            throw TbError.newSQLException(-590751, length);
        }
        return TbCommon.bytes2Int(bytes, offset + 15, 2);
    }

    private TimeZone toTimeZoneFromBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 17) {
            throw TbError.newSQLException(-590751, length);
        }
        int zone_id = TbCommon.bytes2Int(bytes, offset + 15, 2);
        if (zone_id == ZoneInfo.TZ_ID_OFFSET.getId()) {
            int utc_hour = (0xFF & bytes[offset + 12]) - 100;
            int utc_min = 0xFF & bytes[offset + 13];
            NumberFormat nfTime = NumberFormat.getInstance();
            nfTime.setMinimumIntegerDigits(2);
            StringBuffer tzStr = new StringBuffer();
            tzStr.append("GMT");
            if (utc_hour >= 0) {
                tzStr.append("+");
            }
            tzStr.append(nfTime.format(utc_hour));
            tzStr.append(":");
            tzStr.append(nfTime.format(utc_min));
            return TimeZone.getTimeZone(tzStr.toString());
        }
        String timezoneName = ZoneInfo.getZoneNameById(zone_id);
        return TimeZone.getTimeZone(timezoneName);
    }

    private TbTimestamp getTbTimestampTZFromBytes(byte[] bytes, int offset, int length, TimeZone timezone) throws SQLException {
        if (length != 17) {
            throw TbError.newSQLException(-590751, length);
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.bytes2Int(bytes, offset + 8, 4);
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        calendar.set(year, month, day, hour, minute, second);
        calendar.clear(14);
        long time = calendar.getTimeInMillis();
        calendar.setTimeZone(timezone);
        calendar.setTimeInMillis(time);
        TbTimestamp ts = new TbTimestamp(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), nanoSec);
        return ts;
    }

    private TbTimestamp getTbTimestampLTZFromBytes(byte[] bytes, int offset, int length, TimeZone timezone) throws SQLException {
        if (length != 12) {
            throw TbError.newSQLException(-590751, length);
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.bytes2Int(bytes, offset + 8, 4);
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        calendar.set(year, month, day, hour, minute, second);
        calendar.clear(14);
        long time = calendar.getTimeInMillis();
        calendar.setTimeZone(timezone);
        calendar.setTimeInMillis(time);
        bytes = new byte[12];
        int years = calendar.get(1);
        bytes[0] = (byte)(years / 100 + 100);
        bytes[1] = (byte)(years % 100 + 100);
        bytes[2] = (byte)(calendar.get(2) + 1);
        bytes[3] = (byte)calendar.get(5);
        bytes[4] = (byte)calendar.get(11);
        bytes[5] = (byte)calendar.get(12);
        bytes[6] = (byte)calendar.get(13);
        bytes[7] = 0;
        TbCommon.int2Bytes(nanoSec, bytes, 8, 4);
        TbTimestamp ts = new TbTimestamp(bytes);
        return ts;
    }

    private Timestamp toTimestampTZFromBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 17) {
            throw TbError.newSQLException(-590751, length);
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.bytes2Int(bytes, offset + 8, 4);
        Calendar utcCalendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        utcCalendar.set(year, month, day, hour, minute, second);
        utcCalendar.clear(14);
        Timestamp result = new Timestamp(utcCalendar.getTimeInMillis());
        result.setNanos(nanoSec);
        return result;
    }

    private Timestamp toTimestampLTZFromBytes(byte[] bytes, int offset, int length) throws SQLException {
        if (length != 12) {
            throw TbError.newSQLException(-590751, "" + length);
        }
        int db_century = 0xFF & bytes[offset + 0];
        int db_year = 0xFF & bytes[offset + 1];
        int db_month = 0xFF & bytes[offset + 2];
        int day = 0xFF & bytes[offset + 3];
        int hour = 0xFF & bytes[offset + 4];
        int minute = 0xFF & bytes[offset + 5];
        int second = 0xFF & bytes[offset + 6];
        int year = (db_century - 100) * 100 + (db_year - 100);
        int month = db_month - 1;
        int nanoSec = TbCommon.bytes2Int(bytes, offset + 8, 4);
        Calendar calendar = Calendar.getInstance(ZoneInfo.TZ_UTC);
        calendar.set(year, month, day, hour, minute, second);
        long time = calendar.getTimeInMillis();
        calendar.setTimeInMillis(time);
        calendar.clear(14);
        Timestamp localTimestamp = new Timestamp(calendar.getTimeInMillis());
        localTimestamp.setNanos(nanoSec);
        return localTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream toUnicodeStream(Object x, int offset, int length, int dataType, boolean freeTmpLobOnEOF) throws SQLException {
        Debug.logMethod("DataTypeConverter.toUnicodeStream", new Object[]{x, Integer.toString(offset), Integer.toString(length), DataType.getDBTypeName(dataType)});
        if (length <= 0 || x == null) {
            return null;
        }
        if (DataType.isCharacterCategory(dataType)) {
            String value = this.toString(x, offset, length, dataType, freeTmpLobOnEOF);
            return new ByteArrayInputStream(value.getBytes());
        }
        if (x instanceof byte[]) {
            switch (dataType) {
                case 10: {
                    String longData;
                    byte[] locator = new byte[length];
                    System.arraycopy(x, offset, locator, 0, length);
                    TbConnection tbConnection = this.conn;
                    synchronized (tbConnection) {
                        longData = this.conn.getTbComm().readLong(locator);
                    }
                    return new ByteArrayInputStream(longData.getBytes());
                }
            }
            throw TbError.newSQLException(-90612, DataType.getDBTypeName(dataType));
        }
        throw TbError.newSQLException(-90612, x.toString());
    }

    public static String tbBase64Encode(byte[] rawBytes) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < rawBytes.length - 2; i += 3) {
            sb.append(DataTypeConverter.encode(rawBytes[i] >> 2 & 0x3F));
            sb.append(DataTypeConverter.encode((rawBytes[i] & 3) << 4 | (rawBytes[i + 1] & 0xF0) >> 4));
            sb.append(DataTypeConverter.encode((rawBytes[i + 1] & 0xF) << 2 | (rawBytes[i + 2] & 0xC0) >> 6));
            sb.append(DataTypeConverter.encode(rawBytes[i + 2] & 0x3F));
        }
        if (i < rawBytes.length) {
            sb.append(DataTypeConverter.encode(rawBytes[i] >> 2 & 0x3F));
            if (i == rawBytes.length - 1) {
                sb.append(DataTypeConverter.encode((rawBytes[i] & 3) << 4));
                sb.append('=');
            } else {
                sb.append(DataTypeConverter.encode((rawBytes[i] & 3) << 4 | (rawBytes[i + 1] & 0xF0) >> 4));
                sb.append(DataTypeConverter.encode((rawBytes[i + 1] & 0xF) << 2));
            }
            sb.append('=');
        }
        return sb.toString();
    }

    private static char encode(int i) {
        char[] encodeMap = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        return encodeMap[i];
    }

    public static byte[] tbBase64Decode(byte[] in) {
        int i = 0;
        while (i < in.length && pr2six[in[i++]] <= 63) {
        }
        int nprbytes = i - 1;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        i = 0;
        while (nprbytes > 4) {
            buffer.write(pr2six[in[i]] << 2 | pr2six[in[i + 1]] >> 4);
            buffer.write(pr2six[in[i + 1]] << 4 | pr2six[in[i + 2]] >> 2);
            buffer.write(pr2six[in[i + 2]] << 6 | pr2six[in[i + 3]]);
            i += 4;
            nprbytes -= 4;
        }
        if (nprbytes > 1) {
            buffer.write(pr2six[in[i]] << 2 | pr2six[in[i + 1]] >> 4);
        }
        if (nprbytes > 2) {
            buffer.write(pr2six[in[i + 1]] << 4 | pr2six[in[i + 2]] >> 2);
        }
        if (nprbytes > 3) {
            buffer.write(pr2six[in[i + 2]] << 6 | pr2six[in[i + 3]]);
        }
        return buffer.toByteArray();
    }

    public static byte[] base64Decode2(String data) throws Exception {
        int[] tbl = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        byte[] bytes = data.getBytes("ASCII");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int i = 0;
        while (i < bytes.length) {
            int b = 0;
            if (tbl[bytes[i]] == -1) {
                ++i;
                continue;
            }
            b = (tbl[bytes[i]] & 0xFF) << 18;
            int num = 0;
            if (i + 1 < bytes.length && tbl[bytes[i + 1]] != -1) {
                b |= (tbl[bytes[i + 1]] & 0xFF) << 12;
                ++num;
            }
            if (i + 2 < bytes.length && tbl[bytes[i + 2]] != -1) {
                b |= (tbl[bytes[i + 2]] & 0xFF) << 6;
                ++num;
            }
            if (i + 3 < bytes.length && tbl[bytes[i + 3]] != -1) {
                b |= tbl[bytes[i + 3]] & 0xFF;
                ++num;
            }
            while (num > 0) {
                int c = (b & 0xFF0000) >> 16;
                buffer.write((char)c);
                b <<= 8;
                --num;
            }
            i += 4;
        }
        return buffer.toByteArray();
    }

    public static byte[] base64Decode(byte[] in) throws Exception {
        int WITHSPACE = 64;
        int EQUALS = 65;
        int INVALID = 66;
        int buf = 0;
        int iter = 0;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        block5: for (int i = 0; i < in.length; ++i) {
            byte c = d[in[i]];
            switch (c) {
                case 64: {
                    continue block5;
                }
                case 66: {
                    return null;
                }
                case 65: {
                    continue block5;
                }
                default: {
                    buf = buf << 6 | c;
                    if (++iter != 4) continue block5;
                    buffer.write((byte)(buf >> 16 & 0xFF));
                    buffer.write((byte)(buf >> 8 & 0xFF));
                    buffer.write((byte)(buf & 0xFF));
                    buf = 0;
                    iter = 0;
                }
            }
        }
        if (iter == 3) {
            buffer.write((byte)(buf >> 10 & 0xFF));
            buffer.write((byte)(buf >> 2 & 0xFF));
        } else if (iter == 2) {
            buffer.write((byte)(buf >> 4 & 0xFF));
        }
        return buffer.toByteArray();
    }

    class ObjInstBldCtx {
        TbStructDescriptor desc;
        Object[] values;
        int attrProcessed;

        ObjInstBldCtx(TbStructDescriptor desc) {
            this.desc = desc;
            this.values = new Object[desc.getNumOfFields()];
            this.attrProcessed = 0;
        }
    }
}

