/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.err.TbError;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class DataType {
    public static final int NONE = 0;
    public static final int NUMBER = 1;
    public static final int CHAR = 2;
    public static final int VARCHAR = 3;
    public static final int RAW = 4;
    public static final int DATE = 5;
    public static final int TIME = 6;
    public static final int TIMESTAMP = 7;
    public static final int TIMESTAMP_TZ = 21;
    public static final int TIMESTAMP_LTZ = 22;
    public static final int ITV_YTM = 8;
    public static final int ITV_DTS = 9;
    public static final int LONG = 10;
    public static final int LONGRAW = 11;
    public static final int BLOB = 12;
    public static final int CLOB = 13;
    public static final int BFILE = 14;
    public static final int ROWID = 15;
    public static final int CURSOR = 16;
    public static final int UNKNOWN = 17;
    public static final int NCHAR = 18;
    public static final int NVARCHAR = 19;
    public static final int NCLOB = 20;
    public static final int BIN_FLOAT = 23;
    public static final int BIN_DOUBLE = 24;
    public static final int BOOLEAN = 25;
    public static final int PLS_INT = 26;
    public static final int BIN_INT = 27;
    public static final int RECORD = 28;
    public static final int VARRAY = 29;
    public static final int TABLE = 30;
    public static final int IDX_BY_TBL = 31;
    public static final int OBJECT = 32;
    public static final int LGEOMETRY = 1;
    public static final int LXML = 2;
    public static final int LPIVOT = 3;

    private DataType() {
    }

    public static void checkValidDataType(int dataType) throws SQLException {
        switch (dataType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                break;
            }
            default: {
                throw TbError.newSQLException(-590703, Integer.toString(dataType));
            }
        }
    }

    public static int getDataType(int sqlType) throws SQLException {
        switch (sqlType) {
            case -7: 
            case 1: {
                return 2;
            }
            case -4: 
            case -3: 
            case -2: {
                return 4;
            }
            case -1: 
            case 12: {
                return 3;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 1;
            }
            case 91: 
            case 92: {
                return 5;
            }
            case 93: {
                return 7;
            }
            case 2004: {
                return 12;
            }
            case 2005: {
                return 13;
            }
            case -17: 
            case -10: {
                return 16;
            }
            case 101: {
                return 24;
            }
            case 100: {
                return 23;
            }
            case -15: {
                return 18;
            }
            case -9: {
                return 19;
            }
            case 2011: {
                return 13;
            }
            case 2009: {
                return 13;
            }
            case 0: {
                return 3;
            }
            case 2003: {
                return 29;
            }
            case 2002: {
                return 32;
            }
            case -2003: {
                return 30;
            }
        }
        throw TbError.newSQLException(-590704, Integer.toString(sqlType));
    }

    public static int toIntDataType(String dataType) throws SQLException {
        if (dataType.equals("CHAR")) {
            return 2;
        }
        if (dataType.equals("VARCHAR") || dataType.equals("VARCHAR2")) {
            return 3;
        }
        if (dataType.equals("NUMBER")) {
            return 1;
        }
        if (dataType.equals("DATE")) {
            return 5;
        }
        if (dataType.equals("TIME")) {
            return 6;
        }
        if (dataType.equals("TIMESTAMP")) {
            return 7;
        }
        if (dataType.equals("INTERVAL YEAR TO MONTH")) {
            return 8;
        }
        if (dataType.equals("INTERVAL DAY TO SECOND")) {
            return 9;
        }
        if (dataType.equals("RAW")) {
            return 4;
        }
        if (dataType.equals("GEOMETRY")) {
            return 12;
        }
        if (dataType.equals("BLOB")) {
            return 12;
        }
        if (dataType.equals("XMLTYPE")) {
            return 13;
        }
        if (dataType.equals("CLOB")) {
            return 13;
        }
        if (dataType.equals("BINARY_DOUBLE")) {
            return 24;
        }
        if (dataType.equals("BINARY_FLOAT")) {
            return 23;
        }
        if (dataType.equals("BFILE")) {
            return 14;
        }
        if (dataType.equals("LONG")) {
            return 10;
        }
        if (dataType.equals("LONG RAW")) {
            return 11;
        }
        if (dataType.equals("ROWID")) {
            return 15;
        }
        if (dataType.equals("NCHAR")) {
            return 18;
        }
        if (dataType.equals("NVARCHAR")) {
            return 19;
        }
        if (dataType.equals("NCLOB")) {
            return 20;
        }
        if (dataType.equals("CURSOR")) {
            return 16;
        }
        if (dataType.equals("VARRAY")) {
            return 29;
        }
        if (dataType.equals("STRUCT")) {
            return 28;
        }
        if (dataType.equals("TABLE")) {
            return 30;
        }
        return 32;
    }

    public static String getDataTypeClassName(int dataType) throws SQLException {
        switch (dataType) {
            case 1: {
                return "java.math.BigDecimal";
            }
            case 24: {
                return "java.lang.Double";
            }
            case 23: {
                return "java.lang.Float";
            }
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return "java.lang.String";
            }
            case 5: {
                return "java.sql.Date";
            }
            case 6: {
                return "java.sql.Time";
            }
            case 7: 
            case 21: 
            case 22: {
                return "java.sql.Timestamp";
            }
            case 4: 
            case 11: {
                return "byte[]";
            }
            case 15: {
                return "com.tmax.tibero.jdbc.TbRowId";
            }
            case 12: {
                return "java.sql.Blob";
            }
            case 20: {
                return "java.sql.NClob";
            }
            case 13: {
                return "java.sql.Clob";
            }
            case 16: {
                return "java.sql.ResultSet";
            }
            case 9: {
                return "com.tmax.tibero.jdbc.TbIntervalDts";
            }
            case 8: {
                return "com.tmax.tibero.jdbc.TbIntervalYtm";
            }
            case 29: {
                return "java.sql.Array";
            }
            case 28: 
            case 32: {
                return "java.lang.Object";
            }
            case 30: {
                return "java.sql.Array";
            }
        }
        throw TbError.newSQLException(-590703, Integer.toString(dataType));
    }

    public static String getDBTypeName(int dataType) throws SQLException {
        return DataType.getDBTypeName(dataType, 0);
    }

    public static String getDBTypeName(int dataType, int prec) throws SQLException {
        switch (dataType) {
            case 2: {
                return "CHAR";
            }
            case 3: {
                return "VARCHAR2";
            }
            case 1: {
                return "NUMBER";
            }
            case 5: {
                return "DATE";
            }
            case 6: {
                return "TIME";
            }
            case 21: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case 22: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case 7: {
                return "TIMESTAMP";
            }
            case 8: {
                return "INTERVAL YEAR TO MONTH";
            }
            case 9: {
                return "INTERVAL DAY TO SECOND";
            }
            case 4: {
                return "RAW";
            }
            case 12: {
                if (1 == prec) {
                    return "GEOMETRY";
                }
                if (3 == prec) {
                    return "PIVOT";
                }
                return "BLOB";
            }
            case 13: {
                if (2 == prec) {
                    return "XMLTYPE";
                }
                return "CLOB";
            }
            case 24: {
                return "BINARY_DOUBLE";
            }
            case 23: {
                return "BINARY_FLOAT";
            }
            case 14: {
                return "BFILE";
            }
            case 10: {
                return "LONG";
            }
            case 11: {
                return "LONG RAW";
            }
            case 15: {
                return "ROWID";
            }
            case 18: {
                return "NCHAR";
            }
            case 19: {
                return "NVARCHAR";
            }
            case 20: {
                return "NCLOB";
            }
            case 16: {
                return "CURSOR";
            }
            case 29: {
                return "VARRAY";
            }
            case 28: {
                return "STRUCT";
            }
            case 32: {
                return "OBJECT";
            }
            case 30: {
                return "TABLE";
            }
        }
        throw TbError.newSQLException(-590703, Integer.toString(dataType));
    }

    public static int getSqlType(int dataType) throws SQLException {
        return DataType.getSqlType(dataType, 0);
    }

    public static int getSqlType(int dataType, int precision) throws SQLException {
        return DataType.getSqlType(dataType, 0, true);
    }

    public static int getSqlType(int dataType, int precision, boolean mapDateToTimestamp) throws SQLException {
        switch (dataType) {
            case 0: {
                return 0;
            }
            case 18: {
                return -15;
            }
            case 2: {
                return 1;
            }
            case 19: {
                return -9;
            }
            case 3: {
                return 12;
            }
            case 1: {
                return 2;
            }
            case 24: {
                return 101;
            }
            case 23: {
                return 100;
            }
            case 5: {
                if (mapDateToTimestamp) {
                    return 93;
                }
                return 91;
            }
            case 6: {
                return 92;
            }
            case 7: 
            case 21: 
            case 22: {
                return 93;
            }
            case 8: 
            case 9: {
                return 1111;
            }
            case 15: {
                return 1;
            }
            case 4: {
                return -3;
            }
            case 12: {
                if (1 == precision) {
                    return 26;
                }
                if (3 == precision) {
                    return 27;
                }
                return 2004;
            }
            case 20: {
                return 2011;
            }
            case 13: {
                if (2 == precision) {
                    return 2009;
                }
                return 2005;
            }
            case 10: {
                return -1;
            }
            case 11: {
                return -4;
            }
            case 16: {
                return -17;
            }
            case 29: {
                return 2003;
            }
            case 30: {
                return -2003;
            }
            case 28: 
            case 32: {
                return 2002;
            }
        }
        throw TbError.newSQLException(-590703, Integer.toString(dataType));
    }

    public static int getSqlType(Object x) throws SQLException {
        if (x == null) {
            return 1;
        }
        if (x instanceof String) {
            return 12;
        }
        if (x instanceof BigDecimal) {
            return 2;
        }
        if (x instanceof Integer) {
            return 4;
        }
        if (x instanceof Short) {
            return 5;
        }
        if (x instanceof Long) {
            return -5;
        }
        if (x instanceof Float) {
            return 7;
        }
        if (x instanceof Double) {
            return 8;
        }
        if (x instanceof byte[]) {
            return -3;
        }
        if (x instanceof Date || x instanceof TbDate) {
            return 91;
        }
        if (x instanceof Time) {
            return 92;
        }
        if (x instanceof Timestamp || x instanceof TbTimestamp) {
            return 93;
        }
        if (x instanceof Boolean) {
            return -7;
        }
        if (x instanceof NClob) {
            return 2011;
        }
        if (x instanceof Clob) {
            return 2005;
        }
        if (x instanceof Blob) {
            return 2004;
        }
        if (x instanceof Array) {
            return 2003;
        }
        if (x instanceof Struct || x instanceof SQLData) {
            return 2002;
        }
        if (x instanceof Ref) {
            return 2006;
        }
        if (x instanceof URL) {
            return 70;
        }
        if (x instanceof SQLXML) {
            return 2009;
        }
        if (x instanceof RowId) {
            return -8;
        }
        throw TbError.newSQLException(-590703, x.toString());
    }

    public static boolean isCharacterCategory(int dataType) {
        return dataType == 2 || dataType == 3;
    }

    public static boolean isDateCategory(int dataType) {
        return dataType == 5 || dataType == 6 || dataType == 7;
    }

    public static boolean isLobCategory(int dataType) {
        return dataType == 13 || dataType == 12 || dataType == 20;
    }

    public static boolean isLocatorCategory(int dataType) {
        return dataType == 13 || dataType == 12 || dataType == 20 || dataType == 10 || dataType == 11;
    }

    public static boolean isLongCategory(int dataType) {
        return dataType == 10 || dataType == 11;
    }

    public static boolean isNationalCategory(int dataType) {
        return dataType == 18 || dataType == 19;
    }

    public static boolean isNumberCategory(int dataType) {
        return dataType == 1;
    }

    public static boolean isBinaryDoubleCategory(int dataType) {
        return dataType == 24;
    }

    public static boolean isBinaryFloatCategory(int dataType) {
        return dataType == 23;
    }

    public static boolean isUDTCategory(int dataType) {
        return dataType == 32 || dataType == 28 || dataType == 29 || dataType == 30 || dataType == 31;
    }
}

