/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import java.sql.SQLException;

public class BindItem {
    private int paramMode = 0;
    private int sqlType = 0;
    private int length;
    private TbColumnDesc[] colMeta;
    private TbTypeDescriptor typeDesc;
    private String typeName;

    public void clone(BindItem dest) {
        dest.paramMode = this.paramMode;
        dest.sqlType = this.sqlType;
        dest.length = this.length;
        dest.typeName = this.typeName;
        dest.typeDesc = this.typeDesc;
    }

    public TbColumnDesc[] getColMeta() {
        return this.colMeta;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public int getLength() {
        return this.length;
    }

    public int getParamMode() {
        return this.paramMode;
    }

    public TbTypeDescriptor getTypeDescriptor() {
        return this.typeDesc;
    }

    public boolean isDFRParameter() {
        return this.paramMode == 8;
    }

    public boolean isINOUTParameter() {
        return this.paramMode == 4;
    }

    public boolean isINParameter() {
        return this.paramMode == 1 || this.paramMode == 4;
    }

    public boolean isOUTParameter() {
        return this.paramMode == 2 || this.paramMode == 4;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void reset() {
        if (this.colMeta != null) {
            for (int i = 0; i < this.colMeta.length; ++i) {
                this.colMeta[i] = null;
            }
            this.colMeta = null;
        }
        if (this.typeDesc != null) {
            this.typeDesc = null;
        }
    }

    public void reuse() {
        this.paramMode = 0;
        this.sqlType = 0;
        this.typeName = null;
        if (this.colMeta != null) {
            for (int i = 0; i < this.colMeta.length; ++i) {
                this.colMeta[i] = null;
            }
            this.colMeta = null;
        }
        if (this.typeDesc != null) {
            this.typeDesc = null;
        }
    }

    public void set(int kind, int sqlType) {
        this.setParamMode(kind);
        this.sqlType = sqlType;
    }

    public void set(int kind, int sqlType, int length) throws SQLException {
        this.setParamMode(kind);
        this.sqlType = sqlType;
        this.length = length;
    }

    public void set(int sqlType1, int len, TbColumnDesc[] meta, TbTypeDescriptor desc) throws SQLException {
        this.paramMode = 2;
        this.sqlType = sqlType1;
        this.length = len;
        this.colMeta = meta;
        this.typeDesc = desc;
    }

    public void set(int sqlType1, int len, TbColumnDesc[] meta, TbTypeDescriptor desc, String typeName) throws SQLException {
        this.paramMode = 2;
        this.sqlType = sqlType1;
        this.length = len;
        this.colMeta = meta;
        this.typeDesc = desc;
        this.typeName = typeName;
    }

    private void setParamMode(int mode) {
        this.paramMode = this.paramMode == 1 && mode == 2 || this.paramMode == 2 && mode == 1 ? 4 : mode;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void requestUdtMeta(int sqlType, TbConnection conn) throws SQLException {
        String user = conn.info.getUser();
        String[] tokens = this.typeName.split("[.]{1}");
        if (tokens.length != 1) {
            if (tokens.length == 2) {
                user = tokens[0];
                this.typeName = tokens[1];
            } else {
                throw TbError.newSQLException(-90649);
            }
        }
        switch (sqlType) {
            case 2002: {
                this.typeDesc = TbStructDescriptor.lookupUdtMeta(user, this.typeName, conn);
                break;
            }
            case -2003: 
            case 2003: {
                this.typeDesc = TbArrayDescriptor.lookupUdtMeta(user, this.typeName, conn);
            }
        }
    }

    public void setTypeDescriptor(TbTypeDescriptor desc) {
        this.typeDesc = desc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(96);
        sb.append(super.toString()).append("[mode=").append(this.paramMode).append("/sqlType=").append(this.sqlType).append("/length=").append(this.length).append("/colMeta=").append(this.colMeta).append("/typeDescriptor=").append(this.typeDesc).append("/typeName=").append(this.typeName).append(']');
        return sb.toString();
    }
}

