/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class BindData {
    protected BindItem[] bindItems = null;
    protected int deferredParamCnt = 0;

    public BindData() {
    }

    public BindData(int paramCount) throws SQLException {
        if (paramCount < 0) {
            throw TbError.newSQLException(-590731);
        }
        if (this.bindItems == null) {
            this.initialize(paramCount);
        }
    }

    private void checkParameterIndex(int pos) throws SQLException {
        if (this.bindItems == null || pos < 0 || pos >= this.bindItems.length) {
            throw TbError.newSQLException(-90609);
        }
    }

    public void clearDFRParameter() throws SQLException {
        this.deferredParamCnt = 0;
    }

    public void clone(BindData dest) throws SQLException {
        int paramCount = this.bindItems.length;
        dest.initialize(paramCount);
        for (int i = 0; i < paramCount; ++i) {
            this.bindItems[i].clone(dest.bindItems[i]);
        }
        dest.deferredParamCnt = this.deferredParamCnt;
    }

    public BindItem[] getBindItems() {
        return this.bindItems;
    }

    public BindItem getBindItem(int pos) throws SQLException {
        this.checkParameterIndex(pos);
        return this.bindItems[pos];
    }

    public int getDFRParameterCnt() {
        return this.deferredParamCnt;
    }

    public int getInOutParameterCnt() {
        int cnt = 0;
        for (int i = 0; i < this.bindItems.length; ++i) {
            if (!this.bindItems[i].isOUTParameter() || !this.bindItems[i].isINParameter()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getInParameterCnt() {
        int cnt = 0;
        for (int i = 0; i < this.bindItems.length; ++i) {
            if (!this.bindItems[i].isINParameter()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getOutParameterCnt() {
        int cnt = 0;
        for (int i = 0; i < this.bindItems.length; ++i) {
            if (!this.bindItems[i].isOUTParameter()) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getParameterCnt() {
        return this.bindItems.length;
    }

    private void initialize(int paramCount) {
        this.bindItems = new BindItem[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.bindItems[i] = new BindItem();
        }
    }

    public void insertDFRLiteral(int pos, int sqlType, int length) throws SQLException {
        int paramCount = this.bindItems.length;
        for (int i = paramCount - 1; i > pos; --i) {
            this.bindItems[i] = this.bindItems[i - 1];
        }
        this.bindItems[pos] = new BindItem();
        this.bindItems[pos].set(8, sqlType, length);
        ++this.deferredParamCnt;
    }

    public boolean isInParameterOn(int pos) throws SQLException {
        this.checkParameterIndex(pos);
        return this.bindItems[pos].isINParameter();
    }

    public boolean isOutParameterOn(int pos) throws SQLException {
        this.checkParameterIndex(pos);
        return this.bindItems[pos].isOUTParameter();
    }

    public String getOutParameterTypeName(int pos) throws SQLException {
        this.checkParameterIndex(pos);
        return this.bindItems[pos].getTypeName();
    }

    public void removeDFRLiteral(int[] pos) {
        int paramIndex = 0;
        int paramCount = this.bindItems.length - pos.length;
        BindItem[] temp = this.bindItems;
        this.bindItems = new BindItem[paramCount];
        for (int i = 0; i < temp.length; ++i) {
            int j;
            for (j = 0; j < pos.length && i != pos[j]; ++j) {
            }
            if (j != pos.length) continue;
            this.bindItems[paramIndex++] = temp[i];
        }
    }

    public void reset() {
        if (this.bindItems == null) {
            return;
        }
        for (int i = 0; i < this.bindItems.length; ++i) {
            this.bindItems[i].reset();
            this.bindItems[i] = null;
        }
        this.bindItems = null;
    }

    public void resize(int paramCount) {
        if (this.bindItems == null) {
            this.initialize(paramCount);
        } else if (paramCount > this.bindItems.length) {
            BindItem[] temp = this.bindItems;
            this.bindItems = new BindItem[paramCount];
            System.arraycopy(temp, 0, this.bindItems, 0, temp.length);
            for (int i = temp.length; i < paramCount; ++i) {
                this.bindItems[i] = new BindItem();
            }
        } else if (paramCount < this.bindItems.length) {
            BindItem[] temp = this.bindItems;
            this.bindItems = new BindItem[paramCount];
            System.arraycopy(temp, 0, this.bindItems, 0, paramCount);
        }
    }

    public void reuse() {
        if (this.bindItems == null) {
            return;
        }
        for (int i = 0; i < this.bindItems.length; ++i) {
            this.bindItems[i].reuse();
        }
        this.deferredParamCnt = 0;
    }

    public void set(BindData source) throws SQLException {
        int paramCount = source.getParameterCnt();
        if (this.bindItems == null) {
            this.initialize(paramCount);
        } else {
            this.reuse();
        }
        System.arraycopy(source.bindItems, 0, this.bindItems, 0, paramCount);
        this.deferredParamCnt = source.getDFRParameterCnt();
    }

    public void setDFRParam(int pos, int sqlType, int length) throws SQLException {
        this.checkParameterIndex(pos);
        this.bindItems[pos].set(8, sqlType, length);
        ++this.deferredParamCnt;
    }

    public void setINParam(int pos, int sqlType, int length) throws SQLException {
        this.checkParameterIndex(pos);
        this.bindItems[pos].set(1, sqlType, length);
    }

    public void setOUTParam(int pos, int sqlType) throws SQLException {
        this.checkParameterIndex(pos);
        this.bindItems[pos].set(2, sqlType);
    }

    public void setOUTParam(int pos, int sqlType, String typeName) throws SQLException {
        this.checkParameterIndex(pos);
        this.bindItems[pos].set(2, sqlType);
        this.bindItems[pos].setTypeName(typeName);
    }

    public void setOUTParam(int pos, int sqlType, String typeName, TbConnection conn) throws SQLException {
        this.checkParameterIndex(pos);
        this.bindItems[pos].set(2, sqlType);
        this.bindItems[pos].setTypeName(typeName);
        this.bindItems[pos].requestUdtMeta(sqlType, conn);
    }
}

