/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.comm.TbCommType4;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbXAComm;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbXAException;
import com.tmax.tibero.jdbc.ext.TbXid;
import com.tmax.tibero.jdbc.msg.TbMsgSend;
import com.tmax.tibero.jdbc.msg.TbMsgXaRecoverReply;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;
import javax.transaction.xa.Xid;

public class TbXACommType4
extends TbCommType4
implements TbXAComm {
    public TbXACommType4(TbConnection conn) {
        super(conn);
        Debug.logMethod("TbXACommType4", new Object[]{conn});
    }

    private void deserializeXid(byte[] xidBytes, TbXid[] xids) throws TbXAException {
        int offset = 0;
        int formatId = 0;
        int gtLen = 0;
        int bqLen = 0;
        byte[] gtrid = null;
        byte[] bqual = null;
        int xidCount = xids.length;
        for (int i = 0; i < xidCount; ++i) {
            formatId = TbCommon.bytes2Int(xidBytes, offset, 8);
            gtLen = TbCommon.bytes2Int(xidBytes, offset += 8, 8);
            gtrid = new byte[gtLen];
            bqLen = TbCommon.bytes2Int(xidBytes, offset += 8, 8);
            bqual = new byte[bqLen];
            System.arraycopy(xidBytes, offset += 8, gtrid, 0, gtLen);
            System.arraycopy(xidBytes, offset += gtLen, bqual, 0, bqLen);
            offset += bqLen;
            offset += TbXid.SERIALIZED_SIZE - 24 - gtLen - bqLen;
            xids[i] = new TbXid(formatId, gtrid, bqual);
        }
    }

    private void doXAErrorReply(int errorCode, TbMsg msg) throws TbXAException, SQLException {
        SQLException ex = this.getErrorMessage(errorCode, msg);
        throw this.processException(ex);
    }

    private int doXAForgetErrorReply(TbMsg msg) throws TbXAException {
        Debug.logMethod("TbXAComm.doXAForgetErrorReply", new Object[]{this.conn});
        int ret = -3;
        try {
            SQLException ex = this.getErrorMessage(-90542, msg);
            ret = this.mappingXAErrorCode(ex.getErrorCode());
            if (ret != 3 && ret != -4) {
                throw new TbXAException(ret, ex.getMessage());
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return ret;
    }

    private int doXAPrepareErrorReply(TbMsg msg) throws TbXAException {
        Debug.logMethod("TbXAComm.doXAPrepareErrorReply", new Object[]{this.conn});
        int ret = -3;
        try {
            SQLException ex = this.getErrorMessage(-90529, msg);
            ret = this.mappingXAErrorCode(ex.getErrorCode());
            if (ret != 3 && ret != -4) {
                throw new TbXAException(ret, ex.getMessage());
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return ret;
    }

    private Xid[] doXARecoverOK(TbMsgXaRecoverReply replyMsg) throws TbXAException {
        Debug.logMethod("TbXAComm.doXARecoverOK", new Object[]{this.conn});
        try {
            int xidCount = replyMsg.xidCount;
            Xid[] xids = new TbXid[xidCount];
            byte[] xidBytes = replyMsg.xids;
            int len = xidBytes.length;
            if (len != xidCount * TbXid.SERIALIZED_SIZE) {
                throw TbError.newSQLException(-590730);
            }
            if (xidCount > 0) {
                this.deserializeXid(xidBytes, (TbXid[])xids);
            }
            return xids;
        }
        catch (SQLException e) {
            throw this.processException(e);
        }
    }

    private int mappingXAErrorCode(int code) {
        switch (code) {
            case -25001: {
                return -6;
            }
            case -25005: {
                return -5;
            }
            case -25002: {
                return -4;
            }
            case -25007: {
                return 3;
            }
            case -25008: {
                return -8;
            }
            case -25010: {
                return 7;
            }
            case -25011: {
                return 6;
            }
            case -25012: {
                return 5;
            }
            case -25009: {
                return -3;
            }
            case -25003: {
                return -9;
            }
            case -25004: {
                return -2;
            }
            case -25006: {
                return 100;
            }
            case -25013: {
                return 4;
            }
        }
        if (code <= -90400 && code > -90500) {
            return -7;
        }
        return -3;
    }

    private TbXAException processException(SQLException se) {
        int errCode = se.getErrorCode();
        TbXAException xae = new TbXAException(this.mappingXAErrorCode(errCode), se.getMessage());
        xae.initCause(se);
        return xae;
    }

    private void serializeXid(Xid xid, byte[] xidInternal) {
        int offset = 0;
        int formatId = xid.getFormatId();
        byte[] gt = xid.getGlobalTransactionId();
        byte[] bq = xid.getBranchQualifier();
        int realDataSize = gt.length + bq.length;
        TbCommon.long2Bytes(formatId, xidInternal, offset, 8);
        TbCommon.long2Bytes(gt.length, xidInternal, offset += 8, 8);
        TbCommon.long2Bytes(bq.length, xidInternal, offset += 8, 8);
        System.arraycopy(gt, 0, xidInternal, offset += 8, gt.length);
        System.arraycopy(bq, 0, xidInternal, offset += gt.length, bq.length);
        offset += bq.length;
        if (realDataSize < TbXid.DATA_SIZE) {
            for (int i = 0; i < TbXid.DATA_SIZE - realDataSize; ++i) {
                xidInternal[offset] = 0;
            }
        }
    }

    @Override
    public void xaCommit(Xid xid, boolean bool) throws TbXAException {
        Debug.logMethod("TbXAComm.xaCommit", new Object[]{this.conn, xid, new Boolean(bool)});
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, xidInternal);
        int flag = bool ? 0x40000000 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 4, flag, xidInternal, xidInternal.length, 0);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90530, replyMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + replyMsg.getMsgType());
            }
            catch (SQLException e) {
                throw this.processException(e);
            }
        }
    }

    @Override
    public void xaEnd(Xid xid, int flag) throws TbXAException {
        Debug.logMethod("TbXAComm.xaEnd", new Object[]{this.conn, xid, Integer.toString(flag)});
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, xidInternal);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 1, flag, xidInternal, xidInternal.length, 0);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90528, replyMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + replyMsg.getMsgType());
            }
            catch (SQLException e) {
                throw this.processException(e);
            }
        }
    }

    @Override
    public int xaForget(Xid xid) throws TbXAException {
        Debug.logMethod("TbXAComm.xaForget", new Object[]{this.conn, xid});
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, xidInternal);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 5, 0, xidInternal, xidInternal.length, 0);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        return 0;
                    }
                    case 76: {
                        return this.doXAForgetErrorReply(replyMsg);
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + replyMsg.getMsgType());
            }
            catch (SQLException e) {
                throw this.processException(e);
            }
        }
    }

    @Override
    public void xaOpen() throws SQLException {
        Debug.logMethod("TbXAComm.xaOpen", new Object[]{this.conn});
        TbMsg replyMsg = null;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.XA_OPEN(this.stream, 0, 500, 60, 0);
            replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    return;
                }
                case 76: {
                    return;
                }
            }
            throw TbError.newSQLException(-90402, replyMsg.getMsgType());
        }
    }

    @Override
    public int xaPrepare(Xid xid) throws TbXAException {
        Debug.logMethod("TbXAComm.xaPrepare", new Object[]{this.conn, xid});
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, xidInternal);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 3, 0, xidInternal, xidInternal.length, 0);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        return 0;
                    }
                    case 76: {
                        return this.doXAPrepareErrorReply(replyMsg);
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + replyMsg.getMsgType());
            }
            catch (SQLException e) {
                throw this.processException(e);
            }
        }
    }

    @Override
    public Xid[] xaRecover(int flag) throws TbXAException {
        Debug.logMethod("TbXAComm.xaRecover", new Object[]{this.conn, Integer.toString(flag)});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA_RECOVER(this.stream);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 70: {
                        return this.doXARecoverOK((TbMsgXaRecoverReply)replyMsg);
                    }
                    case 76: {
                        this.doXAErrorReply(-90532, replyMsg);
                        return null;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + replyMsg.getMsgType());
            }
            catch (SQLException e) {
                throw this.processException(e);
            }
        }
    }

    @Override
    public void xaRollback(Xid xid) throws TbXAException {
        Debug.logMethod("TbXAComm.xaRollback", new Object[]{this.conn, xid});
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, xidInternal);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 2, 0, xidInternal, xidInternal.length, 0);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90531, replyMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + replyMsg.getMsgType());
            }
            catch (SQLException e) {
                throw this.processException(e);
            }
        }
    }

    @Override
    public void xaStart(Xid xid, int flag) throws TbXAException {
        Debug.logMethod("TbXAComm.xaStart", new Object[]{this.conn, xid, Integer.toString(flag)});
        byte[] xidInternal = new byte[TbXid.SERIALIZED_SIZE];
        this.serializeXid(xid, xidInternal);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbMsgSend.XA(this.stream, 0, flag & 0xFFFEFFFF, xidInternal, xidInternal.length, flag & 0x10000);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        return;
                    }
                    case 76: {
                        this.doXAErrorReply(-90527, replyMsg);
                        return;
                    }
                }
                throw new TbXAException(-6, "Invalid protocol: " + replyMsg.getMsgType());
            }
            catch (SQLException e) {
                throw this.processException(e);
            }
        }
    }
}

