/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbStreamDataWriter {
    private static final int DPL_EXTRA_SIZE = 65536;
    protected StreamBuffer buf;
    private DataTypeConverter converter;

    public TbStreamDataWriter(StreamBuffer buf) {
        this(buf, null);
    }

    public TbStreamDataWriter(StreamBuffer buf, DataTypeConverter dtc) {
        this.initialize(buf);
        this.converter = dtc;
    }

    public void clearDPLBuffer() {
        this.buf.setCurDataSize(24);
    }

    public int getBufferedDataSize() {
        return this.buf != null ? this.buf.getCurDataSize() : 0;
    }

    public int getRemainedBufferSize() {
        int remainedSize = this.buf.getRemained() - 65536;
        return remainedSize < 0 ? 0 : remainedSize;
    }

    public StreamBuffer getStreamBuf() {
        return this.buf;
    }

    public void initialize(StreamBuffer buf1) {
        buf1.init();
        this.buf = buf1;
    }

    public void makeBufferAvailable(int size) {
        this.buf.makeBufferAvailable(size);
    }

    public void moveOffset(int offset) {
        this.buf.moveOffset(offset);
    }

    public int putPadding(int paddingLen) {
        this.buf.putData(paddingLen, (byte)0);
        return paddingLen;
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            this.buf = null;
        }
        this.converter = null;
    }

    public int reWriteInt(int bufOffset, int newVal, int byteLen) throws SQLException {
        TbCommon.int2Bytes(newVal, this.buf.getRawBytes(), bufOffset, byteLen);
        return byteLen;
    }

    public int reWriteLong(int bufOffset, long newVal, int byteLen) throws SQLException {
        TbCommon.long2Bytes(newVal, this.buf.getRawBytes(), bufOffset, byteLen);
        return byteLen;
    }

    public void setCurDataSize(int dataSize) {
        this.buf.setCurDataSize(dataSize);
    }

    public void writeByte(byte data) {
        this.buf.copySingleByte(data);
    }

    public int writeBytes(byte[] bytes) throws SQLException {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    public int writeBytes(byte[] bytes, int offset, int len) {
        this.buf.copyMultiBytes(len, offset, bytes);
        return len;
    }

    public int writeInt(int num, int byteLen) throws SQLException {
        this.buf.makeBufferAvailable(byteLen);
        TbCommon.int2Bytes(num, this.buf.getRawBytes(), this.buf.getCurDataSize(), byteLen);
        this.buf.moveOffset(byteLen);
        return byteLen;
    }

    public int writeLenAndDBEncodedPadString(String str) throws SQLException {
        byte[] bytes = this.converter.getDBEncodedBytes(str);
        int len = bytes.length;
        this.writeInt(len, 4);
        this.buf.copyMultiBytes(len, 0, bytes);
        return len + this.writePadding(len) + 4;
    }

    public int writeLong(long num, int byteLen) throws SQLException {
        this.buf.makeBufferAvailable(byteLen);
        TbCommon.long2Bytes(num, this.buf.getRawBytes(), this.buf.getCurDataSize(), byteLen);
        this.buf.moveOffset(byteLen);
        return byteLen;
    }

    public int writePadBytes(byte[] bytes, int offset, int len) {
        this.writeBytes(bytes, offset, len);
        return len + this.writePadding(len);
    }

    public int writePadding(int len) {
        int padLen = TbCommon.getPadLength(len);
        this.putPadding(padLen);
        return padLen;
    }

    public int writePaddingDPL(int len) {
        int padLen = (4 - len % 4) % 4;
        this.putPadding(padLen);
        return padLen;
    }

    public int writeRpcolData(byte[] data, int len) {
        int rpcolLen;
        if (len <= 250) {
            this.writeByte((byte)len);
            rpcolLen = 1;
        } else {
            this.writeByte((byte)-2);
            this.writeByte((byte)(0xFF & len >> 8));
            this.writeByte((byte)(0xFF & len));
            rpcolLen = 3;
        }
        if (len > 0) {
            this.writeBytes(data, 0, len);
            return rpcolLen + len + this.writePadding(rpcolLen + len);
        }
        this.writeByte((byte)0);
        return rpcolLen + 1 + this.writePadding(rpcolLen + 1);
    }
}

