/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.StreamBuffer;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbStreamDataReader {
    private StreamBuffer buf;
    private int curReadOffset;
    private DataTypeConverter typeConverter = null;

    public TbStreamDataReader(StreamBuffer buf, DataTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.initialize(buf);
    }

    public int getBufferedDataSize() {
        if (this.buf != null) {
            return this.buf.getCurDataSize();
        }
        return 0;
    }

    public int getCurOffset() {
        return this.curReadOffset;
    }

    public void initialize(StreamBuffer buf) {
        this.buf = buf;
        this.curReadOffset = 0;
    }

    private void isBufferAvailable(int len) throws SQLException {
        if (this.buf == null || this.buf.getCurDataSize() <= 0 || this.buf.getCurDataSize() <= this.curReadOffset || this.buf.getCurDataSize() < this.curReadOffset + len) {
            throw TbError.newSQLException(-590730);
        }
    }

    public void moveReadOffset(int offset) {
        this.curReadOffset += offset;
    }

    public void readBytes(byte[] bytes, int offset, int len) throws SQLException {
        this.isBufferAvailable(len);
        System.arraycopy(this.buf.getRawBytes(), this.curReadOffset, bytes, offset, len);
        this.moveReadOffset(len);
    }

    public String readDBDecodedString(int byteLen) throws SQLException {
        this.isBufferAvailable(byteLen);
        String str = null;
        if (byteLen > 0) {
            str = this.typeConverter.getDBDecodedString(this.buf.getRawBytes(), this.curReadOffset, byteLen);
            this.moveReadOffset(byteLen);
        }
        return str;
    }

    public String readDBDecodedPadString(int byteLen) throws SQLException {
        this.isBufferAvailable(byteLen);
        String str = null;
        if (byteLen > 0) {
            str = this.typeConverter.getDBDecodedString(this.buf.getRawBytes(), this.curReadOffset, byteLen);
            this.moveReadOffset(byteLen);
        }
        this.skipPadding(TbCommon.getPadLength(byteLen));
        return str;
    }

    public int readInt32() throws SQLException {
        this.isBufferAvailable(4);
        int num = TbCommon.bytes2Int(this.buf.getRawBytes(), this.curReadOffset, 4);
        this.moveReadOffset(4);
        return num;
    }

    public void readPadBytes(byte[] bytes, int offset, int len) throws SQLException {
        this.readBytes(bytes, offset, len);
        this.skipPadding(TbCommon.getPadLength(len));
    }

    public byte[] readRpcolData() throws SQLException {
        byte[] lenFlag = new byte[1];
        byte[] colData = null;
        this.readBytes(lenFlag, 0, 1);
        if (lenFlag[0] <= -6) {
            byte colLen = lenFlag[0];
            colData = new byte[colLen + 1];
            colData[0] = lenFlag[0];
            this.readBytes(colData, 1, colLen);
        } else if (lenFlag[0] == -2) {
            byte[] colLenByteLarge = new byte[2];
            this.readBytes(colLenByteLarge, 0, 2);
            int colLen = 0xFF & colLenByteLarge[0] << 8;
            colData = new byte[(colLen &= 0xFF & colLenByteLarge[1]) + 3];
            colData[0] = lenFlag[0];
            colData[1] = colLenByteLarge[0];
            colData[2] = colLenByteLarge[1];
            this.readBytes(colData, 3, colLen);
        } else {
            throw TbError.newSQLException(-90405);
        }
        return colData;
    }

    public void reset() {
        this.buf = null;
        this.typeConverter = null;
    }

    private void skipPadding(int skipLen) throws SQLException {
        this.isBufferAvailable(skipLen);
        this.moveReadOffset(skipLen);
    }
}

