/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.comm;

import com.tmax.tibero.Debug;
import com.tmax.tibero.DriverConstants;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbComm;
import com.tmax.tibero.jdbc.comm.TbSocketRegistry;
import com.tmax.tibero.jdbc.comm.TbStream;
import com.tmax.tibero.jdbc.comm.TbStreamDataWriter;
import com.tmax.tibero.jdbc.data.BatchInfo;
import com.tmax.tibero.jdbc.data.BatchUpdateInfo;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.NodeInfo;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.ZoneInfo;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.charset.Charset;
import com.tmax.tibero.jdbc.data.charset.CharsetMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatementImpl;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbPreparedStatementImpl;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbSavepoint;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbClntInfoParam;
import com.tmax.tibero.jdbc.msg.TbColNameList;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.msg.TbMsgBatchUpdateReply;
import com.tmax.tibero.jdbc.msg.TbMsgConnectReply;
import com.tmax.tibero.jdbc.msg.TbMsgDplLoadStreamReply;
import com.tmax.tibero.jdbc.msg.TbMsgDplPrepareReply;
import com.tmax.tibero.jdbc.msg.TbMsgEreply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteCallReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteCountReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteNeedDataReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePivotReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePrefetchNoDescReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePrefetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePsmPrefetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecutePsmReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteRsetNoDescReply;
import com.tmax.tibero.jdbc.msg.TbMsgExecuteRsetReply;
import com.tmax.tibero.jdbc.msg.TbMsgFetchPivotReply;
import com.tmax.tibero.jdbc.msg.TbMsgFetchReply;
import com.tmax.tibero.jdbc.msg.TbMsgGetLastExecutedSqlinfo2Reply;
import com.tmax.tibero.jdbc.msg.TbMsgGetLastExecutedSqlinfoReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobCloseReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobCreateTempReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobInlobReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobInstrReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobLengthReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobOpenReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobReadReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobTruncReply;
import com.tmax.tibero.jdbc.msg.TbMsgLobWriteReply;
import com.tmax.tibero.jdbc.msg.TbMsgLongReadReply;
import com.tmax.tibero.jdbc.msg.TbMsgOkReply;
import com.tmax.tibero.jdbc.msg.TbMsgPrepareReply;
import com.tmax.tibero.jdbc.msg.TbMsgSend;
import com.tmax.tibero.jdbc.msg.TbMsgSessInfoReply;
import com.tmax.tibero.jdbc.msg.TbMsgSesskeyReply;
import com.tmax.tibero.jdbc.msg.TbNlsParam;
import com.tmax.tibero.jdbc.msg.TbOutParam;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.jdbc.msg.TbPvValType;
import com.tmax.tibero.jdbc.msg.common.TbMsg;
import com.tmax.tibero.jdbc.util.TbCommon;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.sql.BatchUpdateException;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.crypto.Cipher;

public class TbCommType4
implements TbComm,
TbClobAccessor,
TbBlobAccessor {
    public TbConnection conn = null;
    public TbStream stream = null;
    public DataTypeConverter typeConverter = null;
    private Cipher rsa = null;

    public TbCommType4() {
        Debug.logMethod("TbCommType4", null);
    }

    public TbCommType4(TbConnection conn) {
        Debug.logMethod("TbCommType4", new Object[]{conn});
        this.conn = conn;
        this.typeConverter = conn.getTypeConverter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] batchUpdate(TbPreparedStatementImpl stmt, BatchUpdateInfo batchUpdateInfo, int startIndex, int endIndex, int flag) throws SQLException {
        Debug.logMethod("TbComm.batchUpdate", new Object[]{this.conn, stmt, Integer.toString(startIndex), Integer.toString(endIndex), Integer.toString(flag)});
        int currentBatchCount = 0;
        int bindParamCnt = stmt.getParameterCnt();
        int totalBatchCount = endIndex - startIndex;
        boolean isFirstBatch = true;
        byte[][] paramTypes = stmt.getParamTypes();
        Binder[][] binder = stmt.getBinder();
        BatchUpdateException exOnBind = null;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                TbStreamDataWriter writer = this.stream.getMsgWriter();
                this.stream.startWritingPacketData();
                writer.writeInt(31, 4);
                writer.writeInt(0, 4);
                writer.writeLong(0L, 8);
                writer.writeLenAndDBEncodedPadString(stmt.getOriginalSql());
                int batchMetaOffset = writer.getBufferedDataSize();
                writer.makeBufferAvailable(20);
                writer.moveOffset(20);
                int paramDataOffset = writer.getBufferedDataSize();
                for (int i = startIndex; i < endIndex; ++i) {
                    BindData bindData = batchUpdateInfo.get(i).getBindData();
                    for (int j = 0; j < binder[i].length; ++j) {
                        int paramFlag = 1;
                        writer.writeInt(paramFlag |= paramTypes[i][j] << 8 & 0xFFFFFF00, 4);
                        binder[i][j].bind(this.conn, stmt, writer, i, j, bindData.getBindItem(j).getLength());
                    }
                    ++currentBatchCount;
                    if (writer.getBufferedDataSize() <= DriverConstants.BATCH_SEND_SIZE) continue;
                    this.batchUpdateFlush(stmt, batchMetaOffset, totalBatchCount, currentBatchCount, flag, isFirstBatch);
                    isFirstBatch = false;
                    currentBatchCount = 0;
                    writer.setCurDataSize(paramDataOffset);
                }
                if (isFirstBatch || writer.getBufferedDataSize() - paramDataOffset > 0) {
                    this.batchUpdateFlush(stmt, batchMetaOffset, totalBatchCount, currentBatchCount, flag, isFirstBatch);
                }
            }
            catch (SQLException se) {
                int errCode = se.getErrorCode();
                if (errCode <= -90400 && errCode > -90500) {
                    throw se;
                }
                exOnBind = new BatchUpdateException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new int[0]);
                if (isFirstBatch) {
                    throw exOnBind;
                }
                this.cancelStatement();
            }
            catch (Exception e) {
                SQLException se = TbError.newSQLException(-90651, e);
                exOnBind = new BatchUpdateException(se.getMessage(), se.getSQLState(), se.getErrorCode(), new int[0]);
                if (isFirstBatch) {
                    throw exOnBind;
                }
                this.cancelStatement();
            }
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 32: {
                    return this.batchUpdateReply((TbMsgBatchUpdateReply)replyMsg, totalBatchCount, bindParamCnt);
                }
                case 76: {
                    if (exOnBind == null) {
                        this.throwEreply(-90515, replyMsg);
                        break;
                    }
                    throw exOnBind;
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
        return null;
    }

    private void batchUpdateFlush(TbPreparedStatementImpl stmt, int offset, int totalBatchCount, int currentBatchCount, int flag, boolean isFirstBatch) throws SQLException {
        Debug.logMethod("TbComm.batchUpdateFlush", new Object[]{this.conn, stmt, Integer.toString(offset), Integer.toString(totalBatchCount), Integer.toString(currentBatchCount), Integer.toString(flag), new Boolean(isFirstBatch)});
        int bindParamCount = stmt.getParameterCnt();
        TbStreamDataWriter writer = this.stream.getMsgWriter();
        writer.reWriteInt(offset, totalBatchCount, 4);
        writer.reWriteInt(offset + 4, currentBatchCount, 4);
        writer.reWriteInt(offset + 8, bindParamCount, 4);
        if (this.conn.getAutoCommit()) {
            flag |= 1;
        }
        if (!isFirstBatch) {
            flag |= 0x1000;
        }
        writer.reWriteInt(offset + 12, flag, 4);
        writer.reWriteInt(offset + 16, currentBatchCount * bindParamCount, 4);
        writer.reWriteInt(4, writer.getBufferedDataSize() - 16, 4);
        this.stream.flush();
    }

    @Override
    public int[] batchUpdateLoop(TbPreparedStatementImpl stmt, BatchUpdateInfo batchUpdateInfo) throws SQLException {
        Debug.logMethod("TbComm.batchUpdateLoop", new Object[]{this.conn, stmt});
        int flag = stmt.getBatchFlag();
        int deferredRowCount = batchUpdateInfo.getDeferredRowCount();
        int totalBatchRowCount = stmt.getBatchRowCount();
        int nextExecRowIndex = 0;
        int updateCntOffset = 0;
        int[] totalUpdateCnt = new int[totalBatchRowCount];
        try {
            int[] eachUpdateCnt;
            if (deferredRowCount == 0) {
                return this.batchUpdate(stmt, batchUpdateInfo, 0, totalBatchRowCount, flag);
            }
            for (int k = 0; k < deferredRowCount; ++k) {
                int deferredRowIndex = batchUpdateInfo.getDeferredRowIndex(k);
                BatchInfo info = batchUpdateInfo.get(deferredRowIndex);
                if (nextExecRowIndex < deferredRowIndex) {
                    eachUpdateCnt = this.batchUpdate(stmt, batchUpdateInfo, nextExecRowIndex, deferredRowIndex, flag);
                    System.arraycopy(eachUpdateCnt, 0, totalUpdateCnt, updateCntOffset, eachUpdateCnt.length);
                    updateCntOffset += eachUpdateCnt.length;
                    nextExecRowIndex = deferredRowIndex;
                }
                stmt.setBindData(info.getBindData());
                totalUpdateCnt[updateCntOffset] = this.prepareExecute(stmt, stmt.getOriginalSql(), info.getCurrentRowIndex());
                ++updateCntOffset;
                ++nextExecRowIndex;
            }
            if (nextExecRowIndex < totalBatchRowCount) {
                eachUpdateCnt = this.batchUpdate(stmt, batchUpdateInfo, nextExecRowIndex, totalBatchRowCount, flag);
                System.arraycopy(eachUpdateCnt, 0, totalUpdateCnt, updateCntOffset, eachUpdateCnt.length);
            }
            return totalUpdateCnt;
        }
        catch (BatchUpdateException e) {
            int updateCntSize = e.getUpdateCounts().length;
            int[] newUpdateCnt = new int[updateCntOffset + updateCntSize];
            System.arraycopy(totalUpdateCnt, 0, newUpdateCnt, 0, updateCntOffset);
            System.arraycopy(e.getUpdateCounts(), 0, newUpdateCnt, updateCntOffset, updateCntSize);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), newUpdateCnt, e.getCause());
        }
        catch (SQLException se) {
            int errCode = se.getErrorCode();
            if (errCode <= -90400 && errCode > -90500) {
                throw se;
            }
            int[] newUpdateCnt = new int[updateCntOffset];
            System.arraycopy(totalUpdateCnt, 0, newUpdateCnt, 0, updateCntOffset);
            throw new BatchUpdateException(se.getMessage(), se.getSQLState(), se.getErrorCode(), newUpdateCnt, (Throwable)se);
        }
    }

    private int[] batchUpdateReply(TbMsgBatchUpdateReply replyMsg, int batchCnt, int bindParamCnt) throws SQLException {
        int i;
        Debug.logMethod("TbComm.batchUpdateReply", new Object[]{this.conn, Integer.toString(batchCnt), Integer.toString(bindParamCnt), Integer.toString(replyMsg.executedCnt), Integer.toString(replyMsg.affectedCnt != null ? replyMsg.affectedCnt.length : 0)});
        int[] updateCnt = new int[replyMsg.executedCnt];
        if (replyMsg.affectedCnt == null) {
            for (i = 0; i < replyMsg.executedCnt; ++i) {
                updateCnt[i] = 1;
            }
        } else {
            for (i = 0; i < replyMsg.executedCnt; ++i) {
                updateCnt[i] = replyMsg.affectedCnt[i].cnt;
            }
        }
        if (bindParamCnt > 0 && batchCnt != replyMsg.executedCnt) {
            SQLException e = replyMsg.getException(-90515);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), updateCnt, (Throwable)e);
        }
        return updateCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        Debug.logMethod("TbComm.cancel", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.CANCEL(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90526, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    @Override
    public void cancelStatement() throws SQLException {
        Debug.logMethod("TbComm.cancelStatement", new Object[]{this.conn});
        TbMsgSend.STMTCANCEL(this.stream, this.conn.getSessionId(), this.conn.getSerialNo(), 0);
    }

    @Override
    public void close() throws SQLException {
        Debug.logMethod("TbComm.close", new Object[]{this.conn});
        this.reset();
    }

    @Override
    public boolean close(TbLob lob) throws SQLException {
        return this.lobClose(lob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCursor(TbResultSet rs, int cursorId) throws SQLException {
        Debug.logMethod("TbComm.closeCursor", new Object[]{this.conn, Integer.toString(cursorId)});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.CLOSE_CSR(this.stream, cursorId);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90507, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession() throws SQLException {
        Debug.logMethod("TbComm.closeSession", new Object[]{this.conn});
        int autoCommit = this.conn.getAutoCommit() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.CLOSE_SESS(this.stream, autoCommit);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90503, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Debug.logMethod("TbComm.commit", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.COMMIT(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90510, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createStream() throws SQLException {
        Debug.logMethod("TbComm.createStream", new Object[]{this.conn});
        String address = null;
        if (this.conn.info.isInternal()) {
            Socket socket = TbSocketRegistry.getSocket();
            if (socket == null) {
                throw TbError.newSQLException(-590720);
            }
            address = "server internally";
            if (this.stream != null) {
                TbStream tbStream = this.stream;
                synchronized (tbStream) {
                    this.stream = new TbStream(this.conn, socket, this.typeConverter, this.conn.info);
                }
            } else {
                this.stream = new TbStream(this.conn, socket, this.typeConverter, this.conn.info);
            }
        } else {
            NodeInfo node = this.conn.info.getClusterNode();
            if (node == null) {
                throw TbError.newSQLException(-590721);
            }
            while (true) {
                address = node.getAddress() + ":" + node.getPort();
                if (this.stream != null) {
                    TbStream tbStream = this.stream;
                    synchronized (tbStream) {
                        try {
                            this.stream = new TbStream(this.conn, node.getAddress(), node.getPort(), this.typeConverter, this.conn.info);
                            break;
                        }
                        catch (SQLException e) {
                            Debug.log("TbComm.createStream (FAILED TO CONNECT " + address + ")");
                            this.stream = null;
                            node = this.conn.info.getSecondaryNode();
                            if (node == null) {
                                throw e;
                            }
                        }
                    }
                }
                try {
                    this.stream = new TbStream(this.conn, node.getAddress(), node.getPort(), this.typeConverter, this.conn.info);
                }
                catch (SQLException e) {
                    Debug.log("TbComm.createStream (FAILED TO CONNECT " + address + ")");
                    this.stream = null;
                    node = this.conn.info.getSecondaryNode();
                    if (node == null) throw e;
                    continue;
                }
                break;
            }
            Object var2_3 = null;
        }
        Debug.log("TbComm.createStream (CONNECTED TO " + address + ")");
    }

    @Override
    public byte[] createTemporaryBlob() throws SQLException {
        return this.lobCreateTemporary(12);
    }

    @Override
    public byte[] createTemporaryClob() throws SQLException {
        return this.lobCreateTemporary(13);
    }

    @Override
    public byte[] createTemporaryNClob() throws SQLException {
        return this.lobCreateTemporary(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describeConnectInfo() throws SQLException {
        Debug.logMethod("TbComm.descConnectInfo", new String[]{"Connection"}, new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DESCRIBE_CONNECT_INFO(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 0: {
                    this.logonConnectReply((TbMsgConnectReply)replyMsg, false);
                    break;
                }
                case 76: {
                    this.throwEreply(-90502, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void describeSessInfo() throws SQLException {
        Debug.logMethod("TbComm.descSessInfo", new String[]{"Connection"}, new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DESCRIBE_SESS_INFO(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 2: {
                    this.logonSessInfoReply((TbMsgSessInfoReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90502, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirPathAbort() throws SQLException {
        Debug.logMethod("TbComm.dirPathAbort", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_ABORT(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90541, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirPathDataSave(int action) throws SQLException {
        Debug.logMethod("TbComm.dirPathDataSave", new Object[]{this.conn, new Integer(action)});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_DATASAVE(this.stream, action);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90538, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirPathFinish() throws SQLException {
        Debug.logMethod("TbComm.dirPathFinish", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_FINISH(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90539, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirPathFlushRow() throws SQLException {
        Debug.logMethod("TbComm.dirPathFinish", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_FLUSH_ROW(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90540, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirPathLoadStream(TbDirPathStream dirPathStream, TbStreamDataWriter writer, int partialFlag) throws SQLException {
        Debug.logMethod("TbComm.dirPathLoadStream", new Object[]{this.conn, Integer.toString(partialFlag)});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            try {
                writer.reWriteInt(0, 57, 4);
                writer.reWriteLong(8, 0L, 8);
                writer.reWriteInt(16, partialFlag, 4);
                writer.reWriteInt(20, writer.getBufferedDataSize() - 24, 4);
                writer.putPadding(4);
                writer.reWriteInt(4, writer.getBufferedDataSize() - 16, 4);
                this.stream.flush(writer);
            }
            finally {
                writer.clearDPLBuffer();
            }
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 58: {
                    TbMsgDplLoadStreamReply loadStreamReply = (TbMsgDplLoadStreamReply)replyMsg;
                    int rowCnt = loadStreamReply.rowCnt;
                    int returnCode = loadStreamReply.returnCode;
                    dirPathStream.addRowCnt(rowCnt);
                    dirPathStream.addTotalRowCnt(rowCnt);
                    dirPathStream.setReturnCode(returnCode);
                    if (returnCode != 3) break;
                    throw loadStreamReply.getException(-90537);
                }
                case 76: {
                    this.throwEreply(-90537, replyMsg);
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirPathPrepare(TbDirPathStream dplStream) throws SQLException {
        Debug.logMethod("TbComm.prepareDirPathLoad", new Object[]{this.conn, dplStream});
        TbDirPathMetaData dplMeta = dplStream.getDPLMetaData();
        int columnCnt = dplMeta.getColumnCnt();
        TbColNameList[] colNameList = new TbColNameList[columnCnt];
        for (int i = 0; i < columnCnt; ++i) {
            colNameList[i] = new TbColNameList();
            colNameList[i].set(dplMeta.getColumn(i + 1));
        }
        int logFlag = dplMeta.getLogFlag() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_PREPARE(this.stream, logFlag, dplMeta.getSchema(), dplMeta.getTable(), columnCnt, colNameList);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 56: {
                    if (columnCnt != ((TbMsgDplPrepareReply)replyMsg).colMeta.length) {
                        throw TbError.newSQLException(-90544);
                    }
                    TbColumnDesc[] metas = ((TbMsgDplPrepareReply)replyMsg).colMeta;
                    dplStream.getDPLMetaData().setColumnMetas(metas);
                    return;
                }
                case 76: {
                    this.throwEreply(-90536, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirPathPrepareParallel(TbDirPathStream dplStream) throws SQLException {
        Debug.logMethod("TbComm.dirPathPrepareParallel", new Object[]{this.conn, dplStream});
        TbDirPathMetaData dplMeta = dplStream.getDPLMetaData();
        int columnCnt = dplMeta.getColumnCnt();
        TbColNameList[] colNameList = new TbColNameList[columnCnt];
        for (int i = 0; i < columnCnt; ++i) {
            colNameList[i] = new TbColNameList();
            colNameList[i].set(dplMeta.getColumn(i + 1));
        }
        int logFlag = dplMeta.getLogFlag() ? 1 : 0;
        int parallelFlag = dplMeta.getParallelFlag() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DPL_PREPARE_PARALLEL(this.stream, logFlag, parallelFlag, dplMeta.getSchema(), dplMeta.getTable(), dplMeta.getPartition(), columnCnt, colNameList);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 56: {
                    if (columnCnt != ((TbMsgDplPrepareReply)replyMsg).colMeta.length) {
                        throw TbError.newSQLException(-90544);
                    }
                    TbColumnDesc[] metas = ((TbMsgDplPrepareReply)replyMsg).colMeta;
                    dplStream.getDPLMetaData().setColumnMetas(metas);
                    return;
                }
                case 76: {
                    this.throwEreply(-90536, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
    }

    @Override
    public int execute(TbPreparedStatementImpl stmt, String sql, int rowIndex) throws SQLException {
        Debug.logMethod("TbComm.execute", new Object[]{this.conn, stmt});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            this.processExecute(stmt, sql, rowIndex, true);
            TbMsg replyMsg = this.stream.readMsg();
            block16: while (true) {
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        this.justOKReply((TbMsgOkReply)replyMsg);
                        return TbSQLTypeScanner.isPSMStmt(stmt.getSqlType()) ? 1 : 0;
                    }
                    case 2: {
                        this.executeSessInfoReply((TbMsgSessInfoReply)replyMsg);
                        return 0;
                    }
                    case 12: {
                        return this.executePrefetchNoDescReply(stmt, (TbMsgExecutePrefetchNoDescReply)replyMsg);
                    }
                    case 13: {
                        return this.executeCountReply(stmt, (TbMsgExecuteCountReply)replyMsg);
                    }
                    case 8: {
                        return this.executeRsetReply(stmt, (TbMsgExecuteRsetReply)replyMsg);
                    }
                    case 10: {
                        return this.executeRsetNoDescReply(stmt, (TbMsgExecuteRsetNoDescReply)replyMsg);
                    }
                    case 16: {
                        return this.executeNeedDataReply(replyMsg, stmt, rowIndex);
                    }
                    case 15: {
                        TbMsgExecutePsmReply psmReply = (TbMsgExecutePsmReply)replyMsg;
                        return this.executeCallReply(stmt, rowIndex, psmReply.paramData);
                    }
                    case 9: {
                        replyMsg = this.executePivotReply(stmt, (TbMsgExecutePivotReply)replyMsg);
                        continue block16;
                    }
                    case 183: {
                        TbMsgExecutePsmPrefetchReply psmPrefetchMsg = (TbMsgExecutePsmPrefetchReply)replyMsg;
                        stmt.buildColMetaArray(psmPrefetchMsg.colCnt, psmPrefetchMsg.hiddenColCnt, psmPrefetchMsg.colMeta);
                        if (!(stmt instanceof TbCallableStatementImpl)) {
                            return 1;
                        }
                        return this.executePsmPrefetchReply((TbCallableStatementImpl)stmt, rowIndex, psmPrefetchMsg);
                    }
                    case 76: {
                        return this.executeEreply(stmt, sql, replyMsg, rowIndex);
                    }
                }
                this.throwProtocolError(replyMsg.getMsgType());
            }
        }
    }

    private int executeCallReply(TbPreparedStatementImpl pstmt, int rowIndex, TbOutParam[] paramData) throws SQLException {
        Debug.logMethod("TbComm.executeCallReply", new Object[]{this.conn, pstmt, Integer.toString(rowIndex)});
        int index = -1;
        int colCnt = paramData == null ? 0 : paramData.length;
        BindData bindData = pstmt.getBindData();
        int bindCnt = pstmt.getParameterCnt();
        if (bindData.getOutParameterCnt() != colCnt) {
            throw TbError.newSQLException(-90618);
        }
        if (paramData == null || !(pstmt instanceof TbCallableStatementImpl)) {
            return 1;
        }
        TbCallableStatementImpl cstmt = (TbCallableStatementImpl)pstmt;
        for (int i = 0; i < colCnt; ++i) {
            ++index;
            while (index < bindCnt && !bindData.isOutParameterOn(index)) {
                ++index;
            }
            if (index >= bindCnt) {
                throw TbError.newSQLException(-90618);
            }
            BindItem bindItem = bindData.getBindItem(index);
            BindItem outItem = cstmt.getOutItems(index);
            outItem.set(bindItem.getSQLType(), paramData[i].value.length, paramData[i].colMeta, null);
            cstmt.setOutParam(index, paramData[i].dataType, paramData[i].value, null);
        }
        return 1;
    }

    private int executePsmPrefetchReply(TbCallableStatementImpl cstmt, int rowIndex, TbMsgExecutePsmPrefetchReply reply) throws SQLException {
        Debug.logMethod("TbComm.executePsmPrefetchReply", new Object[]{this.conn, cstmt, Integer.toString(rowIndex)});
        TbOutParam[] paramData = reply.paramData;
        int index = -1;
        int colCnt = paramData == null ? 0 : paramData.length;
        BindData bindData = cstmt.getBindData();
        int bindCnt = cstmt.getParameterCnt();
        if (bindData.getOutParameterCnt() != colCnt) {
            throw TbError.newSQLException(-90618);
        }
        if (paramData == null) {
            return 1;
        }
        TbResultSet prefetchedRs = this.processPrefetchedRset(cstmt, reply.colCnt, reply.hiddenColCnt, reply.csrId, reply.colMeta, reply.rowChunkSize, reply.rowCnt, reply.isFetchCompleted, reply.getTsn());
        for (int i = 0; i < colCnt; ++i) {
            ++index;
            while (index < bindCnt && !bindData.isOutParameterOn(index)) {
                ++index;
            }
            if (index >= bindCnt) {
                throw TbError.newSQLException(-90618);
            }
            BindItem bindItem = bindData.getBindItem(index);
            BindItem outItem = cstmt.getOutItems(index);
            outItem.set(bindItem.getSQLType(), paramData[i].value.length, paramData[i].colMeta, null);
            if (prefetchedRs != null && paramData[i].dataType == 16) {
                cstmt.setOutParam(index, paramData[i].dataType, paramData[i].value, prefetchedRs);
                prefetchedRs = null;
                cstmt.setPivotInfo(index, cstmt.getPivotInfo());
                Vector<byte[]> prefetchedPvData = cstmt.getPivotData();
                if (prefetchedPvData == null) continue;
                for (byte[] pvData : prefetchedPvData) {
                    cstmt.addPivotData(index, pvData);
                }
                continue;
            }
            cstmt.setOutParam(index, paramData[i].dataType, paramData[i].value, null);
        }
        return 1;
    }

    private int executeCountReply(TbStatement stmt, TbMsgExecuteCountReply reply) throws SQLException {
        Debug.logMethod("TbComm.executeCountReply", new Object[]{this.conn, stmt, reply});
        long updateCount = (0xFFFFFFFF00000000L & (long)reply.cntHigh << 32) + (0xFFFFFFFFL & (long)reply.cntLow);
        return (int)updateCount;
    }

    @Override
    public int executeDirect(TbStatement stmt, String sql) throws SQLException {
        Debug.logMethod("TbComm.executeDirect", new Object[]{this.conn, stmt});
        int autoCommit = this.conn.getAutoCommit() ? 1 : 0;
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.EXECDIR(this.stream, autoCommit, stmt.getPreFetchSize(), sql);
            TbMsg replyMsg = this.stream.readMsg();
            block13: while (true) {
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        this.justOKReply((TbMsgOkReply)replyMsg);
                        return TbSQLTypeScanner.isPSMStmt(stmt.getSqlType()) ? 1 : 0;
                    }
                    case 2: {
                        this.executeSessInfoReply((TbMsgSessInfoReply)replyMsg);
                        return 0;
                    }
                    case 13: {
                        return this.executeCountReply(stmt, (TbMsgExecuteCountReply)replyMsg);
                    }
                    case 8: {
                        return this.executeRsetReply(stmt, (TbMsgExecuteRsetReply)replyMsg);
                    }
                    case 14: 
                    case 15: {
                        return 1;
                    }
                    case 11: {
                        return this.executePrefetchReply(stmt, (TbMsgExecutePrefetchReply)replyMsg);
                    }
                    case 9: {
                        replyMsg = this.executePivotReply(stmt, (TbMsgExecutePivotReply)replyMsg);
                        continue block13;
                    }
                    case 76: {
                        return this.executeDirectEreply(stmt, sql, replyMsg);
                    }
                }
                this.throwProtocolError(replyMsg.getMsgType());
            }
        }
    }

    private int executeDirectEreply(TbStatement stmt, String sql, TbMsg reply) throws SQLException {
        SQLException ex = this.getErrorMessage(-90508, reply);
        if (ex.getErrorCode() == -12018) {
            Debug.log("TbComm.executeDirectEreply (INVALID_PPID_DETECTED)");
            return this.executeDirect(stmt, sql);
        }
        throw ex;
    }

    private int executeEreply(TbPreparedStatementImpl stmt, String sql, TbMsg reply, int rowIndex) throws SQLException {
        SQLException ex = this.getErrorMessage(-90508, reply);
        if (ex.getErrorCode() == -12018) {
            Debug.log("TbComm.executeEreply (INVALID_PPID_DETECTED)");
            stmt.setPPID(null);
            stmt.buildColMetaArray(0, 0, null);
            return this.prepareExecute(stmt, sql, rowIndex);
        }
        throw ex;
    }

    private int executeNeedDataReply(TbMsg reply, TbPreparedStatementImpl stmt, int rowIndex) throws SQLException {
        Debug.logMethod("TbComm.executeNeedDataReply", new Object[]{this.conn, stmt});
        BindData bindData = stmt.getBindData();
        Binder[][] binder = stmt.getBinder();
        TbMsg msg = reply;
        int csrId = stmt.getCurCsrId();
        TbStreamDataWriter writer = this.stream.getMsgWriter();
        for (int deferredParamCnt = bindData.getDFRParameterCnt(); deferredParamCnt > 0; --deferredParamCnt) {
            int paramIndex = ((TbMsgExecuteNeedDataReply)msg).paramIndex;
            BindItem item = bindData.getBindItem(paramIndex);
            if (item.getParamMode() != 8) {
                throw TbError.newSQLException(-590717, item.toString());
            }
            this.stream.startWritingPacketData();
            writer.writeInt(54, 4);
            writer.writeInt(0, 4);
            writer.writeLong(0L, 8);
            writer.writeInt(paramIndex, 4);
            writer.writeInt(csrId, 4);
            binder[rowIndex][paramIndex].bindDFR(this.conn, stmt, writer, rowIndex, paramIndex, item.getLength());
            TbMsgSend.PUT_DATA(this.stream, paramIndex, csrId, new byte[0], 0);
            msg = this.stream.readMsg();
            if (msg.getMsgType() == 16) {
                stmt.setCurCsrId(((TbMsgExecuteNeedDataReply)msg).csrId);
                continue;
            }
            if (msg.getMsgType() != 76) break;
            this.throwEreply(-90508, msg);
        }
        switch (msg.getMsgType()) {
            case 14: {
                TbMsgExecuteCallReply callMsg = (TbMsgExecuteCallReply)msg;
                return this.executeCallReply(stmt, rowIndex, callMsg.paramData);
            }
            case 13: {
                return this.executeCountReply(stmt, (TbMsgExecuteCountReply)msg);
            }
            case 75: {
                this.justOKReply((TbMsgOkReply)msg);
                return TbSQLTypeScanner.isPSMStmt(stmt.getSqlType()) ? 1 : 0;
            }
            case 8: {
                return this.executeRsetReply(stmt, (TbMsgExecuteRsetReply)msg);
            }
            case 11: {
                TbMsgExecutePrefetchReply prefetchMsg = (TbMsgExecutePrefetchReply)msg;
                stmt.setPPID(prefetchMsg.ppid);
                stmt.buildColMetaArray(prefetchMsg.colCnt, prefetchMsg.hiddenColCnt, prefetchMsg.colMeta);
                return this.executePrefetchReply(stmt, prefetchMsg);
            }
            case 12: {
                return this.executePrefetchNoDescReply(stmt, (TbMsgExecutePrefetchNoDescReply)msg);
            }
        }
        this.throwProtocolError(msg.getMsgType());
        return 0;
    }

    @Override
    public void executePivot(TbCallableStatementImpl cstmt, int paramIdx, int csrId) throws SQLException {
        Debug.logMethod("TbComm.executePivot", new Object[]{this.conn, cstmt, Integer.toString(paramIdx), Integer.toString(csrId)});
        TbMsgSend.EXECUTE_PIVOT(this.stream, csrId);
        TbMsg replyMsg = this.stream.readMsg();
        switch (replyMsg.getMsgType()) {
            case 9: {
                this.executePivotReply(cstmt, paramIdx, (TbMsgExecutePivotReply)replyMsg);
                break;
            }
            case 76: {
                this.throwEreply(-90509, replyMsg);
            }
        }
    }

    private void executePivotReply(TbCallableStatementImpl cstmt, int paramIdx, TbMsgExecutePivotReply exPvReply) throws SQLException {
        Debug.logMethod("TbComm.executePivotReply", new Object[]{this.conn, cstmt, Integer.toString(paramIdx)});
        TbPivotInfo[] pivotInfo = new TbPivotInfo[exPvReply.pivotInfo.length];
        for (int i = 0; i < exPvReply.pivotInfo.length; ++i) {
            pivotInfo[i] = new TbPivotInfo();
            pivotInfo[i].colIdx = exPvReply.pivotInfo[i].colIdx;
            pivotInfo[i].chunkCnt = exPvReply.pivotInfo[i].chunkCnt;
            if (exPvReply.pivotInfo[i].valType == null) continue;
            pivotInfo[i].valType = new TbPvValType[exPvReply.pivotInfo[i].valType.length];
            for (int j = 0; j < exPvReply.pivotInfo[i].valType.length; ++j) {
                pivotInfo[i].valType[j] = new TbPvValType();
                pivotInfo[i].valType[j].type = exPvReply.pivotInfo[i].valType[j].type;
            }
        }
        cstmt.setPivotInfo(paramIdx, pivotInfo);
        cstmt.addPivotData(paramIdx, exPvReply.chunk);
        block7: while (true) {
            TbMsgSend.FETCH_PIVOT(this.stream);
            TbMsg reply = this.stream.readMsg();
            switch (reply.getMsgType()) {
                case 21: {
                    TbMsgFetchPivotReply fetchPvReply = (TbMsgFetchPivotReply)reply;
                    if (fetchPvReply.chunkLen <= 0) {
                        return;
                    }
                    cstmt.addPivotData(paramIdx, fetchPvReply.chunk);
                    continue block7;
                }
                case 75: {
                    return;
                }
                case 76: {
                    this.throwEreply(-90509, reply);
                }
            }
            this.throwProtocolError(reply.getMsgType());
        }
    }

    private TbMsg executePivotReply(TbStatement stmt, TbMsgExecutePivotReply reply) throws SQLException {
        TbMsg fetchReply;
        Debug.logMethod("TbComm.executePivotReply", new Object[]{this.conn, stmt, reply});
        TbPivotInfo[] pivotInfo = new TbPivotInfo[reply.pivotInfo.length];
        for (int i = 0; i < reply.pivotInfo.length; ++i) {
            pivotInfo[i] = new TbPivotInfo();
            pivotInfo[i].colIdx = reply.pivotInfo[i].colIdx;
            pivotInfo[i].chunkCnt = reply.pivotInfo[i].chunkCnt;
            if (reply.pivotInfo[i].valType == null) continue;
            pivotInfo[i].valType = new TbPvValType[reply.pivotInfo[i].valType.length];
            for (int j = 0; j < reply.pivotInfo[i].valType.length; ++j) {
                pivotInfo[i].valType[j] = new TbPvValType();
                pivotInfo[i].valType[j].type = reply.pivotInfo[i].valType[j].type;
            }
        }
        stmt.setPivotInfo(pivotInfo);
        stmt.addPivotData(reply.chunk);
        block5: while (true) {
            TbMsgSend.FETCH_PIVOT(this.stream);
            fetchReply = this.stream.readMsg();
            switch (fetchReply.getMsgType()) {
                case 21: {
                    stmt.addPivotData(((TbMsgFetchPivotReply)fetchReply).chunk);
                    continue block5;
                }
            }
            break;
        }
        return fetchReply;
    }

    private int executePrefetchNoDescReply(TbPreparedStatementImpl stmt, TbMsgExecutePrefetchNoDescReply reply) throws SQLException {
        Debug.logMethod("TbComm.executePrefetchNoDescReply", new Object[]{this.conn, stmt, Integer.toString(reply.csrId)});
        TbResultSet rs = this.processPrefetchedRset(stmt, stmt.getOutColCnt(), stmt.getHiddenColCnt(), reply.csrId, stmt.getColMetaArray(), reply.rowChunkSize, reply.rowCnt, reply.isFetchCompleted, reply.getTsn());
        stmt.setResultSet(rs);
        return (int)rs.getUpdateCount();
    }

    private int executePrefetchReply(TbStatement stmt, TbMsgExecutePrefetchReply reply) throws SQLException {
        Debug.logMethod("TbComm.executePrefetchReply", new Object[]{this.conn, stmt, reply});
        TbResultSet rs = this.processPrefetchedRset(stmt, reply.colCnt, reply.hiddenColCnt, reply.csrId, reply.colMeta, reply.rowChunkSize, reply.rowCnt, reply.isFetchCompleted, reply.getTsn());
        stmt.setResultSet(rs);
        return (int)rs.getUpdateCount();
    }

    private int executeRsetNoDescReply(TbPreparedStatementImpl stmt, TbMsgExecuteRsetNoDescReply reply) throws SQLException {
        Debug.logMethod("TbComm.executeRsetNoDescReply", new Object[]{this.conn, stmt});
        TbResultSet rs = this.typeConverter.toResultSet(stmt.getOutColCnt(), stmt.getHiddenColCnt(), reply.csrId, stmt.getColMetaArray(), stmt, null);
        rs.setTsn(reply.getTsn());
        stmt.setResultSet(rs);
        return (int)rs.getUpdateCount();
    }

    private int executeRsetReply(TbStatement stmt, TbMsgExecuteRsetReply reply) throws SQLException {
        Debug.logMethod("TbComm.executeRsetReply", new Object[]{this.conn, stmt, reply});
        TbResultSet rs = this.typeConverter.toResultSet(reply.colCnt, reply.hiddenColCnt, reply.csrId, reply.colMeta, stmt, null);
        rs.setTsn(reply.getTsn());
        stmt.setResultSet(rs);
        return reply.affectedCnt;
    }

    private void executeSessInfoReply(TbMsgSessInfoReply msg) {
        Debug.logMethod("TbComm.executeSessInfoReply", new Object[]{this.conn, msg});
        StringBuffer sb = new StringBuffer(128);
        sb.append("nlsData[");
        if (msg.nlsData != null) {
            int i;
            for (i = 0; i < msg.nlsData.length; ++i) {
                sb.append(msg.nlsData[i].nlsParamId).append("=").append(msg.nlsData[i].nlsParamVal).append("/");
            }
            if (i > 0) {
                sb.setLength(sb.length() - 1);
            }
        } else {
            sb.append("null");
        }
        sb.append("]");
        Debug.log(sb.toString());
        this.conn.setSessionId(msg.sessionId);
        this.conn.setSerialNo(msg.serialNo);
        this.conn.setNLSDate(msg.nlsData[0].nlsParamVal);
        this.conn.setNLSTimestamp(msg.nlsData[2].nlsParamVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(TbStatement stmt, TbResultSetBase rs) throws SQLException {
        Debug.logMethod("TbComm.fetch", new Object[]{this.conn, stmt});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            int preparedFetchedSize = rs.getFetchSize();
            int preparedFetchCnt = rs.getPreparedFetchCnt();
            if (preparedFetchCnt <= 0) {
                TbMsgSend.FETCH(this.stream, rs.getCursorId(), preparedFetchedSize);
                preparedFetchCnt = preparedFetchedSize * -1;
            }
            TbMsg msg = this.stream.readMsg();
            switch (msg.getMsgType()) {
                case 19: {
                    this.fetchReply(stmt, (TbMsgFetchReply)msg, rs);
                    --preparedFetchCnt;
                    break;
                }
                case 76: {
                    SQLException ex = this.getErrorMessage(-90509, msg);
                    String sqlState = ex.getSQLState();
                    if (ex.getErrorCode() == -12018) {
                        ((TbMsgEreply)msg).changeRootException(new SQLException(TbError.getMsg(-12031), sqlState, -12031));
                    }
                    this.throwEreply(-90509, msg);
                    break;
                }
                default: {
                    this.throwProtocolError(msg.getMsgType());
                }
            }
            rs.setPreparedFetchCnt(preparedFetchCnt);
        }
    }

    private void fetchReply(TbStatement stmt, TbMsgFetchReply reply, TbResultSetBase rs) throws SQLException {
        Debug.logMethod("TbComm.fetchReply", new Object[]{this.conn, stmt, reply, rs});
        byte[] buf = rs.getRowChunk(reply.rowChunkSize);
        this.stream.readChunkData(buf, reply.rowChunkSize);
        rs.setFetchCompleted(reply.isFetchCompleted);
        rs.setTsn(reply.getTsn());
        rs.buildRowTable(reply.rowCnt, buf);
    }

    @Override
    public void freeTemporary(TbLob lob) throws SQLException {
        this.lobFreeTemporary(lob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TbResultSet describeCSRReply(TbStatement stmt, int csrId) throws SQLException {
        Debug.logMethod("TbComm.getColumnDescribes", new Object[]{this.conn, stmt, Integer.toString(csrId)});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.DESCRIBE_CSR(this.stream, csrId);
            TbMsg msg = this.stream.readMsg();
            switch (msg.getMsgType()) {
                case 11: {
                    return this.doDescribeCSRPrefetch(stmt, (TbMsgExecutePrefetchReply)msg);
                }
                case 76: {
                    this.throwEreply(-90546, msg);
                    break;
                }
                default: {
                    this.throwProtocolError(msg.getMsgType());
                }
            }
        }
        return null;
    }

    private TbResultSet doDescribeCSRPrefetch(TbStatement stmt, TbMsgExecutePrefetchReply reply) throws SQLException {
        if (reply.colMeta == null) {
            throw TbError.newSQLException(-90644);
        }
        TbResultSet rs = this.processPrefetchedRset(stmt, reply.colCnt, reply.hiddenColCnt, reply.csrId, reply.colMeta, reply.rowChunkSize, reply.rowCnt, reply.isFetchCompleted, reply.getTsn());
        stmt.addSubResultSet(rs);
        return rs;
    }

    @Override
    public SQLException getErrorMessage(int code, TbMsg reply) throws SQLException {
        TbMsgEreply ereply = (TbMsgEreply)reply;
        if (ereply.flag == Integer.MIN_VALUE) {
            Debug.log("TbComm.getErrorMessage (DISCONNECTED)");
            this.reset();
        }
        return ereply.getException(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        Debug.logMethod("TbComm.getLastExecutedSqlinfo", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.GET_LAST_EXECUTED_SQLINFO(this.stream, this.conn.getSessionId());
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 74: {
                    TbMsgGetLastExecutedSqlinfoReply sqlinfoReply = (TbMsgGetLastExecutedSqlinfoReply)replyMsg;
                    TbSQLInfo tbSQLInfo = new TbSQLInfo();
                    tbSQLInfo.setSqlid(sqlinfoReply.sqlid);
                    tbSQLInfo.setHashval(sqlinfoReply.hashval);
                    return tbSQLInfo;
                }
                case 76: {
                    this.throwEreply(-90535, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        Debug.logMethod("TbComm.getLastExecutedSqlinfo", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.GET_LAST_EXECUTED_SQLINFO2(this.stream, this.conn.getSessionId());
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 249: {
                    TbMsgGetLastExecutedSqlinfo2Reply sqlinfo2Reply = (TbMsgGetLastExecutedSqlinfo2Reply)replyMsg;
                    TbSQLInfo2 tbSQLInfo = new TbSQLInfo2();
                    tbSQLInfo.setSqlId(sqlinfo2Reply.sqlid);
                    tbSQLInfo.setChildNum(sqlinfo2Reply.childNum);
                    return tbSQLInfo;
                }
                case 76: {
                    this.throwEreply(-90535, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
        return null;
    }

    @Override
    public TbStream getStream() {
        return this.stream;
    }

    protected TbConnection getTbConnection() {
        return this.conn;
    }

    @Override
    public SQLWarning getWarningMessage() throws SQLException {
        return null;
    }

    private void justOKReply(TbMsgOkReply msg) {
        if (msg.warningMsg != null && msg.warningMsg.length() > 0) {
            this.conn.addWarning(TbError.newSQLWarning(-90500, msg.warningMsg));
        }
    }

    @Override
    public long length(TbLob lob) throws SQLException {
        long length = this.lobLength(lob);
        return lob instanceof TbBlob ? length : length / (long)this.typeConverter.getUCS2MaxBytesPerChar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lobClose(TbLob lob) throws SQLException {
        Debug.logMethod("TbComm.lobClose", new Object[]{this.conn, lob});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_CLOSE(this.stream, lob.getLocator(), lob.getLocatorLength());
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 51: {
                    lob.setLocator(((TbMsgLobCloseReply)replyMsg).slobLoc);
                    return true;
                }
                case 76: {
                    throw this.getErrorMessage(-90522, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] lobCreateTemporary(int type) throws SQLException {
        Debug.logMethod("TbComm.lobCreateTemporary", new Object[]{this.conn, Integer.toString(type)});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_CREATE_TEMP(this.stream, type);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 44: {
                    return ((TbMsgLobCreateTempReply)replyMsg).slobLoc;
                }
                case 76: {
                    throw this.getErrorMessage(-90524, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lobFreeTemporary(TbLob lob) throws SQLException {
        Debug.logMethod("TbComm.lobFreeTemporary", new Object[]{this.conn, lob});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_DELETE_TEMP(this.stream, lob.getLocator(), lob.getLocatorLength());
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90525, replyMsg);
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobLength(TbLob lob) throws SQLException {
        Debug.logMethod("TbComm.lobLength", new Object[]{this.conn, lob});
        if (lob.isInline()) {
            return lob.getIlobLength();
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_LENGTH(this.stream, lob.getLocator(), lob.getLocatorLength());
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 34: {
                    TbMsgLobLengthReply reply = (TbMsgLobLengthReply)replyMsg;
                    return (0xFFFFFFFF00000000L & (long)reply.lenHigh << 32) + (0xFFFFFFFFL & (long)reply.lenLow);
                }
                case 76: {
                    throw this.getErrorMessage(-90523, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lobOpen(TbLob lob, int mode) throws SQLException {
        Debug.logMethod("TbComm.lobOpen", new Object[]{this.conn, lob, Integer.toString(mode)});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_OPEN(this.stream, mode, lob.getLocator(), lob.getLocatorLength());
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 49: {
                    lob.setLocator(((TbMsgLobOpenReply)replyMsg).slobLoc);
                    return true;
                }
                case 76: {
                    throw this.getErrorMessage(-90521, replyMsg);
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobPosition(TbLob lob, String searchStr, long start) throws SQLException {
        Debug.logMethod("TbComm.lobPosition", new Object[]{this.conn, lob, searchStr, Long.toString(start)});
        int offsetHigh = (int)(start >> 32);
        int offsetLow = (int)(start & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_INSTR(this.stream, offsetHigh, offsetLow, lob.getLocator(), lob.getLocatorLength(), searchStr);
            TbMsg msg = this.stream.readMsg();
            switch (msg.getMsgType()) {
                case 40: {
                    TbMsgLobInstrReply reply = (TbMsgLobInstrReply)msg;
                    long position = 0xFFFFFFFF00000000L & (long)(reply.offsetHigh << 32) + (0xFFFFFFFFL & (long)reply.offsetLow);
                    return position;
                }
                case 76: {
                    throw this.getErrorMessage(-90518, msg);
                }
            }
            this.throwProtocolError(msg.getMsgType());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lobPosition(TbLob lob, TbLob searchLob, long start) throws SQLException {
        Debug.logMethod("TbComm.lobPosition", new Object[]{this.conn, lob, searchLob, Long.toString(start)});
        int offsetHigh = (int)(start >> 32);
        int offsetLow = (int)(start & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_INLOB(this.stream, offsetHigh, offsetLow, lob.getLocator(), lob.getLocatorLength(), searchLob.getLocator(), searchLob.getLocatorLength());
            TbMsg msg = this.stream.readMsg();
            switch (msg.getMsgType()) {
                case 47: {
                    TbMsgLobInlobReply reply = (TbMsgLobInlobReply)msg;
                    long position = 0xFFFFFFFF00000000L & (long)(reply.offsetHigh << 32) + (0xFFFFFFFFL & (long)reply.offsetLow);
                    return position;
                }
                case 76: {
                    throw this.getErrorMessage(-90519, msg);
                }
            }
            this.throwProtocolError(msg.getMsgType());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lobRead(TbLob lob, long pos, char[] cbuf, byte[] bbuf, long bufOffset, int len) throws SQLException {
        Debug.logMethod("TbComm.lobRead", new Object[]{this.conn, lob, Long.toString(pos), cbuf, bbuf, Long.toString(bufOffset), Integer.toString(len)});
        if (lob.isInline()) {
            boolean is_remote = false;
            if (lob.isRemote()) {
                if (!lob.isXML()) {
                    throw TbError.newSQLException(-90902);
                }
                is_remote = true;
            }
            return lob.readIlob((int)pos, cbuf, bbuf, (int)bufOffset, len, this.typeConverter, is_remote);
        }
        int offsetHigh = (int)(pos >> 32);
        int offsetLow = (int)(pos & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_READ(this.stream, offsetHigh, offsetLow, len, lob.getLocator(), lob.getLocatorLength());
            TbMsg msg = this.stream.readMsg();
            switch (msg.getMsgType()) {
                case 36: {
                    return this.lobReadReply((TbMsgLobReadReply)msg, lob, pos, cbuf, bbuf, bufOffset, len);
                }
                case 76: {
                    throw this.getErrorMessage(-90516, msg);
                }
            }
            this.throwProtocolError(msg.getMsgType());
        }
        return 0;
    }

    private int lobReadReply(TbMsgLobReadReply reply, TbLob lob, long pos, char[] cbuf, byte[] bbuf, long bufOffset, int len) throws SQLException {
        Debug.logMethod("TbComm.lobReadReply", new Object[]{this.conn, reply, lob, Long.toString(pos), cbuf, bbuf, Long.toString(bufOffset), Integer.toString(len)});
        int byteLen = 0;
        if (reply.data != null) {
            byteLen = reply.data.length;
        }
        if (byteLen == len) {
            lob.setEndOfStream(false);
        } else {
            lob.setEndOfStream(true);
        }
        if (byteLen <= 0) {
            return 0;
        }
        if (lob instanceof TbClob || lob instanceof TbNClob) {
            return this.typeConverter.fixedBytesToChars(reply.data, 0, byteLen, cbuf, (int)bufOffset, (int)((long)cbuf.length - bufOffset));
        }
        System.arraycopy(reply.data, 0, bbuf, (int)bufOffset, byteLen);
        return byteLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lobTruncate(TbLob lob, long len) throws SQLException {
        Debug.logMethod("TbComm.lobTruncate", new Object[]{this.conn, lob, Long.toString(len)});
        int offsetHigh = (int)(len >> 32);
        int offsetLow = (int)(len & 0xFFFFFFFFL);
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_TRUNC(this.stream, offsetHigh, offsetLow, lob.getLocator(), lob.getLocatorLength());
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 38: {
                    lob.setLocator(((TbMsgLobTruncReply)replyMsg).slobLoc);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90520, replyMsg);
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lobWrite(TbLob lob, long pos, char[] cbuf, byte[] bbuf, long bufOffset, long len, int packetPos) throws SQLException {
        Debug.logMethod("TbComm.lobWrite", new Object[]{this.conn, lob, Long.toString(pos), cbuf, bbuf, Long.toString(bufOffset), Long.toString(len), Integer.toString(packetPos)});
        int offsetHigh = (int)(pos >> 32);
        int offsetLow = (int)(pos & 0xFFFFFFFFL);
        int dataLen = 0;
        byte[] data = null;
        if (lob instanceof TbClob || lob instanceof TbNClob) {
            int maxLen = this.typeConverter.getUCS2MaxBytesPerChar() * (int)len;
            data = new byte[maxLen];
            dataLen = maxLen;
            this.typeConverter.charsToFixedBytes(cbuf, (int)bufOffset, (int)len, data, 0, dataLen);
        } else {
            int paddingLen = TbCommon.getPadLength((int)len);
            data = new byte[(int)len + paddingLen];
            dataLen = (int)len;
            System.arraycopy(bbuf, (int)bufOffset, data, 0, (int)len);
            TbCommon.writePadding(data, (int)len, paddingLen);
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.LOB_WRITE(this.stream, offsetHigh, offsetLow, packetPos, lob.getLocator(), lob.getLocatorLength(), data, dataLen);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 42: {
                    this.lobWriteReply(lob, (TbMsgLobWriteReply)replyMsg, packetPos);
                    break;
                }
                case 76: {
                    throw this.getErrorMessage(-90517, replyMsg);
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    private void lobWriteReply(TbLob lob, TbMsgLobWriteReply reply, int packetPos) {
        Debug.logMethod("TbComm.lobWriteReply", new Object[]{this.conn, lob, reply, Integer.toString(packetPos)});
        if ((packetPos & 0x2000000) == 0) {
            return;
        }
        lob.setLocator(reply.slobLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void logon(boolean logonWithNewPassword) throws SQLException {
        Debug.logMethod("TbComm.logon", new Object[]{this.conn});
        while (true) {
            TbStream tbStream = this.stream;
            synchronized (tbStream) {
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 0: {
                        if (!this.logonConnectReply((TbMsgConnectReply)replyMsg, logonWithNewPassword)) {
                            return;
                        }
                        this.logonAuthRequest(logonWithNewPassword);
                        break;
                    }
                    case 2: {
                        this.logonSessInfoReply((TbMsgSessInfoReply)replyMsg);
                        return;
                    }
                    case 144: {
                        break;
                    }
                    case 76: {
                        this.logonEreply(replyMsg, logonWithNewPassword);
                        return;
                    }
                    default: {
                        this.throwProtocolError(replyMsg.getMsgType());
                    }
                }
            }
        }
    }

    private void logonAuthRequest(boolean logonWithNewPassword) throws SQLException {
        String progname;
        String dbname;
        Debug.logMethod("TbComm.logonAuthRequest", new Object[]{this.conn});
        String username = this.conn.info.getUser();
        String passwd = this.conn.info.getPassword();
        if (passwd.length() >= 2 && passwd.startsWith("\"") && passwd.endsWith("\"")) {
            passwd = passwd.substring(1, passwd.length() - 1);
        }
        if ((dbname = this.conn.info.getDatabaseName()).length() >= 2 && dbname.startsWith("\"") && dbname.endsWith("\"")) {
            dbname = dbname.substring(1, dbname.length() - 1);
        }
        if ((progname = this.conn.info.getProgramName()) == null) {
            progname = "JDBC Thin Client Debug";
        }
        String osuser = System.getProperty("user.name");
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        TbClntInfoParam[] clientParam = new TbClntInfoParam[7];
        for (int i = 0; i < 7; ++i) {
            clientParam[i] = new TbClntInfoParam();
        }
        clientParam[0].set(0, "-1");
        clientParam[1].set(1, progname);
        clientParam[2].set(2, null);
        clientParam[3].set(3, osuser);
        clientParam[4].set(4, hostname);
        int flag = 0;
        String newPassword = this.conn.info.getNewPassword();
        String currentPassword = null;
        if (newPassword != null && newPassword.length() != 0) {
            flag |= 0x10;
            currentPassword = passwd;
            passwd = newPassword;
        }
        if (this.rsa != null && this.conn.getSessKey() != null) {
            try {
                DataTypeConverter dtCvt = this.conn.getTypeConverter();
                String sessKey = this.conn.getSessKey();
                byte[] pemRaw = DataTypeConverter.tbBase64Decode(sessKey.getBytes("ASCII"));
                sessKey = new String(pemRaw, "ASCII");
                String prefix = "-----BEGIN PUBLIC KEY-----\n";
                String postfix = "-----END PUBLIC KEY-----";
                String pem = sessKey.substring("-----BEGIN PUBLIC KEY-----\n".length(), sessKey.lastIndexOf("-----END PUBLIC KEY-----"));
                X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(DataTypeConverter.base64Decode(pem.getBytes("ASCII")));
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                PublicKey pubkey = keyFactory.generatePublic(pubSpec);
                this.rsa.init(1, pubkey);
                byte[] pwdBytes = this.rsa.doFinal(dtCvt.getDBEncodedBytes(passwd));
                passwd = DataTypeConverter.tbBase64Encode(pwdBytes);
                if (currentPassword != null) {
                    pwdBytes = this.rsa.doFinal(dtCvt.getDBEncodedBytes(currentPassword));
                    currentPassword = DataTypeConverter.tbBase64Encode(pwdBytes);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                throw TbError.newSQLException(-90502);
            }
        }
        clientParam[5].set(5, currentPassword);
        TbNlsParam[] nlsParam = new TbNlsParam[14];
        for (int i = 0; i < 14; ++i) {
            nlsParam[i] = new TbNlsParam();
        }
        nlsParam[0].set(0, null);
        nlsParam[1].set(1, null);
        nlsParam[2].set(2, null);
        nlsParam[3].set(6, null);
        nlsParam[4].set(3, CharsetMetaData.getNLSLanguage(Locale.getDefault()));
        nlsParam[5].set(4, null);
        nlsParam[6].set(5, null);
        TimeZone timezone = TimeZone.getDefault();
        String timezoneID = ZoneInfo.convertStandardTimeZoneID(timezone.getID());
        if (ZoneInfo.getTimeZoneIdByName(timezoneID) == 581) {
            int offset = timezone.getRawOffset();
            String offsetText = "";
            offsetText = offset >= 0 ? offsetText + "+" : offsetText + "-";
            int hour = Math.abs(offset) / 3600000;
            int min = offset / 60000 % 60;
            offsetText = hour >= 10 ? offsetText + String.valueOf(hour) : offsetText + "0" + String.valueOf(hour);
            offsetText = min == 0 ? offsetText + ":00" : offsetText + ":" + String.valueOf(min);
            timezone.setID("GMT" + offsetText);
            timezoneID = ZoneInfo.convertStandardTimeZoneID(timezone.getID());
        }
        nlsParam[7].set(7, timezoneID);
        TbMsgSend.AUTH_REQ_WITH_VER(this.stream, 2, 15, flag, username, dbname, passwd, clientParam.length, clientParam, nlsParam.length, nlsParam, 1);
    }

    private boolean logonConnectReply(TbMsgConnectReply reply, boolean logonWithNewPassword) throws SQLException {
        if (this.conn.info.isLoadBalance() && !this.conn.isMiddleOfFailover() && reply.flags == 4096) {
            Debug.log("TbComm.logonConnectReply (HIGHLOAD)");
            ConnectionInfo info = this.conn.info;
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.conn.openConnection(info, logonWithNewPassword);
            Debug.log("TbComm.logonConnectReply (CONNECTED IN HIGHLOAD)");
            return false;
        }
        Debug.logMethod("TbComm.logonConnectReply", new Object[]{this.conn, reply});
        int charset = Charset.getCharset(this.conn.info.getCharacterSet());
        if (charset == -1) {
            charset = reply.charset;
        }
        Debug.logMethod("TbComm.logonConnectReply (charset)", new Object[]{this.conn, String.valueOf(charset), this.conn.info.getCharacterSet()});
        if (reply.protocolMajor < 2) {
            throw TbError.newSQLException(-90203);
        }
        ServerInfo info = new ServerInfo(charset, reply.ncharset, reply.svrIsBigendian, reply.svrIsNanobase, reply.tbMajor, reply.tbMinor, reply.tbProductName, reply.tbProductVersion, reply.protocolMajor, reply.protocolMinor);
        this.conn.setServerInfo(info);
        this.conn.setMthrPid(reply.mthrPid);
        this.typeConverter.setCharset(this.conn.getServerCharSet(), this.conn.getServerNCharSet());
        this.conn.setMaxDFRCharCount();
        if (reply.protocolMinor >= 2 && reply.protocolMinor >= 9) {
            try {
                this.rsa = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
            }
            catch (Exception e) {
                this.conn.addWarning(TbError.newSQLWarning(-90200, e));
            }
        }
        if (this.rsa != null) {
            TbMsgSend.REQUEST_SESSKEY(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 283: {
                    TbMsgSesskeyReply sesskeyReply = (TbMsgSesskeyReply)replyMsg;
                    if (sesskeyReply.sesskey == null || sesskeyReply.sesskey.length() == 0) {
                        this.conn.setSessKey(null);
                        break;
                    }
                    this.conn.setSessKey(sesskeyReply.sesskey);
                    break;
                }
                case 76: {
                    this.logonEreply(replyMsg, logonWithNewPassword);
                    return false;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
        return true;
    }

    private void logonEreply(TbMsg msg, boolean logonWithNewPassword) throws SQLException {
        Debug.logMethod("TbComm.logonEreply", new Object[]{this.conn});
        ConnectionInfo info = this.conn.info;
        SQLException ex = this.getErrorMessage(-90502, msg);
        if (ex.getErrorCode() == -12060) {
            Debug.log("TbComm.authRequestEreply (RETRY TO SECONDARY NODE)");
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.conn.openConnection(info, logonWithNewPassword);
        } else if (ex.getErrorCode() == -12004) {
            Debug.log("TbComm.logonEreply (RETRY TO SAME NODE)");
            this.logon(logonWithNewPassword);
        } else {
            throw ex;
        }
    }

    private void logonSessInfoReply(TbMsgSessInfoReply msg) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(msg).append("[#\nsessionId=").append(msg.sessionId).append("/serialNo=").append(msg.serialNo);
        if (msg.nlsData != null) {
            for (int i = 0; i < msg.nlsData.length; ++i) {
                sb.append("\n/").append(msg.nlsData[i].nlsParamId).append("=").append(msg.nlsData[i].nlsParamVal);
            }
        }
        sb.append("#]");
        Debug.logMethod("TbComm.logonSessInfoReply", new Object[]{this.conn, sb.toString()});
        this.conn.setSessionId(msg.sessionId);
        this.conn.setSerialNo(msg.serialNo);
        this.conn.setNLSDate(msg.nlsData[0].nlsParamVal);
        this.conn.setNLSTimestamp(msg.nlsData[2].nlsParamVal);
        if (msg.nlsData.length > 8 && msg.nlsData[8].nlsParamVal != null) {
            this.conn.setNLSWarning(true);
            String pwdGExVal = msg.nlsData[8].nlsParamVal;
            if (pwdGExVal.equals("Y")) {
                this.conn.addWarning(TbError.newSQLWarning(-90547));
            } else {
                this.conn.addWarning(TbError.newSQLWarning(-90548, new Object[]{pwdGExVal}));
            }
        }
    }

    @Override
    public boolean open(TbLob lob, int mode) throws SQLException {
        return this.lobOpen(lob, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openSession() throws SQLException {
        Debug.logMethod("TbComm.openSession", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.OPEN_SESS(this.stream);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90504, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ping() throws SQLException {
        Debug.logMethod("TbComm.ping", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.TB_PING(this.stream, 0);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90500, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    @Override
    public long position(TbBlob blob, byte[] searchByte, long start) throws SQLException {
        return this.lobPosition((TbLob)blob, searchByte.toString(), start);
    }

    @Override
    public long position(TbClobBase clob, char[] searchStr, long start) throws SQLException {
        long pos = this.lobPosition((TbLob)clob, searchStr.toString(), start);
        return pos * (long)this.typeConverter.getUCS2MaxBytesPerChar();
    }

    @Override
    public long position(TbLob lob, TbLob searchLob, long start) throws SQLException {
        long pos = this.lobPosition(lob, searchLob, start);
        return lob instanceof TbBlob ? pos : pos * (long)this.typeConverter.getUCS2MaxBytesPerChar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(TbPreparedStatementImpl pstmt, String originalSql, Vector<Integer> paramTypes) throws SQLException {
        Debug.logMethod("TbComm.prepare", new Object[]{this.conn, pstmt, originalSql});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.PREPARE(this.stream, originalSql);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 4: {
                    this.prepareReply(pstmt, (TbMsgPrepareReply)replyMsg, paramTypes);
                    return;
                }
                case 76: {
                    this.throwEreply(-90506, replyMsg);
                    return;
                }
            }
            this.throwProtocolError(replyMsg.getMsgType());
        }
    }

    @Override
    public int prepareExecute(TbPreparedStatementImpl stmt, String sql, int rowIndex) throws SQLException {
        if (stmt.getPPID() != null) {
            return this.execute(stmt, sql, rowIndex);
        }
        Debug.logMethod("TbComm.prepareExecute", new Object[]{this.conn, stmt});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            this.processExecute(stmt, sql, rowIndex, false);
            TbMsg replyMsg = this.stream.readMsg();
            block16: while (true) {
                switch (replyMsg.getMsgType()) {
                    case 75: {
                        this.justOKReply((TbMsgOkReply)replyMsg);
                        return TbSQLTypeScanner.isPSMStmt(stmt.getSqlType()) ? 1 : 0;
                    }
                    case 2: {
                        this.executeSessInfoReply((TbMsgSessInfoReply)replyMsg);
                        return 0;
                    }
                    case 13: {
                        TbMsgExecuteCountReply countMsg = (TbMsgExecuteCountReply)replyMsg;
                        stmt.setPPID(countMsg.ppid);
                        return this.executeCountReply(stmt, countMsg);
                    }
                    case 11: {
                        TbMsgExecutePrefetchReply prefetchMsg = (TbMsgExecutePrefetchReply)replyMsg;
                        stmt.setPPID(prefetchMsg.ppid);
                        stmt.buildColMetaArray(prefetchMsg.colCnt, prefetchMsg.hiddenColCnt, prefetchMsg.colMeta);
                        return this.executePrefetchReply(stmt, prefetchMsg);
                    }
                    case 8: {
                        TbMsgExecuteRsetReply rsetMsg = (TbMsgExecuteRsetReply)replyMsg;
                        stmt.setPPID(rsetMsg.ppid);
                        stmt.buildColMetaArray(rsetMsg.colCnt, rsetMsg.hiddenColCnt, rsetMsg.colMeta);
                        return this.executeRsetReply(stmt, rsetMsg);
                    }
                    case 16: {
                        return this.executeNeedDataReply(replyMsg, stmt, rowIndex);
                    }
                    case 15: {
                        TbMsgExecutePsmReply psmMsg = (TbMsgExecutePsmReply)replyMsg;
                        return this.executeCallReply(stmt, rowIndex, psmMsg.paramData);
                    }
                    case 14: {
                        TbMsgExecuteCallReply callMsg = (TbMsgExecuteCallReply)replyMsg;
                        return this.executeCallReply(stmt, rowIndex, callMsg.paramData);
                    }
                    case 183: {
                        TbMsgExecutePsmPrefetchReply psmPrefetchMsg = (TbMsgExecutePsmPrefetchReply)replyMsg;
                        stmt.setPPID(psmPrefetchMsg.ppid);
                        stmt.buildColMetaArray(psmPrefetchMsg.colCnt, psmPrefetchMsg.hiddenColCnt, psmPrefetchMsg.colMeta);
                        if (!(stmt instanceof TbCallableStatementImpl)) {
                            return 1;
                        }
                        return this.executePsmPrefetchReply((TbCallableStatementImpl)stmt, rowIndex, psmPrefetchMsg);
                    }
                    case 9: {
                        replyMsg = this.executePivotReply(stmt, (TbMsgExecutePivotReply)replyMsg);
                        continue block16;
                    }
                    case 76: {
                        this.throwEreply(-90508, replyMsg);
                    }
                }
                this.throwProtocolError(replyMsg.getMsgType());
            }
        }
    }

    private void prepareReply(TbPreparedStatementImpl pstmt, TbMsgPrepareReply reply, Vector<Integer> paramTypes) {
        Debug.logMethod("TbComm.prepareReply", new Object[]{this.conn, pstmt, reply});
        if (reply.isPreparedDdl == 1) {
            pstmt.setPPID(null);
            pstmt.setParameterCnt(0);
        } else {
            int paramCnt = reply.bindParamCnt;
            pstmt.setPPID(reply.ppid);
            pstmt.setParameterCnt(paramCnt);
            for (int j = 0; j < paramCnt; ++j) {
                paramTypes.add(j, new Integer(reply.bindParamMeta[j].type));
            }
            pstmt.buildColMetaArray(reply.outColCnt, reply.hiddenColCnt, reply.colDesc);
        }
    }

    private void processExecute(TbPreparedStatementImpl stmt, String sql, int rowIndex, boolean havePPID) throws SQLException {
        TbStreamDataWriter writer = this.stream.getMsgWriter();
        int autoCommit = this.conn.getAutoCommit() ? 1 : 0;
        BindData bindData = stmt.getBindData();
        Binder[][] binder = stmt.getBinder();
        int paramCount = bindData.getParameterCnt();
        this.stream.startWritingPacketData();
        if (havePPID) {
            writer.writeInt(5, 4);
        } else {
            writer.writeInt(7, 4);
        }
        writer.writeInt(0, 4);
        writer.writeLong(0L, 8);
        if (havePPID) {
            writer.writeBytes(stmt.getPPID());
        } else {
            writer.writeLenAndDBEncodedPadString(sql == null ? "" : sql);
        }
        writer.writeInt(autoCommit, 4);
        writer.writeInt(stmt.getPreFetchSize(), 4);
        writer.writeInt(paramCount, 4);
        for (int i = 0; i < paramCount; ++i) {
            boolean isTable;
            if (binder[rowIndex][i] == null) {
                throw TbError.newSQLException(-90627);
            }
            BindItem item = bindData.getBindItem(i);
            int flag = item.getParamMode() & 0xFF | stmt.getParamType(rowIndex, i) << 8 & 0xFFFFFF00;
            writer.writeInt(flag, 4);
            boolean isObjProtocolAvailable = this.conn.serverInfo.getObjBindAvailable();
            boolean isObject = stmt.getParamType(rowIndex, i) == 32;
            boolean isVarray = stmt.getParamType(rowIndex, i) == 29;
            boolean bl = isTable = stmt.getParamType(rowIndex, i) == 30;
            if (!isObjProtocolAvailable && (isObject || isVarray || isTable)) {
                throw TbError.newSQLException(-90402);
            }
            binder[rowIndex][i].bind(this.conn, stmt, writer, rowIndex, i, item.getLength());
        }
        writer.reWriteInt(4, writer.getBufferedDataSize() - 16, 4);
        this.stream.flush();
    }

    private TbResultSet processPrefetchedRset(TbStatement stmt, int colCnt, int hiddenColCnt, int csrId, TbColumnDesc[] colMeta, int rowChunkSize, int rowCnt, int isFetchCompleted, long tsn) throws SQLException {
        byte[] rowChunk = new byte[rowChunkSize];
        this.stream.readChunkData(rowChunk, rowChunkSize);
        TbResultSet rs = this.typeConverter.toResultSet(colCnt, hiddenColCnt, csrId, colMeta, stmt, rowChunk);
        rs.setFetchCompleted(isFetchCompleted);
        rs.setTsn(tsn);
        rs.buildRowTable(rowCnt, rowChunk);
        return rs;
    }

    @Override
    public long read(TbBlob blob, long pos, byte[] buffer, long bufOffset, long len) throws SQLException {
        Debug.logMethod("TbComm.read", new Object[]{this.conn, blob, Long.toString(pos), buffer, Long.toString(bufOffset), Long.toString(len)});
        int splitLen = 0;
        int readLen = 0;
        long totalLen = 0L;
        do {
            splitLen = len - totalLen >= (long)TbLob.getMaxChunkSize() ? TbLob.getMaxChunkSize() : (int)(len - totalLen);
        } while (len > (totalLen += (long)(readLen = this.lobRead(blob, pos + totalLen, null, buffer, bufOffset + totalLen, splitLen))) && splitLen == readLen);
        return totalLen;
    }

    @Override
    public long read(TbClobBase clob, long pos, char[] buffer, long bufOffset, long len) throws SQLException {
        Debug.logMethod("TbComm.read", new Object[]{this.conn, clob, Long.toString(pos), Long.toString(len), Long.toString(bufOffset), buffer});
        int splitCharCnt = 0;
        int readCharCnt = 0;
        long totalCharCnt = 0L;
        int bytePerChar = 2;
        long byteOffset = pos * (long)bytePerChar;
        int maxChar = TbLob.getMaxChunkSize() / bytePerChar;
        do {
            splitCharCnt = len - totalCharCnt >= (long)maxChar ? maxChar : (int)(len - totalCharCnt);
            readCharCnt = this.lobRead(clob, byteOffset, buffer, null, bufOffset + totalCharCnt, splitCharCnt * bytePerChar);
            byteOffset += (long)(readCharCnt * bytePerChar);
        } while (len > (totalCharCnt += (long)readCharCnt) && !clob.isEndOfStream());
        return totalCharCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLong(byte[] locator) throws SQLException {
        Debug.logMethod("TbComm.readLong", new Object[]{this.conn, locator});
        StringBuffer sb = new StringBuffer();
        TbMsgLongReadReply reply = null;
        byte[] clb = new byte[3];
        int clbLen = 0;
        char[] cbuf = new char[65532];
        do {
            TbStream tbStream = this.stream;
            synchronized (tbStream) {
                TbMsgSend.LONG_READ(this.stream, 65532, locator, locator.length);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 53: {
                        byte[] src;
                        reply = (TbMsgLongReadReply)replyMsg;
                        locator = new byte[reply.longLoc.length];
                        System.arraycopy(reply.longLoc, 0, locator, 0, locator.length);
                        if (reply.data == null || reply.data.length == 0) break;
                        if (clbLen > 0) {
                            src = new byte[reply.data.length + clbLen];
                            System.arraycopy(clb, 0, src, 0, clbLen);
                            System.arraycopy(reply.data, 0, src, clbLen, reply.data.length);
                            clbLen = 0;
                        } else {
                            src = reply.data;
                        }
                        int clbOff = this.typeConverter.getEndingBytePos(src, src.length - 1);
                        if (clbOff > src.length - 1) {
                            clbOff = this.typeConverter.getLeadingBytePos(src, src.length - 1);
                            clbLen = src.length - clbOff;
                            System.arraycopy(src, clbOff, clb, 0, clbLen);
                        }
                        int charCnt = this.typeConverter.bytesToChars(src, 0, clbOff + 1, cbuf, 0, clbOff + 1);
                        sb.append(cbuf, 0, charCnt);
                        break;
                    }
                    case 76: {
                        throw this.getErrorMessage(-90534, replyMsg);
                    }
                    default: {
                        this.throwProtocolError(replyMsg.getMsgType());
                    }
                }
            }
        } while (reply.isLastData == 0);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readLongRaw(byte[] locator) throws SQLException {
        Debug.logMethod("TbComm.readLongRaw", new Object[]{this.conn, locator});
        ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
        TbMsgLongReadReply reply = null;
        do {
            TbStream tbStream = this.stream;
            synchronized (tbStream) {
                TbMsgSend.LONG_READ(this.stream, 65532, locator, locator.length);
                TbMsg replyMsg = this.stream.readMsg();
                switch (replyMsg.getMsgType()) {
                    case 53: {
                        reply = (TbMsgLongReadReply)replyMsg;
                        locator = new byte[reply.longLoc.length];
                        System.arraycopy(reply.longLoc, 0, locator, 0, locator.length);
                        byteBuf.write(reply.data, 0, reply.data.length);
                        break;
                    }
                    case 76: {
                        throw this.getErrorMessage(-90534, replyMsg);
                    }
                    default: {
                        this.throwProtocolError(replyMsg.getMsgType());
                    }
                }
            }
        } while (reply.isLastData == 0);
        return byteBuf.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        block6: {
            try {
                if (this.stream == null) break block6;
                TbStream tbStream = this.stream;
                synchronized (tbStream) {
                    this.stream.close();
                    this.stream = null;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            this.conn.reset();
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetSession() throws SQLException {
        Debug.logMethod("TbComm.resetSession", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.RESET_SESS(this.stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        Debug.logMethod("TbComm.rollback", new Object[]{this.conn});
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.ROLLBACK(this.stream, null);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90511, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(TbSavepoint savepoint) throws SQLException {
        Debug.logMethod("TbComm.rollback", new Object[]{this.conn});
        String savepointName = null;
        if (savepoint != null) {
            try {
                savepointName = savepoint.getSavepointName();
            }
            catch (SQLException e) {
                savepointName = "SVPT" + savepoint.getSavepointId();
            }
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.ROLLBACK(this.stream, savepointName);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90511, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    @Override
    public void setClientInfo(String[] clientInfo) throws SQLClientInfoException {
        Debug.logMethod("TbComm.setClientInfo", new Object[]{this.conn, clientInfo});
        HashMap<String, ClientInfoStatus> map = new HashMap<String, ClientInfoStatus>();
        for (int i = 0; i < clientInfo.length; ++i) {
            map.put(TbConnection.CLIENT_INFO_KEYS[i], ClientInfoStatus.REASON_UNKNOWN);
        }
        String msg = TbError.getMsg(-90545);
        String state = TbError.getSQLState(-90545);
        throw new SQLClientInfoException(msg, state, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsolationLevel(int level) throws SQLException {
        Debug.logMethod("TbComm.setIsolationLevel", new Object[]{this.conn, Integer.toString(level)});
        int dbIsolation = 0;
        if (level == 2) {
            dbIsolation = 0;
        } else if (level == 8) {
            dbIsolation = 1;
        } else {
            throw TbError.newSQLException(-590722);
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.SET_ISL_LVL(this.stream, dbIsolation);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90513, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSavePoint(TbSavepoint savepoint) throws SQLException {
        Debug.logMethod("TbComm.setSavePoint", new Object[]{this.conn});
        String savepointName = null;
        try {
            savepointName = savepoint.getSavepointName();
        }
        catch (SQLException e) {
            savepointName = "SVPT" + savepoint.getSavepointId();
        }
        TbStream tbStream = this.stream;
        synchronized (tbStream) {
            TbMsgSend.SAVEPT(this.stream, savepointName);
            TbMsg replyMsg = this.stream.readMsg();
            switch (replyMsg.getMsgType()) {
                case 75: {
                    this.justOKReply((TbMsgOkReply)replyMsg);
                    break;
                }
                case 76: {
                    this.throwEreply(-90514, replyMsg);
                    break;
                }
                default: {
                    this.throwProtocolError(replyMsg.getMsgType());
                }
            }
        }
    }

    private void throwEreply(int errorCode, TbMsg msg) throws SQLException {
        SQLException ex = this.getErrorMessage(errorCode, msg);
        throw ex;
    }

    private void throwProtocolError(int msgType) throws SQLException {
        throw TbError.newSQLException(-590727, msgType);
    }

    @Override
    public void truncate(TbLob lob, long len) throws SQLException {
        if (lob instanceof TbNClob) {
            len *= (long)this.typeConverter.getMaxBytesPerNChar();
        } else if (lob instanceof TbClob) {
            len *= (long)this.typeConverter.getUCS2MaxBytesPerChar();
        }
        this.lobTruncate(lob, len);
    }

    @Override
    public long write(TbBlob blob, long pos, byte[] buffer, long bufOffset, long len) throws SQLException {
        boolean firstMsg = true;
        boolean lastMsg = false;
        int splitLen = 0;
        long totalLen = 0L;
        int flag = 0;
        if (len <= (long)TbLob.getMaxChunkSize()) {
            this.lobWrite(blob, pos, null, buffer, bufOffset, len, 0x3000000);
            return len;
        }
        do {
            if (len - totalLen > (long)TbLob.getMaxChunkSize()) {
                splitLen = TbLob.getMaxChunkSize();
            } else {
                splitLen = (int)(len - totalLen);
                lastMsg = true;
            }
            flag = 0;
            if (firstMsg) {
                flag = 0x1000000;
            } else if (lastMsg) {
                flag = 0x2000000;
            }
            this.lobWrite(blob, pos + totalLen, null, buffer, bufOffset + totalLen, splitLen, flag);
            firstMsg = false;
        } while (len > (totalLen += (long)splitLen));
        return totalLen;
    }

    @Override
    public long write(TbClobBase clob, long pos, char[] buffer, long bufOffset, long len) throws SQLException {
        boolean firstMsg = true;
        boolean lastMsg = false;
        int splitCharCnt = 0;
        long totalCharCnt = 0L;
        int flag = 0;
        int bytePerChar = 2;
        int maxChar = TbLob.getMaxChunkSize() / bytePerChar;
        long byteOffset = pos * (long)bytePerChar;
        if (len <= (long)maxChar) {
            this.lobWrite(clob, byteOffset, buffer, null, bufOffset, len, 0x3000000);
            return len;
        }
        do {
            if (len - totalCharCnt > (long)maxChar) {
                splitCharCnt = maxChar;
            } else {
                splitCharCnt = (int)(len - totalCharCnt);
                lastMsg = true;
            }
            flag = 0;
            if (firstMsg) {
                flag = 0x1000000;
            } else if (lastMsg) {
                flag = 0x2000000;
            }
            this.lobWrite(clob, byteOffset, buffer, null, bufOffset + totalCharCnt, splitCharCnt, flag);
            byteOffset += (long)(splitCharCnt * bytePerChar);
            firstMsg = false;
        } while (len > (totalCharCnt += (long)splitCharCnt));
        return totalCharCnt;
    }
}

