/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.UdtAttrMeta;
import com.tmax.tibero.jdbc.data.UdtHierarchyInfo;
import com.tmax.tibero.jdbc.data.UdtInfo;
import com.tmax.tibero.jdbc.data.UdtMeta;
import com.tmax.tibero.jdbc.driver.TbConnection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class TbTypeDescriptor {
    public static final String UDT_INFO_SQLTYPENAME = "SYS.UDT_INFO_T";
    public static final String ATTR_META_SQLTYPENAME = "SYS.ATTR_META_T";
    public static final String ATTR_IDX_ARRAY_SQLTYPENAME = "SYS.ATTR_IDX_ARR";
    public static final String HIERARCHY_INFO_SQLTYPENAME = "SYS.HIERARCHY_INFO_T";
    public static final String ATTR_META_ARRAY_SQLTYPENAME = "SYS.ATTR_META_ARR";
    public static final String HIERARCHY_INFO_ARRAY_SQLTYPENAME = "SYS.HIERARCHY_INFO_ARR";
    public static final String UDT_META_SQLTYPENAME = "SYS.UDT_META_T";
    public static final String SQLTYPENAME_XMLTYPE = "SYS.XMLTYPE";
    public static final String UDT_INFO_OID = "00000000000000000000000000000003";
    public static final String ATTR_META_OID = "00000000000000000000000000000004";
    public static final String ATTR_IDX_ARRAY_OID = "00000000000000000000000000000005";
    public static final String HIERARCHY_INFO_OID = "00000000000000000000000000000006";
    public static final String ATTR_META_ARRAY_OID = "00000000000000000000000000000007";
    public static final String HIERARCHY_INFO_ARRAY_OID = "00000000000000000000000000000008";
    public static final String UDT_META_OID = "00000000000000000000000000000009";
    public static final String OID_XMLTYPE = "00000000000000000000000000000001";
    public static final String _DESC_OID_PREFIX = "/O";
    public static List<String> preDefinedOIDList = new ArrayList<String>();
    public static List<String> preDefinedTypeNameList = new ArrayList<String>();
    private static Map<String, Class<?>> udtMeta2ClsMap;
    private String sqlTypeName;
    private String schemaName;
    private String packageName;
    private String typeName;
    private int dataType;
    private String hexEncodedOID;
    private int tobjID;
    private int versionNo;

    void init(int dataType, String oid, String sqlTypeName) throws SQLException {
        this.dataType = dataType;
        this.hexEncodedOID = oid;
        this.sqlTypeName = sqlTypeName;
        this.parseSQLTypeName(sqlTypeName);
    }

    public static List<TbTypeDescriptor> genPredefUDTDescs(TbConnection conn) {
        ArrayList<TbTypeDescriptor> descs = new ArrayList<TbTypeDescriptor>(7);
        try {
            descs.add(new TbStructDescriptor(32, UDT_INFO_OID, UDT_INFO_SQLTYPENAME, new int[]{3, 3, 3, 3, 1, 1, 1, 4}, new String[8], new String[8], conn));
            descs.add(new TbStructDescriptor(32, ATTR_META_OID, ATTR_META_SQLTYPENAME, new int[]{3, 1, 1, 1, 1, 3}, new String[6], new String[6], conn));
            descs.add(new TbArrayDescriptor(29, ATTR_IDX_ARRAY_OID, ATTR_IDX_ARRAY_SQLTYPENAME, 1, null, 1500, conn));
            descs.add(new TbStructDescriptor(32, HIERARCHY_INFO_OID, HIERARCHY_INFO_SQLTYPENAME, new int[]{32, 29, 4}, new String[]{UDT_INFO_SQLTYPENAME, ATTR_IDX_ARRAY_SQLTYPENAME, null}, new String[]{UDT_INFO_OID, ATTR_IDX_ARRAY_OID, null}, conn));
            descs.add(new TbArrayDescriptor(29, ATTR_META_ARRAY_OID, ATTR_META_ARRAY_SQLTYPENAME, 32, ATTR_META_SQLTYPENAME, 1500, conn));
            descs.add(new TbArrayDescriptor(29, HIERARCHY_INFO_ARRAY_OID, HIERARCHY_INFO_ARRAY_SQLTYPENAME, 32, HIERARCHY_INFO_SQLTYPENAME, 1500, conn));
            descs.add(new TbStructDescriptor(32, UDT_META_OID, UDT_META_SQLTYPENAME, new int[]{1, 32, 29, 29, 1, 1}, new String[]{null, UDT_INFO_SQLTYPENAME, ATTR_META_ARRAY_SQLTYPENAME, HIERARCHY_INFO_ARRAY_SQLTYPENAME, null, null}, new String[]{null, UDT_INFO_OID, ATTR_META_ARRAY_OID, HIERARCHY_INFO_ARRAY_OID, null, null}, conn));
            if (conn != null) {
                for (int i = 0; i < descs.size(); ++i) {
                    TbTypeDescriptor desc = (TbTypeDescriptor)descs.get(i);
                    conn.putDescriptor(_DESC_OID_PREFIX + desc.getOID(), desc);
                    conn.putDescriptor(desc.getSQLTypeName(), desc);
                }
            }
        }
        catch (Exception e) {
            descs.clear();
            Debug.logThrowable(e);
        }
        return descs;
    }

    public static Map<String, Class<?>> getUdtMeta2ClsMap() {
        if (udtMeta2ClsMap.size() == 0) {
            udtMeta2ClsMap.put(UDT_INFO_SQLTYPENAME, UdtInfo.class);
            udtMeta2ClsMap.put(ATTR_META_SQLTYPENAME, UdtAttrMeta.class);
            udtMeta2ClsMap.put(HIERARCHY_INFO_SQLTYPENAME, UdtHierarchyInfo.class);
            udtMeta2ClsMap.put(UDT_META_SQLTYPENAME, UdtMeta.class);
        }
        return udtMeta2ClsMap;
    }

    public String getSQLTypeName() {
        return this.sqlTypeName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getOID() {
        return this.hexEncodedOID;
    }

    public int getVersionNo() {
        return this.versionNo;
    }

    public int getTobjID() {
        return this.tobjID;
    }

    public void setVersionNo(int version) {
        this.versionNo = version;
    }

    public void setTobjID(int id) {
        this.tobjID = id;
    }

    private int parseSQLTypeName(String name) throws SQLException {
        String delimeter = ".";
        StringTokenizer token = new StringTokenizer(name, delimeter);
        int tokenSize = token.countTokens();
        if (tokenSize == 2) {
            this.schemaName = token.nextToken().toUpperCase();
            this.typeName = token.nextToken().toUpperCase();
            this.packageName = null;
        } else if (tokenSize == 3) {
            this.schemaName = token.nextToken().toUpperCase();
            this.packageName = token.nextToken().toUpperCase();
            this.typeName = token.nextToken().toUpperCase();
        } else {
            throw new SQLException("Invalid type name : " + name);
        }
        return tokenSize;
    }

    public static String[] splitSQLTypeName(String name) {
        String[] tokens = null;
        String delim = "[.]{1}";
        tokens = name.split(delim);
        return tokens;
    }

    protected void setOID(String oid) {
        this.hexEncodedOID = oid;
    }

    static {
        preDefinedOIDList.add("/O00000000000000000000000000000003");
        preDefinedOIDList.add("/O00000000000000000000000000000004");
        preDefinedOIDList.add("/O00000000000000000000000000000005");
        preDefinedOIDList.add("/O00000000000000000000000000000006");
        preDefinedOIDList.add("/O00000000000000000000000000000007");
        preDefinedOIDList.add("/O00000000000000000000000000000008");
        preDefinedOIDList.add("/O00000000000000000000000000000009");
        preDefinedOIDList.add("/O00000000000000000000000000000001");
        preDefinedTypeNameList.add(UDT_INFO_SQLTYPENAME);
        preDefinedTypeNameList.add(ATTR_META_SQLTYPENAME);
        preDefinedTypeNameList.add(ATTR_IDX_ARRAY_SQLTYPENAME);
        preDefinedTypeNameList.add(HIERARCHY_INFO_SQLTYPENAME);
        preDefinedTypeNameList.add(ATTR_META_ARRAY_SQLTYPENAME);
        preDefinedTypeNameList.add(HIERARCHY_INFO_ARRAY_SQLTYPENAME);
        preDefinedTypeNameList.add(UDT_META_SQLTYPENAME);
        preDefinedTypeNameList.add(SQLTYPENAME_XMLTYPE);
        udtMeta2ClsMap = new HashMap();
    }
}

