/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbSQLInput;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.UdtAttrMeta;
import com.tmax.tibero.jdbc.data.UdtHierarchyInfo;
import com.tmax.tibero.jdbc.data.UdtInfo;
import com.tmax.tibero.jdbc.data.UdtMeta;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;

public class TbStructDescriptor
extends TbTypeDescriptor {
    private TbConnection conn;
    private int memberNo;
    private int numOfFields;
    private int[] attributeTypes;
    private String[] attributeTypeNames;
    private String[] attributeOIDs;
    private boolean isFinal = true;
    public static final String _DESC_OID_PREFIX = "/O";
    public static final String _DESC_TOBJ_ID_PREFIX = "/T";
    public static final String _DESC_VERSION_NO_PREFIX = "/V";

    protected TbStructDescriptor(String typeName, Connection conn) throws SQLException {
        this.init(32, null, typeName.toUpperCase());
        this.conn = (TbConnection)conn;
    }

    protected TbStructDescriptor(int kind, String hexEncodedOID, String sqlTypeName, int[] attrTypes, String[] attrTypeNames, String[] attrOIDs, TbConnection conn) throws SQLException {
        this.init(kind, hexEncodedOID, sqlTypeName);
        this.attributeTypes = attrTypes;
        this.numOfFields = attrTypes.length;
        this.attributeTypeNames = attrTypeNames;
        this.attributeOIDs = attrOIDs;
        this.conn = conn;
    }

    public static TbStructDescriptor createDescriptor(String sqlTypeName, Connection conn) throws SQLException {
        Debug.logMethod("TbStructDescriptor.createDescriptor", new Object[]{sqlTypeName, conn});
        if (sqlTypeName == null || sqlTypeName.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + sqlTypeName + "]");
        }
        if (!(conn instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + conn + "]");
        }
        TbConnection tbconn = (TbConnection)conn;
        if (!tbconn.getExtFeatureInfo().supports(2)) {
            throw TbError.newSQLException(-90203);
        }
        String fullTypeName = sqlTypeName.toUpperCase();
        Object obj = tbconn.getDescriptor(fullTypeName);
        if (obj instanceof TbStructDescriptor) {
            return (TbStructDescriptor)obj;
        }
        if (obj != null) {
            throw TbError.newSQLException(-90666);
        }
        String[] tokens = TbTypeDescriptor.splitSQLTypeName(fullTypeName);
        if (tokens.length != 2) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + sqlTypeName + "]");
        }
        return TbStructDescriptor.lookupUdtMeta(tokens[0], tokens[1], tbconn);
    }

    public static TbStructDescriptor createDescriptor(int kind, String hexEncodedOID, Connection conn) throws SQLException {
        Debug.logMethod("TbStructDescriptor.createDescriptor", new Object[]{String.valueOf(kind), hexEncodedOID, conn});
        if (hexEncodedOID == null || hexEncodedOID.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + hexEncodedOID + "]");
        }
        if (!(conn instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + conn + "]");
        }
        TbConnection tbconn = (TbConnection)conn;
        Object obj = tbconn.getDescriptor(_DESC_OID_PREFIX + hexEncodedOID);
        if (obj instanceof TbStructDescriptor) {
            return (TbStructDescriptor)obj;
        }
        if (obj != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbStructDescriptor.lookupUdtMeta(hexEncodedOID, tbconn);
    }

    public static TbStructDescriptor createDescriptor(int kind, String hexEncodedOID, int tobjID, int versionNo, Connection conn) throws SQLException {
        Debug.logMethod("TbStructDescriptor.createDescriptor", new Object[]{String.valueOf(kind), hexEncodedOID, conn});
        if (hexEncodedOID == null || hexEncodedOID.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + hexEncodedOID + "]");
        }
        if (!(conn instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + conn + "]");
        }
        TbConnection tbconn = (TbConnection)conn;
        Object obj = tbconn.getDescriptor(_DESC_OID_PREFIX + hexEncodedOID + _DESC_TOBJ_ID_PREFIX + tobjID + _DESC_VERSION_NO_PREFIX + versionNo);
        if (obj instanceof TbStructDescriptor) {
            return (TbStructDescriptor)obj;
        }
        if (obj != null) {
            throw TbError.newSQLException(-90666);
        }
        return TbStructDescriptor.lookupUdtMeta(hexEncodedOID, tbconn);
    }

    public static TbStructDescriptor lookupUdtMeta(String hexEncodedOID, TbConnection conn) throws SQLException {
        Debug.logMethod("TbStructDescriptor.lookupUdtMeta", new Object[]{hexEncodedOID, conn});
        if ("00000000000000000000000000000009".equalsIgnoreCase(hexEncodedOID)) {
            return null;
        }
        if (hexEncodedOID == null || hexEncodedOID.length() == 0) {
            throw TbError.newSQLException(-90608, "OID(hex)[" + hexEncodedOID + "]");
        }
        PreparedStatement pstmt = conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_OID);
        pstmt.setString(1, hexEncodedOID);
        ResultSet rs = pstmt.executeQuery();
        return TbStructDescriptor.lookupUdtMetaInternal((TbResultSetBase)rs, conn);
    }

    public static TbStructDescriptor lookupUdtMeta(String schemaName, String typeName, TbConnection conn) throws SQLException {
        Debug.logMethod("TbStructDescriptor.lookupUdtMeta", new Object[]{schemaName, typeName, conn});
        if ("SYS.UDT_META_T".equalsIgnoreCase(schemaName + "." + typeName)) {
            return null;
        }
        if (typeName == null || typeName.length() == 0) {
            throw TbError.newSQLException(-90608, "typeName[" + typeName + "]");
        }
        PreparedStatement pstmt = conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDTMETA__BY_TYPENAME);
        pstmt.setString(1, schemaName);
        pstmt.setString(2, typeName);
        ResultSet rs = pstmt.executeQuery();
        return TbStructDescriptor.lookupUdtMetaInternal((TbResultSetBase)rs, conn);
    }

    private static TbStructDescriptor lookupUdtMetaInternal(TbResultSetBase rs, TbConnection conn) throws SQLException {
        if (!rs.next()) {
            throw TbError.newSQLException(-90665);
        }
        try {
            Object o = rs.getObject(1, TbTypeDescriptor.getUdtMeta2ClsMap());
            if (!(o instanceof UdtMeta)) {
                throw TbError.newSQLException(-90664);
            }
            UdtMeta udt = (UdtMeta)o;
            int udtInfoVersionNo = udt.getUdtId().getVersionNo();
            int udtInfoTobjID = udt.getUdtId().getTobjID();
            Object[] attrMetaArr = (Object[])udt.getAttrMetaArr().getArray();
            Object[] hierInfoArr = (Object[])udt.getHierarchyInfoArr().getArray();
            TbStructDescriptor returnDesc = null;
            for (int i = 0; i < udt.getHierarchyCnt(); ++i) {
                UdtHierarchyInfo hInfo = (UdtHierarchyInfo)hierInfoArr[i];
                byte[] isFinal = hInfo.getProperties();
                UdtInfo udtId = hInfo.getUdtId();
                BigDecimal[] idxArr = (BigDecimal[])hInfo.getAttrIdxArr().getArray();
                int[] attrTypes = new int[idxArr.length];
                String[] attrTypeNames = new String[idxArr.length];
                String[] attrOIDs = new String[idxArr.length];
                String sqlTypeName = udtId.getSchemaName() + "." + udtId.getUdtName();
                for (int j = 0; j < idxArr.length; ++j) {
                    UdtAttrMeta attrMeta = (UdtAttrMeta)attrMetaArr[idxArr[j].intValue() - 1];
                    attrTypes[j] = attrMeta.getTypeNo();
                    attrOIDs[j] = attrMeta.getOid();
                }
                TbStructDescriptor newDesc = new TbStructDescriptor(udtId.getTypeNo(), udtId.getOid(), sqlTypeName, attrTypes, attrTypeNames, attrOIDs, conn);
                newDesc.setVersionNo(udtInfoVersionNo);
                newDesc.setTobjID(udtInfoTobjID);
                newDesc.setIsFinal(isFinal);
                if (i == 0) {
                    returnDesc = newDesc;
                }
                conn.putDescriptor(sqlTypeName, newDesc);
                conn.putDescriptor(_DESC_OID_PREFIX + udtId.getOid(), newDesc);
            }
            return returnDesc;
        }
        catch (SQLException e) {
            int ec = e.getErrorCode();
            if (ec <= -90400 && ec > -90500 || ec == -90664) {
                throw e;
            }
            throw TbError.newSQLException(-90664, e);
        }
        catch (Exception e) {
            throw TbError.newSQLException(-90664, e);
        }
    }

    public SQLInput toSQLInput(TbStruct struct, Map<String, Class<?>> map) throws SQLException {
        return new TbSQLInput(struct, this, map);
    }

    public SQLOutput toSQLOutput() {
        return new TbSQLOutput(this, this.conn);
    }

    public int getNumOfFields() {
        return this.numOfFields;
    }

    public String[] getAttributeOIDs() {
        return this.attributeOIDs;
    }

    public int[] getAttributeTypes() {
        return this.attributeTypes;
    }

    public String[] getAttributeTypeNames() {
        return this.attributeTypeNames;
    }

    public int getMemberNo() {
        return this.memberNo;
    }

    public Class<?> getClass(Map<String, Class<?>> map) throws SQLException {
        Class<?> cls;
        String sqlTypeName = this.getSQLTypeName();
        Class<?> c = map.get(sqlTypeName);
        if (c == null && this.conn != null && (cls = this.conn.getTypeMap().get(sqlTypeName)) instanceof Class) {
            c = cls;
        }
        return c;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setIsFinal(byte[] fin) throws SQLException {
        if (fin[0] == 1) {
            this.isFinal = true;
        } else if (fin[0] == 0) {
            this.isFinal = false;
        } else {
            throw TbError.newSQLException(-90664);
        }
    }
}

