/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArray;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbStruct
implements Struct {
    private TbStructDescriptor descriptor;
    private TbConnection conn;
    private Object[] attributes;
    private Params subParams;

    public TbStruct(TbStructDescriptor desc, Connection conn, Object[] attributes) throws SQLException {
        if (desc == null) {
            throw TbError.newSQLException(-90608, "desc=null");
        }
        if (conn == null) {
            throw TbError.newSQLException(-90608, "conn=null");
        }
        this.descriptor = desc;
        this.conn = (TbConnection)conn;
        this.attributes = attributes;
        int numOfFields = desc.getNumOfFields();
        int[] attributeTypes = desc.getAttributeTypes();
        this.subParams = new Params();
        this.initSubParams(numOfFields, attributeTypes, attributes);
    }

    private void initSubParams(int size, int[] attributeTypes, Object[] attributes) throws SQLException {
        int numOfAttr = attributes == null ? 0 : attributes.length;
        Params.access$002(this.subParams, new Binder[size]);
        this.subParams.bindData = new BindData(size);
        block11: for (int i = 0; i < numOfAttr; ++i) {
            if (attributes[i] == null) {
                ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                continue;
            }
            switch (attributeTypes[i]) {
                case 1: {
                    String subErrMsg;
                    if (this.subParams.paramBigDecimal == null) {
                        Params.access$202(this.subParams, new BigDecimal[size]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBigDecimalBinder();
                    if (attributes[i] instanceof Short) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Short)attributes[i]).intValue());
                    } else if (attributes[i] instanceof Integer) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Integer)attributes[i]);
                    } else if (attributes[i] instanceof Long) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Long)attributes[i]);
                    } else if (attributes[i] instanceof BigInteger) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((BigInteger)attributes[i]);
                    } else if (attributes[i] instanceof BigDecimal) {
                        ((Params)this.subParams).paramBigDecimal[i] = (BigDecimal)attributes[i];
                    } else if (attributes[i] instanceof Float) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Float)attributes[i]).floatValue());
                    } else if (attributes[i] instanceof Double) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Double)attributes[i]);
                    } else if (attributes[i] instanceof String) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((String)attributes[i]);
                    } else if (attributes[i] instanceof Boolean) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Boolean)attributes[i] != false ? 1.0 : 0.0);
                    } else {
                        subErrMsg = "elementType=" + DataType.getDBTypeName(attributeTypes[i]) + ",attribute=" + attributes[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 2: 
                case 3: 
                case 10: {
                    if (this.subParams.paramString == null) {
                        Params.access$302(this.subParams, new String[size]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStringBinder();
                    ((Params)this.subParams).paramString[i] = attributes[i] instanceof Boolean ? ((Boolean)attributes[i] != false ? "1" : "0") : (attributes[i] == null ? null : attributes[i].toString());
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 18: 
                case 19: {
                    if (this.subParams.paramString == null) {
                        Params.access$302(this.subParams, new String[size]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNStringBinder();
                    ((Params)this.subParams).paramString[i] = attributes[i] instanceof Boolean ? ((Boolean)attributes[i] != false ? "1" : "0") : (attributes[i] == null ? null : attributes[i].toString());
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 4: {
                    String subErrMsg;
                    if (this.subParams.paramBytes == null) {
                        Params.access$402(this.subParams, new byte[size][]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                    if (!(attributes[i] instanceof byte[])) {
                        subErrMsg = "elementType=" + DataType.getDBTypeName(attributeTypes[i]) + ",attribute=" + attributes[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    ((Params)this.subParams).paramBytes[i] = (byte[])attributes[i];
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 5: {
                    Calendar cal;
                    String subErrMsg;
                    if (attributes[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance(((TbTimestampTZ)attributes[i]).getTimeZone());
                        cal.setTime((TbTimestampTZ)attributes[i]);
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (attributes[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[size]);
                        }
                        TbTimestamp tts = (TbTimestamp)attributes[i];
                        ((Params)this.subParams).paramTbDate[i] = new TbDate(tts.getYear(), tts.getMonth(), tts.getDayOfMonth(), tts.getHourOfDay(), tts.getMinutes(), tts.getSeconds());
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (attributes[i] instanceof TbDate) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$602(this.subParams, new TbDate[size]);
                        }
                        ((Params)this.subParams).paramTbDate[i] = (TbDate)attributes[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbDateBinder();
                    } else if (attributes[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance();
                        cal.setTime((Date)attributes[i]);
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (attributes[i] instanceof Timestamp) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance();
                        cal.setTime((Timestamp)attributes[i]);
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (attributes[i] instanceof String) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance();
                        cal.setTime(Date.valueOf((String)attributes[i]));
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else {
                        subErrMsg = "elementType=" + DataType.getDBTypeName(attributeTypes[i]) + ",attribute=" + attributes[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 7: {
                    Calendar cal;
                    String subErrMsg;
                    if (attributes[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[size]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)attributes[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (attributes[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[size]);
                        }
                        ((Params)this.subParams).paramTbTimestamp[i] = (TbTimestamp)attributes[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (attributes[i] instanceof TbDate) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$802(this.subParams, new TbTimestamp[size]);
                        }
                        TbDate td = (TbDate)attributes[i];
                        ((Params)this.subParams).paramTbTimestamp[i] = new TbTimestamp(td.getYear(), td.getMonth(), td.getDayOfMonth(), td.getHourOfDay(), td.getMinutes(), td.getSeconds(), 0);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                    } else if (attributes[i] instanceof Timestamp) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[size]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)attributes[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                    } else if (attributes[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$502(this.subParams, new Calendar[size]);
                        }
                        cal = Calendar.getInstance();
                        cal.setTime((Date)attributes[i]);
                        ((Params)this.subParams).paramCalendar[i] = cal;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                    } else if (attributes[i] instanceof String) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$702(this.subParams, new Timestamp[size]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = Timestamp.valueOf((String)attributes[i]);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                    } else {
                        subErrMsg = "elementType=" + DataType.getDBTypeName(attributeTypes[i]) + ",attribute=" + attributes[i];
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 12: 
                case 13: 
                case 20: {
                    String subErrMsg;
                    if (attributes[i] instanceof TbLob) {
                        if (this.subParams.paramBytes == null) {
                            Params.access$402(this.subParams, new byte[size][]);
                        }
                    } else {
                        subErrMsg = "elementType=" + DataType.getDBTypeName(attributeTypes[i]) + ",attribute=" + attributes;
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    ((Params)this.subParams).paramBytes[i] = ((TbLob)attributes[i]).getLocator();
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 29: 
                case 30: 
                case 31: {
                    String subErrMsg;
                    if (this.subParams.paramArray == null) {
                        Params.access$902(this.subParams, new Array[size]);
                    }
                    if (attributes[i] instanceof Array) {
                        ((Params)this.subParams).paramArray[i] = (Array)attributes[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getArrayInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbArray)attributes[i]).getDescriptor());
                    } else if (attributes[i] == null) {
                        ((Params)this.subParams).paramArray[i] = null;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                    } else {
                        subErrMsg = "elementType=" + DataType.getDBTypeName(attributeTypes[i]) + ",attribute=" + attributes;
                        throw TbError.newSQLException(-90651, subErrMsg);
                    }
                    this.subParams.bindData.setINParam(i, attributeTypes[i], 0);
                    continue block11;
                }
                case 28: 
                case 32: {
                    if (this.subParams.paramStruct == null) {
                        Params.access$1002(this.subParams, new Struct[size]);
                    }
                    if (attributes[i] instanceof Struct) {
                        ((Params)this.subParams).paramStruct[i] = (Struct)attributes[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)attributes[i]).getDescriptor());
                        continue block11;
                    }
                    if (attributes[i] instanceof SQLData) {
                        Struct struct;
                        ((Params)this.subParams).paramStruct[i] = struct = (Struct)TbStruct.toStruct(attributes[i], this.conn);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStructInBinder();
                        this.subParams.getBindData().getBindItem(i).setTypeDescriptor(((TbStruct)struct).getDescriptor());
                        continue block11;
                    }
                    if (attributes[i] == null) {
                        ((Params)this.subParams).paramStruct[i] = null;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                        continue block11;
                    }
                    String subErrMsg = "elementType=" + DataType.getDBTypeName(attributeTypes[i]) + ",attribute=" + attributes;
                    throw TbError.newSQLException(-90651, subErrMsg);
                }
                default: {
                    throw TbError.newSQLException(-590703, DataType.getDBTypeName(attributeTypes[i]));
                }
            }
        }
    }

    public TbStructDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public int getNumOfFields() {
        return this.descriptor.getNumOfFields();
    }

    public static Object toStruct(Object x, Connection conn) throws SQLException {
        TbStruct struct = null;
        if (x != null) {
            if (x instanceof TbStruct) {
                struct = (TbStruct)x;
            } else if (x instanceof SQLData) {
                SQLData sqlData = (SQLData)x;
                TbStructDescriptor descriptor = TbStructDescriptor.createDescriptor(sqlData.getSQLTypeName(), conn);
                SQLOutput sqlOutput = descriptor.toSQLOutput();
                sqlData.writeSQL(sqlOutput);
                struct = ((TbSQLOutput)sqlOutput).getStruct();
            } else {
                throw TbError.newSQLException(-90651, String.valueOf(x));
            }
        }
        return struct;
    }

    public ParamContainer getSubParams() {
        return this.subParams;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.descriptor.getSQLTypeName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        Debug.logMethod("TbArray.getAttributes", new Object[0]);
        return this.attributes;
    }

    public Object toClass(Class<?> c, Map<String, Class<?>> map) throws SQLException {
        if (c == null) {
            return this;
        }
        Object obj = null;
        try {
            obj = c.newInstance();
            if (obj instanceof SQLData) {
                ((SQLData)obj).readSQL(this.descriptor.toSQLInput(this, map), this.descriptor.getSQLTypeName());
            }
        }
        catch (InstantiationException e) {
            throw TbError.newSQLException(-90651, e);
        }
        catch (IllegalAccessException e) {
            throw TbError.newSQLException(-90651, e);
        }
        return obj;
    }

    public Object toClass(Map<String, Class<?>> map) throws SQLException {
        Class<?> c;
        Object obj = this;
        Map<String, Class<?>> typeMap = map;
        if (typeMap != null) {
            Class<?> c2 = this.descriptor.getClass(typeMap);
            if (c2 != null) {
                obj = this.toClass(c2, typeMap);
            }
        } else if (this.conn != null && (c = this.descriptor.getClass(typeMap = this.conn.getTypeMap())) != null) {
            obj = this.toClass(c, typeMap);
        }
        return obj;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> paramMap) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    class Params
    implements ParamContainer {
        private Binder[] attributeBinders;
        private BindData bindData;
        private BigDecimal[] paramBigDecimal;
        private String[] paramString;
        private Timestamp[] paramTimestamp;
        private TbTimestampTZ[] paramTbTimestampTZ;
        private TbTimestamp[] paramTbTimestamp;
        private TbDate[] paramTbDate;
        private Calendar[] paramCalendar;
        private byte[][] paramBytes;
        private InputStream[] paramStream;
        private Reader[] paramReader;
        private Struct[] paramStruct;
        private Array[] paramArray;

        Params() {
        }

        @Override
        public BindData getBindData() {
            return this.bindData;
        }

        @Override
        public Binder[][] getBinder() {
            return null;
        }

        @Override
        public Binder getBinder(int rowIndex, int colIndex) {
            return this.attributeBinders[colIndex];
        }

        @Override
        public int getParameterCnt() {
            return 1;
        }

        @Override
        public byte getParamType(int rowIndex, int colIndex) {
            return 0;
        }

        @Override
        public byte[][] getParamTypes() {
            return null;
        }

        @Override
        public byte[] getParamTypesOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Array getParamArray(int rowIndex, int colIndex) {
            return this.paramArray[colIndex];
        }

        @Override
        public Array[] getParamArrayOfRow(int rowIndex) {
            return null;
        }

        @Override
        public BigDecimal getParamBigDecimal(int rowIndex, int colIndex) {
            return this.paramBigDecimal[colIndex];
        }

        @Override
        public BigDecimal[] getParamBigDecimalOfRow(int rowIndex) {
            return null;
        }

        @Override
        public byte[] getParamBytes(int rowIndex, int colIndex) {
            return this.paramBytes[colIndex];
        }

        @Override
        public byte[][] getParamBytesOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Calendar getParamCalendar(int rowIndex, int colIndex) {
            return this.paramCalendar[colIndex];
        }

        @Override
        public Calendar[] getParamCalendarOfRow(int rowIndex) {
            return null;
        }

        @Override
        public double getParamDouble(int rowIndex, int colIndex) {
            return 0.0;
        }

        @Override
        public double[] getParamDoubleOfRow(int rowIndex) {
            return null;
        }

        @Override
        public float getParamFloat(int rowIndex, int colIndex) {
            return 0.0f;
        }

        @Override
        public float[] getParamFloatOfRow(int rowIndex) {
            return null;
        }

        @Override
        public int getParamInt(int rowIndex, int colIndex) {
            return 0;
        }

        @Override
        public int[] getParamIntOfRow(int rowIndex) {
            return null;
        }

        @Override
        public long getParamLong(int rowIndex, int colIndex) {
            return 0L;
        }

        @Override
        public long[] getParamLongOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Reader getParamReader(int rowIndex, int colIndex) {
            return this.paramReader[colIndex];
        }

        @Override
        public Reader[] getParamReaderOfRow(int rowIndex) {
            return null;
        }

        @Override
        public InputStream getParamStream(int rowIndex, int colIndex) {
            return this.paramStream[colIndex];
        }

        @Override
        public InputStream[] getParamStreamOfRow(int rowIndex) {
            return null;
        }

        @Override
        public String getParamString(int rowIndex, int colIndex) {
            return this.paramString[colIndex];
        }

        @Override
        public String[] getParamStringOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Struct getParamStruct(int rowIndex, int colIndex) {
            return this.paramStruct[colIndex];
        }

        @Override
        public Struct[] getParamStructOfRow(int rowIndex) {
            return null;
        }

        @Override
        public TbDate getParamTbDate(int rowIndex, int colIndex) {
            return this.paramTbDate[colIndex];
        }

        @Override
        public TbDate[] getParamTbDateOfRow(int rowIndex) {
            return null;
        }

        @Override
        public TbTimestamp getParamTbTimestamp(int rowIndex, int colIndex) {
            return this.paramTbTimestamp[colIndex];
        }

        @Override
        public TbTimestamp[] getParamTbTimestampOfRow(int rowIndex) {
            return null;
        }

        @Override
        public TbTimestampTZ getParamTbTimestampTZ(int rowIndex, int colIndex) {
            return this.paramTbTimestampTZ[colIndex];
        }

        @Override
        public TbTimestampTZ[] getParamTbTimestampTZOfRow(int rowIndex) {
            return null;
        }

        @Override
        public Timestamp getParamTimestamp(int rowIndex, int colIndex) {
            return this.paramTimestamp[colIndex];
        }

        @Override
        public Timestamp[] getParamTimestampOfRow(int rowIndex) {
            return null;
        }

        static /* synthetic */ Binder[] access$002(Params x0, Binder[] x1) {
            x0.attributeBinders = x1;
            return x1;
        }

        static /* synthetic */ BigDecimal[] access$202(Params x0, BigDecimal[] x1) {
            x0.paramBigDecimal = x1;
            return x1;
        }

        static /* synthetic */ String[] access$302(Params x0, String[] x1) {
            x0.paramString = x1;
            return x1;
        }

        static /* synthetic */ byte[][] access$402(Params x0, byte[][] x1) {
            x0.paramBytes = x1;
            return x1;
        }

        static /* synthetic */ Calendar[] access$502(Params x0, Calendar[] x1) {
            x0.paramCalendar = x1;
            return x1;
        }

        static /* synthetic */ TbDate[] access$602(Params x0, TbDate[] x1) {
            x0.paramTbDate = x1;
            return x1;
        }

        static /* synthetic */ Timestamp[] access$702(Params x0, Timestamp[] x1) {
            x0.paramTimestamp = x1;
            return x1;
        }

        static /* synthetic */ TbTimestamp[] access$802(Params x0, TbTimestamp[] x1) {
            x0.paramTbTimestamp = x1;
            return x1;
        }

        static /* synthetic */ Array[] access$902(Params x0, Array[] x1) {
            x0.paramArray = x1;
            return x1;
        }

        static /* synthetic */ Struct[] access$1002(Params x0, Struct[] x1) {
            x0.paramStruct = x1;
            return x1;
        }
    }
}

