/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbSQLInput
implements SQLInput {
    private Map map;
    private Object[] attributes;
    private int[] attributeTypes;
    private int index;
    private boolean wasNull;
    private TbStruct struct;
    private TbStructDescriptor descriptor;

    public TbSQLInput(TbStruct struct, TbStructDescriptor descriptor, Map map) throws SQLException {
        this.struct = struct;
        this.descriptor = descriptor;
        this.map = map;
        this.attributes = struct.getAttributes();
        this.attributeTypes = descriptor.getAttributeTypes();
        this.wasNull = false;
        this.index = 0;
    }

    @Override
    public String readString() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                String string = null;
                return string;
            }
            if (this.attributes[this.index] instanceof String) {
                String x;
                String string = x = (String)this.attributes[this.index];
                return string;
            }
            if (this.attributes[this.index] instanceof Date) {
                Date x = (Date)this.attributes[this.index];
                String string = x.toString();
                return string;
            }
            if (this.attributes[this.index] instanceof Time) {
                Time x = (Time)this.attributes[this.index];
                String string = x.toString();
                return string;
            }
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp x = (Timestamp)this.attributes[this.index];
                String string = x.toString();
                return string;
            }
            if (this.attributes[this.index] instanceof Clob) {
                Clob x = (Clob)this.attributes[this.index];
                String string = x.getSubString(1L, (int)x.length());
                return string;
            }
            try {
                throw TbError.newSQLException(-90612, "readString():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public boolean readBoolean() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                boolean bl = false;
                return bl;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                boolean bl = x.equals("1");
                return bl;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                boolean bl = x == 1;
                return bl;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                boolean bl = x.intValue() == 1;
                return bl;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                boolean bl = x.intValue() == 1;
                return bl;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                boolean bl = x.intValue() == 1;
                return bl;
            }
            try {
                throw TbError.newSQLException(-90612, "readBoolean():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public byte readByte() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                byte by = 0;
                return by;
            }
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal x = (BigDecimal)this.attributes[this.index];
                byte by = x.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                byte by = x.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                byte by = x.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                byte by = x.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                byte by = x.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                byte by = Byte.parseByte(x);
                return by;
            }
            try {
                throw TbError.newSQLException(-90612, "readByte():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public short readShort() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                short s = 0;
                return s;
            }
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal x = (BigDecimal)this.attributes[this.index];
                short s = x.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                short s = x.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                short s = x.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                short s = x.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                short s = x.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                short s = Short.parseShort(x);
                return s;
            }
            try {
                throw TbError.newSQLException(-90612, "readShort():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public int readInt() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                int n = 0;
                return n;
            }
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)this.attributes[this.index];
                int n = bd.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                int n = x;
                return n;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                int n = x.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                int n = x.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                int n = x.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                int n = Integer.parseInt(x);
                return n;
            }
            try {
                throw TbError.newSQLException(-90612, "readInt():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public long readLong() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                long l = 0L;
                return l;
            }
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)this.attributes[this.index];
                long l = bd.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                long l = x.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                long l = x;
                return l;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                long l = x.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                long l = x.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                long l = Long.parseLong(x);
                return l;
            }
            try {
                throw TbError.newSQLException(-90612, "readLong():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public float readFloat() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                float f = 0.0f;
                return f;
            }
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)this.attributes[this.index];
                float f = bd.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                float f = x.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                float f = x.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                float f = x.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                float f = x.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                float f = Float.parseFloat(x);
                return f;
            }
            try {
                throw TbError.newSQLException(-90612, "readFloat():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public double readDouble() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                double d = 0.0;
                return d;
            }
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)this.attributes[this.index];
                double d = bd.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                double d = x.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                double d = x.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                double d = x.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                double d = x;
                return d;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                double d = Double.parseDouble(x);
                return d;
            }
            try {
                throw TbError.newSQLException(-90612, "readDouble():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                BigDecimal bigDecimal = null;
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bd;
                BigDecimal bigDecimal = bd = (BigDecimal)this.attributes[this.index];
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer x = (Integer)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(x);
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long x = (Long)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(x.doubleValue());
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float x = (Float)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(x.doubleValue());
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double x = (Double)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(x);
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(x);
                return bigDecimal;
            }
            try {
                throw TbError.newSQLException(-90612, "readBigDecimal():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public byte[] readBytes() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.attributes[this.index] instanceof byte[]) {
                byte[] byArray = (byte[])this.attributes[this.index];
                return byArray;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                byte[] byArray = x.getBytes();
                return byArray;
            }
            if (this.attributes[this.index] instanceof Blob) {
                Blob x = (Blob)this.attributes[this.index];
                byte[] byArray = x.getBytes(1L, (int)x.length());
                return byArray;
            }
            try {
                throw TbError.newSQLException(-90612, "readBytes():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public Date readDate() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                Date date = null;
                return date;
            }
            if (this.attributes[this.index] instanceof Date) {
                Date date = (Date)this.attributes[this.index];
                return date;
            }
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp x = (Timestamp)this.attributes[this.index];
                Date date = new Date(x.getTime());
                return date;
            }
            if (this.attributes[this.index] instanceof TbDate) {
                TbDate x = (TbDate)this.attributes[this.index];
                Calendar c = Calendar.getInstance();
                c.set(x.getYear(), x.getMonth(), x.getDayOfMonth(), x.getHourOfDay(), x.getMinutes(), x.getSeconds());
                Date date = new Date(c.getTimeInMillis());
                return date;
            }
            try {
                throw TbError.newSQLException(-90612, "readDate():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public Time readTime() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                Time time = null;
                return time;
            }
            if (this.attributes[this.index] instanceof Time) {
                Time time = (Time)this.attributes[this.index];
                return time;
            }
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp x = (Timestamp)this.attributes[this.index];
                Time time = new Time(x.getTime());
                return time;
            }
            try {
                throw TbError.newSQLException(-90612, "readTime():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                Timestamp timestamp = null;
                return timestamp;
            }
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)this.attributes[this.index];
                return timestamp;
            }
            if (this.attributes[this.index] instanceof Date) {
                Date x = (Date)this.attributes[this.index];
                Timestamp timestamp = new Timestamp(x.getTime());
                return timestamp;
            }
            if (this.attributes[this.index] instanceof Time) {
                Time x = (Time)this.attributes[this.index];
                Timestamp timestamp = new Timestamp(x.getTime());
                return timestamp;
            }
            try {
                throw TbError.newSQLException(-90612, "readTimestamp():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                Reader reader = null;
                return reader;
            }
            if (this.attributes[this.index] instanceof Clob) {
                Clob x = (Clob)this.attributes[this.index];
                Reader reader = x.getCharacterStream();
                return reader;
            }
            if (this.attributes[this.index] instanceof String) {
                String x = (String)this.attributes[this.index];
                StringReader stringReader = new StringReader(x);
                return stringReader;
            }
            try {
                throw TbError.newSQLException(-90612, "readCharacterStream():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                InputStream inputStream = null;
                return inputStream;
            }
            if (this.attributes[this.index] instanceof Clob) {
                Clob x = (Clob)this.attributes[this.index];
                InputStream inputStream = x.getAsciiStream();
                return inputStream;
            }
            try {
                throw TbError.newSQLException(-90612, "readAsciiStream():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                InputStream inputStream = null;
                return inputStream;
            }
            if (this.attributes[this.index] instanceof Blob) {
                Blob x = (Blob)this.attributes[this.index];
                InputStream inputStream = x.getBinaryStream();
                return inputStream;
            }
            try {
                throw TbError.newSQLException(-90612, "readBinaryStream():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject() throws SQLException {
        Object obj;
        block7: {
            obj = null;
            try {
                this.wasNull = this.attributes[this.index] == null;
                if (this.wasNull) {
                    Object var2_2 = null;
                    return var2_2;
                }
                if (this.attributes[this.index] instanceof TbStruct) {
                    obj = ((TbStruct)this.attributes[this.index]).toClass(this.map);
                    break block7;
                }
                if (this.attributes[this.index] instanceof SQLData) {
                    obj = this.attributes[this.index];
                    break block7;
                }
                throw TbError.newSQLException(-90612, "readObject():attr=" + this.attributes[this.index]);
            }
            finally {
                ++this.index;
            }
        }
        return obj;
    }

    @Override
    public Ref readRef() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Blob readBlob() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                Blob blob = null;
                return blob;
            }
            if (this.attributes[this.index] instanceof Blob) {
                Blob blob = (Blob)this.attributes[this.index];
                return blob;
            }
            try {
                throw TbError.newSQLException(-90612, "readBlob():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public Clob readClob() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                Clob clob = null;
                return clob;
            }
            if (this.attributes[this.index] instanceof Clob) {
                Clob clob = (Clob)this.attributes[this.index];
                return clob;
            }
            try {
                throw TbError.newSQLException(-90612, "readClob():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public Array readArray() throws SQLException {
        try {
            this.wasNull = this.attributes[this.index] == null;
            if (this.wasNull) {
                Array array = null;
                return array;
            }
            if (this.attributes[this.index] instanceof Array) {
                Array array = (Array)this.attributes[this.index];
                return array;
            }
            try {
                throw TbError.newSQLException(-90612, "readArray():attr=" + this.attributes[this.index]);
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw TbError.newSQLException(-90651, e);
            }
        }
        finally {
            ++this.index;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public URL readURL() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public String readNString() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw TbError.newSQLException(-90201);
    }
}

