/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.RowId;
import java.sql.SQLException;

public class TbRowId
implements RowId {
    private static final int ROWID_SGMT_BYTE_CNT = 4;
    private static final int ROWID_BLOCK_BYTE_CNT = 4;
    private static final int ROWID_FILE_BYTE_CNT = 2;
    private static final int ROWID_ROW_BYTE_CNT = 2;
    private static final byte[] rowid_encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final int ROWID_DIVISION_SHIFT = 6;
    private static final int ROWID_REMAINDER_BIT = 63;
    private static final int ROWID_SGMT_LEN = 6;
    private static final int ROWID_FILE_LEN = 3;
    private static final int ROWID_BLOCK_LEN = 6;
    private static final int ROWID_ROW_LEN = 3;
    private static final int ROWID_SGMT_LAST = 5;
    private static final int ROWID_FILE_LAST = 8;
    private static final int ROWID_BLOCK_LAST = 14;
    private static final int ROWID_ROW_LAST = 17;
    private static final int ROWID_BYTE_CNT = 12;
    private static final long ROWID_SGMT_MAX = 0xFFFFFFFFL;
    private static final long ROWID_BLOCK_MAX = 0xFFFFFFFFL;
    private static final int ROWID_FILE_MAX = 65535;
    private static final int ROWID_ROW_MAX = 65535;
    private static final int ROWID_LEN = 18;
    private long sgmt;
    private long block;
    private int file;
    private int row;
    private byte[] erowid = new byte[12];

    private int convSingleRowId(byte c) {
        return 65 <= c && c <= 90 ? c - 65 + 0 : (97 <= c && c <= 122 ? c - 97 + 26 : (48 <= c && c <= 57 ? c - 48 + 52 : (43 == c ? 62 : (47 == c ? 63 : -1))));
    }

    public void fromBytes(int svrEndian, byte[] x, int offset) throws SQLException {
        this.setRowIdFields(0L, 0L, 0, 0);
        if (svrEndian == 1) {
            this.sgmt = TbCommon.bytes2Long(x, offset, 4);
            this.block = TbCommon.bytes2Long(x, offset += 4, 4);
            this.file = TbCommon.bytes2Int(x, offset += 4, 2);
            this.row = TbCommon.bytes2Int(x, offset += 2, 2);
        } else if (svrEndian == 0) {
            this.sgmt = TbCommon.bytes2LongR(x, offset, 4);
            this.block = TbCommon.bytes2LongR(x, offset += 4, 4);
            this.file = TbCommon.bytes2IntR(x, offset += 4, 2);
            this.row = TbCommon.bytes2IntR(x, offset += 2, 2);
        }
        if (svrEndian == 1) {
            TbCommon.long2Bytes(this.sgmt, this.erowid, 0, 4);
            TbCommon.long2Bytes(this.block, this.erowid, 4, 4);
            TbCommon.int2Bytes(this.file, this.erowid, 8, 2);
            TbCommon.int2Bytes(this.row, this.erowid, 10, 2);
        } else {
            TbCommon.long2BytesR(this.sgmt, this.erowid, 0, 4);
            TbCommon.long2BytesR(this.block, this.erowid, 4, 4);
            TbCommon.int2BytesR(this.file, this.erowid, 8, 2);
            TbCommon.int2BytesR(this.row, this.erowid, 10, 2);
        }
    }

    public int fromString(byte[] buf, int offset, int svrEndian, String x) throws SQLException {
        int c;
        byte[] bytes = x.getBytes();
        this.setRowIdFields(0L, 0L, 0, 0);
        long k = 1L;
        int n = 5;
        while (n >= 0) {
            c = this.convSingleRowId(bytes[n]);
            if (c < 0) {
                throw TbError.newSQLException(-590753, c);
            }
            if (0xFFFFFFFFL - this.sgmt < k * (long)c) {
                throw TbError.newSQLException(-590753, "4294967295 - " + this.sgmt + " < " + k + " * " + c);
            }
            this.sgmt += k * (long)c;
            c = this.convSingleRowId(bytes[9 + n]);
            if (c < 0) {
                throw TbError.newSQLException(-590753, c);
            }
            if (0xFFFFFFFFL - this.block < k * (long)c) {
                throw TbError.newSQLException(-590754, "4294967295 - " + this.block + " < " + k + " * " + c);
            }
            this.block += k * (long)c;
            --n;
            k <<= 6;
        }
        int l = 1;
        n = 8;
        while (n > 5) {
            c = this.convSingleRowId(bytes[n]);
            if (c < 0) {
                throw TbError.newSQLException(-590753, c);
            }
            if (65535 - this.file < l * c) {
                throw TbError.newSQLException(-590755, "65535 - " + this.file + " < " + l + " * " + c);
            }
            this.file += l * c;
            c = this.convSingleRowId(bytes[9 + n]);
            if (c < 0) {
                throw TbError.newSQLException(-590753, c);
            }
            if (65535 - this.row < l * c) {
                throw TbError.newSQLException(-590757, "65535 - " + this.row + " < " + l + " * " + c);
            }
            this.row += l * c;
            --n;
            l <<= 6;
        }
        if (svrEndian == 1) {
            TbCommon.long2Bytes(this.sgmt, buf, offset, 4);
            TbCommon.long2Bytes(this.block, buf, offset + 4, 4);
            TbCommon.int2Bytes(this.file, buf, offset + 8, 2);
            TbCommon.int2Bytes(this.row, buf, offset + 10, 2);
        } else {
            TbCommon.long2BytesR(this.sgmt, buf, offset, 4);
            TbCommon.long2BytesR(this.block, buf, offset + 4, 4);
            TbCommon.int2BytesR(this.file, buf, offset + 8, 2);
            TbCommon.int2BytesR(this.row, buf, offset + 10, 2);
        }
        return 12;
    }

    @Override
    public byte[] getBytes() {
        return this.erowid;
    }

    private void setRowIdFields(long sgmt, long block, int file, int row) {
        this.sgmt = sgmt;
        this.block = block;
        this.file = file;
        this.row = row;
    }

    @Override
    public String toString() {
        int n;
        byte[] erowid = new byte[18];
        long tmpSgmt = this.sgmt;
        long tmpBlock = this.block;
        int tmpFile = this.file;
        int tmpRow = this.row;
        for (n = 5; n >= 0; --n) {
            erowid[n] = rowid_encoding[(int)tmpSgmt & 0x3F];
            tmpSgmt >>= 6;
            erowid[9 + n] = rowid_encoding[(int)tmpBlock & 0x3F];
            tmpBlock >>= 6;
        }
        for (n = 8; n > 5; --n) {
            erowid[n] = rowid_encoding[tmpFile & 0x3F];
            tmpFile >>= 6;
            erowid[9 + n] = rowid_encoding[tmpRow & 0x3F];
            tmpRow >>= 6;
        }
        return new String(erowid);
    }
}

