/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class TbClobWriter
extends Writer {
    private TbClobBase clob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private boolean opened = false;
    private char[] charBuf = null;

    public TbClobWriter(TbClobBase clob, long pos) throws SQLException {
        Debug.logMethod("TbClobWriter", new Object[]{this, clob, Long.toString(pos)});
        if (clob == null) {
            throw TbError.newSQLException(-590767);
        }
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        this.clob = clob;
        this.lobOffset = pos;
        this.bufOffset = 0;
        this.opened = true;
        this.charBuf = new char[TbLob.getMaxChunkSize()];
    }

    private void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    @Override
    public void close() throws IOException {
        Debug.logMethod("TbClobWriter.close", new Object[]{this, this.clob});
        this.checkClosed();
        try {
            this.flushBuffer();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        this.opened = false;
    }

    @Override
    public void flush() throws IOException {
        Debug.logMethod("TbClobWriter.flush", new Object[]{this, this.clob});
        this.checkClosed();
        try {
            this.flushBuffer();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void flushBuffer() throws SQLException {
        if (this.bufOffset > 0) {
            int writeNum = this.clob.putChars(this.lobOffset, this.charBuf, 0L, this.bufOffset);
            this.lobOffset += (long)writeNum;
            this.bufOffset = 0;
        }
    }

    private int getRemainedInBuffer() {
        return TbLob.getMaxChunkSize() - this.bufOffset;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int lenToCopy;
        Debug.logMethod("TbClobWriter.write", new Object[]{this, this.clob, cbuf, Integer.toString(off), Integer.toString(len)});
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.checkClosed();
        int bufRemained = this.getRemainedInBuffer();
        int srcOffset = off;
        for (int dataRemained = len; dataRemained > 0; dataRemained -= lenToCopy) {
            lenToCopy = bufRemained > dataRemained ? dataRemained : bufRemained;
            System.arraycopy(cbuf, srcOffset, this.charBuf, this.bufOffset, lenToCopy);
            srcOffset += lenToCopy;
            this.bufOffset += lenToCopy;
            if ((bufRemained -= lenToCopy) != 0) continue;
            try {
                this.flushBuffer();
                bufRemained = this.getRemainedInBuffer();
                continue;
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage());
            }
        }
    }
}

