/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbClobReader;
import com.tmax.tibero.jdbc.TbClobWriter;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbLobInputStream;
import com.tmax.tibero.jdbc.TbLobOutputStream;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbLobAccessor;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class TbClobBase
extends TbLob
implements Clob {
    public TbClobBase(TbConnection conn, byte[] loc, boolean freeTmpLobOnEOF) {
        super(conn, loc, freeTmpLobOnEOF);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        Debug.logMethod("TbClob.getAsciiStream", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        return new TbLobInputStream(this, 1L, Integer.MAX_VALUE);
    }

    public int getBufferSize() throws SQLException {
        Debug.logMethod("TbClob.getBufferSize", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        return TbLob.getMaxChunkSize();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        Debug.logMethod("TbClob.getCharacterStream", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        return new TbClobReader(this, 1L, Long.MAX_VALUE);
    }

    @Override
    public Reader getCharacterStream(long pos, long len) throws SQLException {
        Debug.logMethod("TbClob.getCharacterStream", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0L) {
            throw TbError.newSQLException(-590765, len);
        }
        return new TbClobReader(this, pos, len);
    }

    public long getChars(long pos, char[] buffer) throws SQLException {
        return this.getChars(pos, buffer, 0L, buffer.length);
    }

    public long getChars(long pos, char[] buffer, long len) throws SQLException {
        return this.getChars(pos, buffer, 0L, len);
    }

    public long getChars(long pos, char[] buffer, long bufOffset, long len) throws SQLException {
        Debug.logMethod("TbClob.getChars", new Object[]{this, Long.toString(pos), buffer, Long.toString(bufOffset), Long.toString(len)});
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0L) {
            throw TbError.newSQLException(-590765, len);
        }
        if (len > (long)buffer.length) {
            len = buffer.length;
        }
        if (len == 0L) {
            return 0L;
        }
        long lenInternal = this.getLengthInternal();
        long readLen = this.getClobAccessor().read(this, pos - 1L, buffer, bufOffset, len);
        if (lenInternal > -1L && pos == 1L && lenInternal <= readLen && this.getIsTempLob() && this.freeTmpLobOnEOF()) {
            Debug.log("Implicit clob free. " + this.toString());
            this.getLobAccessor().freeTemporary(this);
        }
        return readLen;
    }

    protected TbClobAccessor getClobAccessor() {
        return this.getConnection().getClobAccessor();
    }

    @Override
    protected TbLobAccessor getLobAccessor() {
        return this.getClobAccessor();
    }

    @Override
    public String getSubString(long pos, int len) throws SQLException {
        Debug.logMethod("TbClob.getSubString", new Object[]{this, Long.toString(pos), Integer.toString(len)});
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0) {
            throw TbError.newSQLException(-590765, len);
        }
        if (len == 0) {
            return new String();
        }
        char[] read = new char[len];
        long numRead = this.getChars(pos, read);
        if (numRead > 0L) {
            return new String(read, 0, (int)numRead);
        }
        return new String();
    }

    @Override
    public long position(Clob searchLob, long start) throws SQLException {
        return super.position((TbLob)((Object)searchLob), start);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        Debug.logMethod("TbClob.position", new Object[]{this, searchstr, Long.toString(start)});
        this.checkInvalidActionOnEmpty();
        if (start < 1L) {
            throw TbError.newSQLException(-590766, "" + start);
        }
        return this.getClobAccessor().position(this, searchstr.toCharArray(), start - 1L);
    }

    public long putChars(long pos, char[] buffer) throws SQLException {
        Debug.logMethod("TbClob.putChars", new Object[]{this, Long.toString(pos), buffer});
        return this.putCharsInternal(pos, buffer, 0L, buffer.length);
    }

    public long putChars(long pos, char[] buffer, long len) throws SQLException {
        Debug.logMethod("TbClob.putChars", new Object[]{this, Long.toString(pos), buffer, Long.toString(len)});
        return this.putCharsInternal(pos, buffer, 0L, len);
    }

    public int putChars(long pos, char[] buffer, long bufOffset, long len) throws SQLException {
        Debug.logMethod("TbClob.putChars", new Object[]{this, Long.toString(pos), buffer, Long.toString(bufOffset), Long.toString(len)});
        return (int)this.putCharsInternal(pos, buffer, bufOffset, len);
    }

    private long putCharsInternal(long pos, char[] buffer, long bufOffset, long len) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (pos < 1L) {
            throw TbError.newSQLException(-590764, pos);
        }
        if (len < 0L) {
            throw TbError.newSQLException(-590765, len);
        }
        if (bufOffset + len > (long)buffer.length) {
            len = (long)buffer.length - bufOffset;
        }
        if (len <= 0L) {
            return 0L;
        }
        return this.getClobAccessor().write(this, pos - 1L, buffer, bufOffset, len);
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        Debug.logMethod("TbClob.setAsciiStream", new Object[]{this, Long.toString(pos)});
        this.checkInvalidActionOnEmpty();
        return new TbLobOutputStream(this, pos == 0L ? 1L : pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        Debug.logMethod("TbClob.setCharacterStream", new Object[]{this, Long.toString(pos)});
        this.checkInvalidActionOnEmpty();
        return new TbClobWriter(this, pos == 0L ? 1L : pos);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        Debug.logMethod("TbClob.setString", new Object[]{this, Long.toString(pos), str});
        this.checkInvalidActionOnEmpty();
        if (str == null) {
            throw TbError.newSQLException(-590768);
        }
        char[] ac = str.toCharArray();
        return (int)this.putCharsInternal(pos, ac, 0L, ac.length);
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        Debug.logMethod("TbClob.setString", new Object[]{this, Long.toString(pos), str, Integer.toString(offset), Integer.toString(len)});
        this.checkInvalidActionOnEmpty();
        if (len < 0) {
            throw TbError.newSQLException(-590765, len);
        }
        if (str == null) {
            throw TbError.newSQLException(-590768);
        }
        if (len == 0) {
            return 0;
        }
        char[] chars = new char[len];
        str.getChars(offset, offset + len, chars, 0);
        return (int)this.putCharsInternal(pos, chars, 0L, len);
    }
}

